/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import cz.kpsys.portaro.acquisition.RecordDemand;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.department.AuthContextualDepartmentsLoader;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.FallbackableCompositeCacheManager;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.SearchImplConfig;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.datasource.Datasource;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.discard.Discardion;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.inventory.Capture;
import cz.kpsys.portaro.inventory.Inventory;
import cz.kpsys.portaro.inventory.Match;
import cz.kpsys.portaro.loan.Loan;
import cz.kpsys.portaro.loan.reminder.LoanReminder;
import cz.kpsys.portaro.messages.dto.Message;
import cz.kpsys.portaro.payment.Payment;
import cz.kpsys.portaro.record.IdsToRecordsConverter;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordExportsGeneratorFactory;
import cz.kpsys.portaro.record.RichRecord;
import cz.kpsys.portaro.record.authority.RecordHierarchyLoader;
import cz.kpsys.portaro.record.authority.RichAuthority;
import cz.kpsys.portaro.record.document.IdsToDocumentsConverter;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.record.edit.RecordEntryElementResolver;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.newestdocuments.NewestDocumentsService;
import cz.kpsys.portaro.record.operation.RecordOperation;
import cz.kpsys.portaro.record.search.RawableSearchService;
import cz.kpsys.portaro.record.sec.CurrentAuthEditableFondsLoader;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.factory.SearchFactory;
import cz.kpsys.portaro.search.factory.SearchFactoryCaching;
import cz.kpsys.portaro.search.impl.SpringDbMostLentDocumentsLoader;
import cz.kpsys.portaro.search.impl.SpringDbMostWatchedDocumentsLoader;
import cz.kpsys.portaro.search.impl.SpringDbNewestDocumentsLoader;
import cz.kpsys.portaro.search.impl.SpringDbTopRatedLoader;
import cz.kpsys.portaro.search.lucene.LuceneSearchResult;
import cz.kpsys.portaro.search.sorting.Sorting;
import cz.kpsys.portaro.search.view.ResultConverterFactory;
import cz.kpsys.portaro.search.z.ZServerSearch;
import cz.kpsys.portaro.search.z.ZServerService;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.User;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class SearchImplConfig {
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final NamedParameterJdbcOperations notCriticalJdbcTemplate;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final AuthContextualDepartmentsLoader familyModeAuthContextualDepartmentsLoader;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedDocumentFondsDepartmentedProvider;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedAuthorityFondsDepartmentedProvider;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedFondsDepartmentedProvider;
    @NonNull
    private final RecordHierarchyLoader recordHierarchyLoader;
    @NonNull
    private final RawableSearchService<LuceneSearchResult<Record, MapBackedParams>, MapBackedParams, Record> recordSearchService;
    @NonNull
    private final PageSearchLoader<MapBackedParams, RichAuthority> notCriticalAuthoritySearchSqlLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, UUID> notCriticalDocumentIdSearchSqlLoader;
    @NonNull
    private final FallbackableCompositeCacheManager cacheManager;
    @NonNull
    private final AllByIdsLoadable<RichRecord, UUID> richRecordLoader;
    @NonNull
    private final AllByIdsLoadable<RichAuthority, Integer> authorityByKindedIdLoader;
    @NonNull
    private final AllByIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final AllByIdsLoadable<RichDocument, UUID> detailedDocumentLoader;
    @NonNull
    private final IdAndIdsLoadable<RichDocument, Integer> documentByKindedIdLoader;
    @NonNull
    private final AllByIdsLoadable<Discardion, Long> discardionLoader;
    @NonNull
    private final Provider<Sorting> defaultExemplarSearchSortingProvider;
    @NonNull
    private final ZServerService zServerService;
    @NonNull
    private final Saver<Record> externalRecordRepository;
    @NonNull
    private final RecordEntryElementResolver recordEntryElementResolver;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Exemplar> exemplarSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, ? extends User> userSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Payment> paymentSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Inventory> inventorySearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Capture> captureSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Match> matchSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Loan> loanSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, LoanReminder> loanReminderSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, RecordDemand> recordDemandSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, RecordOperation> recordOperationSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Message> messageSearchLoader;
    @NonNull
    private final ByIdLoadable<Sorting, String> searchSortingLoader;
    @NonNull
    private final Provider<Sorting> defaultDocumentSearchSortingProvider;
    @NonNull
    private final Provider<Sorting> defaultAuthoritySearchSortingProvider;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsDepartmentedProvider;
    @NonNull
    private final RecordExportsGeneratorFactory recordExportsGeneratorFactory;
    @NonNull
    private final CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader;

    @Bean
    public SearchFactory globalSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory documentIndexSearchFactory() {
        new /* Unavailable Anonymous Inner Class!! */;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory topRatedSearchFactory() {
        SpringDbTopRatedLoader topRatedDocumentsLoader = new SpringDbTopRatedLoader(this.notCriticalJdbcTemplate, this.queryFactory);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory newestSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory authorityIndexSearchFactory() {
        6 authorityIndexSearchByAppserverSearchFactory = new /* Unavailable Anonymous Inner Class!! */;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory mostLentSearchFactory() {
        SpringDbMostLentDocumentsLoader mostLentDocumentsLoader = new SpringDbMostLentDocumentsLoader(this.notCriticalJdbcTemplate, this.queryFactory, 100, this.departmentAccessor);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory mostWatchedSearchFactory() {
        SpringDbMostWatchedDocumentsLoader mostWatchedDocumentsLoader = new SpringDbMostWatchedDocumentsLoader(this.notCriticalJdbcTemplate, this.queryFactory);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory exemplarSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory userSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory recordOperationSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory fileSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory paymentSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory inventorySearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory captureSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory matchSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory recordRequestSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory loanSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory reminderSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory messageSearchFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFactory zServerSearchFactory() {
        22 zServerSearchFactory = new /* Unavailable Anonymous Inner Class!! */;
        CaffeineCacheManager zServerSearchCaching = new CaffeineCacheManager(new String[]{"search"});
        zServerSearchCaching.setCaffeine(Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
            if (cause != RemovalCause.REPLACED) {
                ((ZServerSearch)value).close();
            }
        }));
        this.cacheManager.addCacheManager((CacheManager)zServerSearchCaching);
        Cache searchCache = Objects.requireNonNull(this.cacheManager.getCache("search"));
        return new SearchFactoryCaching(searchCache, (SearchFactory)zServerSearchFactory);
    }

    @Bean
    public ResultConverterFactory<String> resultConverterFactory() {
        IdsToRecordsConverter idsToRecordsConverter = new IdsToRecordsConverter().withAuthoritySupport(this.authorityByKindedIdLoader).withDocumentSupport((AllByIdsLoadable)this.documentByKindedIdLoader).withRecordSupport(this.richRecordLoader);
        return this.createResultConverterFactory((Converter)idsToRecordsConverter);
    }

    @Bean
    public ResultConverterFactory<UUID> documentIdsResultConverterFactory() {
        IdsToDocumentsConverter idsToRecordsConverter = new IdsToDocumentsConverter(this.richRecordLoader);
        return this.createResultConverterFactory((Converter)idsToRecordsConverter);
    }

    private <E> ResultConverterFactory<E> createResultConverterFactory(Converter<List<E>, List<? extends Record>> idsToRecordsConverter) {
        return new ResultConverterFactory(idsToRecordsConverter, this.recordExportsGeneratorFactory);
    }

    @Bean
    public PageSearchLoader<MapBackedParams, UUID> newestDocumentsLoader() {
        return new SpringDbNewestDocumentsLoader(this.notCriticalJdbcTemplate, this.queryFactory);
    }

    @Bean
    public NewestDocumentsService newestDocumentsService() {
        NewestDocumentsService bean = new NewestDocumentsService(this.detailedDocumentLoader, this.newestDocumentsLoader(), this.settingLoader.getOnRootProvider(SettingKeys.NEWS_WITH_COVER_PREFERING_ENABLED), this.settingLoader.getOnRootProvider(SettingKeys.NEWS_SLIDER_PRESEARCHED_COUNT), this.settingLoader.getOnRootProvider(SettingKeys.NEWS_SLIDER_SHOWED_COUNT), this.allowedDocumentFondsDepartmentedProvider, this.settingLoader.getOnRootProvidedList(SettingKeys.FORBIDDEN_RECORDS), this.settingLoader.getOnRootProvidedList(SettingKeys.FORBIDDEN_RECORD_STATUSES), this.settingLoader.getOnRootProvidedList(SettingKeys.NEWS_EXEMPLAR_STATUSES), this.settingLoader.getOnRootProvidedList(SettingKeys.NEWS_SLIDER_BUILDINGS), this.departmentAccessor);
        this.cacheService.registerCleaner((CacheCleaner)bean);
        return bean;
    }

    @ConstructorProperties(value={"queryFactory", "notCriticalJdbcTemplate", "cacheService", "settingLoader", "departmentAccessor", "familyModeAuthContextualDepartmentsLoader", "allowedDocumentFondsDepartmentedProvider", "allowedAuthorityFondsDepartmentedProvider", "allowedFondsDepartmentedProvider", "recordHierarchyLoader", "recordSearchService", "notCriticalAuthoritySearchSqlLoader", "notCriticalDocumentIdSearchSqlLoader", "cacheManager", "richRecordLoader", "authorityByKindedIdLoader", "nonDetailedDocumentLoader", "detailedDocumentLoader", "documentByKindedIdLoader", "discardionLoader", "defaultExemplarSearchSortingProvider", "zServerService", "externalRecordRepository", "recordEntryElementResolver", "exemplarSearchLoader", "userSearchLoader", "fileSearchLoader", "paymentSearchLoader", "inventorySearchLoader", "captureSearchLoader", "matchSearchLoader", "loanSearchLoader", "loanReminderSearchLoader", "recordDemandSearchLoader", "recordOperationSearchLoader", "messageSearchLoader", "searchSortingLoader", "defaultDocumentSearchSortingProvider", "defaultAuthoritySearchSortingProvider", "authenticationHolder", "currentAuthEditableDepartmentsLoader", "allowedDatasetsDepartmentedProvider", "recordExportsGeneratorFactory", "currentAuthEditableFondsLoader"})
    @Generated
    public SearchImplConfig(@NonNull QueryFactory queryFactory, @NonNull NamedParameterJdbcOperations notCriticalJdbcTemplate, @NonNull CacheService cacheService, @NonNull SettingLoader settingLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull AuthContextualDepartmentsLoader familyModeAuthContextualDepartmentsLoader, @NonNull ContextualProvider<Department, List<Fond>> allowedDocumentFondsDepartmentedProvider, @NonNull ContextualProvider<Department, List<Fond>> allowedAuthorityFondsDepartmentedProvider, @NonNull ContextualProvider<Department, List<Fond>> allowedFondsDepartmentedProvider, @NonNull RecordHierarchyLoader recordHierarchyLoader, @NonNull RawableSearchService<LuceneSearchResult<Record, MapBackedParams>, MapBackedParams, Record> recordSearchService, @NonNull PageSearchLoader<MapBackedParams, RichAuthority> notCriticalAuthoritySearchSqlLoader, @NonNull PageSearchLoader<MapBackedParams, UUID> notCriticalDocumentIdSearchSqlLoader, @NonNull FallbackableCompositeCacheManager cacheManager, @NonNull AllByIdsLoadable<RichRecord, UUID> richRecordLoader, @NonNull AllByIdsLoadable<RichAuthority, Integer> authorityByKindedIdLoader, @NonNull AllByIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader, @NonNull AllByIdsLoadable<RichDocument, UUID> detailedDocumentLoader, @NonNull IdAndIdsLoadable<RichDocument, Integer> documentByKindedIdLoader, @NonNull AllByIdsLoadable<Discardion, Long> discardionLoader, @NonNull Provider<Sorting> defaultExemplarSearchSortingProvider, @NonNull ZServerService zServerService, @NonNull Saver<Record> externalRecordRepository, @NonNull RecordEntryElementResolver recordEntryElementResolver, @NonNull PageSearchLoader<MapBackedParams, Exemplar> exemplarSearchLoader, @NonNull PageSearchLoader<MapBackedParams, ? extends User> userSearchLoader, @NonNull PageSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader, @NonNull PageSearchLoader<MapBackedParams, Payment> paymentSearchLoader, @NonNull PageSearchLoader<MapBackedParams, Inventory> inventorySearchLoader, @NonNull PageSearchLoader<MapBackedParams, Capture> captureSearchLoader, @NonNull PageSearchLoader<MapBackedParams, Match> matchSearchLoader, @NonNull PageSearchLoader<MapBackedParams, Loan> loanSearchLoader, @NonNull PageSearchLoader<MapBackedParams, LoanReminder> loanReminderSearchLoader, @NonNull PageSearchLoader<MapBackedParams, RecordDemand> recordDemandSearchLoader, @NonNull PageSearchLoader<MapBackedParams, RecordOperation> recordOperationSearchLoader, @NonNull PageSearchLoader<MapBackedParams, Message> messageSearchLoader, @NonNull ByIdLoadable<Sorting, String> searchSortingLoader, @NonNull Provider<Sorting> defaultDocumentSearchSortingProvider, @NonNull Provider<Sorting> defaultAuthoritySearchSortingProvider, @NonNull AuthenticationHolder authenticationHolder, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull @NonNull ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsDepartmentedProvider, @NonNull RecordExportsGeneratorFactory recordExportsGeneratorFactory, @NonNull CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader) {
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(notCriticalJdbcTemplate, "notCriticalJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(familyModeAuthContextualDepartmentsLoader, "familyModeAuthContextualDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(allowedDocumentFondsDepartmentedProvider, "allowedDocumentFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedAuthorityFondsDepartmentedProvider, "allowedAuthorityFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedFondsDepartmentedProvider, "allowedFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(recordHierarchyLoader, "recordHierarchyLoader is marked non-null but is null");
        Objects.requireNonNull(recordSearchService, "recordSearchService is marked non-null but is null");
        Objects.requireNonNull(notCriticalAuthoritySearchSqlLoader, "notCriticalAuthoritySearchSqlLoader is marked non-null but is null");
        Objects.requireNonNull(notCriticalDocumentIdSearchSqlLoader, "notCriticalDocumentIdSearchSqlLoader is marked non-null but is null");
        Objects.requireNonNull(cacheManager, "cacheManager is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(authorityByKindedIdLoader, "authorityByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(detailedDocumentLoader, "detailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(documentByKindedIdLoader, "documentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(discardionLoader, "discardionLoader is marked non-null but is null");
        Objects.requireNonNull(defaultExemplarSearchSortingProvider, "defaultExemplarSearchSortingProvider is marked non-null but is null");
        Objects.requireNonNull(zServerService, "zServerService is marked non-null but is null");
        Objects.requireNonNull(externalRecordRepository, "externalRecordRepository is marked non-null but is null");
        Objects.requireNonNull(recordEntryElementResolver, "recordEntryElementResolver is marked non-null but is null");
        Objects.requireNonNull(exemplarSearchLoader, "exemplarSearchLoader is marked non-null but is null");
        Objects.requireNonNull(userSearchLoader, "userSearchLoader is marked non-null but is null");
        Objects.requireNonNull(fileSearchLoader, "fileSearchLoader is marked non-null but is null");
        Objects.requireNonNull(paymentSearchLoader, "paymentSearchLoader is marked non-null but is null");
        Objects.requireNonNull(inventorySearchLoader, "inventorySearchLoader is marked non-null but is null");
        Objects.requireNonNull(captureSearchLoader, "captureSearchLoader is marked non-null but is null");
        Objects.requireNonNull(matchSearchLoader, "matchSearchLoader is marked non-null but is null");
        Objects.requireNonNull(loanSearchLoader, "loanSearchLoader is marked non-null but is null");
        Objects.requireNonNull(loanReminderSearchLoader, "loanReminderSearchLoader is marked non-null but is null");
        Objects.requireNonNull(recordDemandSearchLoader, "recordDemandSearchLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationSearchLoader, "recordOperationSearchLoader is marked non-null but is null");
        Objects.requireNonNull(messageSearchLoader, "messageSearchLoader is marked non-null but is null");
        Objects.requireNonNull(searchSortingLoader, "searchSortingLoader is marked non-null but is null");
        Objects.requireNonNull(defaultDocumentSearchSortingProvider, "defaultDocumentSearchSortingProvider is marked non-null but is null");
        Objects.requireNonNull(defaultAuthoritySearchSortingProvider, "defaultAuthoritySearchSortingProvider is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(allowedDatasetsDepartmentedProvider, "allowedDatasetsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(recordExportsGeneratorFactory, "recordExportsGeneratorFactory is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableFondsLoader, "currentAuthEditableFondsLoader is marked non-null but is null");
        this.queryFactory = queryFactory;
        this.notCriticalJdbcTemplate = notCriticalJdbcTemplate;
        this.cacheService = cacheService;
        this.settingLoader = settingLoader;
        this.departmentAccessor = departmentAccessor;
        this.familyModeAuthContextualDepartmentsLoader = familyModeAuthContextualDepartmentsLoader;
        this.allowedDocumentFondsDepartmentedProvider = allowedDocumentFondsDepartmentedProvider;
        this.allowedAuthorityFondsDepartmentedProvider = allowedAuthorityFondsDepartmentedProvider;
        this.allowedFondsDepartmentedProvider = allowedFondsDepartmentedProvider;
        this.recordHierarchyLoader = recordHierarchyLoader;
        this.recordSearchService = recordSearchService;
        this.notCriticalAuthoritySearchSqlLoader = notCriticalAuthoritySearchSqlLoader;
        this.notCriticalDocumentIdSearchSqlLoader = notCriticalDocumentIdSearchSqlLoader;
        this.cacheManager = cacheManager;
        this.richRecordLoader = richRecordLoader;
        this.authorityByKindedIdLoader = authorityByKindedIdLoader;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.detailedDocumentLoader = detailedDocumentLoader;
        this.documentByKindedIdLoader = documentByKindedIdLoader;
        this.discardionLoader = discardionLoader;
        this.defaultExemplarSearchSortingProvider = defaultExemplarSearchSortingProvider;
        this.zServerService = zServerService;
        this.externalRecordRepository = externalRecordRepository;
        this.recordEntryElementResolver = recordEntryElementResolver;
        this.exemplarSearchLoader = exemplarSearchLoader;
        this.userSearchLoader = userSearchLoader;
        this.fileSearchLoader = fileSearchLoader;
        this.paymentSearchLoader = paymentSearchLoader;
        this.inventorySearchLoader = inventorySearchLoader;
        this.captureSearchLoader = captureSearchLoader;
        this.matchSearchLoader = matchSearchLoader;
        this.loanSearchLoader = loanSearchLoader;
        this.loanReminderSearchLoader = loanReminderSearchLoader;
        this.recordDemandSearchLoader = recordDemandSearchLoader;
        this.recordOperationSearchLoader = recordOperationSearchLoader;
        this.messageSearchLoader = messageSearchLoader;
        this.searchSortingLoader = searchSortingLoader;
        this.defaultDocumentSearchSortingProvider = defaultDocumentSearchSortingProvider;
        this.defaultAuthoritySearchSortingProvider = defaultAuthoritySearchSortingProvider;
        this.authenticationHolder = authenticationHolder;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.allowedDatasetsDepartmentedProvider = allowedDatasetsDepartmentedProvider;
        this.recordExportsGeneratorFactory = recordExportsGeneratorFactory;
        this.currentAuthEditableFondsLoader = currentAuthEditableFondsLoader;
    }
}

