/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.CompositeAllValuesProvider;
import cz.kpsys.portaro.commons.object.FilteredAndSortedAllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.ProviderByIdProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByIdLoaderAdapter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.DefaultProvider;
import cz.kpsys.portaro.commons.object.repo.FilteringCodebook;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.fond.FondEntity;
import cz.kpsys.portaro.record.fond.FondFromDtoConverter;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.view.web.rest.record.FondApiController;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class RecordCodebookConfig {
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final ConverterRegisterer converterRegisterer;

    @Bean
    public FondApiController fondApiController() {
        return new FondApiController((AllValuesProvider)this.fondLoader());
    }

    @Bean
    public Provider<Fond> defaultDocumentFondProvider() {
        return DefaultProvider.byFirst((AllValuesProvider)this.documentFondLoader());
    }

    @Bean
    public Provider<Fond> defaultAuthorityFondProvider() {
        return DefaultProvider.byFirst((AllValuesProvider)this.authorityFondLoader());
    }

    @Bean
    public Codebook<Fond, Integer> fondLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(FondEntity.class, "id").convertedEachBy((Converter)new FondFromDtoConverter()).staticCached(Fond.class.getSimpleName()).build();
    }

    @Bean
    public Codebook<Fond, Integer> filteredFondCodebook() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new CompositeAllValuesProvider(new AllValuesProvider[]{this.allowedDocumentFondsProvider(), this.allowedAuthorityFondsProvider()})).build();
    }

    @Bean
    public Codebook<Fond, Integer> authorityFondLoader() {
        return FilteringCodebook.filteredEverything((Codebook)this.fondLoader(), Fond::isOfAuthority);
    }

    @Bean
    public Codebook<Fond, Integer> documentFondLoader() {
        return FilteringCodebook.filteredEverything((Codebook)this.fondLoader(), Fond::isOfDocument);
    }

    @Bean
    public ContextualProvider<Department, @NonNull List<Fond>> allowedFondsDepartmentedProvider() {
        return department -> ListUtil.union((Collection[])new Collection[]{(Collection)this.allowedDocumentFondsDepartmentedProvider().getOn(department), (Collection)this.allowedAuthorityFondsDepartmentedProvider().getOn(department)});
    }

    @Bean
    public ContextualProvider<Department, @NonNull List<Fond>> allowedDocumentFondsDepartmentedProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.DOCUMENT_FONDS).andThen(arg_0 -> ((AllByIdsLoadableByIdLoaderAdapter)new AllByIdsLoadableByIdLoaderAdapter((ByIdLoadable)this.documentFondLoader())).getAllByIds(arg_0));
    }

    @Bean
    public ContextualProvider<Department, @NonNull List<Fond>> allowedAuthorityFondsDepartmentedProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.AUTHORITY_FONDS).andThen(arg_0 -> ((AllByIdsLoadableByIdLoaderAdapter)new AllByIdsLoadableByIdLoaderAdapter((ByIdLoadable)this.authorityFondLoader())).getAllByIds(arg_0));
    }

    @Bean
    public AllValuesProvider<Fond> allowedDocumentFondsProvider() {
        return new FilteredAndSortedAllValuesProvider((AllValuesProvider)this.documentFondLoader(), this.settingLoader.getOnRootProvidedList(SettingKeys.DOCUMENT_FONDS));
    }

    @Bean
    public AllValuesProvider<Fond> allowedAuthorityFondsProvider() {
        return new FilteredAndSortedAllValuesProvider((AllValuesProvider)this.authorityFondLoader(), this.settingLoader.getOnRootProvidedList(SettingKeys.AUTHORITY_FONDS));
    }

    @Bean
    public Provider<Fond> supplierAuthorityFondProvider() {
        return ProviderByIdProvider.ofStaticId((ByIdLoadable)this.fondLoader(), (Object)61);
    }

    @Bean
    public Provider<Fond> desiderataFondProvider() {
        return ProviderByIdProvider.ofStaticId((ByIdLoadable)this.fondLoader(), (Object)21);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Fond.class, (ByIdLoadable)this.fondLoader());
    }

    @ConstructorProperties(value={"settingLoader", "codebookLoaderBuilderFactory", "converterRegisterer"})
    @Generated
    public RecordCodebookConfig(@NonNull SettingLoader settingLoader, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull ConverterRegisterer converterRegisterer) {
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        this.settingLoader = settingLoader;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.converterRegisterer = converterRegisterer;
    }
}

