/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.cover.CoverService;
import cz.kpsys.portaro.file.directory.DirectoryInsightLoader;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.ParentableDirectory;
import cz.kpsys.portaro.filter.FilterLoader;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.view.web.FileDownloadController;
import cz.kpsys.portaro.view.web.rest.FilterApiController;
import cz.kpsys.portaro.view.web.rest.file.DirectoryApiController;
import cz.kpsys.portaro.view.web.rest.file.FileApiController;
import cz.kpsys.portaro.view.web.rest.record.RecordCoverApiController;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Lazy
public class FileRestApiConfig {
    @NonNull
    private final FilterLoader filterLoader;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader;
    @NonNull
    private final Saver<IdentifiedFile> loadedIdentifiedFileSaver;
    @NonNull
    private final Deleter<IdentifiedFile> identifiedFileDeleter;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final Saver<ParentableDirectory> directorySaver;
    @NonNull
    private final Deleter<ParentableDirectory> directoryDeleter;
    @NonNull
    private final DirectoryInsightLoader directoryInsightLoader;
    @NonNull
    private final FileDataStreamer cachedFileThumbnailDataStreamer;
    @NonNull
    private final FileDataStreamer securedFileDataStreamer;
    @NonNull
    private final FileDataStreamer securedFileTextDataStreamer;
    @NonNull
    private final CoverService coverService;
    @NonNull
    private final Provider<FileAccessType> defaultFileAccessTypeProvider;

    @Bean
    public FilterApiController filterApiController() {
        return new FilterApiController(this.filterLoader);
    }

    @Bean
    public FileApiController fileApiController() {
        return new FileApiController(this.identifiedFileLoader, this.fileSearchLoader, this.loadedIdentifiedFileSaver, this.identifiedFileDeleter);
    }

    @Bean
    public DirectoryApiController directoryApiController() {
        return new DirectoryApiController(this.directoryLoader, this.directorySaver, this.directoryDeleter, this.directoryInsightLoader, this.defaultFileAccessTypeProvider);
    }

    @Bean
    public FileDownloadController fileDownloadController() {
        return new FileDownloadController(this.securedFileDataStreamer, this.cachedFileThumbnailDataStreamer, this.securedFileTextDataStreamer);
    }

    @Bean
    public RecordCoverApiController recordCoverApiController() {
        return new RecordCoverApiController(this.coverService);
    }

    @ConstructorProperties(value={"filterLoader", "identifiedFileLoader", "fileSearchLoader", "loadedIdentifiedFileSaver", "identifiedFileDeleter", "directoryLoader", "directorySaver", "directoryDeleter", "directoryInsightLoader", "cachedFileThumbnailDataStreamer", "securedFileDataStreamer", "securedFileTextDataStreamer", "coverService", "defaultFileAccessTypeProvider"})
    @Generated
    public FileRestApiConfig(@NonNull FilterLoader filterLoader, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader, @NonNull Saver<IdentifiedFile> loadedIdentifiedFileSaver, @NonNull Deleter<IdentifiedFile> identifiedFileDeleter, @NonNull DirectoryLoader directoryLoader, @NonNull Saver<ParentableDirectory> directorySaver, @NonNull Deleter<ParentableDirectory> directoryDeleter, @NonNull DirectoryInsightLoader directoryInsightLoader, @NonNull FileDataStreamer cachedFileThumbnailDataStreamer, @NonNull FileDataStreamer securedFileDataStreamer, @NonNull FileDataStreamer securedFileTextDataStreamer, @NonNull CoverService coverService, @NonNull Provider<FileAccessType> defaultFileAccessTypeProvider) {
        Objects.requireNonNull(filterLoader, "filterLoader is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(fileSearchLoader, "fileSearchLoader is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(identifiedFileDeleter, "identifiedFileDeleter is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(directorySaver, "directorySaver is marked non-null but is null");
        Objects.requireNonNull(directoryDeleter, "directoryDeleter is marked non-null but is null");
        Objects.requireNonNull(directoryInsightLoader, "directoryInsightLoader is marked non-null but is null");
        Objects.requireNonNull(cachedFileThumbnailDataStreamer, "cachedFileThumbnailDataStreamer is marked non-null but is null");
        Objects.requireNonNull(securedFileDataStreamer, "securedFileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(securedFileTextDataStreamer, "securedFileTextDataStreamer is marked non-null but is null");
        Objects.requireNonNull(coverService, "coverService is marked non-null but is null");
        Objects.requireNonNull(defaultFileAccessTypeProvider, "defaultFileAccessTypeProvider is marked non-null but is null");
        this.filterLoader = filterLoader;
        this.identifiedFileLoader = identifiedFileLoader;
        this.fileSearchLoader = fileSearchLoader;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
        this.identifiedFileDeleter = identifiedFileDeleter;
        this.directoryLoader = directoryLoader;
        this.directorySaver = directorySaver;
        this.directoryDeleter = directoryDeleter;
        this.directoryInsightLoader = directoryInsightLoader;
        this.cachedFileThumbnailDataStreamer = cachedFileThumbnailDataStreamer;
        this.securedFileDataStreamer = securedFileDataStreamer;
        this.securedFileTextDataStreamer = securedFileTextDataStreamer;
        this.coverService = coverService;
        this.defaultFileAccessTypeProvider = defaultFileAccessTypeProvider;
    }
}

