/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro;

import cz.kpsys.portaro.core.application.PortaroVersion;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public final class ExternalLogFields {
    @NonNull
    private final Map<String, Object> map;

    public ExternalLogFields setConfiguringPhase() {
        this.map.put("phase", "configuring");
        return this;
    }

    public ExternalLogFields setStartedPhase() {
        this.map.put("phase", "started");
        return this;
    }

    public ExternalLogFields setVersion(@NonNull PortaroVersion portaroVersion) {
        Objects.requireNonNull(portaroVersion, "portaroVersion is marked non-null but is null");
        this.map.put("version", portaroVersion.getValue());
        this.map.put("versionDate", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(portaroVersion.getDate()));
        return this;
    }

    public ExternalLogFields setSerialCode(@NonNull String serialCode) {
        Objects.requireNonNull(serialCode, "serialCode is marked non-null but is null");
        this.map.put("serialNumber", serialCode);
        return this;
    }

    public ExternalLogFields setPortaroUrl(@Nullable String portaroUrl) {
        this.map.put("portaroUrl", portaroUrl);
        return this;
    }

    public ExternalLogFields setLibraryName(@Nullable String libraryName) {
        this.map.put("libraryName", libraryName);
        return this;
    }

    public ExternalLogFields setLibraryCity(@Nullable String libraryCity) {
        this.map.put("libraryCity", libraryCity);
        return this;
    }

    @ConstructorProperties(value={"map"})
    @Generated
    public ExternalLogFields(@NonNull Map<String, Object> map) {
        Objects.requireNonNull(map, "map is marked non-null but is null");
        this.map = map;
    }

    @NonNull
    @Generated
    public Map<String, Object> getMap() {
        return this.map;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalLogFields)) {
            return false;
        }
        ExternalLogFields other = (ExternalLogFields)o;
        Map this$map = this.getMap();
        Map other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExternalLogFields(map=" + this.getMap() + ")";
    }
}

