/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_tr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AUD", "AU$" },
            { "JPY", "\u00a5" },
            { "PHP", "PHP" },
            { "THB", "\u0e3f" },
            { "TRY", "\u20ba" },
            { "USD", "$" },
            { "adp", "Andorra Pezetas\u0131" },
            { "aed", "Birle\u015fik Arap Emirlikleri dirhemi" },
            { "afa", "Afganistan Afganisi (1927\u20132002)" },
            { "afn", "Afganistan afganisi" },
            { "alk", "Arnavutluk Leki (1946\u20131965)" },
            { "all", "Arnavutluk leki" },
            { "amd", "Ermenistan dram\u0131" },
            { "ang", "Hollanda Antilleri guldeni" },
            { "aoa", "Angola kvanzas\u0131" },
            { "aok", "Angola Kvanzas\u0131 (1977\u20131990)" },
            { "aon", "Yeni Angola Kvanzas\u0131 (1990\u20132000)" },
            { "aor", "Angola Kvanzas\u0131 Reajustado (1995\u20131999)" },
            { "ara", "Arjantin Australi" },
            { "arl", "Arjantin Peso Leyi (1970\u20131983)" },
            { "arm", "Arjantin Pesosu (1881\u20131970)" },
            { "arp", "Arjantin Pezosu (1983\u20131985)" },
            { "ars", "Arjantin pesosu" },
            { "ats", "Avusturya \u015eilini" },
            { "aud", "Avustralya dolar\u0131" },
            { "awg", "Aruba florini" },
            { "azm", "Azerbaycan Manat\u0131 (1993\u20132006)" },
            { "azn", "Azerbaycan manat\u0131" },
            { "bad", "Bosna Hersek Dinar\u0131" },
            { "bam", "Konvertibl Bosna Hersek mark\u0131" },
            { "ban", "Yeni Bosna Hersek Dinar\u0131 (1994\u20131997)" },
            { "bbd", "Barbados dolar\u0131" },
            { "bdt", "Banglade\u015f takas\u0131" },
            { "bec", "Bel\u00e7ika Frang\u0131 (konvertibl)" },
            { "bef", "Bel\u00e7ika Frang\u0131" },
            { "bel", "Bel\u00e7ika Frang\u0131 (finansal)" },
            { "bgl", "Bulgar Levas\u0131 (Hard)" },
            { "bgm", "Sosyalist Bulgaristan Levas\u0131" },
            { "bgn", "Bulgar levas\u0131" },
            { "bgo", "Bulgar Levas\u0131 (1879\u20131952)" },
            { "bhd", "Bahreyn dinar\u0131" },
            { "bif", "Burundi frang\u0131" },
            { "bmd", "Bermuda dolar\u0131" },
            { "bnd", "Brunei dolar\u0131" },
            { "bob", "Bolivya bolivyanosu" },
            { "bol", "Bolivya Bolivyanosu (1863\u20131963)" },
            { "bop", "Bolivya Pezosu" },
            { "bov", "Bolivya Mvdolu" },
            { "brb", "Yeni Brezilya Kruzeirosu (1967\u20131986)" },
            { "brc", "Brezilya Kruzadosu" },
            { "bre", "Brezilya Kruzeirosu (1990\u20131993)" },
            { "brl", "Brezilya reali" },
            { "brn", "Yeni Brezilya Kruzadosu" },
            { "brr", "Brezilya Kruzeirosu" },
            { "brz", "Brezilya Kruzeirosu (1942\u20131967)" },
            { "bsd", "Bahama dolar\u0131" },
            { "btn", "Butan ngultrumu" },
            { "buk", "Burma Kyat\u0131" },
            { "bwp", "Botsvana pulas\u0131" },
            { "byb", "Yeni Beyaz Rusya Rublesi (1994\u20131999)" },
            { "byn", "Belarus rublesi" },
            { "byr", "Beyaz Rusya Rublesi (2000\u20132016)" },
            { "bzd", "Belize dolar\u0131" },
            { "cad", "Kanada dolar\u0131" },
            { "cdf", "Kongo frang\u0131" },
            { "che", "WIR Avrosu" },
            { "chf", "\u0130svi\u00e7re frang\u0131" },
            { "chw", "WIR Frang\u0131" },
            { "cle", "\u015eili Esk\u00fcdosu" },
            { "clf", "\u015eili Unidades de Fomento" },
            { "clp", "\u015eili pesosu" },
            { "cnh", "\u00c7in yuan\u0131 (offshore)" },
            { "cnx", "\u00c7in Halk Cumhuriyeti Merkez Bankas\u0131 Dolar\u0131" },
            { "cny", "\u00c7in yuan\u0131" },
            { "cop", "Kolombiya pesosu" },
            { "cou", "Unidad de Valor Real" },
            { "crc", "Kosta Rika kolonu" },
            { "csd", "Eski S\u0131rbistan Dinar\u0131" },
            { "csk", "\u00c7ekoslavak Korunas\u0131 (Hard)" },
            { "cuc", "Konvertibl K\u00fcba pesosu" },
            { "cup", "K\u00fcba pesosu" },
            { "cve", "Cape Verde esk\u00fcdosu" },
            { "cyp", "G\u00fcney K\u0131br\u0131s Liras\u0131" },
            { "czk", "\u00c7ek korunas\u0131" },
            { "ddm", "Do\u011fu Alman Mark\u0131" },
            { "dem", "Alman Mark\u0131" },
            { "djf", "Cibuti frang\u0131" },
            { "dkk", "Danimarka kronu" },
            { "dop", "Dominik pesosu" },
            { "dzd", "Cezayir dinar\u0131" },
            { "ecs", "Ekvador Sukresi" },
            { "ecv", "Ekvador Unidad de Valor Constante (UVC)" },
            { "eek", "Estonya Krunu" },
            { "egp", "M\u0131s\u0131r liras\u0131" },
            { "ern", "Eritre nakfas\u0131" },
            { "esa", "\u0130spanyol Pezetas\u0131 (A hesab\u0131)" },
            { "esb", "\u0130spanyol Pezetas\u0131 (konvertibl hesap)" },
            { "esp", "\u0130spanyol Pezetas\u0131" },
            { "etb", "Etiyopya birri" },
            { "eur", "Euro" },
            { "fim", "Fin Markkas\u0131" },
            { "fjd", "Fiji dolar\u0131" },
            { "fkp", "Falkland Adalar\u0131 liras\u0131" },
            { "frf", "Frans\u0131z Frang\u0131" },
            { "gbp", "\u0130ngiliz sterlini" },
            { "gek", "G\u00fcrcistan Kupon Larisi" },
            { "gel", "G\u00fcrcistan larisi" },
            { "ghc", "Gana Sedisi (1979\u20132007)" },
            { "ghs", "Gana sedisi" },
            { "gip", "Cebelitar\u0131k liras\u0131" },
            { "gmd", "Gambiya dalasisi" },
            { "gnf", "Gine frang\u0131" },
            { "gns", "Gine Sylisi" },
            { "gqe", "Ekvator Ginesi Ekuelesi" },
            { "grd", "Yunan Drahmisi" },
            { "gtq", "Guatemala quetzal\u0131" },
            { "gwe", "Portekiz Ginesi Esk\u00fcdosu" },
            { "gwp", "Gine-Bissau Pezosu" },
            { "gyd", "Guyana dolar\u0131" },
            { "hkd", "Hong Kong dolar\u0131" },
            { "hnl", "Honduras lempiras\u0131" },
            { "hrd", "H\u0131rvatistan Dinar\u0131" },
            { "hrk", "H\u0131rvatistan kunas\u0131" },
            { "htg", "Haiti gurdu" },
            { "huf", "Macar forinti" },
            { "idr", "Endonezya rupisi" },
            { "iep", "\u0130rlanda Liras\u0131" },
            { "ilp", "\u0130srail Liras\u0131" },
            { "ilr", "\u0130srail \u015eekeli (1980\u20131985)" },
            { "ils", "Yeni \u0130srail \u015fekeli" },
            { "inr", "Hindistan rupisi" },
            { "iqd", "Irak dinar\u0131" },
            { "irr", "\u0130ran riyali" },
            { "isj", "\u0130zlanda Kronu (1918\u20131981)" },
            { "isk", "\u0130zlanda kronu" },
            { "itl", "\u0130talyan Lireti" },
            { "jmd", "Jamaika dolar\u0131" },
            { "jod", "\u00dcrd\u00fcn dinar\u0131" },
            { "jpy", "Japon yeni" },
            { "kes", "Kenya \u015filini" },
            { "kgs", "K\u0131rg\u0131zistan somu" },
            { "khr", "Kambo\u00e7ya rieli" },
            { "kmf", "Komorlar frang\u0131" },
            { "kpw", "Kuzey Kore wonu" },
            { "krh", "G\u00fcney Kore Hwan\u0131 (1953\u20131962)" },
            { "kro", "G\u00fcney Kore Wonu (1945\u20131953)" },
            { "krw", "G\u00fcney Kore wonu" },
            { "kwd", "Kuveyt dinar\u0131" },
            { "kyd", "Cayman Adalar\u0131 dolar\u0131" },
            { "kzt", "Kazakistan tengesi" },
            { "lak", "Laos kipi" },
            { "lbp", "L\u00fcbnan liras\u0131" },
            { "lkr", "Sri Lanka rupisi" },
            { "lrd", "Liberya dolar\u0131" },
            { "lsl", "Lesotho lotisi" },
            { "ltl", "Litvanya Litas\u0131" },
            { "ltt", "Litvanya Talonu" },
            { "luc", "Konvertibl L\u00fcksemburg Frang\u0131" },
            { "luf", "L\u00fcksemburg Frang\u0131" },
            { "lul", "Finansal L\u00fcksemburg Frang\u0131" },
            { "lvl", "Letonya Lat\u0131" },
            { "lvr", "Letonya Rublesi" },
            { "lyd", "Libya dinar\u0131" },
            { "mad", "Fas dirhemi" },
            { "maf", "Fas Frang\u0131" },
            { "mcf", "Monako Frang\u0131" },
            { "mdc", "Moldova Kuponu" },
            { "mdl", "Moldova leyi" },
            { "mga", "Madagaskar ariarisi" },
            { "mgf", "Madagaskar Frang\u0131" },
            { "mkd", "Makedonya dinar\u0131" },
            { "mkn", "Makedonya Dinar\u0131 (1992\u20131993)" },
            { "mlf", "Mali Frang\u0131" },
            { "mmk", "Myanmar kyat\u0131" },
            { "mnt", "Mo\u011folistan tugriki" },
            { "mop", "Makao patakas\u0131" },
            { "mro", "Moritanya Ugiyas\u0131 (1973\u20132017)" },
            { "mru", "Moritanya ugiyas\u0131" },
            { "mtl", "Malta Liras\u0131" },
            { "mtp", "Malta Sterlini" },
            { "mur", "Mauritius rupisi" },
            { "mvp", "Maldiv Rupisi" },
            { "mvr", "Maldiv rufiyaas\u0131" },
            { "mwk", "Malavi kva\u00e7as\u0131" },
            { "mxn", "Meksika pesosu" },
            { "mxp", "G\u00fcm\u00fc\u015f Meksika Pezosu (1861\u20131992)" },
            { "mxv", "Meksika Unidad de Inversion (UDI)" },
            { "myr", "Malezya ringgiti" },
            { "mze", "Mozambik Esk\u00fcdosu" },
            { "mzm", "Eski Mozambik Metikali" },
            { "mzn", "Mozambik metikali" },
            { "nad", "Namibya dolar\u0131" },
            { "ngn", "Nijerya nairas\u0131" },
            { "nic", "Nikaragua Kordobas\u0131 (1988\u20131991)" },
            { "nio", "Nikaragua kordobas\u0131" },
            { "nlg", "Hollanda Florini" },
            { "nok", "Norve\u00e7 kronu" },
            { "npr", "Nepal rupisi" },
            { "nzd", "Yeni Zelanda dolar\u0131" },
            { "omr", "Umman riyali" },
            { "pab", "Panama balboas\u0131" },
            { "pei", "Peru \u0130nti" },
            { "pen", "Peru sol\u00fc" },
            { "pes", "Peru Sol\u00fc (1863\u20131965)" },
            { "pgk", "Papua Yeni Gine kinas\u0131" },
            { "php", "Filipinler pesosu" },
            { "pkr", "Pakistan rupisi" },
            { "pln", "Polonya zlotisi" },
            { "plz", "Polonya Zlotisi (1950\u20131995)" },
            { "pte", "Portekiz Esk\u00fcdosu" },
            { "pyg", "Paraguay guaranisi" },
            { "qar", "Katar riyali" },
            { "rhd", "Rodezya Dolar\u0131" },
            { "rol", "Eski Romen Leyi" },
            { "ron", "Romen leyi" },
            { "rsd", "S\u0131rp dinar\u0131" },
            { "rub", "Rus rublesi" },
            { "rur", "Rus Rublesi (1991\u20131998)" },
            { "rwf", "Ruanda frang\u0131" },
            { "sar", "Suudi Arabistan riyali" },
            { "sbd", "Solomon Adalar\u0131 dolar\u0131" },
            { "scr", "Sey\u015feller rupisi" },
            { "sdd", "Eski Sudan Dinar\u0131" },
            { "sdg", "Sudan liras\u0131" },
            { "sdp", "Eski Sudan Liras\u0131" },
            { "sek", "\u0130sve\u00e7 kronu" },
            { "sgd", "Singapur dolar\u0131" },
            { "shp", "Saint Helena liras\u0131" },
            { "sit", "Slovenya Tolar\u0131" },
            { "skk", "Slovak Korunas\u0131" },
            { "sle", "Sierra Leone leonesi" },
            { "sll", "Sierra Leone leonesi (1964\u20132022)" },
            { "sos", "Somali \u015filini" },
            { "srd", "Surinam dolar\u0131" },
            { "srg", "Surinam Guldeni" },
            { "ssp", "G\u00fcney Sudan liras\u0131" },
            { "std", "S\u00e3o Tom\u00e9 ve Pr\u00edncipe Dobras\u0131 (1977\u20132017)" },
            { "stn", "Sao Tome ve Principe dobras\u0131" },
            { "sur", "Sovyet Rublesi" },
            { "svc", "El Salvador Kolonu" },
            { "syp", "Suriye liras\u0131" },
            { "szl", "Svaziland lilangenisi" },
            { "thb", "Tayland baht\u0131" },
            { "tjr", "Tacikistan Rublesi" },
            { "tjs", "Tacikistan somonisi" },
            { "tmm", "T\u00fcrkmenistan Manat\u0131 (1993\u20132009)" },
            { "tmt", "T\u00fcrkmenistan manat\u0131" },
            { "tnd", "Tunus dinar\u0131" },
            { "top", "Tonga pa\u02bbangas\u0131" },
            { "tpe", "Timor Esk\u00fcdosu" },
            { "trl", "Eski T\u00fcrk Liras\u0131" },
            { "try", "T\u00fcrk liras\u0131" },
            { "ttd", "Trinidad ve Tobago dolar\u0131" },
            { "twd", "Yeni Tayvan dolar\u0131" },
            { "tzs", "Tanzanya \u015filini" },
            { "uah", "Ukrayna grivnas\u0131" },
            { "uak", "Ukrayna Karbovanetz" },
            { "ugs", "Uganda \u015eilini (1966\u20131987)" },
            { "ugx", "Uganda \u015filini" },
            { "usd", "ABD dolar\u0131" },
            { "usn", "ABD Dolar\u0131 (Ertesi g\u00fcn)" },
            { "uss", "ABD Dolar\u0131 (Ayn\u0131 g\u00fcn)" },
            { "uyi", "Uruguay Peso en Unidades Indexadas" },
            { "uyp", "Uruguay Pezosu (1975\u20131993)" },
            { "uyu", "Uruguay pesosu" },
            { "uzs", "\u00d6zbekistan somu" },
            { "veb", "Venezuela Bolivar\u0131 (1871\u20132008)" },
            { "vef", "Venezuela Bolivar\u0131 (2008\u20132018)" },
            { "ves", "Venezuela bolivar\u0131" },
            { "vnd", "Vietnam dongu" },
            { "vnn", "Vietnam Dongu (1978\u20131985)" },
            { "vuv", "Vanuatu vatusu" },
            { "wst", "Samoa talas\u0131" },
            { "xaf", "Orta Afrika CFA frang\u0131" },
            { "xag", "G\u00fcm\u00fc\u015f" },
            { "xau", "Alt\u0131n" },
            { "xba", "Birle\u015fik Avrupa Birimi" },
            { "xbb", "Avrupa Para Birimi (EMU)" },
            { "xbc", "Avrupa Hesap Birimi (XBC)" },
            { "xbd", "Avrupa Hesap Birimi (XBD)" },
            { "xcd", "Do\u011fu Karayip dolar\u0131" },
            { "xdr", "\u00d6zel \u00c7ekme Hakk\u0131 (SDR)" },
            { "xeu", "Avrupa Para Birimi" },
            { "xfo", "Frans\u0131z Alt\u0131n Frang\u0131" },
            { "xfu", "Frans\u0131z UIC-Frang\u0131" },
            { "xof", "Bat\u0131 Afrika CFA frang\u0131" },
            { "xpd", "Paladyum" },
            { "xpf", "CFP frang\u0131" },
            { "xpt", "Platin" },
            { "xre", "RINET Fonlar\u0131" },
            { "xsu", "Sucre" },
            { "xts", "Test Para Birimi Kodu" },
            { "xua", "ADB Hesap Birimi" },
            { "xxx", "Bilinmeyen Para Birimi" },
            { "ydd", "Yemen Dinar\u0131" },
            { "yer", "Yemen riyali" },
            { "yud", "Yugoslav Dinar\u0131 (Hard)" },
            { "yum", "Yeni Yugoslav Dinar\u0131" },
            { "yun", "Konvertibl Yugoslav Dinar\u0131" },
            { "yur", "\u0130yile\u015ftirilmi\u015f Yugoslav Dinar\u0131 (1992\u20131993)" },
            { "zal", "G\u00fcney Afrika Rand\u0131 (finansal)" },
            { "zar", "G\u00fcney Afrika rand\u0131" },
            { "zmk", "Zambiya Kva\u00e7as\u0131 (1968\u20132012)" },
            { "zmw", "Zambiya kva\u00e7as\u0131" },
            { "zrn", "Yeni Zaire Zairesi" },
            { "zrz", "Zaire Zairesi" },
            { "zwd", "Zimbabve Dolar\u0131" },
            { "zwl", "Zimbabve Dolar\u0131 (2009)" },
            { "zwr", "Zimbabve Dolar\u0131 (2008)" },
        };
        return data;
    }
}
