"use strict";(globalThis.webpackChunkportaro=globalThis.webpackChunkportaro||[]).push([[352],{54770:(n,e,t)=>{t.r(e),t.d(e,{default:()=>p});var a=t(18591),o=(t(2531),t(94655)),s=t(87390),i=t(33247);const r='# API docs for Portaro\n{docdate}\n:toc: left\n:sectnums:\n:toclevels: 2\n:sectnumlevels: 2\n:doctype: book\n:icons: font\n:source-highlighter: highlightjs\n:verbisboxerStationHeartbeatInterval: 30s\n:verbisboxerStationDownTimeout: 2min\n:verbisboxerServerResponseTimeout: 20s\n:verbisboxerStationRequestRetryCount: 2\n:verbisboxerPinLength: 6\n:verbisboxerUrlPrefix: https://verbis-boxer.kpsys.cz/verbisbox/v2\n\n## Authentication\n\nAuthentication to Portaro uses standard OAuth2 client or authorization code flows.\n\n### Get token\n\n#### for client (e.g. Verbis app)\n\n```http\nPOST /oauth/token HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nAuthorization: Basic <base64encodedclientandpassword>\nHost: https://demo.kpsys.cz\n\ngrant_type:client_credentials\n````\n\n##### Example cURL\n\n```bash\ncurl --request POST --url http://localhost/oauth/token --header "Authorization: Basic <base64encodedclientandpassword>" --data grant_type=client_credentials\n```\n\n#### for user via client\n\n```http\nPOST /oauth/token HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nAuthorization: Basic <base64encodedclientandpassword>\nHost: https://demo.kpsys.cz\n\ngrant_type:password\nusername:<knihovnikovo_jmeno>\npassword:<knihovnikovo_heslo>\n```\n\n##### Example cURL\n\n```bash\ncurl --request POST --url http://localhost/oauth/token --header "Authorization: Basic <base64encodedclientandpassword>" --data grant_type=password --data username=<knihovnikovo_jmeno> --data password=<knihovnikovo_heslo>\n```\n\n## Response\n\n### Example\n\n```json\n{\n  "access_token": "<access_token>",\n  "token_type": "bearer",\n  "expires_in": 43199,\n  "scope": "EVIDED",\n  "jti": "dd6d6306-a13e-46d6-8379-92b9096fbd13"\n}\n```\n\n## Subsequent authorized calls\n\nTo all requests, add header\n\n```\nAuthorization: Bearer <access_token>\n```\n\n### Example cURL\n\n```bash\ncurl --request GET --url http://localhost/api/users/current --header "Authorization: Bearer <access_token>"\n```\n\n## Search\n\nCommon entrypoint for all search is `/search`. Main parameter for specifying what to search is `kind`.\n\nCommon parameters\n\n```\n- pageSize - page size used for pagination\n- pageNumber - page number in pagination\n- kind - what to search, values can be \'document\', \'authority\', \'exemplar\', \'user\'\n- q - generic query parameter, used as global or \'whatewer\'\n- name - item name (document field 245, authority field 100, use person name, etc.)\n```\n\n### Document search\n\nWhen search for documents, specify `kind=record&subkind=document` parameters. Specific parameters\n\n#### Example 200\n\n```http\nGET /api/search?kind=record&subkind=document&rootFond=1&name=babicka HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\nContent-Length: 0\n```\n\n```json\n{\n    "title": "babicka",\n    "subtitle": null,\n    "type": "",\n    "id": "LqvxiiCWQl-Je5RImqfiUw",\n    "result": {\n        "totalElements": 3,\n        "duration": 281,\n        "content": [\n            {\n                "fond": {\n                    "id": 1,\n                    "name": "Monografie",\n                    "text": "Monografie"\n                },\n                "status": {\n                    "id": 4,\n                    "text": "Ukončená katalogizace"\n                },\n                "author": "aaaa bbbb",\n                "isbn": null,\n                "name": "Babička",\n                "type": "document",\n                "id": "63a6c870-cbdf-43cb-ad7b-12bd4af083b0",\n                "kindedId": 97169,\n                "text": "Babička",\n                "exemplarable": true,\n                "publisher": null,\n                "lastUpdateDate": "2020-11-04T14:51:42+01:00",\n                "cover": null,\n                "directoryId": 282019,\n                "volumeable": false,\n                "periodical": false\n            },\n            {\n                "fond": {\n                    "id": 1,\n                    "name": "Monografie",\n                    "text": "Monografie"\n                },\n                "status": {\n                    "id": 4,\n                    "text": "Ukončená katalogizace"\n                },\n                "author": "Němcová, Božena,",\n                "isbn": null,\n                "name": "Babička",\n                "type": "document",\n                "id": "d7905d5d-0bc6-41b4-b3a8-b66c9af0a2f4",\n                "kindedId": 4334,\n                "text": "Babička",\n                "exemplarable": true,\n                "publisher": "Praha : Státní nakladatelství krásné literatury a umění, 1961",\n                "lastUpdateDate": "2020-10-14T11:10:03+02:00",\n                "cover": null,\n                "directoryId": 19868,\n                "volumeable": false,\n                "periodical": false\n            },\n            {\n                "fond": {\n                    "id": 1,\n                    "name": "Monografie",\n                    "text": "Monografie"\n                },\n                "status": {\n                    "id": 0,\n                    "text": "Nedefinován"\n                },\n                "author": "Hejná, Olga,",\n                "isbn": null,\n                "name": "Tajemnica babci",\n                "type": "document",\n                "id": "f0e0a945-06f5-4fbb-aedb-c18bc6b0f164",\n                "kindedId": 14,\n                "text": "Tajemnica babci",\n                "exemplarable": true,\n                "publisher": "Warszawa : Nasza Księgarnia, 1972",\n                "lastUpdateDate": "2020-10-19T09:25:32+02:00",\n                "cover": {\n                    "id": 42968,\n                    "name": "obálka",\n                    "text": "obálka"\n                },\n                "directoryId": 71034,\n                "volumeable": false,\n                "periodical": false\n            }\n        ],\n        "numberOfElements": 3,\n        "totalPages": 1,\n        "pageNumber": 1,\n        "pageSize": 10\n    }\n}\n```\n\n### Authority search\n\nWhen search for authorities, specify `kind=record&subind=authority` parameter. Specific parameters\n\n```\n```\n\n#### Example 200\n\n```http\nGET /api/search?kind=record&subkind=authority&rootFond=31&name=Božena+Němcová HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\nContent-Length: 0\n```\n\n```json\n{\n    "title": "Božena Němcová",\n    "subtitle": null,\n    "type": "",\n    "id": "K9MwxcprTo2daXoKxvMHWw",\n    "result": {\n        "totalElements": 1,\n        "duration": 138,\n        "content": [\n            {\n                "name": "Božena Němcová",\n                "type": "authority",\n                "text": "Božena Němcová",\n                "fond": {\n                    "id": 31,\n                    "name": "Jména osob",\n                    "text": "Jména osob"\n                },\n                "id": "b6d4b384-08f8-4e7b-8497-13e76893985d",\n                "kindedId": 191470,\n                "status": {\n                    "id": 13,\n                    "text": "Vlastní autorita"\n                },\n                "lastUpdateDate": "2020-09-06T15:43:24+02:00",\n                "cover": null,\n                "directoryId": 282021\n            }\n        ],\n        "numberOfElements": 1,\n        "totalPages": 1,\n        "pageNumber": 1,\n        "pageSize": 30\n    }\n}\n```\n\n## Newest documents\n\nStandalone endpoint for fetching newest documents (showing on portaro home page)\n\n### Example\n\n#### Example 200\n\n```http\nGET /api/newest-documents HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\nContent-Length: 0\n```\n\n```json\n[\n    {\n        "id": "25a8d5a6-40aa-49ce-83a6-e7eccb185e9a",\n        "name": "Chlorid sodný",\n        "type": "document",\n        "fond": {"id": 1, "name": "Monografie"},\n        "author": "Adler-Olsen, Jussi,",\n        "isbn": {\n            "value": "9788027511587",\n            "trimmedValue": "9788027511587"\n        },\n        "publisher": "Brno : Host, 2022",\n        "publicationStartYear": {"value": 2022, "text": "2022"},\n        "cover": {"id": 427344},\n        "fields": [],\n        "text": "Chlorid sodný"\n    }\n]\n```\n\n## Record resource\n\n### Create or edit the record field\n\nTo create/edit a field or subfield, you must specify fieldId of that field\n\n```url\nPUT /api/v2/records/{recordId}/fields/{fieldId}\n```\n\nwhere\n\n- `recordId` is record uuid, e.g. `517458e6-0a48-4af0-a33f-4089f87ccfda`\n- `fieldId` e.g. `d245#0.a#0`\n- request body is json with value to set in `value` field\n\n#### Example 200\n\n```http\nPOST /api/v2/records/4949eac9-dfee-4256-8f51-56f42c5464a0/fields/d245#0.a#0 HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n  "value":"Headway"\n}\n```\n\nComplex authority field (code `main`)\n\n```http\nPOST /api/v2/records/4949eac9-dfee-4256-8f51-56f42c5464a0/fields/d100#0.main#0 HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n  "value":{\n    "id":"fb8f6957-f17b-4f09-86e1-bdfdfd7519b8"\n  }\n}\n```\n\nSimple authority field (code `a`) by unknown record - specify string subfield value\n\n```http\nPOST /api/v2/records/4949eac9-dfee-4256-8f51-56f42c5464a0/fields/d655#0.a#0 HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n  "value": {\n    "fieldLabel": "Beletrie"\n  }\n}\n```\n\nComplex authority field (code `main`) by unknown record - specify values for particular subfield codes (e.g. 100.a, 100.b, 100.c)\n\n```http\nPOST /api/v2/records/4949eac9-dfee-4256-8f51-56f42c5464a0/fields/d100#0.main#0 HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n  "value": {\n    "fieldLabels": {\n      "d100.a": "Němcová, Božena",\n      "d100.d": "1820-1862"\n    }\n  }\n}\n```\n\n## Record editation resource\n\nFor a complex manipulation with record, use `/api/record-editations` endpoint. Firstly, create an record editation for easy fields manipulation. Then, you can add or remove new fields, add or edit field values. Each field gets own unique id. With this id you can address any of field.\n\n### Create record editation\n\nCreates new editation session with given record\n\n```url\nPOST /api/record-editations\n```\n\nwith request body\n\n```json\n{\n  "subkind": {kind},\n  "fond": {fond},\n  "revisionSavingPolicy": {revisionSavingPolicy},\n  "emptyFieldsCompletion": {emptyFieldsCompletion},\n}\n```\n\nwhere\n\n- `kind` is type of record: `document` or `authority`\n- `fond` is id of desired record fond, e.g. `1` or `53`\n- `revisionSavingPolicy` is policy, when to automatically save record, possible values are\n    * `manual-only` - system will never save record automatically - after finish editation, you will have to call save or publish\n    * `after-each-change-when-draft` - system will save record after any change, when record is DRAFT (not published), after publish, you will have to call save manually\n    * `after-each-change-always` - system will save record after any change automatically (no need for manual calling save or publish)\n- `emptyFieldsCompletion` is whether to automatic empty fields creation, `true` or `false`, default `true`\n\n#### Example 200\n\n```http\nPOST /api/record-editations HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n  "subkind": "document",\n  "fond": 1,\n  "revisionSavingPolicy": "manual-only",\n  "emptyFieldsCompletion": false\n}\n```\n\n```json\n{\n  "id": "sP5NmmLPQVqMGG-EMxqecg",\n  "text": "",\n  "recordId": "1283f867-3ff8-446f-b3a1-e67ce20cd21c",\n  "directoryId": 482527,\n  "type": "document",\n  "draft": false,\n  "revisionSaved": true,\n  "fond": {\n    "id": 1,\n    "text": "Monografie"\n  },\n  "fields": [\n    {\n      "id": "96ab9ae4-8764-4fca-9a3e-a78a76e85a30",\n      "fieldRepetition": 0,\n      "ind1": "0",\n      "ind2": "0",\n      "empty": true,\n      "fieldId": "245#0",\n      "text": "",\n      "code": "245",\n      "typeId": "d245",\n      "fieldTypeText": "Údaje o názvu",\n      "fields": [\n        {\n          "id": "4cc32a88-4246-409e-8931-850b61db1ceb",\n          "value": null,\n          "empty": true,\n          "fieldId": "245#0.a#0",\n          "text": "",\n          "url": false,\n          "recordLink": false,\n          "raw": null,\n          "recordId": null,\n          "typeId": "d245.a",\n          "code": "a",\n          "fieldTypeText": "Název"\n        },\n        {\n          "id": "6324477d-3491-41ec-a77d-01371227611d",\n          "value": null,\n          "empty": true,\n          "fieldId": "245#0.b#0",\n          "text": "",\n          "url": false,\n          "recordLink": false,\n          "raw": null,\n          "recordId": null,\n          "typeId": "d245.b",\n          "code": "b",\n          "fieldTypeText": "Další údaje o názvu"\n        },\n        {\n          "id": "e9ee2815-ab07-4b53-a8de-73e701e433b1",\n          "value": null,\n          "empty": true,\n          "fieldId": "245#0.c#0",\n          "text": "",\n          "url": false,\n          "recordLink": false,\n          "raw": null,\n          "recordId": null,\n          "typeId": "d245.c",\n          "code": "c",\n          "fieldTypeText": "Údaj o odpovědnosti atd."\n        }\n      ]\n    }\n  ]\n}\n```\n\n### Publish record editation\n\nPublish and save finished record editation session\n\n```http\nPOST /api/record-editations/sP5NmmLPQVqMGG-EMxqecg/publish HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n```\n\n### Set record catalogization phase\n\n```url\nPOST /api/records/status\n\n{\n    record: string,\n    status: number\n}\n```\n\nwhere\n\n- `record` is record uuid, e.g. `517458e6-0a48-4af0-a33f-4089f87ccfda`\n- `status` is desired record status, valid value is one of:\n    * `3` — represent status "standard document" state\n    * `4` — represent "finished cataloging" state\n\n\x3c!-- end list --\x3e\n\n```http\nPOST /api/records/status HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n  "record": "517458e6-0a48-4af0-a33f-4089f87ccfda",\n  "status": 4\n}\n```\n\n### Set record to be visible on given department\n\nAfter record is created, you hava to specify, where it can be visible. So, create record "holding" on given department.\n\n```http\nPOST /api/record-holdings HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n    "record": "1283f867-3ff8-446f-b3a1-e67ce20cd21c",\n    "department": 26\n}\n```\n\nResponse\n\n```json\n{\n  "savedObject": {\n    "id": "6713191e-f9cc-47a7-9307-7d7cffbb0b44"\n  }\n}\n```\n\n## Record bulk edit resource\n\n### Bulk upsert record fields\n\nFor a bulk editation of one or more fields in one or more records\n\n```url\n/api/records/fields/bulkedit/complex\n```\n\n#### Example 200\n\nIf we want to upsert (create or replace) field `856` with value `https://neco.cz` in subfield `u` and value `plný text` in subfield `y`. If subfield `856.u` with value `https://neco.cz` is already present in record, it will be reused and updated with `plný text` to subfield `y`.\n\n```http\nPOST /api/records/fields/bulkedit/complex\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n```\n\n```json\n{\n    "reusing": [{"id": "dkid:23543"}],\n    "value": [\n        {\n            "reusing": [{\n                "type": "d856",\n                "havingField": {"type": "d856.u", "value": "https://neco.cz"}\n            }],\n            "set": {\n                "type": "d856",\n                "value": [\n                    {\n                        "reusing": [{"type": "d856.u"}],\n                        "set": {"type": "d856.u", "value": "https://neco.cz"}\n                    },\n                    {\n                        "reusing": [{"type": "d856.y"}],\n                        "set": {"type": "d856.y", "value": "plný text"}\n                    }\n                ]\n            }\n        }\n    ]\n}\n```\n\nwhere\n\n- `reusing` is object, which defines record(s) or field(s), which will be edited ("deduplicated"). If no record/field is found, new record/field will be created.\n- `reusing.type` type id of field, which we want to edit\n- `reusing.havingField` if we want to specify, that field we want to edit must have subfield of given type and value\n\n## Sync resource\n\n### Sync single user by external-system user identifier\n\nTo sync single user\n\n```url\nPOST /api/sync/user\n```\n\nResponse: `FinishedUserSyncResponse` (subclass of `ActionResponse`)\n\n```\nFinishedUserSyncResponse:\n{\n    responseType: "FinishedUserSyncResponse",\n    text: string,\n    items: ItemSyncResult[]\n}\n\nItemSyncResult:\n{\n    item?: LabeledIdentified,\n    way: string\n}\n\nLabeledIdentified:\n{\n    id: string | number,\n    text: string\n}\n\nSyncWay:\n"CREATE" | "CREATE_DRAFT" | "UPDATE" | "DELETE" | "SKIP"\n```\n\n#### Example 200\n\n```http\nPOST /api/sync/user HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n  "identifier": "ZAM1XYZ"\n}\n```\n\n```json\n{\n    "text": "User synced with identifier ZAM1XYZ",\n    "responseType": "FinishedUserSyncResponse",\n    "finished": true,\n    "items": [{\n        "item": {\n            "id": 123456,\n            "text": "Jessica Alba"\n        },\n        "way": "CREATE"\n    }]\n}\n```\n\n### Fetch-only single user by external-system user identifier\n\nTo fetch single user\n\n```url\nPOST /api/sync/user/fetch\n```\n\nResponse: `FinishedUserFetchResponse` (subclass of `ActionResponse`)\n\n```\nFinishedUserFetchResponse:\n{\n    responseType: "FinishedUserFetchResponse",\n    text: string,\n    items: ItemFetchResult[]\n}\n\nItemFetchResult:\n{\n    item: UserEditationRequest\n}\n```\n\n#### Example 200\n\n```http\nPOST /api/sync/user/fetch HTTP/1.1\nContent-Type: application/json; charset=UTF-8\nHost: https://demo.kpsys.cz\n\n{\n  "identifier": "ZAM1XYZ"\n}\n```\n\n```json\n{\n  "text": "User sync with identifier SCH0387",\n  "responseType": "FinishedUserFetchResponse",\n  "finished": true,\n  "items": [\n    {\n      "item": {\n        "id": 31230,\n        "active": false,\n        "readerAccounts": [\n          {\n            "readerCategory": {\n              "id": "IST",\n              "text": "Interní-student"\n            },\n            "cardNumber": "SCH0387",\n            "registrationDate": "2021-09-08T00:00:00+02:00",\n            "registrationExpirationDate": "9999-12-31T00:00:00+01:00"\n          }\n        ],\n        "editorAccounts": null,\n        "emails": [\n          {\n            "value": "rostislav.schwarz.st@vsb.cz",\n            "source": {\n              "id": "external-unis",\n              "text": "Unis"\n            }\n          }\n        ],\n        "phoneNumbers": [\n          {\n            "value": "+420734281136",\n            "smsCapable": true,\n            "source": {\n              "id": "external-unis",\n              "text": "Unis"\n            }\n          }\n        ],\n        "addresses": [\n          {\n            "permanent": true,\n            "mailing": true,\n            "street": "Peškova 523/12",\n            "city": "Olomouc",\n            "state": "Česká republika",\n            "postalCode": "77900"\n          }\n        ],\n        "username": null,\n        "readableDepartments": null,\n        "firstName": "Rostislav",\n        "lastName": "Schwarz",\n        "prefixDegree": null,\n        "suffixDegree": null,\n        "birthDate": "1988-03-09T00:00:00+01:00",\n        "guId": "SCH0387",\n        "netId": "SCH0387",\n        "openidId": null,\n        "bakalariId": "040449B2BC6380",\n        "edookitId": null,\n        "edupageId": null,\n        "jobName": null,\n        "jobAddress": null,\n        "educationLevel": "FEI / Fakulta elektrotechniky a informatiky",\n        "schoolClass": "K / B",\n        "identityCardNumber": null,\n        "kind": "PERSON"\n      }\n    }\n  ]\n}\n```\n\n## VerbisBox\n\n- **Station** je celá stanice/sestava skládající se z x boxů, může se skládat z několika sloupců. Každý station má z výroby vygenerované UUIDv4, dále jako `stationId`.\n- **Box** je jedna schránka. Každý box má také z výroby vygenerované UUIDv4, dále jako `boxId`.\n\n`stationId`, `boxId` a basic auth password budou poskytnuta k nastavení do knihovního systému.\n\n### Communication\n\nSystém komunikace stanice s knihovním systémem je stylem klient-server (klient je stanice) pomocí protokolu HTTPS.\nStanice posílá serveru události a server vrací seznam příkazů, které stanice provádí. Například, po zadání pinu na stanici o tom stanice posílá request a server vrací příkaz na otevření boxu.\n\nAdresy requestů mají definovatelnou doménu a prefix cesty, ta se může měnit. Aktuálně ale je `{verbisboxerUrlPrefix}`.\n\nKomunikace probíhá ve formátu JSON.\n\n- Jestliže server/klient dostane v odpovědi neznámé/nezdokumentované fieldy, ignoruje je.\n- Všechny hodnoty jsou case-sensitive.\n- Všechna UUIDv4 jsou lowercase.\n- Pokud není explicitně řečeno jinak, všechny hodnoty jsou not-null.\n\nKaždý request obsahuje field `event`, ve kterém je stanicí vygenerovaníé UUIDv4 události, dále jako `eventId`.\n\nV případě, že server do {verbisboxerServerResponseTimeout} neodpoví, stanice zkusí stejnou (i se stejným `eventId`) zprávu poslat ještě {verbisboxerStationRequestRetryCount}x.\nPokud ani na posledni request server neodpoví, stanice se nastaví do deaktivovaného režimu. Dále posílá pouze heartbeat (viz níže).\n\n#### Autentikace\n\nKlient (station) se autentikuje v každém requestu pomocí basic auth, tedy\n\n```\nAuthorization: Basic a2FyZWw6aGVzbG8=\n```\n\n, kde username je `stationId` stanice, tedy např. `9a64be42-2f1f-4451-915f-dc6cc69aa789`, password je náhodně vygenerovaný, 20-ti místný alfanumerický řetězec.\n\n##### Testovací uživatel\n\n- Username: `9a64be42-2f1f-4451-915f-dc6cc69aa789`\n- Password: `kVyqwcqfP4uPCbhn4RER`\n\n#### HTTP hlavičky\n\nKlient (station), kromě `Authorization`, posílá i hlavičky\n\n```\nContent-Type: application/json\nAccept: application/json\nUser-Agent: VerbisBox/{version}\n```\n\n, kde místo `\\{version\\}` bude aktuální verze SW stanice, ideálně (ne nutně) v SemVer formátu, např. `4.1.35`.\n\n##### Accept-Language\n\nKlient (station) MŮŽE posílat i hlavičku `Accept-Language` podle specifikace, viz např. https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Language\n\n##### X-Verbis-Trace-Id\n\nKlient (station) MŮŽE posílat i hlavičku `X-Verbis-Trace-Id` sloužící jako MDC (Mapped Diagnostic Context) pro identifikaci akce/requestu v logu. Stanice by měla pro každý request vygenerovat UUID a v této hlavičce ho posílat. Všechny řádky v logu portara v rámci tohoto requestu budou toto UUID obsahovat. Tím lze jednoduše vyfiltrovat jen logy relevantní pro daný request\n\nLog je z webu dostupný pod knihovnickým účtem na stránce `/actuator/logfile`.\n\n### State\n\nStanice posílá pravidelně echo o svem stavu. Maximální interval bude daný nastavením stanice, defaultně {verbisboxerStationHeartbeatInterval}. Maximální znamená, že stanice může echo poslat dříve, např. okamžitě při nastalé chybě.\n\nStav obsahuje jak aktualní "health" stanice, tak stavy jednotlivých boxů. Boxy stanice posílá všechny, což se může v budoucnu změnit kvůli optimalizaci.\n\n```\nPOST /state\n```\n\n```json\n{\n  "station": "9a64be42-2f1f-4451-915f-dc6cc69aa789",\n  "st": "UP",\n  "errorMessage": null,\n  "inputVoltage": 11.7,\n  "internetSignalStrength": 67,\n  "boxes": [\n    {\n      "id": "bad0cc90-54d2-4267-8e2a-9737a3e5b1f8",\n      "st": "OPEN"\n    },\n    {\n      "id": "b8ec8f91-2835-4f16-a358-6426e0bc0308",\n      "st": "CLOSED"\n    }\n  ],\n  "event": "b171a575-ba4c-48b4-a6bb-3d0670c8ec13"\n}\n```\n\n- Field `st` nabývá hodnot `UP` a `DOWN`.\n- Field `errorMessage` je nullable.\n- Field `inputVoltage` je not null JSON number. Udává vstupní napětí (z baterie nebo z adaptéru) ve voltech.\n- Field `internetSignalStrength` je not null JSON integer (celočíselný). Udává procentuální sílu signálu použitého pro připojení k internetu. Pokud je stanice připojnena drátem, hodnota bude 100.\n- Field `boxes[].st` nabývá hodnot `OPEN` a `CLOSED`.\n\nPokud je stanice v chybovém stavu, posílá (pokud je toho schopna) stav také:\n\n```\nPOST /state\n```\n\n```json\n{\n  "station": "9a64be42-2f1f-4451-915f-dc6cc69aa789",\n  "st": "DOWN",\n  "errorMessage": "Low voltage",\n  "boxes": [\n    {\n      "id": "bad0cc90-54d2-4267-8e2a-9737a3e5b1f8",\n      "st": "OPEN"\n    },\n    {\n      "id": "b8ec8f91-2835-4f16-a358-6426e0bc0308",\n      "st": "CLOSED"\n    }\n  ],\n  "event": "ba0cb1ce-2b6a-4162-83d2-70e76f4fe929"\n}\n```\n\nServer může odpovědí vynutit např. nastavení textu displeje\n\nResponse 200\n\n```json\n{\n  "type": "wait-for-input",\n  "displayMessages": ["Zadejte PIN"]\n}\n```\n\nNebo v případě chyby, dočasně deaktivovat stanici\n\nResponse 200\n\n```json\n{\n  "type": "station-disable",\n  "displayMessages": ["Stanice je vypnuta"]\n}\n```\n\nJestliže server nedostane od stanice po {verbisboxerStationDownTimeout} žádný heartbeat request, stanice se považuje za vypnutou/nedostupnou. Verbis zakáže jakékoliv akce s boxem a upozorní administrátory.\n\nJestliže naopak stanice nedostane od serveru po {verbisboxerServerResponseTimeout} odpověď, server se považuje za vypnutý/nedostupný. Stanice nastaví na displeji text "Stanice je vypnuta" a zakáže jakékoliv operace.\n\n### Vložení objednávky do boxu\n\nKnihovník příjde ke stanici, naskenuje knihu. Stanice pošle serveru request s typem identifikátoru: `BAR_CODE` nebo `RFID` a hodnotou.\n\n```\nPOST /item-identify\n```\n\n```json\n{\n  "station": "9a64be42-2f1f-4451-915f-dc6cc69aa789",\n  "identifierValue": "1234567890",\n  "identifierType": "BAR_CODE",\n  "event": "b3118eb2-41cf-44c6-8f3b-e2dc85913df4"\n}\n```\n\nResponse 200\n\n```json\n{\n  "type": "box-open",\n  "boxes": ["bad0cc90-54d2-4267-8e2a-9737a3e5b1f8"],\n  "displayMessages": ["Otevírám schránku..."]\n}\n```\n\nNa základě `box-open` se otevře box s id `bad0cc90-54d2-4267-8e2a-9737a3e5b1f8` a na displeji se zobrazí informační text "Vložte knihu do schránky a zavřete".\nPo otevření boxu (nebo všech boxů) stanice posílá `/state` s aktuálním stavem otevřenosti boxů.\n\n```\nPOST /state\n```\n\nResponse 200\n\n```json\n{\n  "type": "wait-for-closing",\n  "boxes": ["bad0cc90-54d2-4267-8e2a-9737a3e5b1f8"],\n  "displayMessages": [\n    "Vložte knihu",\n    "do schránky",\n    "a zavřete"\n  ],\n  "cancellable": true\n}\n```\n\nKnihovník vloží knihu do schránky a schránku zavře. Zavřením stanice pošle serveru opět request `/state` s aktuálním stavem otevřenosti boxů.\n\n```\nPOST /state\n```\n\nResponse 200\n\n```json\n{\n  "type": "wait-for-input",\n  "displayMessages": ["Zadejte PIN"]\n}\n```\n\nDo jednoho boxu může knihovník vložit více knih, každou knihu ale vkládá samostatně. Po každé musí box zavrít a otevřít, aby se eliminovaly lidské chyby.\n\nV této chvíli má knihovník možnost akci zrušit stisknutím tlačítka "zrušit", ještě před uzavřením boxu.\nStisknutím tlačítka "zrušit" stanice pošle serveru request\n\n```\nPOST /cancel\n```\n\n```json\n{\n  "station": "9a64be42-2f1f-4451-915f-dc6cc69aa789",\n  "event": "b35d890f-a8f4-4ce9-a2c8-3cc9e213df2f"\n}\n```\n\nServer v takovém případě ví, který box je otevřený a tedy ví, která akce (v tomto případě objednávka) se ruší.\n\nResponse 200\n\n```json\n{\n  "type": "wait-for-closing",\n  "boxes": ["bad0cc90-54d2-4267-8e2a-9737a3e5b1f8"],\n  "displayMessages": ["Zavřete schránku"]\n}\n```\n\n### Vyzvednutí objednávky z boxu\n\nČtenář příjde ke stanici, zadá {verbisboxerPinLength}-místný PIN, který dostal např. SMSkou. Stanice pošle serveru request\n\n```\nPOST /pin-enter\n```\n\n```json\n{\n  "station": "9a64be42-2f1f-4451-915f-dc6cc69aa789",\n  "pin": "123456",\n  "event": "150e9676-91cf-4870-a02a-2bdb9cf03884"\n}\n```\n\nResponse 200\n\n```json\n{\n  "type": "box-open",\n  "boxes": ["bad0cc90-54d2-4267-8e2a-9737a3e5b1f8"],\n  "displayMessages": ["Otevírám schránku..."]\n}\n```\n\nNa základě `box-open` se otevře box s id `bad0cc90-54d2-4267-8e2a-9737a3e5b1f8`, stanice posílá `/state` request a na displeji se zobrazí informační text "Odeberte knihy a zavřete".\n\n```\nPOST /state\n```\n\nResponse 200\n\n```json\n{\n  "type": "wait-for-closing",\n  "boxes": ["bad0cc90-54d2-4267-8e2a-9737a3e5b1f8"],\n  "displayMessages": [\n    "Odeberte knihy",\n    "a zavřete"\n  ]\n}\n```\n\nČtenář odebere knihy a schránku zavře. Zavřením stanice pošle serveru `/state` request\n\n```\nPOST /state\n```\n\nResponse 200\n\n```json\n{\n  "type": "wait-for-input",\n  "displayMessages": ["Zadejte PIN"]\n}\n```\n\n### Chybové odpovědi\n\nJakýkoliv request může skončit s chybou. Chybové odpovědi podporují standardní HTTP status kódy (série 4XX a 5XX) a jsou ve standardizovaném formátu.\nField `type` je v případě chyby `exception`, `exceptionType` pak definuje konkretni chybu. Hodnoty v níže uvedených přikladech jsou jen orientační.\n\nNapř. v případě stisknutí tlačítka "zrušit" ve chvíli, kdy akci zrušit nelze:\n\nResponse 400\n\n```json\n{\n  "type": "exception",\n  "exceptionType": "CannotCancelException",\n  "displayMessages": [\n    "Tuto akci",\n    "nelze zrušit"\n  ]\n}\n```\n\nNapř. v případě chyby na serveru:\n\nResponse 500\n\n```json\n{\n  "type": "exception",\n  "exceptionType": "IllegalStateException",\n  "displayMessages": [\n    "Nastala chyba",\n    "na serveru"\n  ]\n}\n```\n';function d(n){let e,t;return e=new i.A({props:{markdown:r,block:!0}}),{c(){(0,a.N0i)(e.$$.fragment)},m(n,o){(0,a.wSR)(e,n,o),t=!0},p:a.lQ1,i(n){t||((0,a.c7F)(e.$$.fragment,n),t=!0)},o(n){(0,a.Tn8)(e.$$.fragment,n),t=!1},d(n){(0,a.Hbl)(e,n)}}}function l(n){let e,t;return e=new s.A({props:{pageClass:"kp-apidocs-page",loading:!(0,o.t2)(r),$$slots:{default:[d]},$$scope:{ctx:n}}}),{c(){(0,a.N0i)(e.$$.fragment)},m(n,o){(0,a.wSR)(e,n,o),t=!0},p(n,[t]){const a={};1&t&&(a.$$scope={dirty:t,ctx:n}),e.$set(a)},i(n){t||((0,a.c7F)(e.$$.fragment,n),t=!0)},o(n){(0,a.Tn8)(e.$$.fragment,n),t=!1},d(n){(0,a.Hbl)(e,n)}}}class c extends a.r7T{constructor(n){super(),(0,a.TsN)(this,n,null,l,a.jXN,{})}}const p=c},87390:(n,e,t)=>{t.d(e,{A:()=>x});var a=t(18591),o=(t(2531),t(95669)),s=t(94655),i=t(48440),r=t(6426),d=t(73558),l=t(33146);function c(n){let e,t,i,r,d,l=(0,s.t2)(n[7]),c="circular"===n[2]&&p(n),f="line"===n[2]&&u(n),m=l&&b(n);return{c(){e=(0,a.ND4)("div"),c&&c.c(),t=(0,a.xem)(),f&&f.c(),i=(0,a.xem)(),m&&m.c(),(0,a.CFu)(e,"class","loading-container svelte-iuiee2")},m(n,o){(0,a.Yry)(n,e,o),c&&c.m(e,null),(0,a.BCw)(e,t),f&&f.m(e,null),(0,a.BCw)(e,i),m&&m.m(e,null),d=!0},p(o,r){"circular"===(n=o)[2]?c?4&r&&(0,a.c7F)(c,1):(c=p(n),c.c(),(0,a.c7F)(c,1),c.m(e,t)):c&&((0,a.V44)(),(0,a.Tn8)(c,1,1,(()=>{c=null})),(0,a.GYV)()),"line"===n[2]?f?4&r&&(0,a.c7F)(f,1):(f=u(n),f.c(),(0,a.c7F)(f,1),f.m(e,i)):f&&((0,a.V44)(),(0,a.Tn8)(f,1,1,(()=>{f=null})),(0,a.GYV)()),128&r&&(l=(0,s.t2)(n[7])),l?m?m.p(n,r):(m=b(n),m.c(),m.m(e,null)):m&&(m.d(1),m=null)},i(t){d||((0,a.c7F)(c),(0,a.c7F)(f),t&&(r||(0,a.Dti)((()=>{r=(0,a.b7f)(e,o._J,n[9]),r.start()}))),d=!0)},o(n){(0,a.Tn8)(c),(0,a.Tn8)(f),d=!1},d(n){n&&(0,a.YoD)(e),c&&c.d(),f&&f.d(),m&&m.d()}}}function p(n){let e,t;return e=new i.A({}),{c(){(0,a.N0i)(e.$$.fragment)},m(n,o){(0,a.wSR)(e,n,o),t=!0},i(n){t||((0,a.c7F)(e.$$.fragment,n),t=!0)},o(n){(0,a.Tn8)(e.$$.fragment,n),t=!1},d(n){(0,a.Hbl)(e,n)}}}function u(n){let e,t;return e=new d.A({}),{c(){(0,a.N0i)(e.$$.fragment)},m(n,o){(0,a.wSR)(e,n,o),t=!0},i(n){t||((0,a.c7F)(e.$$.fragment,n),t=!0)},o(n){(0,a.Tn8)(e.$$.fragment,n),t=!1},d(n){(0,a.Hbl)(e,n)}}}function b(n){let e;return{c(){e=(0,a.Qq7)(n[7])},m(n,t){(0,a.Yry)(n,e,t)},p(n,t){128&t&&(0,a.iQh)(e,n[7])},d(n){n&&(0,a.YoD)(e)}}}function f(n){let e,t,s,i;return t=new r.A({props:{align:"center",justify:"center",orientation:"vertical",icon:"exclamation",$$slots:{default:[v]},$$scope:{ctx:n}}}),{c(){e=(0,a.ND4)("div"),(0,a.N0i)(t.$$.fragment),(0,a.CFu)(e,"class","loading-container load-error svelte-iuiee2")},m(n,o){(0,a.Yry)(n,e,o),(0,a.wSR)(t,e,null),i=!0},p(e,a){n=e;const o={};2304&a&&(o.$$scope={dirty:a,ctx:n}),t.$set(o)},i(r){i||((0,a.c7F)(t.$$.fragment,r),r&&(s||(0,a.Dti)((()=>{s=(0,a.b7f)(e,o._J,n[9]),s.start()}))),i=!0)},o(n){(0,a.Tn8)(t.$$.fragment,n),i=!1},d(n){n&&(0,a.YoD)(e),(0,a.Hbl)(t)}}}function m(n){let e;return{c(){e=(0,a.Qq7)(n[8])},m(n,t){(0,a.Yry)(n,e,t)},p(n,t){256&t&&(0,a.iQh)(e,n[8])},d(n){n&&(0,a.YoD)(e)}}}function v(n){let e,t=(0,s.t2)(n[8]),o=t&&m(n);return{c(){o&&o.c(),e=(0,a.Iex)()},m(n,t){o&&o.m(n,t),(0,a.Yry)(n,e,t)},p(n,a){256&a&&(t=(0,s.t2)(n[8])),t?o?o.p(n,a):(o=m(n),o.c(),o.m(e.parentNode,e)):o&&(o.d(1),o=null)},d(n){n&&(0,a.YoD)(e),o&&o.d(n)}}}function h(n){let e,t;return e=new l.A({props:{isBootstrapContainer:!1,additionalClasses:n[0],gap:n[3],$$slots:{default:[y]},$$scope:{ctx:n}}}),{c(){(0,a.N0i)(e.$$.fragment)},m(n,o){(0,a.wSR)(e,n,o),t=!0},p(n,t){const a={};1&t&&(a.additionalClasses=n[0]),8&t&&(a.gap=n[3]),2048&t&&(a.$$scope={dirty:t,ctx:n}),e.$set(a)},i(n){t||((0,a.c7F)(e.$$.fragment,n),t=!0)},o(n){(0,a.Tn8)(e.$$.fragment,n),t=!1},d(n){(0,a.Hbl)(e,n)}}}function y(n){let e;const t=n[10].default,o=(0,a.Of3)(t,n,n[11],null);return{c(){o&&o.c()},m(n,t){o&&o.m(n,t),e=!0},p(n,s){o&&o.p&&(!e||2048&s)&&(0,a.nkG)(o,t,n,n[11],e?(0,a.sWk)(t,n[11],s,null):(0,a.i32)(n[11]),null)},i(n){e||((0,a.c7F)(o,n),e=!0)},o(n){(0,a.Tn8)(o,n),e=!1},d(n){o&&o.d(n)}}}function k(n){let e,t,o,s,i,r=n[1]&&c(n),d=n[6]&&f(n),l=!n[1]&&!n[6]&&h(n);return{c(){e=(0,a.ND4)("div"),r&&r.c(),t=(0,a.xem)(),d&&d.c(),o=(0,a.xem)(),l&&l.c(),(0,a.CFu)(e,"class",s="kp-loadable-page-container "+n[5]+" svelte-iuiee2"),(0,a.goL)(e,"container",n[4])},m(n,s){(0,a.Yry)(n,e,s),r&&r.m(e,null),(0,a.BCw)(e,t),d&&d.m(e,null),(0,a.BCw)(e,o),l&&l.m(e,null),i=!0},p(n,[p]){n[1]?r?(r.p(n,p),2&p&&(0,a.c7F)(r,1)):(r=c(n),r.c(),(0,a.c7F)(r,1),r.m(e,t)):r&&((0,a.V44)(),(0,a.Tn8)(r,1,1,(()=>{r=null})),(0,a.GYV)()),n[6]?d?(d.p(n,p),64&p&&(0,a.c7F)(d,1)):(d=f(n),d.c(),(0,a.c7F)(d,1),d.m(e,o)):d&&((0,a.V44)(),(0,a.Tn8)(d,1,1,(()=>{d=null})),(0,a.GYV)()),n[1]||n[6]?l&&((0,a.V44)(),(0,a.Tn8)(l,1,1,(()=>{l=null})),(0,a.GYV)()):l?(l.p(n,p),66&p&&(0,a.c7F)(l,1)):(l=h(n),l.c(),(0,a.c7F)(l,1),l.m(e,null)),(!i||32&p&&s!==(s="kp-loadable-page-container "+n[5]+" svelte-iuiee2"))&&(0,a.CFu)(e,"class",s),(!i||48&p)&&(0,a.goL)(e,"container",n[4])},i(n){i||((0,a.c7F)(r),(0,a.c7F)(d),(0,a.c7F)(l),i=!0)},o(n){(0,a.Tn8)(r),(0,a.Tn8)(d),(0,a.Tn8)(l),i=!1},d(n){n&&(0,a.YoD)(e),r&&r.d(),d&&d.d(),l&&l.d()}}}function g(n,e,t){let{$$slots:a={},$$scope:o}=e,{pageClass:s}=e,{loading:i=!1}=e,{loaderType:r="circular"}=e,{gap:d="30px"}=e,{isBootstrapContainer:l=!0}=e,{containerClass:c=""}=e,{loadError:p=!1}=e,{loadingLabel:u=null}=e,{loadErrorLabel:b=null}=e;return n.$$set=n=>{"pageClass"in n&&t(0,s=n.pageClass),"loading"in n&&t(1,i=n.loading),"loaderType"in n&&t(2,r=n.loaderType),"gap"in n&&t(3,d=n.gap),"isBootstrapContainer"in n&&t(4,l=n.isBootstrapContainer),"containerClass"in n&&t(5,c=n.containerClass),"loadError"in n&&t(6,p=n.loadError),"loadingLabel"in n&&t(7,u=n.loadingLabel),"loadErrorLabel"in n&&t(8,b=n.loadErrorLabel),"$$scope"in n&&t(11,o=n.$$scope)},[s,i,r,d,l,c,p,u,b,{y:15,duration:250},a,o]}class T extends a.r7T{constructor(n){super(),(0,a.TsN)(this,n,g,k,a.jXN,{pageClass:0,loading:1,loaderType:2,gap:3,isBootstrapContainer:4,containerClass:5,loadError:6,loadingLabel:7,loadErrorLabel:8})}}const x=T}}]);
//# sourceMappingURL=apidocs.f091964729135da5e2fc.js.map