/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.web;

import com.twelvemonkeys.servlet.image.IIOProviderContextListener;
import cz.kpsys.portaro.app.ssl.HttpsKeysSource;
import cz.kpsys.portaro.appserver.Appserver;
import cz.kpsys.portaro.appserver.AppserverFileDataStreamer;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.ByIdOptLoadable;
import cz.kpsys.portaro.commons.util.ObjectUtil;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.config.web.EmbeddedServerConfig;
import cz.kpsys.portaro.config.web.TomcatHttpsConfigurer;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.file.DbFileResourceProtocolResolver;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.custom.ProvidedDepartmentCustomFileResourceProtocolResolver;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.view.web.PortaroErrorViewResolver;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.HttpSessionListener;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletRegistrationBean;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.filter.OrderedCharacterEncodingFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.web.client.RestOperations;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.DispatcherServlet;

@Profile(value={"embedded-server"})
@Configuration
public class EmbeddedServerConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedServerConfig.class);
    @NonNull
    private final ApplicationContext applicationContext;
    @NonNull
    private final MultipartConfigElement multipartConfigElement;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final @NonNull Provider<@NonNull String> userAgentProvider;
    @NonNull
    private final ServerProperties serverProperties;
    @NonNull
    private final ByIdOptLoadable<CustomFile, String> customFileLoader;
    @NonNull
    private final Appserver appserver;
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;

    @Bean
    public ResourceLoader keystoreResourceLoader() {
        DefaultResourceLoader bean = new DefaultResourceLoader();
        AppserverFileDataStreamer fileDataStreamer = AppserverFileDataStreamer.ofOriginalData((String)this.appserver.url(), (RestOperations)this.rest);
        bean.addProtocolResolver((ProtocolResolver)new ProvidedDepartmentCustomFileResourceProtocolResolver(this.customFileLoader, (FileDataStreamer)fileDataStreamer, this.rootDepartmentProvider));
        bean.addProtocolResolver((ProtocolResolver)new DbFileResourceProtocolResolver((FileDataStreamer)fileDataStreamer));
        return bean;
    }

    @Bean
    public TomcatServletWebServerFactory servletContainer() {
        TomcatServletWebServerFactory factory = new TomcatServletWebServerFactory();
        this.serverProperties.setServerHeader((String)this.userAgentProvider.get());
        Optional<InetAddress> serverListenIp = ((Optional)this.settingLoader.getOnRootProvider(SettingKeys.SERVER_LISTEN_IP).optionally().get()).map(serverListenIpAddress -> {
            try {
                return InetAddress.getByName(serverListenIpAddress.getValue());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot set listening ip address (%s) for HTTPS connector".formatted(serverListenIpAddress), e);
            }
        });
        serverListenIp.ifPresent(arg_0 -> ((ServerProperties)this.serverProperties).setAddress(arg_0));
        try {
            Boolean httpsEnabled = (Boolean)this.settingLoader.getOnRoot(SettingKeys.INTERNAL_HTTPS_ENABLED);
            if (httpsEnabled.booleanValue()) {
                HttpsKeysSource httpsKeysSource = (HttpsKeysSource)this.settingLoader.getOnRoot(SettingKeys.INTERNAL_HTTPS_KEYS_SOURCE);
                Integer httpsPort = (Integer)this.settingLoader.getOnRoot(SettingKeys.INTERNAL_HTTPS_PORT);
                TomcatHttpsConfigurer tomcatHttpsConfigurer = new TomcatHttpsConfigurer(this.keystoreResourceLoader(), serverListenIp);
                if (this.serverProperties.getHttp2().isEnabled()) {
                    tomcatHttpsConfigurer.addConnectorCustomizer(connector -> connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol()));
                }
                switch (1.$SwitchMap$cz$kpsys$portaro$app$ssl$HttpsKeysSource[httpsKeysSource.ordinal()]) {
                    case 1: {
                        String certificateLocation = (String)this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_CERTIFICATE_LOCATION).throwingWhenNull().get();
                        String caCertificateLocation = (String)this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_CA_CERTIFICATE_LOCATION).get();
                        String privateKeyLocation = (String)this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_PRIVATE_KEY_LOCATION).throwingWhenNull().get();
                        String privateKeyPassword = (String)this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_PRIVATE_KEY_PASSWORD).get();
                        tomcatHttpsConfigurer.configureByCertificateAndKey(factory, httpsPort.intValue(), certificateLocation, caCertificateLocation, privateKeyLocation, privateKeyPassword);
                        break;
                    }
                    case 2: {
                        String acmeCertificateChainLocation = (String)this.settingLoader.getOnRootProvider(SettingKeys.ACME_CERTIFICATE_LOCATION).get();
                        String acmePrivateKeyLocation = (String)this.settingLoader.getOnRootProvider(SettingKeys.ACME_PRIVATE_KEY_LOCATION).get();
                        tomcatHttpsConfigurer.configureByCertificateAndKey(factory, httpsPort.intValue(), acmeCertificateChainLocation, null, acmePrivateKeyLocation, null);
                        break;
                    }
                    case 3: {
                        String keystoreLocation = (String)this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_KEYSTORE_LOCATION).throwingWhenNull().get();
                        String keystorePassword = (String)this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_KEYSTORE_PASSWORD).throwingWhenNull().get();
                        String keystoreKeyAlias = (String)ObjectUtil.firstNotNull((Object)StringUtil.notEmptyString((String)((String)this.settingLoader.getOnRoot(SettingKeys.INTERNAL_HTTPS_KEYSTORE_KEY_ALIAS))), (Object)"auto");
                        tomcatHttpsConfigurer.configureByKeystore(factory, httpsPort.intValue(), keystoreLocation, keystorePassword, keystoreKeyAlias);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Cannot initialize https", (Throwable)e);
        }
        return factory;
    }

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> {
            servletContext.setSessionTrackingModes(Collections.singleton(SessionTrackingMode.COOKIE));
            SessionCookieConfig sessionCookieConfig = servletContext.getSessionCookieConfig();
            sessionCookieConfig.setSecure(((Boolean)this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_ENABLED).get()).booleanValue());
            servletContext.addListener(IIOProviderContextListener.class);
        };
    }

    @Bean
    public PortaroErrorViewResolver errorViewResolver() {
        return new PortaroErrorViewResolver();
    }

    @Bean
    public DispatcherServletRegistrationBean dispatcherServletRegistration() {
        DispatcherServlet ds = new DispatcherServlet();
        ds.setApplicationContext(this.applicationContext);
        DispatcherServletRegistrationBean registrationBean = new DispatcherServletRegistrationBean(ds, "/*");
        registrationBean.setMultipartConfig(this.multipartConfigElement);
        return registrationBean;
    }

    @Bean
    public CharacterEncodingFilter characterEncodingFilter() {
        OrderedCharacterEncodingFilter bean = new OrderedCharacterEncodingFilter();
        bean.setEncoding(StandardCharsets.UTF_8.name());
        bean.setForceEncoding(true);
        bean.setForceRequestEncoding(true);
        bean.setForceResponseEncoding(true);
        bean.setOrder(Integer.MIN_VALUE);
        return bean;
    }

    @Bean
    public HttpSessionListener httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }

    @Bean
    public ServletRequestListener servletRequestListener() {
        return new RequestContextListener();
    }

    @ConstructorProperties(value={"applicationContext", "multipartConfigElement", "settingLoader", "userAgentProvider", "serverProperties", "customFileLoader", "appserver", "rest", "rootDepartmentProvider"})
    @Generated
    public EmbeddedServerConfig(@NonNull ApplicationContext applicationContext, @NonNull MultipartConfigElement multipartConfigElement, @NonNull SettingLoader settingLoader, @NonNull @NonNull Provider<@NonNull String> userAgentProvider, @NonNull ServerProperties serverProperties, @NonNull ByIdOptLoadable<CustomFile, String> customFileLoader, @NonNull Appserver appserver, @NonNull RestOperations rest, @NonNull Provider<Department> rootDepartmentProvider) {
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(multipartConfigElement, "multipartConfigElement is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(userAgentProvider, "userAgentProvider is marked non-null but is null");
        Objects.requireNonNull(serverProperties, "serverProperties is marked non-null but is null");
        Objects.requireNonNull(customFileLoader, "customFileLoader is marked non-null but is null");
        Objects.requireNonNull(appserver, "appserver is marked non-null but is null");
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        this.applicationContext = applicationContext;
        this.multipartConfigElement = multipartConfigElement;
        this.settingLoader = settingLoader;
        this.userAgentProvider = userAgentProvider;
        this.serverProperties = serverProperties;
        this.customFileLoader = customFileLoader;
        this.appserver = appserver;
        this.rest = rest;
        this.rootDepartmentProvider = rootDepartmentProvider;
    }
}

