/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.web;

import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.acme.AcmeApiController;
import cz.kpsys.portaro.acme.AcmeHttpChallengeController;
import cz.kpsys.portaro.acme.AcmeService;
import cz.kpsys.portaro.acme.AcmeTemplate;
import cz.kpsys.portaro.acme.CertAndKeySaverToPemCustomFiles;
import cz.kpsys.portaro.acme.CertificateValidityChecker;
import cz.kpsys.portaro.acme.CertificateValidityCheckerImpl;
import cz.kpsys.portaro.acme.ConditionalCertificateValidityChecker;
import cz.kpsys.portaro.acme.HttpsDataReloader;
import cz.kpsys.portaro.acme.HttpsDataReloaderByRestart;
import cz.kpsys.portaro.acme.IniSavingChallengeKeySetter;
import cz.kpsys.portaro.app.ssl.HttpsKeysSource;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.SideThreadAuthenticationIsolator;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.DecoratableContextualProvider;
import cz.kpsys.portaro.commons.contextual.StaticContextualDelegatingProvider;
import cz.kpsys.portaro.commons.object.OrBooleanProvider;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.TtlCachedProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.SystemInstitution;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.LoadedIdentifiedFileCreator;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.custom.CustomFileSaveAccessor;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryAccessor;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.ParentableDirectoryCreator;
import cz.kpsys.portaro.resource.ResourceProviderByResourceLoader;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.shutdown.ApplicationRestarter;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.User;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
public class AcmeConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AcmeConfig.class);
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Saver<CustomSetting<String>, ?> customSettingSaver;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider;
    @NonNull
    private final RootCustomDirectoryAccessor rootCustomDirectoryAccessor;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final Provider<Integer> portaroUserIdProvider;
    @NonNull
    private final ByIdLoadable<CustomFile, String> customFileLoader;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final ApplicationRestarter applicationRestarter;
    @NonNull
    private final ResourceLoader keystoreResourceLoader;
    @NonNull
    private final Provider<Department> realRootDepartmentProvider;
    @NonNull
    private final @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final ParentableDirectoryCreator parentableDirectoryCreator;
    @NonNull
    private final LoadedIdentifiedFileCreator loadedIdentifiedFileCreator;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final @NonNull Provider<@NonNull User> portaroUserProvider;
    @NonNull
    private final ExecutorService executorService;

    @Bean
    public Provider<Boolean> acmeHttpsEnabledProvider() {
        Provider[] providerArray = new Provider[2];
        providerArray[0] = this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_ENABLED);
        providerArray[1] = this.settingLoader.getOnRootProvider(SettingKeys.INTERNAL_HTTPS_KEYS_SOURCE).andThen(arg_0 -> HttpsKeysSource.ACME.equals(arg_0));
        return OrBooleanProvider.of((Provider[])providerArray);
    }

    @Bean
    public AcmeHttpChallengeController acmeHttpChallengeController() {
        StaticContextualDelegatingProvider rootDepKeyProvider = new StaticContextualDelegatingProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.ACME_CHALLENGE_KEY), this.realRootDepartmentProvider);
        ContextIgnoringContextualProvider depIgnoringKeyProvider = new ContextIgnoringContextualProvider((Provider)rootDepKeyProvider);
        DecoratableContextualProvider cachePreCleaningKeyProvider = new DecoratableContextualProvider((ContextualProvider)depIgnoringKeyProvider).withPreHook(d -> this.cacheService.invalidateAllCaches());
        return new AcmeHttpChallengeController((ContextualProvider)cachePreCleaningKeyProvider);
    }

    @Bean
    public AcmeApiController acmeApiController() {
        return new AcmeApiController(this.acmeService(), this.automaticRenewingCertificateValidityChecker());
    }

    @Bean
    public AcmeService acmeService() {
        return new AcmeService(new AcmeTemplate(), this.realRootDepartmentProvider, (List)new ProvidedProxiedList((Provider)TtlCachedProvider.ofSeconds((long)10L, () -> new ArrayList(this.settingLoader.getContextToValueMap(CoreSettingKeys.SERVER_URL).values()))), this.systemInstitutionProvider, (Consumer)new IniSavingChallengeKeySetter(this.customSettingSaver, (SettingTypeId)SettingKeys.ACME_CHALLENGE_KEY, (Integer)((Department)this.realRootDepartmentProvider.get()).getId(), this.customSettingLoader), (Saver)new CertAndKeySaverToPemCustomFiles(new CustomFileSaveAccessor(this.rootCustomDirectoryAccessor, this.directoryLoader, this.customFileLoader, this.identifiedFileLoader, this.defaultFileAccessTypeProvider, this.defaultTransactionTemplateFactory.get(), this.parentableDirectoryCreator, this.loadedIdentifiedFileCreator, new SideThreadAuthenticationIsolator(this.authenticationHolder, this.portaroUserProvider, this.executorService)), "cert", "acme-fullchain.pem", "acme-privkey.pem", this.portaroUserIdProvider)).withAfterRenew(() -> ((HttpsDataReloader)this.httpsDataReloader()).reload());
    }

    @Bean
    public HttpsDataReloader httpsDataReloader() {
        return new HttpsDataReloaderByRestart(this.applicationRestarter);
    }

    @Bean
    public CertificateValidityChecker automaticRenewingCertificateValidityChecker() {
        CertificateValidityCheckerImpl checker = new CertificateValidityCheckerImpl((Provider)new ResourceProviderByResourceLoader(this.keystoreResourceLoader, (Supplier)this.settingLoader.getOnRootProvider(SettingKeys.ACME_CERTIFICATE_LOCATION)), Duration.of(25L, ChronoUnit.DAYS), duration -> this.acmeService().renew());
        return new ConditionalCertificateValidityChecker(this.acmeHttpsEnabledProvider(), (CertificateValidityChecker)checker);
    }

    @Bean
    public Task<Void> acmeCheckAndRenewTask() {
        return Tasks.recurring((String)"acme-check-and-renew-task", (Schedule)Schedules.daily((ZoneId)CoreConstants.CZECH_TIME_ZONE_ID, (LocalTime[])new LocalTime[]{LocalTime.parse("04:00:00")})).execute((taskInstance, executionContext) -> this.automaticRenewingCertificateValidityChecker().check());
    }

    @ConstructorProperties(value={"cacheService", "settingLoader", "customSettingSaver", "systemInstitutionProvider", "rootCustomDirectoryAccessor", "directoryLoader", "portaroUserIdProvider", "customFileLoader", "identifiedFileLoader", "applicationRestarter", "keystoreResourceLoader", "realRootDepartmentProvider", "defaultFileAccessTypeProvider", "customSettingLoader", "defaultTransactionTemplateFactory", "parentableDirectoryCreator", "loadedIdentifiedFileCreator", "authenticationHolder", "portaroUserProvider", "executorService"})
    @Generated
    public AcmeConfig(@NonNull CacheService cacheService, @NonNull SettingLoader settingLoader, @NonNull Saver<CustomSetting<String>, ?> customSettingSaver, @NonNull @NonNull ContextualProvider<Department, @NonNull SystemInstitution> systemInstitutionProvider, @NonNull RootCustomDirectoryAccessor rootCustomDirectoryAccessor, @NonNull DirectoryLoader directoryLoader, @NonNull Provider<Integer> portaroUserIdProvider, @NonNull ByIdLoadable<CustomFile, String> customFileLoader, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull ApplicationRestarter applicationRestarter, @NonNull ResourceLoader keystoreResourceLoader, @NonNull Provider<Department> realRootDepartmentProvider, @NonNull @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider, @NonNull CustomSettingLoader customSettingLoader, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull ParentableDirectoryCreator parentableDirectoryCreator, @NonNull LoadedIdentifiedFileCreator loadedIdentifiedFileCreator, @NonNull AuthenticationHolder authenticationHolder, @NonNull @NonNull Provider<@NonNull User> portaroUserProvider, @NonNull ExecutorService executorService) {
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(systemInstitutionProvider, "systemInstitutionProvider is marked non-null but is null");
        Objects.requireNonNull(rootCustomDirectoryAccessor, "rootCustomDirectoryAccessor is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(portaroUserIdProvider, "portaroUserIdProvider is marked non-null but is null");
        Objects.requireNonNull(customFileLoader, "customFileLoader is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(applicationRestarter, "applicationRestarter is marked non-null but is null");
        Objects.requireNonNull(keystoreResourceLoader, "keystoreResourceLoader is marked non-null but is null");
        Objects.requireNonNull(realRootDepartmentProvider, "realRootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(defaultFileAccessTypeProvider, "defaultFileAccessTypeProvider is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(parentableDirectoryCreator, "parentableDirectoryCreator is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileCreator, "loadedIdentifiedFileCreator is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(portaroUserProvider, "portaroUserProvider is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        this.cacheService = cacheService;
        this.settingLoader = settingLoader;
        this.customSettingSaver = customSettingSaver;
        this.systemInstitutionProvider = systemInstitutionProvider;
        this.rootCustomDirectoryAccessor = rootCustomDirectoryAccessor;
        this.directoryLoader = directoryLoader;
        this.portaroUserIdProvider = portaroUserIdProvider;
        this.customFileLoader = customFileLoader;
        this.identifiedFileLoader = identifiedFileLoader;
        this.applicationRestarter = applicationRestarter;
        this.keystoreResourceLoader = keystoreResourceLoader;
        this.realRootDepartmentProvider = realRootDepartmentProvider;
        this.defaultFileAccessTypeProvider = defaultFileAccessTypeProvider;
        this.customSettingLoader = customSettingLoader;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.parentableDirectoryCreator = parentableDirectoryCreator;
        this.loadedIdentifiedFileCreator = loadedIdentifiedFileCreator;
        this.authenticationHolder = authenticationHolder;
        this.portaroUserProvider = portaroUserProvider;
        this.executorService = executorService;
    }
}

