/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.modules;

import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.StaticCodebook;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.datatype.ScalarDatatype;
import cz.kpsys.portaro.foreigndatabase.ForeignDatabase;
import cz.kpsys.portaro.foreigndatabase.ForeignDatabaseConstants;
import cz.kpsys.portaro.foreigndatabase.ForeignDocumentAvailabilityService;
import cz.kpsys.portaro.foreigndatabase.ForeignDocumentAvailabilityServiceImpl;
import cz.kpsys.portaro.foreigndatabase.ForeignOccurrence;
import cz.kpsys.portaro.foreigndatabase.ForeignOccurrenceLoader;
import cz.kpsys.portaro.foreigndatabase.SpringDbForeignDatabaseLoader;
import cz.kpsys.portaro.foreigndatabase.SpringDbForeignOccurrenceLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.view.web.rest.ForeignOccurrenceApiController;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.web.client.RestOperations;

@Configuration
public class CentralIndexConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CentralIndexConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final StaticCodebook<ScalarDatatype, String> staticScalarDatatypeLoader;

    @Bean
    public ForeignOccurrenceApiController foreignOccurrenceApiController() {
        log.debug("Enabling Central index module");
        return new ForeignOccurrenceApiController(this.foreignOccurrenceLoader(), this.foreignDocumentAvailabilityService());
    }

    @Bean
    public ForeignOccurrenceLoader foreignOccurrenceLoader() {
        return new SpringDbForeignOccurrenceLoader(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.foreignDatabaseLoader());
    }

    @Bean
    public Codebook<ForeignDatabase, Integer> foreignDatabaseLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbForeignDatabaseLoader(this.jdbcTemplate, this.queryFactory)).staticCached(ForeignDatabase.class.getSimpleName()).build();
    }

    @Bean
    public ForeignDocumentAvailabilityService foreignDocumentAvailabilityService() {
        return new ForeignDocumentAvailabilityServiceImpl(this.rest);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerModule() {
        this.staticScalarDatatypeLoader.add((Object)ForeignDatabaseConstants.Datatype.FOREIGN_DATABASE);
        this.converterRegisterer.registerForIntegerId(ForeignDatabase.class, (ByIdLoadable)this.foreignDatabaseLoader()).registerForLongId(ForeignOccurrence.class, (ByIdLoadable)this.foreignOccurrenceLoader());
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "codebookLoaderBuilderFactory", "rest", "converterRegisterer", "staticScalarDatatypeLoader"})
    @Generated
    public CentralIndexConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull RestOperations rest, @NonNull ConverterRegisterer converterRegisterer, @NonNull StaticCodebook<ScalarDatatype, String> staticScalarDatatypeLoader) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(staticScalarDatatypeLoader, "staticScalarDatatypeLoader is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.rest = rest;
        this.converterRegisterer = converterRegisterer;
        this.staticScalarDatatypeLoader = staticScalarDatatypeLoader;
    }
}

