/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.PostConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingDeleter;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.database.FlushingJpaDeleter;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.datatype.DatatypableStringConverter;
import cz.kpsys.portaro.datatype.ScalarDatatype;
import cz.kpsys.portaro.form.editor.ValueEditorByDatatypeLoader;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.locale.UserLocaleResolver;
import cz.kpsys.portaro.userpreferences.SpringDbUserPreferenceDefinitionLoader;
import cz.kpsys.portaro.userpreferences.SpringDbUserPreferenceLoader;
import cz.kpsys.portaro.userpreferences.UserPrefAccessor;
import cz.kpsys.portaro.userpreferences.UserPreference;
import cz.kpsys.portaro.userpreferences.UserPreferenceCreator;
import cz.kpsys.portaro.userpreferences.UserPreferenceDefinition;
import cz.kpsys.portaro.userpreferences.UserPreferenceEntity;
import cz.kpsys.portaro.userpreferences.UserPreferenceFromEntityConverter;
import cz.kpsys.portaro.userpreferences.UserPreferenceKeyPermission;
import cz.kpsys.portaro.userpreferences.UserPreferenceLoader;
import cz.kpsys.portaro.userpreferences.UserPreferenceSaver;
import cz.kpsys.portaro.userpreferences.UserPreferenceToEntityConverter;
import cz.kpsys.portaro.userpreferences.gdpr.GdprNotSetPermissionResolver;
import cz.kpsys.portaro.userpreferences.locale.UserLocaleFromUserPreferenceResolver;
import cz.kpsys.portaro.view.web.rest.user.UserPreferenceApiController;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class UserDetailsConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserDetailsConfig.class);
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final ValueEditorByDatatypeLoader valueEditorByDatatypeLoader;
    @NonNull
    private final DatatypableStringConverter datatypableStringConverter;
    @NonNull
    private final ByIdLoadable<ScalarDatatype, String> fallbackingScalarDatatypeLoader;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final ByIdLoadable<BasicUser, Integer> basicUserLoader;

    @Bean
    public UserPreferenceApiController userPreferenceApiController() {
        return new UserPreferenceApiController(this.userPreferenceLoader(), this.userPreferenceDeleter(), this.userPreferenceCreator());
    }

    @Bean
    public UserLocaleResolver userLocaleResolver() {
        return new UserLocaleFromUserPreferenceResolver(this.userPrefAccessor());
    }

    @Bean
    public PermissionResolver<BasicUser> gdprNotSetPermissionResolver() {
        return new GdprNotSetPermissionResolver(this.userPrefAccessor(), this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_ANONYMIZATION_QUESTION_DIALOG));
    }

    @Bean
    public UserPreferenceLoader userPreferenceLoader() {
        SpringDbUserPreferenceLoader bean = new SpringDbUserPreferenceLoader(this.jdbcTemplate, this.queryFactory, this.userPreferenceDefinitionLoader(), this.datatypableStringConverter);
        this.cacheService.registerCleaner(UserPreferenceDefinition.class.getSimpleName(), (CacheCleaner)bean);
        return bean;
    }

    @Bean
    public Codebook<UserPreferenceDefinition, Integer> userPreferenceDefinitionLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbUserPreferenceDefinitionLoader(this.jdbcTemplate, this.queryFactory, this.datatypableStringConverter, this.valueEditorByDatatypeLoader, (ByIdLoadable)UserPreferenceKeyPermission.CODEBOOK, this.fallbackingScalarDatatypeLoader)).staticCached(UserPreferenceDefinition.class.getSimpleName()).build();
    }

    @Bean
    public Saver<UserPreference, UserPreference> userPreferenceSaver() {
        return new TransactionalSaver((Saver)new UserPreferenceSaver((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new UserPreferenceToEntityConverter(this.datatypableStringConverter), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(UserPreferenceEntity.class, this.entityManager))), (Converter)new UserPreferenceFromEntityConverter(this.basicUserLoader, this.userPreferenceDefinitionLoader())), this.userPreferenceDeleter()), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public UserPreferenceCreator userPreferenceCreator() {
        return new UserPreferenceCreator(this.userPreferenceSaver(), this.defaultTransactionTemplateFactory.get(), this.userPreferenceDefinitionLoader(), this.datatypableStringConverter, this.userPreferenceLoader());
    }

    @Bean
    public Deleter<UserPreference> userPreferenceDeleter() {
        return new PreConvertingDeleter((Converter)new UserPreferenceToEntityConverter(this.datatypableStringConverter), (Deleter)new FlushingJpaDeleter((JpaRepository)new SimpleJpaRepository(UserPreferenceEntity.class, this.entityManager)));
    }

    @Bean
    public UserPrefAccessor userPrefAccessor() {
        return new UserPrefAccessor(this.userPreferenceLoader(), this.userPreferenceSaver(), this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "cacheService", "valueEditorByDatatypeLoader", "datatypableStringConverter", "fallbackingScalarDatatypeLoader", "codebookLoaderBuilderFactory", "settingLoader", "defaultTransactionTemplateFactory", "entityManager", "basicUserLoader"})
    @Generated
    public UserDetailsConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull CacheService cacheService, @NonNull ValueEditorByDatatypeLoader valueEditorByDatatypeLoader, @NonNull DatatypableStringConverter datatypableStringConverter, @NonNull ByIdLoadable<ScalarDatatype, String> fallbackingScalarDatatypeLoader, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SettingLoader settingLoader, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull EntityManager entityManager, @NonNull ByIdLoadable<BasicUser, Integer> basicUserLoader) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(valueEditorByDatatypeLoader, "valueEditorByDatatypeLoader is marked non-null but is null");
        Objects.requireNonNull(datatypableStringConverter, "datatypableStringConverter is marked non-null but is null");
        Objects.requireNonNull(fallbackingScalarDatatypeLoader, "fallbackingScalarDatatypeLoader is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.cacheService = cacheService;
        this.valueEditorByDatatypeLoader = valueEditorByDatatypeLoader;
        this.datatypableStringConverter = datatypableStringConverter;
        this.fallbackingScalarDatatypeLoader = fallbackingScalarDatatypeLoader;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.settingLoader = settingLoader;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.entityManager = entityManager;
        this.basicUserLoader = basicUserLoader;
    }
}

