/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.auth.AuthenticationCleaner;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.AuthenticationProvider;
import cz.kpsys.portaro.auth.BasicUserAuthentication;
import cz.kpsys.portaro.auth.OnlyThrowingAuthenticationFailureHandler;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.auth.anonym.AnonymSuccessAuthentication;
import cz.kpsys.portaro.auth.current.AuthableUserResponse;
import cz.kpsys.portaro.auth.current.CurrentAuthResponse;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.auth.listen.AuthenticationSuccessMultipleListener;
import cz.kpsys.portaro.auth.listen.FilteredSuccessAuthenticationListener;
import cz.kpsys.portaro.auth.listen.SuccessAuthenticationListener;
import cz.kpsys.portaro.auth.logout.HolderCleaningLogouter;
import cz.kpsys.portaro.auth.logout.LogoutController;
import cz.kpsys.portaro.auth.logout.Logouter;
import cz.kpsys.portaro.auth.process.AuthoritiedSuccessAuthentication;
import cz.kpsys.portaro.auth.view.AuthableUserToResponseConverter;
import cz.kpsys.portaro.auth.view.CurrentAuthToResponseConverter;
import cz.kpsys.portaro.config.SecurityCoreConfig;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.user.AuthableUser;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.auth.spring.AjaxAwareSimpleUrlAuthenticationSuccessHandler;
import cz.kpsys.portaro.web.ResponseEntityHttpResponseWriter;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;

@Configuration
public class SecurityCoreConfig {
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final UserByBasicUserLoader userLoader;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthReadableDepartmentsLoader;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final ResponseEntityHttpResponseWriter responseEntityHttpResponseWriter;
    @NonNull
    private final Eventer eventer;

    @Bean
    public AuthenticationTrustResolver trustResolver() {
        AuthenticationTrustResolverImpl bean = new AuthenticationTrustResolverImpl();
        bean.setAnonymousClass(AnonymSuccessAuthentication.class);
        return bean;
    }

    @Bean
    public SecurityContextRepository securityContextRepository() {
        HttpSessionSecurityContextRepository bean = new HttpSessionSecurityContextRepository();
        bean.setTrustResolver((AuthenticationTrustResolver)new /* Unavailable Anonymous Inner Class!! */);
        return bean;
    }

    @Bean
    public AuthenticationFailureHandler failureHandler() {
        return new OnlyThrowingAuthenticationFailureHandler();
    }

    @Bean
    public Converter<UserAuthentication, CurrentAuthResponse> currentAuthToResponseConverter() {
        return new CurrentAuthToResponseConverter(this.currentAuthReadableDepartmentsLoader, this.currentAuthEditableDepartmentsLoader, this.authableUserToResponseConverter(), this.userLoader);
    }

    @Bean
    public Converter<AuthableUser, AuthableUserResponse> authableUserToResponseConverter() {
        return new AuthableUserToResponseConverter(this.userLoader);
    }

    @Bean
    public AuthenticationSuccessHandler redirectParameterSearchingSuccessHandler() {
        AjaxAwareSimpleUrlAuthenticationSuccessHandler successHandler = new AjaxAwareSimpleUrlAuthenticationSuccessHandler(this.authenticationHolder, this.currentAuthToResponseConverter(), this.responseEntityHttpResponseWriter);
        successHandler.setTargetUrlParameter("redirect");
        return successHandler;
    }

    @Bean
    public List<Class<? extends AuthoritiedSuccessAuthentication>> authenticationEventSavingTypes() {
        return new ArrayList<Class<? extends AuthoritiedSuccessAuthentication>>();
    }

    @Bean
    public LogoutController logoutController() {
        return new LogoutController((AuthenticationProvider)this.authenticationHolder, this.responseEntityHttpResponseWriter).addLogouter((Logouter)new HolderCleaningLogouter((AuthenticationCleaner)this.authenticationHolder));
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public AuthenticationSuccessMultipleListener interactiveAuthenticationSuccessEventListener() {
        return new AuthenticationSuccessMultipleListener();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerAuthenticationSuccessEventSaving() {
        SuccessAuthenticationListener eventSavingListener = authentication -> {
            SuccessAuthenticationEventData eventData = new SuccessAuthenticationEventData((Integer)this.authenticationHolder.getCurrentAuth().getAuthenticatedUser().getId(), authentication.getClass().getSimpleName());
            this.eventer.save("user-login", (BasicUserAuthentication)authentication, authentication.getCtx(), (Object)eventData);
        };
        this.authenticationHolder.addOnEvidedSuccessListener((SuccessAuthenticationListener)FilteredSuccessAuthenticationListener.forAllowedTypes((SuccessAuthenticationListener)eventSavingListener, (Collection)this.authenticationEventSavingTypes()));
    }

    @ConstructorProperties(value={"authenticationHolder", "userLoader", "currentAuthReadableDepartmentsLoader", "currentAuthEditableDepartmentsLoader", "responseEntityHttpResponseWriter", "eventer"})
    @Generated
    public SecurityCoreConfig(@NonNull AuthenticationHolder authenticationHolder, @NonNull UserByBasicUserLoader userLoader, @NonNull CurrentAuthDepartmentsLoader currentAuthReadableDepartmentsLoader, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull ResponseEntityHttpResponseWriter responseEntityHttpResponseWriter, @NonNull Eventer eventer) {
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthReadableDepartmentsLoader, "currentAuthReadableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(responseEntityHttpResponseWriter, "responseEntityHttpResponseWriter is marked non-null but is null");
        Objects.requireNonNull(eventer, "eventer is marked non-null but is null");
        this.authenticationHolder = authenticationHolder;
        this.userLoader = userLoader;
        this.currentAuthReadableDepartmentsLoader = currentAuthReadableDepartmentsLoader;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.responseEntityHttpResponseWriter = responseEntityHttpResponseWriter;
        this.eventer = eventer;
    }
}

