/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.ThisThreadAuthenticatingContextualRunner;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.commons.cache.CacheDeletableById;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.json.ByIntConverterJsonDeserializer;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.PostConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalDeleter;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.mail.MailService;
import cz.kpsys.portaro.record.IdsToRecordsConverter;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.ViewableRecord;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import cz.kpsys.portaro.search.InternalSearchResult;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.RangePaging;
import cz.kpsys.portaro.search.SearchService;
import cz.kpsys.portaro.search.view.SearchTextResolver;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.sdi.Periodicity;
import cz.kpsys.portaro.user.sdi.SdiApiController;
import cz.kpsys.portaro.user.sdi.SdiRequest;
import cz.kpsys.portaro.user.sdi.SdiRequestCreationRequest;
import cz.kpsys.portaro.user.sdi.SdiRequestCreationRequestDefaulter;
import cz.kpsys.portaro.user.sdi.SdiRequestCreator;
import cz.kpsys.portaro.user.sdi.SdiRequestDeleter;
import cz.kpsys.portaro.user.sdi.SdiRequestEntity;
import cz.kpsys.portaro.user.sdi.SdiRequestFromEntityConverter;
import cz.kpsys.portaro.user.sdi.SdiRequestLoader;
import cz.kpsys.portaro.user.sdi.SdiRequestToEntityConverter;
import cz.kpsys.portaro.user.sdi.SdiRequestUpdater;
import cz.kpsys.portaro.user.sdi.SdiSecurityActions;
import cz.kpsys.portaro.user.sdi.SdiSending;
import cz.kpsys.portaro.user.sdi.SdiSendingCreator;
import cz.kpsys.portaro.user.sdi.SdiSendingEntity;
import cz.kpsys.portaro.user.sdi.SdiSendingFromEntityConverter;
import cz.kpsys.portaro.user.sdi.SdiSendingLoader;
import cz.kpsys.portaro.user.sdi.SdiSendingToEntityConverter;
import cz.kpsys.portaro.user.sdi.SdiService;
import cz.kpsys.portaro.user.sdi.SpringDbSdiRequestLoader;
import cz.kpsys.portaro.user.sdi.SpringDbSdiSendingLoader;
import cz.kpsys.portaro.view.ViewableItemsTypedConverter;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.format.FormatterRegistry;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class SdiConfig {
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final FormatterRegistry conversionService;
    @NonNull
    private final SimpleModule objectMapperModule;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordParagraphItemsConverter;
    @NonNull
    private final MailService mailService;
    @NonNull
    private final AllByIdsLoadable<Record, UUID> richRecordLoader;
    @NonNull
    private final AllByIdsLoadable<Record, Integer> documentByKindedIdLoader;
    @NonNull
    private final SearchService<InternalSearchResult<String, MapBackedParams, RangePaging>, MapBackedParams> recordSearchService;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final ByIdLoadable<User, Integer> userLoader;
    @NonNull
    private final ByIdLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, UUID> recordOperationRecordIdSearchLoader;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final Provider<User> portaroUserProvider;
    @NonNull
    private final SearchTextResolver searchTitleResolver;
    @NonNull
    private final CacheDeletableById recordCache;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final @NonNull ContextualProvider<Department, Converter<UUID, @NonNull String>> recordIdToRecordDetailUrlConverterProvider;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final DatabaseProperties databaseProperties;
    @NonNull
    private final TransactionTemplateFactory readonlyTransactionTemplateFactory;

    @Bean
    public SdiApiController sdiApiController() {
        return new SdiApiController(this.sdiService(), this.sdiRequestLoader(), this.sdiRequestDeleter(), this.sdiSendingLoader(), this.securityManager, this.sdiRequestCreator(), this.sdiRequestUpdater());
    }

    @Bean
    public SdiRequestCreator sdiRequestCreator() {
        return new SdiRequestCreator(this.sdiRequestSaver(), (ContextualProvider)ContextIgnoringContextualProvider.of((Provider)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"SEQ_ID_OPAC_SDI", (String)"opac_sdi_id_opac_sdi_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.defaultTransactionTemplateFactory.get(), this.securityManager, this.userLoader);
    }

    @Bean
    public SdiRequestUpdater sdiRequestUpdater() {
        return new SdiRequestUpdater(this.sdiRequestLoader(), this.sdiRequestSaver(), this.securityManager, this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public SdiRequestLoader sdiRequestLoader() {
        return new SpringDbSdiRequestLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory, this.basicUserLoader, this.departmentLoader, this.readonlyTransactionTemplateFactory.get());
    }

    @Bean
    public Saver<SdiRequest, SdiRequest> sdiRequestSaver() {
        return new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new SdiRequestToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(SdiRequestEntity.class, this.entityManager))), (Converter)new SdiRequestFromEntityConverter(this.userLoader, this.departmentLoader));
    }

    @Bean
    public Deleter<SdiRequest> sdiRequestDeleter() {
        return new TransactionalDeleter((Deleter)new SdiRequestDeleter(this.sdiRequestSaver()), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public SdiSendingLoader sdiSendingLoader() {
        return new SpringDbSdiSendingLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public Saver<SdiSending, SdiSending> sdiSendingSaver() {
        return new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new SdiSendingToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(SdiSendingEntity.class, this.entityManager))), (Converter)new SdiSendingFromEntityConverter());
    }

    @Bean
    public SdiSendingCreator sdiSendingCreator() {
        return new SdiSendingCreator(Provider.of((Supplier)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"SEQ_ID_OPAC_SDI_SENDING", (String)"opac_sdi_sendings_id_opac_sdi_sending_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.defaultTransactionTemplateFactory.get(), this.sdiSendingSaver());
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<SdiRequestCreationRequest> sdiRequestCreationRequestDefaulter() {
        return new SdiRequestCreationRequestDefaulter(this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.searchTitleResolver, this.translator);
    }

    @Bean
    public SdiService sdiService() {
        return new SdiService(this.sdiRequestLoader(), this.sdiSendingLoader(), (Converter)new IdsToRecordsConverter().withDocumentSupport(this.documentByKindedIdLoader).withRecordSupport(this.richRecordLoader), this.recordSearchService, this.mailService, this.templateEngine, this.recordsToViewableRecordParagraphItemsConverter, this.translator, this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.recordOperationTypeLoader, this.recordOperationRecordIdSearchLoader, this.rootDepartmentProvider, this.recordCache, this.recordIdToRecordDetailUrlConverterProvider, this.sdiSendingCreator()).withTimeZone(CoreConstants.CZECH_TIME_ZONE_ID);
    }

    @Bean
    public Task<Void> sdiSendTask() {
        return Tasks.recurring((String)"sdi-send-task", (Schedule)Schedules.daily((ZoneId)CoreConstants.CZECH_TIME_ZONE_ID, (LocalTime[])new LocalTime[]{LocalTime.parse("05:00:00")})).execute((taskInstance, executionContext) -> this.sendAllSendableSdisRunner().accept((Department)this.rootDepartmentProvider.get()));
    }

    @Bean
    public Consumer<Department> sendAllSendableSdisRunner() {
        return new ThisThreadAuthenticatingContextualRunner(this.authenticationHolder, this.portaroUserProvider, arg_0 -> ((SdiService)this.sdiService()).sendAllSendable(arg_0));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        IdToObjectConverter integerToSdiRequestConverter = new IdToObjectConverter((ByIdLoadable)this.sdiRequestLoader());
        this.conversionService.addConverter(Integer.class, SdiRequest.class, (Converter)integerToSdiRequestConverter);
        this.conversionService.addConverter(String.class, SdiRequest.class, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)integerToSdiRequestConverter));
        this.objectMapperModule.addDeserializer(Periodicity.class, (JsonDeserializer)new ByIntConverterJsonDeserializer(Periodicity.class, (Converter)new IdToObjectConverter((ByIdLoadable)Periodicity.CODEBOOK)));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SdiSecurityActions.SDI_USE, this.permissionFactory.currentEvidedAuthenticActive());
        this.permissionRegistry.add(SdiSecurityActions.ALL_SDI_REQUESTS_SHOW, this.permissionFactory.edit());
        this.permissionRegistry.add(SdiSecurityActions.USER_SDI_REQUESTS_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.editOnReadableDepartmentsOfUser()})}));
        this.permissionRegistry.add(SdiSecurityActions.SDI_SAVE, (PermissionResolver)PermissionResolver.adaptingSubject(SdiRequest::getUser, (PermissionResolver)this.permissionRegistry.getLazy(SdiSecurityActions.USER_SDI_REQUESTS_SHOW)));
    }

    @ConstructorProperties(value={"settingLoader", "jdbcTemplate", "queryFactory", "permissionRegistry", "permissionFactory", "conversionService", "objectMapperModule", "templateEngine", "recordsToViewableRecordParagraphItemsConverter", "mailService", "richRecordLoader", "documentByKindedIdLoader", "recordSearchService", "translator", "userLoader", "basicUserLoader", "departmentLoader", "recordOperationTypeLoader", "recordOperationRecordIdSearchLoader", "securityManager", "rootDepartmentProvider", "authenticationHolder", "portaroUserProvider", "searchTitleResolver", "recordCache", "entityManager", "recordIdToRecordDetailUrlConverterProvider", "defaultTransactionTemplateFactory", "notAutoCommittingJdbcTemplate", "databaseProperties", "readonlyTransactionTemplateFactory"})
    @Generated
    public SdiConfig(@NonNull SettingLoader settingLoader, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull FormatterRegistry conversionService, @NonNull SimpleModule objectMapperModule, @NonNull TemplateEngine templateEngine, @NonNull ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordParagraphItemsConverter, @NonNull MailService mailService, @NonNull AllByIdsLoadable<Record, UUID> richRecordLoader, @NonNull AllByIdsLoadable<Record, Integer> documentByKindedIdLoader, @NonNull SearchService<InternalSearchResult<String, MapBackedParams, RangePaging>, MapBackedParams> recordSearchService, @NonNull Translator<Department> translator, @NonNull ByIdLoadable<User, Integer> userLoader, @NonNull ByIdLoadable<BasicUser, Integer> basicUserLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ByIdLoadable<RecordOperationType, Integer> recordOperationTypeLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, UUID> recordOperationRecordIdSearchLoader, @NonNull SecurityManager securityManager, @NonNull Provider<Department> rootDepartmentProvider, @NonNull AuthenticationHolder authenticationHolder, @NonNull Provider<User> portaroUserProvider, @NonNull SearchTextResolver searchTitleResolver, @NonNull CacheDeletableById recordCache, @NonNull EntityManager entityManager, @NonNull @NonNull ContextualProvider<Department, Converter<UUID, @NonNull String>> recordIdToRecordDetailUrlConverterProvider, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull DatabaseProperties databaseProperties, @NonNull TransactionTemplateFactory readonlyTransactionTemplateFactory) {
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(objectMapperModule, "objectMapperModule is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(recordsToViewableRecordParagraphItemsConverter, "recordsToViewableRecordParagraphItemsConverter is marked non-null but is null");
        Objects.requireNonNull(mailService, "mailService is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(documentByKindedIdLoader, "documentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(recordSearchService, "recordSearchService is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationTypeLoader, "recordOperationTypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationRecordIdSearchLoader, "recordOperationRecordIdSearchLoader is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(portaroUserProvider, "portaroUserProvider is marked non-null but is null");
        Objects.requireNonNull(searchTitleResolver, "searchTitleResolver is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(recordIdToRecordDetailUrlConverterProvider, "recordIdToRecordDetailUrlConverterProvider is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(readonlyTransactionTemplateFactory, "readonlyTransactionTemplateFactory is marked non-null but is null");
        this.settingLoader = settingLoader;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.conversionService = conversionService;
        this.objectMapperModule = objectMapperModule;
        this.templateEngine = templateEngine;
        this.recordsToViewableRecordParagraphItemsConverter = recordsToViewableRecordParagraphItemsConverter;
        this.mailService = mailService;
        this.richRecordLoader = richRecordLoader;
        this.documentByKindedIdLoader = documentByKindedIdLoader;
        this.recordSearchService = recordSearchService;
        this.translator = translator;
        this.userLoader = userLoader;
        this.basicUserLoader = basicUserLoader;
        this.departmentLoader = departmentLoader;
        this.recordOperationTypeLoader = recordOperationTypeLoader;
        this.recordOperationRecordIdSearchLoader = recordOperationRecordIdSearchLoader;
        this.securityManager = securityManager;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.authenticationHolder = authenticationHolder;
        this.portaroUserProvider = portaroUserProvider;
        this.searchTitleResolver = searchTitleResolver;
        this.recordCache = recordCache;
        this.entityManager = entityManager;
        this.recordIdToRecordDetailUrlConverterProvider = recordIdToRecordDetailUrlConverterProvider;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.databaseProperties = databaseProperties;
        this.readonlyTransactionTemplateFactory = readonlyTransactionTemplateFactory;
    }
}

