/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.record.InternalRecordLoader;
import cz.kpsys.portaro.record.RecordIdFondPair;
import cz.kpsys.portaro.record.detail.FieldType;
import cz.kpsys.portaro.record.detail.FieldTypeId;
import cz.kpsys.portaro.record.detail.FieldTypes;
import cz.kpsys.portaro.record.detail.UnknownFieldTypeFactory;
import cz.kpsys.portaro.record.detail.binding.FondBoundFieldsLoader;
import cz.kpsys.portaro.record.detail.binding.KindedIdBoundFieldsLoader;
import cz.kpsys.portaro.record.detail.binding.NativeNameBoundFieldsLoader;
import cz.kpsys.portaro.record.detail.binding.RecordIdBoundFieldsLoader;
import cz.kpsys.portaro.record.detail.binding.UserBoundFieldsLoader;
import cz.kpsys.portaro.record.detail.value.ScalarFieldValue;
import cz.kpsys.portaro.record.edit.EditableFieldType;
import cz.kpsys.portaro.record.edit.TypeToUnknownEditableConverter;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.user.User;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PortaroRecordFieldConfig {
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader;
    @NonNull
    private final InternalRecordLoader internalRecordAllByIdsLoader;
    @NonNull
    private final UnknownFieldTypeFactory unknownFieldTypeFactory;

    @Bean
    public Map<FieldTypeId, BiFunction<Fond, FieldType, Optional<EditableFieldType<?>>>> customEditableFieldTypes() {
        return Map.of(FieldTypes.DOCUMENT_LEADER_FIELD_TYPE_ID, (fond, fieldType) -> fond.isOfAuthority() ? Optional.empty() : Optional.of(EditableFieldType.ofHiddenSingle((FieldType)fieldType, (Fond)fond, (TypeToUnknownEditableConverter)this.unknownFieldTypeFactory.createUnknownEditableSubfieldTypesConverter(fond))), FieldTypes.AUTHORITY_LEADER_FIELD_TYPE_ID, (fond, fieldType) -> fond.isOfDocument() ? Optional.empty() : Optional.of(EditableFieldType.ofHiddenSingle((FieldType)fieldType, (Fond)fond, (TypeToUnknownEditableConverter)this.unknownFieldTypeFactory.createUnknownEditableSubfieldTypesConverter(fond))), FieldTypes.FOND_FIELD_TYPE_ID, (fond, fieldType) -> Optional.of(EditableFieldType.ofAlwaysVisibleSingle((FieldType)fieldType, (Fond)fond, (TypeToUnknownEditableConverter)this.unknownFieldTypeFactory.createUnknownEditableSubfieldTypesConverter(fond))), FieldTypes.NATIVE_NAME_FIELD_TYPE_ID, (fond, fieldType) -> Optional.of(EditableFieldType.ofHiddenSingle((FieldType)fieldType, (Fond)fond, (TypeToUnknownEditableConverter)this.unknownFieldTypeFactory.createUnknownEditableSubfieldTypesConverter(fond))), FieldTypes.USER_FIELD_TYPE_ID, (fond, fieldType) -> {
            if (!"user".equals(fond.getBinding())) {
                return Optional.empty();
            }
            return Optional.of(EditableFieldType.ofAlwaysVisibleSingle((FieldType)fieldType, (Fond)fond, (TypeToUnknownEditableConverter)this.unknownFieldTypeFactory.createUnknownEditableSubfieldTypesConverter(fond)));
        }, FieldTypes.RECORD_ID_FIELD_TYPE_ID, (fond, fieldType) -> Optional.of(EditableFieldType.ofHiddenSingle((FieldType)fieldType, (Fond)fond, (TypeToUnknownEditableConverter)this.unknownFieldTypeFactory.createUnknownEditableSubfieldTypesConverter(fond))), FieldTypes.DOCUMENT_KINDED_ID_FIELD_TYPE_ID, (fond, fieldType) -> {
            if (fond.isOfAuthority()) {
                return Optional.empty();
            }
            return Optional.of(EditableFieldType.ofHiddenSingle((FieldType)fieldType, (Fond)fond, (TypeToUnknownEditableConverter)this.unknownFieldTypeFactory.createUnknownEditableSubfieldTypesConverter(fond)));
        }, FieldTypes.AUTHORITY_KINDED_ID_FIELD_TYPE_ID, (fond, fieldType) -> {
            if (fond.isOfDocument()) {
                return Optional.empty();
            }
            return Optional.of(EditableFieldType.ofHiddenSingle((FieldType)fieldType, (Fond)fond, (TypeToUnknownEditableConverter)this.unknownFieldTypeFactory.createUnknownEditableSubfieldTypesConverter(fond)));
        });
    }

    @Bean
    public Map<FieldTypeId, Function<Set<RecordIdFondPair>, Map<RecordIdFondPair, ? extends ScalarFieldValue<?, ?>>>> bindingLoaders() {
        return Map.of(FieldTypes.FOND_FIELD_TYPE_ID, new FondBoundFieldsLoader(), FieldTypes.NATIVE_NAME_FIELD_TYPE_ID, new NativeNameBoundFieldsLoader(), FieldTypes.USER_FIELD_TYPE_ID, new UserBoundFieldsLoader(this.userSearchLoader), FieldTypes.RECORD_ID_FIELD_TYPE_ID, new RecordIdBoundFieldsLoader(), FieldTypes.DOCUMENT_KINDED_ID_FIELD_TYPE_ID, new KindedIdBoundFieldsLoader(this.internalRecordAllByIdsLoader, Boolean.valueOf(true)), FieldTypes.AUTHORITY_KINDED_ID_FIELD_TYPE_ID, new KindedIdBoundFieldsLoader(this.internalRecordAllByIdsLoader, Boolean.valueOf(false)));
    }

    @ConstructorProperties(value={"userSearchLoader", "internalRecordAllByIdsLoader", "unknownFieldTypeFactory"})
    @Generated
    public PortaroRecordFieldConfig(@NonNull ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader, @NonNull InternalRecordLoader internalRecordAllByIdsLoader, @NonNull UnknownFieldTypeFactory unknownFieldTypeFactory) {
        Objects.requireNonNull(userSearchLoader, "userSearchLoader is marked non-null but is null");
        Objects.requireNonNull(internalRecordAllByIdsLoader, "internalRecordAllByIdsLoader is marked non-null but is null");
        Objects.requireNonNull(unknownFieldTypeFactory, "unknownFieldTypeFactory is marked non-null but is null");
        this.userSearchLoader = userSearchLoader;
        this.internalRecordAllByIdsLoader = internalRecordAllByIdsLoader;
        this.unknownFieldTypeFactory = unknownFieldTypeFactory;
    }
}

