/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.StaticCacheFactory;
import cz.kpsys.portaro.config.BasicCodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.CachedCodebookAssembly;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.TransactionalCodebookLoaderBuilderFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ModelBuilderConfig {
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final StaticCacheFactory staticCacheFactory;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final CacheManager cacheManager;
    @NonNull
    private final TransactionTemplateFactory readonlyTransactionTemplateFactory;

    @Bean
    public CodebookLoaderBuilderFactory codebookLoaderBuilderFactory() {
        return new BasicCodebookLoaderBuilderFactory(this.entityManager, this.staticCacheFactory, this.cacheService, this.cacheManager);
    }

    @Bean
    public CodebookLoaderBuilderFactory transactionalCodebookLoaderBuilderFactory() {
        return new TransactionalCodebookLoaderBuilderFactory(this.entityManager, this.staticCacheFactory, this.cacheService, this.cacheManager, this.readonlyTransactionTemplateFactory);
    }

    @Bean
    public CachedCodebookAssembly codebookAssembler() {
        return new CachedCodebookAssembly(this.cacheService, this.staticCacheFactory);
    }

    @ConstructorProperties(value={"entityManager", "staticCacheFactory", "cacheService", "cacheManager", "readonlyTransactionTemplateFactory"})
    @Generated
    public ModelBuilderConfig(@NonNull EntityManager entityManager, @NonNull StaticCacheFactory staticCacheFactory, @NonNull CacheService cacheService, @NonNull CacheManager cacheManager, @NonNull TransactionTemplateFactory readonlyTransactionTemplateFactory) {
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(staticCacheFactory, "staticCacheFactory is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(cacheManager, "cacheManager is marked non-null but is null");
        Objects.requireNonNull(readonlyTransactionTemplateFactory, "readonlyTransactionTemplateFactory is marked non-null but is null");
        this.entityManager = entityManager;
        this.staticCacheFactory = staticCacheFactory;
        this.cacheService = cacheService;
        this.cacheManager = cacheManager;
        this.readonlyTransactionTemplateFactory = readonlyTransactionTemplateFactory;
    }
}

