/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import cz.kpsys.portaro.ExternalLogFields;
import cz.kpsys.portaro.alert.Alert;
import cz.kpsys.portaro.appserver.Appserver;
import cz.kpsys.portaro.appserver.AppserverAuthorizer;
import cz.kpsys.portaro.appserver.AppserverAuthorizerByKey;
import cz.kpsys.portaro.appserver.AppserverFileDataStreamer;
import cz.kpsys.portaro.appserver.AppserverService;
import cz.kpsys.portaro.appserver.AppserverXmlMapperFactory;
import cz.kpsys.portaro.appserver.AuthorizedAppserverService;
import cz.kpsys.portaro.appserver.BasicAppserverService;
import cz.kpsys.portaro.appserver.CircuitBreakingAppserverService;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.MappingAppserverDmlAppserverService;
import cz.kpsys.portaro.appserver.mapping.BasicMappingAppserverService;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.appserver.properties.AppserverPropertiesLoader;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.FallbackableCompositeCacheManager;
import cz.kpsys.portaro.commons.cache.StaticCacheFactory;
import cz.kpsys.portaro.commons.health.ExceptionAwareLivenessProvider;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.io.FileDataStreamerSpecificFileDataStreamer;
import cz.kpsys.portaro.commons.io.RemoteFileDataStreamer;
import cz.kpsys.portaro.commons.io.SpecificFileDataStreamer;
import cz.kpsys.portaro.commons.object.CompositeAddableAllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.util.TimeMeter;
import cz.kpsys.portaro.commons.webclient.HttpClientWebFileDataStreamer;
import cz.kpsys.portaro.commons.webclient.RestRemoteFileDataStreamer;
import cz.kpsys.portaro.database.DatabaseProductNameProvider;
import cz.kpsys.portaro.databaseproperties.DataSourceFactory;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.file.SpringDbFileDataStreamer;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.licence.EnumeratedBusinessVersion;
import cz.kpsys.portaro.licence.LicenceKeyDecoder;
import cz.kpsys.portaro.licence.valcode.CipheredValidationCodeLicenceKeyDecoder;
import cz.kpsys.portaro.licence.valcode.DecipheredValidationCodeLicenceKeyDecoder;
import cz.kpsys.portaro.monitoring.health.AppserverHealthMonitor;
import cz.kpsys.portaro.monitoring.health.AppserverPropertiesLoaderAppserverHealthMonitor;
import cz.kpsys.portaro.monitoring.health.StaticSettableHealthIndicator;
import cz.kpsys.portaro.resourcesupdate.DbFileUpdateFactory;
import cz.kpsys.portaro.resourcesupdate.Portaro13UpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.Portaro20UpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.Portaro21UpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.ResourceUpdateDisabledException;
import cz.kpsys.portaro.resourcesupdate.ResourcesUpdaterImpl;
import cz.kpsys.portaro.resourcesupdate.UpdateFactory;
import cz.kpsys.portaro.resourcesupdate.UpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.V23UpdatesProvider;
import cz.kpsys.portaro.resourcesupdate.migrationto20.Migration13To20UpdatesProvider;
import cz.kpsys.portaro.search.CacheMode;
import cz.kpsys.portaro.sql.generator.DbSpecificsFactory;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
public class DataSourceConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceConfig.class);
    @Value(value="${portaro.instance.name}")
    private String instanceName;
    @Value(value="${appserver.apiSecret}")
    private String appserverApiSecret;
    @Value(value="${database.firebirdDbUpdateUsername}")
    private String firebirdDbUpdateUsername;
    @Value(value="${database.firebirdDbUpdatePassword}")
    private String firebirdDbUpdatePassword;
    @Value(value="${portaro.resources-update.strict}")
    private boolean strictResourceUpdates;
    @Value(value="${portaro.resources-update.enabled}")
    private boolean resourceUpdatesEnabled;
    @NonNull
    private final RestTemplate rest;
    @NonNull
    private final @NonNull Provider<@NonNull ZoneId> databaseColumnsTimeZoneProvider;
    @NonNull
    private final DatabaseProperties databaseProperties;
    @NonNull
    private final Appserver appserver;
    @NonNull
    private final AppserverPropertiesLoader appserverPropertiesLoader;
    @NonNull
    private final ObjectMapper xmlMapper;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider;
    @NonNull
    private final Closeable initDataSource;
    @NonNull
    private final DbSpecificsFactory dbSpecificsFactory;

    @Bean
    public String instanceName() {
        return this.instanceName;
    }

    @Bean
    public ExternalLogFields externalLogFields() {
        return new ExternalLogFields(new HashMap());
    }

    @Bean
    public Date startTime() {
        return new Date();
    }

    @Bean
    public CompositeAddableAllValuesProvider<Alert> globalAlertsProvider() {
        return CompositeAddableAllValuesProvider.ofEmpty();
    }

    @Bean
    public AppserverHealthMonitor appserverHealthMonitor() {
        return new AppserverPropertiesLoaderAppserverHealthMonitor(this.appserverPropertiesLoader);
    }

    @Bean
    public AppserverService basicAppserverService() {
        BasicAppserverService delegate = new BasicAppserverService(this.appserver.url(), (RestOperations)this.rest, this.xmlMapper);
        return new CircuitBreakingAppserverService((AppserverService)delegate, (ExceptionAwareLivenessProvider)this.appserverHealthMonitor());
    }

    @Bean
    public AppserverService authorizedAppserverService() {
        AppserverAuthorizerByKey authorizer = new AppserverAuthorizerByKey(this.xmlMapper, (MappingAppserverService)new BasicMappingAppserverService(this.basicAppserverService()), this.appserverApiSecret);
        return new AuthorizedAppserverService(this.basicAppserverService(), (AppserverAuthorizer)authorizer);
    }

    @Bean
    public StaticSettableHealthIndicator databaseStructureHealthIndicator() {
        return StaticSettableHealthIndicator.initiallyUnknown();
    }

    @Bean
    public StaticSettableHealthIndicator filesystemStructureHealthIndicator() {
        return StaticSettableHealthIndicator.initiallyUnknown();
    }

    @Bean
    @DependsOn(value={"externalLogFields"})
    public DataSource dataSource() {
        this.updateResources();
        return this.createStandardDataSource("portaro-critical-pool", cfg -> cfg.setAutoCommit(true));
    }

    @Primary
    @Bean
    @DependsOn(value={"dataSource"})
    public DataSource notAutocommitDataSource() {
        return this.createStandardDataSource("portaro-critical-non-autocommit-pool", cfg -> cfg.setAutoCommit(false));
    }

    @Bean
    @DependsOn(value={"dataSource"})
    public DataSource fileStreamAutoCommittingDataSource() {
        return this.createStandardDataSource("portaro-file-stream-pool", cfg -> cfg.setAutoCommit(true));
    }

    @Bean
    @DependsOn(value={"dataSource"})
    public DataSource notCriticalDataSource() {
        return this.createStandardDataSource("portaro-non-critical-pool", cfg -> cfg.setAutoCommit(true));
    }

    private HikariDataSource createStandardDataSource(String poolName, Consumer<HikariConfig> configurer) {
        return DataSourceFactory.createDataSource((String)poolName, (DatabaseConnectionSettings)this.databaseProperties, (ZoneId)((ZoneId)this.databaseColumnsTimeZoneProvider.get()), configurer);
    }

    private void updateResources() {
        TimeMeter tm = TimeMeter.start();
        EnumeratedBusinessVersion licenceVersion = EnumeratedBusinessVersion.V2_3;
        try {
            licenceVersion = (BusinessVersion)this.licenceVersionProvider.get();
        }
        catch (Exception e) {
            log.error("Error while resolving licence version, fallbacking to {}", (Object)licenceVersion, (Object)e);
        }
        try {
            this.initDataSource.close();
        }
        catch (IOException e) {
            log.error("Error while closing initDataSource", (Throwable)e);
        }
        try (HikariDataSource dataSource = DataSourceFactory.createDbUpdateDataSource((DatabaseConnectionSettings)this.dbUpdateDatabaseProperties(), (ZoneId)((ZoneId)this.databaseColumnsTimeZoneProvider.get()), cfg -> {});){
            JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
            jdbcTemplate.setQueryTimeout(Math.toIntExact(TimeUnit.HOURS.toSeconds(1L)));
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
            QueryFactory queryFactory = QueryFactory.of((DatabaseConnectionSettings)this.dbUpdateDatabaseProperties(), (DbSpecificsFactory)this.dbSpecificsFactory);
            String databaseType = this.dbUpdateDatabaseProperties().getType();
            String customFolderPath = "!!!DEPRECATED!!!";
            MappingAppserverDmlAppserverService dmlAppserverService = new MappingAppserverDmlAppserverService((MappingAppserverService)new BasicMappingAppserverService(this.authorizedAppserverService()));
            AppserverFileDataStreamer appserverRemoteStreamer = AppserverFileDataStreamer.ofOriginalData((String)this.appserver.url(), (RestOperations)this.rest);
            SpringDbFileDataStreamer fileDataStreamer = SpringDbFileDataStreamer.ofOriginalData((NamedParameterJdbcOperations)namedParameterJdbcTemplate, (QueryFactory)queryFactory, (SpecificFileDataStreamer)new FileDataStreamerSpecificFileDataStreamer((FileDataStreamer)appserverRemoteStreamer), (SpecificFileDataStreamer)new HttpClientWebFileDataStreamer((RemoteFileDataStreamer)new RestRemoteFileDataStreamer(this.rest)));
            UpdateFactory updateFactory = new UpdateFactory(jdbcTemplate, databaseType, (Supplier)new DatabaseProductNameProvider(jdbcTemplate));
            DbFileUpdateFactory dbFileUpdateFactory = new DbFileUpdateFactory(updateFactory, jdbcTemplate, (DmlAppserverService)dmlAppserverService, (FileDataStreamer)fileDataStreamer);
            licenceVersion.assertAtLeast((BusinessVersion)EnumeratedBusinessVersion.V1_3);
            Portaro13UpdatesProvider v13Updates = new Portaro13UpdatesProvider(updateFactory, jdbcTemplate, customFolderPath, dbFileUpdateFactory);
            ResourcesUpdaterImpl v13Updater = new ResourcesUpdaterImpl("version_opac", jdbcTemplate, (UpdatesProvider)v13Updates, this.resourceUpdatesEnabled);
            v13Updater.update();
            licenceVersion.assertAtLeast((BusinessVersion)EnumeratedBusinessVersion.V2_0);
            Migration13To20UpdatesProvider v13To20Updates = new Migration13To20UpdatesProvider(updateFactory, jdbcTemplate, validationCodeCipher -> new CipheredValidationCodeLicenceKeyDecoder((LicenceKeyDecoder)new DecipheredValidationCodeLicenceKeyDecoder()).decode(validationCodeCipher).licenceVersion().isAtLeast((BusinessVersion)EnumeratedBusinessVersion.V2_0));
            ResourcesUpdaterImpl v13To20Updater = new ResourcesUpdaterImpl("version_mig_2_0", jdbcTemplate, (UpdatesProvider)v13To20Updates, this.resourceUpdatesEnabled);
            v13To20Updater.update();
            licenceVersion.assertAtLeast((BusinessVersion)EnumeratedBusinessVersion.V2_0);
            Portaro20UpdatesProvider v20Updates = new Portaro20UpdatesProvider(updateFactory, dbFileUpdateFactory);
            ResourcesUpdaterImpl v20Updater = new ResourcesUpdaterImpl("version_opac_2_0", jdbcTemplate, (UpdatesProvider)v20Updates, this.resourceUpdatesEnabled);
            v20Updater.update();
            licenceVersion.assertAtLeast((BusinessVersion)EnumeratedBusinessVersion.V2_1);
            Portaro21UpdatesProvider v21Updates = new Portaro21UpdatesProvider(updateFactory, dbFileUpdateFactory);
            ResourcesUpdaterImpl v21Updater = new ResourcesUpdaterImpl("version_opac_2_1", jdbcTemplate, (UpdatesProvider)v21Updates, this.resourceUpdatesEnabled);
            v21Updater.update();
            licenceVersion.assertAtLeast((BusinessVersion)EnumeratedBusinessVersion.V2_3);
            V23UpdatesProvider v23Updates = new V23UpdatesProvider(updateFactory, dbFileUpdateFactory);
            ResourcesUpdaterImpl v23Updater = new ResourcesUpdaterImpl("v2_3", jdbcTemplate, (UpdatesProvider)v23Updates, this.resourceUpdatesEnabled);
            v23Updater.update();
            dataSource.close();
            this.databaseStructureHealthIndicator().setUp();
        }
        catch (ResourceUpdateDisabledException e) {
            throw e;
        }
        catch (Exception e) {
            this.databaseStructureHealthIndicator().setDown(e);
            if (this.strictResourceUpdates) {
                log.error("Error while update (strict resources update flag is enabled, rethrowing exception)", (Throwable)e);
                throw e;
            }
            log.error("Error while update", (Throwable)e);
        }
        log.debug("Structures update took {}", (Object)tm.elapsedTimeString());
    }

    @Bean
    public DatabaseProperties dbUpdateDatabaseProperties() {
        if (!this.databaseProperties.getType().equals("firebird")) {
            return this.databaseProperties;
        }
        return this.databaseProperties.withUsername(this.firebirdDbUpdateUsername).withPassword(this.firebirdDbUpdatePassword);
    }

    @Bean
    public ObjectMapper appserverXmlMapper() {
        return AppserverXmlMapperFactory.createAppserverXmlMapper((boolean)false);
    }

    @Bean
    public NamedParameterJdbcOperations autoCommittingJdbcTemplate() {
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource());
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setQueryTimeout(35);
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setMaxRows(20000);
        return jdbcTemplate;
    }

    @Bean
    public NamedParameterJdbcOperations notAutoCommittingJdbcTemplate() {
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(this.notAutocommitDataSource());
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setQueryTimeout(35);
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setMaxRows(20000);
        return jdbcTemplate;
    }

    @Bean
    public NamedParameterJdbcOperations jdbcTemplate() {
        return this.autoCommittingJdbcTemplate();
    }

    @Bean
    public NamedParameterJdbcOperations fileStreamAutoCommittingJdbcTemplate() {
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(this.fileStreamAutoCommittingDataSource());
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setQueryTimeout(35);
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setMaxRows(200);
        return jdbcTemplate;
    }

    @Bean
    public NamedParameterJdbcOperations notCriticalJdbcTemplate() {
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(this.notCriticalDataSource());
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setQueryTimeout(35);
        ((JdbcTemplate)jdbcTemplate.getJdbcOperations()).setMaxRows(20000);
        return jdbcTemplate;
    }

    @Bean
    public Provider<@NonNull String> databaseProductNameProvider() {
        return new DatabaseProductNameProvider(new JdbcTemplate(this.dataSource())).cached();
    }

    @Bean
    public CacheService cacheService() {
        return new CacheService((CacheManager)this.cacheManager());
    }

    @Primary
    @Bean
    public FallbackableCompositeCacheManager cacheManager() {
        return new FallbackableCompositeCacheManager((CacheManager)this.noExpiringCacheManager()).addCacheManager((CacheManager)this.tenMinutesExpiringCacheManager()).addCacheManager((CacheManager)this.fewSecondsExpiringCacheManager()).addCacheManager((CacheManager)this.longTermCacheManager());
    }

    @Bean
    public CaffeineCacheManager noExpiringCacheManager() {
        CaffeineCacheManager fallbackCacheManager = new CaffeineCacheManager();
        fallbackCacheManager.setCaffeine(Caffeine.newBuilder().recordStats());
        return fallbackCacheManager;
    }

    @Bean
    public CaffeineCacheManager longTermCacheManager() {
        CaffeineCacheManager longTermCaching = new CaffeineCacheManager(new String[]{"rawableSearchLongTerm"});
        longTermCaching.setCaffeine(Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(CacheMode.LONGTERM.getDuration()).recordStats());
        return longTermCaching;
    }

    @Bean
    public CaffeineCacheManager tenMinutesExpiringCacheManager() {
        CaffeineCacheManager tenMinutesExpiringCaching = new CaffeineCacheManager(new String[]{"departmentsByRequestUrl", "templateDescriptors", "recordEditLevel", "showableEditorFonds", "editableEditorFonds", "userEditableDepartments", "userReadableDepartments", "filterByRootId", "userRelations"});
        tenMinutesExpiringCaching.setCaffeine(Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).recordStats());
        return tenMinutesExpiringCaching;
    }

    @Bean
    public CaffeineCacheManager fewSecondsExpiringCacheManager() {
        CaffeineCacheManager fewSecondsExpiringCaching = new CaffeineCacheManager(new String[]{"searchedUsersByParams", "searchedUsersCountByParams", "searchedItemsByParams", "searchedItemsCountByParams"});
        fewSecondsExpiringCaching.setCaffeine(Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(60L, TimeUnit.SECONDS).recordStats());
        return fewSecondsExpiringCaching;
    }

    @Bean
    public StaticCacheFactory staticCacheFactory() {
        return new StaticCacheFactory.FullCacheReturningFactory();
    }

    @ConstructorProperties(value={"rest", "databaseColumnsTimeZoneProvider", "databaseProperties", "appserver", "appserverPropertiesLoader", "xmlMapper", "licenceVersionProvider", "initDataSource", "dbSpecificsFactory"})
    @Generated
    public DataSourceConfig(@NonNull RestTemplate rest, @NonNull @NonNull Provider<@NonNull ZoneId> databaseColumnsTimeZoneProvider, @NonNull DatabaseProperties databaseProperties, @NonNull Appserver appserver, @NonNull AppserverPropertiesLoader appserverPropertiesLoader, @NonNull ObjectMapper xmlMapper, @NonNull @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider, @NonNull Closeable initDataSource, @NonNull DbSpecificsFactory dbSpecificsFactory) {
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(databaseColumnsTimeZoneProvider, "databaseColumnsTimeZoneProvider is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(appserver, "appserver is marked non-null but is null");
        Objects.requireNonNull(appserverPropertiesLoader, "appserverPropertiesLoader is marked non-null but is null");
        Objects.requireNonNull(xmlMapper, "xmlMapper is marked non-null but is null");
        Objects.requireNonNull(licenceVersionProvider, "licenceVersionProvider is marked non-null but is null");
        Objects.requireNonNull(initDataSource, "initDataSource is marked non-null but is null");
        Objects.requireNonNull(dbSpecificsFactory, "dbSpecificsFactory is marked non-null but is null");
        this.rest = rest;
        this.databaseColumnsTimeZoneProvider = databaseColumnsTimeZoneProvider;
        this.databaseProperties = databaseProperties;
        this.appserver = appserver;
        this.appserverPropertiesLoader = appserverPropertiesLoader;
        this.xmlMapper = xmlMapper;
        this.licenceVersionProvider = licenceVersionProvider;
        this.initDataSource = initDataSource;
        this.dbSpecificsFactory = dbSpecificsFactory;
    }
}

