/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.record.comment.Comment;
import cz.kpsys.portaro.record.comment.CommentApiController;
import cz.kpsys.portaro.record.comment.CommentEntity;
import cz.kpsys.portaro.record.comment.CommentResponse;
import cz.kpsys.portaro.record.comment.CommentSecurityActions;
import cz.kpsys.portaro.record.comment.CommentStyle;
import cz.kpsys.portaro.record.comment.CommentToCommentResponseConverter;
import cz.kpsys.portaro.record.comment.CommentToEntityConverter;
import cz.kpsys.portaro.record.comment.EntitiesToCommentsConverter;
import cz.kpsys.portaro.record.comment.SpringDbCommentIdSearchLoader;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.BasicUser;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class CommentConfig {
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final ConverterRegisterer converterRegisterer;

    @Bean
    public CommentApiController commentApiController() {
        return new CommentApiController(this.commentSearchLoader(), this.commentSaver(), this.commentDeleter(), this.commentToCommentResponseConverter());
    }

    @Bean
    public Codebook<Comment, String> commentLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(CommentEntity.class).converted((Converter)new EntitiesToCommentsConverter((AllByIdsLoadable)this.basicUserLoader)).build();
    }

    @Bean
    public Saver<Comment, Comment> commentSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new CommentToEntityConverter()).withClearedCacheName(CommentEntity.class.getSimpleName()).build();
    }

    @Bean
    public Deleter<Comment> commentDeleter() {
        return this.modelBeanBuilder.hibernateSoftDeleter(CommentEntity.class, (Converter)new CommentToEntityConverter()).build();
    }

    @Bean
    public Converter<Comment, CommentResponse> commentToCommentResponseConverter() {
        return new CommentToCommentResponseConverter();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, String> commentIdSearchLoader() {
        SpringDbCommentIdSearchLoader modelIdSearchLoader = new SpringDbCommentIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelIdSearchLoader).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Comment> commentSearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.commentIdSearchLoader(), (AllByIdsLoadable)this.commentLoader()).build();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForStringId(Comment.class, (ByIdLoadable)this.commentLoader());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        @NonNull ContextualProvider commentStyleProvider = this.settingLoader.getDepartmentedProvider(SettingKeys.COMMENT_STYLE);
        this.permissionRegistry.add(CommentSecurityActions.COMMENT_ADD, (auth, ctx, comment) -> {
            if (comment.getCreator().isPresent() && !auth.getActiveUser().equals(comment.getCreator().get())) {
                return PermissionResult.forbid((Text)Texts.ofNative((String)"Cannot add comment as another user"));
            }
            if (!((CommentStyle)commentStyleProvider.getOn((Object)ctx)).isEnabled()) {
                return PermissionResult.disabledFeature((Text)Texts.ofNative((String)"Comments are disabled"));
            }
            if (((CommentStyle)commentStyleProvider.getOn((Object)ctx)).isEnabledForAnonyms()) {
                return PermissionResult.allow();
            }
            return this.permissionFactory.currentEvidedAuthenticActive().can(auth, ctx, null);
        });
        this.permissionRegistry.add(CommentSecurityActions.COMMENTS_DELETE, this.permissionFactory.edit());
        this.permissionRegistry.add(CommentSecurityActions.COMMENT_DELETE, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, comment) -> {
            if (comment.getCreator().isEmpty()) {
                return PermissionResult.forbid((Text)Texts.ofNative((String)"Comment is anonymous, cannot delete by not-editor user"));
            }
            return this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser().can(auth, ctx, (Object)((BasicUser)comment.getCreator().get()));
        }, this.permissionFactory.edit()}));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "basicUserLoader", "modelBeanBuilder", "codebookLoaderBuilderFactory", "saverBuilderFactory", "permissionRegistry", "permissionFactory", "settingLoader", "converterRegisterer"})
    @Generated
    public CommentConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull SettingLoader settingLoader, @NonNull ConverterRegisterer converterRegisterer) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.basicUserLoader = basicUserLoader;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.settingLoader = settingLoader;
        this.converterRegisterer = converterRegisterer;
    }
}

