<#ftl outputFormat="HTML">
<#import "../../../../../freemarker/_localization.ftl" as loc>


<div ng-cloak>
    <button type="button" id="btn-slider-prev-{{$ctrl.uniq}}" class="btn-slider btn-slider-prev btn btn-default glyphicon glyphicon-chevron-left"></button>
    <button type="button" id="btn-slider-next-{{$ctrl.uniq}}" class="btn-slider btn-slider-next btn btn-default glyphicon glyphicon-chevron-right"></button>

    <jp-slider class="news-slider" mode="multiple" settings="$ctrl.settings" ng-if="$ctrl.documents.length > 0">

        <div class="news-slider-item" ng-repeat="document in $ctrl.documents">
            <div class="cover-container cover-container-in-slider">
                <kp-svelte-component-wrapper component="::$ctrl.kpCoverComponent" props="::{record: document, fillTo: 'height'}"></kp-svelte-component-wrapper>
            </div>
            <div class="slider-record">
                <div class="news-record-name">
                    <a ng-href="/records/{{document.id}}">{{document.name}}</a>
                </div>
                <div ng-if="document.subtitle && document.subtitle.length > 0" class="news-record-subtitle">
                    <kp-svelte-component-wrapper component="::$ctrl.labelsComponent" props="::{labeleds: document.subtitle, linkifyUrls: false}"></kp-svelte-component-wrapper>
                </div>
                <div ng-if="document.primaryAuthors && document.primaryAuthors.length > 0" class="news-record-author">
                    <kp-svelte-component-wrapper component="::$ctrl.labelsComponent" props="::{labeleds: document.primaryAuthors}"></kp-svelte-component-wrapper>
                </div>
            </div>
            <div class="cleaner"></div>
        </div>

    </jp-slider>

</div>