/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.appserver.config.AppserverConfigService;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.batch.db.AllColumnsJdbcChunkSaver;
import cz.kpsys.portaro.commons.cache.CacheBackedRepository;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.contextual.ContextualConsumer;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.SwitchContextualProvider;
import cz.kpsys.portaro.commons.date.StringToDateRangeConverter;
import cz.kpsys.portaro.commons.date.TimezonedStringToDatetimeRangeConverter;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.IdentifiedValue;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdAndByIdOptLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdOptLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import cz.kpsys.portaro.commons.object.repo.NotFoundExceptionTranslatingRepository;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.SeveritedItemNotFoundException;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.datatype.ScalarDatatype;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.form.editor.ValueEditorByDatatypeLoader;
import cz.kpsys.portaro.form.valueeditor.bool.BooleanValueEditorModifier;
import cz.kpsys.portaro.formconfig.valueeditor.AuthenticatedAcceptableValuesResolver;
import cz.kpsys.portaro.hierarchy.HierarchyLoadScope;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.hierarchy.InheritanceLoader;
import cz.kpsys.portaro.marcxml.convert.JacksonStringToRecordMarcDtoConverter;
import cz.kpsys.portaro.marcxml.model.LenientVerbisRecordMarcDto;
import cz.kpsys.portaro.marcxml.model.RecordMarcDto;
import cz.kpsys.portaro.marcxml.model.StrictVerbisRecordMarcDto;
import cz.kpsys.portaro.record.DependentRecordFieldDbProcInvalidator;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordFactory;
import cz.kpsys.portaro.record.RecordImportApiController;
import cz.kpsys.portaro.record.RecordLockedContextualPredicate;
import cz.kpsys.portaro.record.RecordSaver;
import cz.kpsys.portaro.record.RecordSecurityActions;
import cz.kpsys.portaro.record.RecordSettingKeys;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.portaro.record.RecordStatusResolver;
import cz.kpsys.portaro.record.copy.RecordCopyRequest;
import cz.kpsys.portaro.record.deletion.AppserverRecordDeleter;
import cz.kpsys.portaro.record.deletion.RecordDeleter;
import cz.kpsys.portaro.record.deletion.RecordDeleterDelegatingRecordHoldingDeleter;
import cz.kpsys.portaro.record.deletion.RecordDeletionCommand;
import cz.kpsys.portaro.record.deletion.RecordHardDeleter;
import cz.kpsys.portaro.record.deletion.RecordHoldingDeletionCommand;
import cz.kpsys.portaro.record.deletion.RecordHoldingDeletionRequest;
import cz.kpsys.portaro.record.deletion.RecordHoldingDeletionRequestDefaulter;
import cz.kpsys.portaro.record.deletion.SecuredRecordDeleter;
import cz.kpsys.portaro.record.deletion.SecuredRecordHoldingDeleter;
import cz.kpsys.portaro.record.detail.FieldDependencyResolver;
import cz.kpsys.portaro.record.detail.FieldType;
import cz.kpsys.portaro.record.detail.FieldTypeId;
import cz.kpsys.portaro.record.detail.datatype.FieldStructuredDatatypeLoader;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueApiController;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueCommandResolver;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueId;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueResolver;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueSaveCommand;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueSaveCommandToCustomSettingConverter;
import cz.kpsys.portaro.record.detail.dflt.DelegatingDefaultFieldValueCommandResolver;
import cz.kpsys.portaro.record.detail.resolver.FieldMetadataResolver;
import cz.kpsys.portaro.record.detail.resolver.FieldRootFondsResolver;
import cz.kpsys.portaro.record.discardation.AppServerRecordHoldingDiscarder;
import cz.kpsys.portaro.record.discardation.RecordDeleterDelegatingRecordHoldingDiscarder;
import cz.kpsys.portaro.record.discardation.RecordDiscarder;
import cz.kpsys.portaro.record.discardation.RecordHoldingDiscarder;
import cz.kpsys.portaro.record.discardation.SecuredRecordDiscarder;
import cz.kpsys.portaro.record.discardation.SecuredRecordHoldingDiscarder;
import cz.kpsys.portaro.record.edit.ByFondLoaderDelegatingRecordFieldTypesLoader;
import cz.kpsys.portaro.record.edit.DefaultFieldValueGenerator;
import cz.kpsys.portaro.record.edit.FieldTypesByFondLoader;
import cz.kpsys.portaro.record.edit.MissingAddingRecordEditableFieldTypesLoader;
import cz.kpsys.portaro.record.edit.RecordAutoSavingPolicyRequest;
import cz.kpsys.portaro.record.edit.RecordConstraintsFormatValidator;
import cz.kpsys.portaro.record.edit.RecordEditationAvailableFondsResolver;
import cz.kpsys.portaro.record.edit.RecordEditationFactory;
import cz.kpsys.portaro.record.edit.RecordEditationHelper;
import cz.kpsys.portaro.record.edit.RecordEntryFieldTypeIdResolver;
import cz.kpsys.portaro.record.edit.RecordFieldEditor;
import cz.kpsys.portaro.record.edit.RecordFieldTypesLoader;
import cz.kpsys.portaro.record.edit.RecordValidator;
import cz.kpsys.portaro.record.edit.fieldshierarchy.FieldValueCommandResolver;
import cz.kpsys.portaro.record.fieldtype.EditableFieldTypesToFieldTypeDefinitionConverter;
import cz.kpsys.portaro.record.file.DirectoryAndItsContentIdLoader;
import cz.kpsys.portaro.record.fond.BestSuitableFondResolver;
import cz.kpsys.portaro.record.fond.FieldTypeIdByBindingLoader;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.fond.FondInheritanceLoader;
import cz.kpsys.portaro.record.fond.FondTypeResolver;
import cz.kpsys.portaro.record.fond.InclusionLoader;
import cz.kpsys.portaro.record.holding.RecordHolding;
import cz.kpsys.portaro.record.holding.RecordHoldingEntity;
import cz.kpsys.portaro.record.holding.RecordHoldingLoader;
import cz.kpsys.portaro.record.holding.RecordHoldingToEntityConverter;
import cz.kpsys.portaro.record.holding.RecordHoldingUpserter;
import cz.kpsys.portaro.record.importer.marc.RecordImporter;
import cz.kpsys.portaro.record.importer.marc.RecordMarcDtoImporter;
import cz.kpsys.portaro.record.load.RecordDayIdLoader;
import cz.kpsys.portaro.record.load.RecordFieldsLoader;
import cz.kpsys.portaro.record.merge.RecordMergeRequest;
import cz.kpsys.portaro.record.operation.CachingRecordEditLevelProvider;
import cz.kpsys.portaro.record.prop.DetailRecordPropertiesGenerator;
import cz.kpsys.portaro.record.search.SearchingContextualRecordLoader;
import cz.kpsys.portaro.record.search.SearchingContextualRecordsCountLoader;
import cz.kpsys.portaro.record.search.restriction.FieldTypeSearchField;
import cz.kpsys.portaro.record.search.restriction.RecordConstraintsSearchRestrictionConstructor;
import cz.kpsys.portaro.record.sec.CurrentAuthFondsLoader;
import cz.kpsys.portaro.record.util.RecordRefresher;
import cz.kpsys.portaro.record.view.DatatypeResolvingFieldStructuredDatatypeLoader;
import cz.kpsys.portaro.record.view.DatatypeResolvingFieldValueEditorLoader;
import cz.kpsys.portaro.record.view.EditableFieldTypesToResponseConverter;
import cz.kpsys.portaro.record.view.FieldValueEditorLoader;
import cz.kpsys.portaro.record.view.SourceRecordSupportingRecordEditorFactory;
import cz.kpsys.portaro.record.view.StandardRecordEditorFactory;
import cz.kpsys.portaro.record.view.UserInteractionRecordEditation;
import cz.kpsys.portaro.record.view.ViewableRecordEditationFactory;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingEntity;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.role.editor.EditLevel;
import cz.kpsys.portaro.user.role.editor.EditorAccount;
import cz.kpsys.portaro.view.web.rest.record.FieldTypeApiController;
import jakarta.validation.constraints.NotBlank;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.function.Consumers;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
@Lazy
public class RecordEditConfig {
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final RecordSaver recordSaver;
    @NonNull
    private final HierarchyLoader<Department> contextHierarchyLoader;
    @NonNull
    private final DetailRecordPropertiesGenerator detailRecordPropertiesGenerator;
    @NonNull
    private final ByIdLoadable<FieldType<?>, FieldTypeId> subfieldTypeLoader;
    @NonNull
    private final AllValuesProvider<Fond> enabledFondsProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Fond> defaultNonPeriodicalDocumentFondProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Fond> defaultPeriodicalDocumentFondProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Fond> defaultAuthorityFondProvider;
    @NonNull
    private final DynamicCache<Record> recordCache;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final CurrentAuthFondsLoader currentAuthEditableFondsLoader;
    @NonNull
    private final ContextualConsumer<RecordDeletionCommand, Department> subtreeDepartmentedRecordExemplarsDeleter;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    @NonNull
    private final Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final ByIdLoadable<Fond, Integer> fondLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Record> nonDetailedRecordSearchSqlLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Record> detailedRecordSearchSqlLoader;
    @NonNull
    private final CachingRecordEditLevelProvider recordEditLevelProvider;
    @NonNull
    private final RecordHoldingLoader recordHoldingLoader;
    private final @NonNull AllValuesProvider<IdentifiedValue<DefaultFieldValueId, @NotBlank String>> defaultFieldValueLoader;
    @NonNull
    private final RecordValidator recordValidator;
    @NonNull
    private final ByIdLoadable<FieldType<?>, FieldTypeId> fieldTypeLoader;
    @NonNull
    private final FieldTypesByFondLoader fieldTypesByFondLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> recordLoader;
    @NonNull
    private final RecordFieldsLoader recordFieldsLoader;
    @NonNull
    private final RecordEntryFieldTypeIdResolver recordEntryFieldTypeIdResolver;
    @NonNull
    private final ConversionService conversionService;
    @NonNull
    private final AllValuesProvider<Fond> enabledDocumentFondsProvider;
    private final @NonNull ByIdLoadable<@Nullable AllValuesProvider<? extends LabeledIdentified<?>>, ScalarDatatype> acceptableValuesProviderLoader;
    @NonNull
    private final ValueEditorByDatatypeLoader valueEditorByDatatypeLoader;
    @NonNull
    private final @NonNull Converter<@NonNull String, @NonNull Instant> recordFieldStringToInstantConverter;
    @NonNull
    private final StringToDateRangeConverter recordFieldStringToDateRangeConverter;
    @NonNull
    private final TimezonedStringToDatetimeRangeConverter recordFieldStringToDatetimeRangeConverter;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final ContextualFunction<Record, Department, Boolean> singleNodeDepartmentedRecordHasExemplarsPredicate;
    @NonNull
    private final DefaultFieldValueResolver defaultFieldValueResolver;
    @NonNull
    private final RecordHoldingUpserter recordHoldingUpserter;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final DatabaseProperties databaseProperties;
    @NonNull
    private final Runnable saveTransactionAuthenticator;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final AppserverConfigService appserverConfigService;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final UserByBasicUserLoader userLoader;
    @NonNull
    private final RecordDayIdLoader recordDayIdLoader;
    @NonNull
    private final Function<Fond, List<Fond>> enabledIncludableFondsExpander;
    @NonNull
    private final @NonNull Provider<@NonNull ZoneId> defaultTimeZoneProvider;
    @NonNull
    private final FondInheritanceLoader enabledFondInheritanceLoader;
    @NonNull
    private final ByIdAndByIdOptLoadable<FieldTypeSearchField, String> fieldTypeSearchFieldLoader;
    @NonNull
    private final DependentRecordFieldDbProcInvalidator dbProcInvalidator;
    @NonNull
    private final FieldMetadataResolver fieldMetadataResolver;
    @NonNull
    private final RecordConstraintsSearchRestrictionConstructor recordConstraintsSearchRestrictionConstructor;

    @Bean
    public RecordEditationAvailableFondsResolver recordEditationAvailableFondsResolver() {
        return new RecordEditationAvailableFondsResolver(this.currentAuthEditableFondsLoader, (InclusionLoader)this.enabledFondInheritanceLoader);
    }

    @Bean
    public RecordLockedContextualPredicate recordLockedContextualPredicate() {
        return new RecordLockedContextualPredicate(this.recordStatusResolver());
    }

    @Bean
    public ViewableRecordEditationFactory viewableRecordEditationFactory() {
        return new ViewableRecordEditationFactory(this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_EDITED_INDICATORS_ENABLED), this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_EDITED_FIELD_IDENTIFIERS_ENABLED), this.recordEditationAvailableFondsResolver());
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<RecordMergeRequest> recordMergeRequestDefaulter() {
        return (formObject, ctx, currentAuth) -> {
            if (formObject.mergeDetail() == null) {
                formObject = formObject.withMergeDetail(Boolean.valueOf(true));
            }
            return formObject;
        };
    }

    @Bean
    public AuthenticatedAcceptableValuesResolver<RecordCopyRequest, Fond> recordCopyRequestAllowedFondsResolver() {
        return new RecordCopyRequest.RecordCopyRequestAllowedFondsResolver(this.currentAuthEditableFondsLoader);
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<RecordCopyRequest> recordCopyRequestDefaulter() {
        return new RecordCopyRequest.RecordCopyRequestDefaulter();
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<RecordCopyRequest> recordCopyRequestPreValidationModifier() {
        return new RecordCopyRequest.RecordCopyRequestPreValidationModifier();
    }

    @Bean
    public DefaultFieldValueApiController defaultFieldValueApiController() {
        return new DefaultFieldValueApiController(this.defaultFieldValueLoader, this.defaultFieldValueSaver());
    }

    @Bean
    public RecordImportApiController recordImportApiController() {
        return new RecordImportApiController(this.stringToStrictRecordMarcDtoConverter(), this.stringToLenientVerbisRecordMarcDtoConverter(), this.recordMarcDtoImporter());
    }

    @Bean
    public RecordImporter<RecordMarcDto> recordMarcDtoImporter() {
        return new RecordMarcDtoImporter(this.recordEditationFactory(), this.recordFieldEditor(), this.fondLoader, this.recordFieldStringToInstantConverter, this.recordFieldStringToDateRangeConverter, this.recordFieldStringToDatetimeRangeConverter);
    }

    @Bean
    public Converter<String, StrictVerbisRecordMarcDto> stringToStrictRecordMarcDtoConverter() {
        return JacksonStringToRecordMarcDtoConverter.ofStrict();
    }

    @Bean
    public Converter<String, LenientVerbisRecordMarcDto> stringToLenientVerbisRecordMarcDtoConverter() {
        return JacksonStringToRecordMarcDtoConverter.ofLenientVerbis();
    }

    @Bean
    public FieldTypeApiController fieldTypeApiController() {
        return new FieldTypeApiController(this.fieldTypesByFondLoader, this.recordEditableFieldTypesLoader(), this.editableFieldTypesToFieldTypeDefinitionConverter(), this.editableFieldTypesToResponseConverter());
    }

    @Bean
    public EditableFieldTypesToFieldTypeDefinitionConverter editableFieldTypesToFieldTypeDefinitionConverter() {
        return new EditableFieldTypesToFieldTypeDefinitionConverter((FieldValueEditorLoader)this.fieldValueEditorLoader(), (FieldStructuredDatatypeLoader)this.fieldValueStructuredDatatypeLoader(), this.enabledIncludableFondsExpander, (InheritanceLoader)this.enabledFondInheritanceLoader, this.defaultTimeZoneProvider, this.fieldTypesByFondLoader, (ByIdOptLoadable)this.fieldTypeSearchFieldLoader, (FieldRootFondsResolver)this.fieldMetadataResolver);
    }

    @Bean
    public EditableFieldTypesToResponseConverter editableFieldTypesToResponseConverter() {
        return new EditableFieldTypesToResponseConverter(this.recordEntryFieldTypeIdResolver, (FieldValueEditorLoader)this.fieldValueEditorLoader());
    }

    @Bean
    public RecordStatusResolver recordStatusResolver() {
        return new RecordStatusResolver((ContextualProvider)this.publishingDocumentRecordStatusProvider(), this.editLockThreshold(), this.securityManager);
    }

    @Bean
    @NonNull
    public ContextualProvider<Department, Optional<RecordStatus>> editLockThreshold() {
        return this.settingLoader.getDepartmentedProvider(RecordSettingKeys.EDIT_LOCK_THRESHOLD).andThenFastReturningNull(arg_0 -> ((Codebook)RecordStatus.CODEBOOK).getById(arg_0)).optionally();
    }

    @Bean
    public RecordEditationFactory recordEditationFactory() {
        return new RecordEditationFactory(this.recordEditableFieldTypesLoader(), this.recordValidator, this.recordSaver, this.fieldTypesByFondLoader, (ContextualProvider)this.publishingDocumentRecordStatusProvider(), this.recordHoldingUpserter, this.fieldValueCommandResolver(), this.fieldTypeLoader, this.recordFieldEditor(), this.recordFieldsLoader, this.defaultFieldValueCommandResolver(), (ContextualFunction)this.recordLockedContextualPredicate(), this.recordStatusResolver());
    }

    @Bean
    @NonNull
    public SwitchContextualProvider<Department, RecordStatus> publishingDocumentRecordStatusProvider() {
        return new SwitchContextualProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.PUBLISHING_DOCUMENT_FINISHED_CATALOGIZATION), (Object)RecordStatus.STANDARD_DOCUMENT, (Object)RecordStatus.FINISHED_CATALOGING);
    }

    @Bean
    public DefaultFieldValueCommandResolver defaultFieldValueCommandResolver() {
        return new DelegatingDefaultFieldValueCommandResolver(this.defaultFieldValueResolver, new DefaultFieldValueGenerator((ByIdLoadable)this.recordLoader, this.recordDayIdLoader, this.userLoader));
    }

    @Bean
    public RecordConstraintsFormatValidator recordConstraintsValidator() {
        return new RecordConstraintsFormatValidator(new SearchingContextualRecordsCountLoader(this.nonDetailedRecordSearchSqlLoader, this.contextHierarchyLoader, HierarchyLoadScope.FAMILY), this.recordConstraintsSearchRestrictionConstructor);
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
    public RecordFieldEditor recordFieldEditor() {
        return new RecordFieldEditor(this.fieldTypeLoader, this.recordSaver, this.recordHoldingUpserter, this.defaultFieldValueCommandResolver(), new FieldDependencyResolver(this.recordEntryFieldTypeIdResolver), this.recordEntryFieldTypeIdResolver, new SearchingContextualRecordLoader(this.detailedRecordSearchSqlLoader, this.contextHierarchyLoader, HierarchyLoadScope.FAMILY), this.recordEditationFactory(), (ByIdLoadable)this.fieldTypeSearchFieldLoader, this.recordConstraintsValidator());
    }

    @Bean
    public RecordEditationHelper recordEditationHelper() {
        return new RecordEditationHelper(this.recordFieldEditor());
    }

    @Bean
    public FieldValueCommandResolver fieldValueCommandResolver() {
        return new FieldValueCommandResolver((ByIdLoadable)this.recordLoader, this.conversionService, this.fieldTypeLoader);
    }

    @Bean
    public RecordFieldTypesLoader recordEditableFieldTypesLoader() {
        return new MissingAddingRecordEditableFieldTypesLoader((RecordFieldTypesLoader)new ByFondLoaderDelegatingRecordFieldTypesLoader(this.fieldTypesByFondLoader), this.fieldTypesByFondLoader, this.subfieldTypeLoader);
    }

    @Bean
    public DatatypeResolvingFieldValueEditorLoader fieldValueEditorLoader() {
        return new DatatypeResolvingFieldValueEditorLoader(this.valueEditorByDatatypeLoader, (Function)new SourceRecordSupportingRecordEditorFactory((Function)new StandardRecordEditorFactory(), this.enabledDocumentFondsProvider));
    }

    @Bean
    public DatatypeResolvingFieldStructuredDatatypeLoader fieldValueStructuredDatatypeLoader() {
        return new DatatypeResolvingFieldStructuredDatatypeLoader(this.acceptableValuesProviderLoader);
    }

    @Bean
    public RecordFactory recordFactory() {
        return new RecordFactory(this.detailRecordPropertiesGenerator, this.recordValidator);
    }

    @Bean
    public BestSuitableFondResolver bestSuitableFondResolver() {
        return new BestSuitableFondResolver(this.enabledFondsProvider, this.defaultNonPeriodicalDocumentFondProvider, this.defaultPeriodicalDocumentFondProvider, this.defaultAuthorityFondProvider, this.recordValidator);
    }

    @Bean
    public Saver<DefaultFieldValueSaveCommand, CustomSettingEntity> defaultFieldValueSaver() {
        return new PreConvertingSaver((Converter)new DefaultFieldValueSaveCommandToCustomSettingConverter(this.customSettingLoader), this.customSettingSaver);
    }

    @Bean
    public Repository<UserInteractionRecordEditation, String> recordEditationRepository() {
        CacheBackedRepository delegate = CacheBackedRepository.ofIdentified((DynamicCache)GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofHours(2L), (boolean)false));
        return new NotFoundExceptionTranslatingRepository((Repository)delegate, source -> {
            Object desiredItemIdentifier = source instanceof ItemNotFoundException ? ((ItemNotFoundException)source).getDesiredItemIdentifier() : null;
            return new SeveritedItemNotFoundException(UserInteractionRecordEditation.class, desiredItemIdentifier, null, Texts.ofNative((String)"Editation is expired or not exists"), 2);
        });
    }

    @Bean
    public RecordDeleter recordDeleter() {
        AppserverRecordDeleter bean = new AppserverRecordDeleter(this.mappingAppserver, this.subtreeDepartmentedRecordExemplarsDeleter, this.appserverXmlMapper, List.of(this.recordCache));
        return new SecuredRecordDeleter((RecordDeleter)bean, this.securityManager);
    }

    @Bean
    public RecordDiscarder recordDiscarder() {
        AppServerRecordHoldingDiscarder bean = new AppServerRecordHoldingDiscarder(this.mappingAppserver, this.appserverXmlMapper, List.of(this.recordCache));
        return new SecuredRecordDiscarder((RecordDiscarder)bean, this.securityManager);
    }

    @Bean
    public RecordHardDeleter recordHardDeleter() {
        return new RecordHardDeleter(this.notAutoCommittingJdbcTemplate, this.defaultTransactionTemplateFactory.get(), this.queryFactory, this.saveTransactionAuthenticator, this.directoryAndItsContentIdLoader(), this.appserverConfigService, this.databaseProperties.getType().equals("firebird"));
    }

    @Bean
    public DirectoryAndItsContentIdLoader directoryAndItsContentIdLoader() {
        return new DirectoryAndItsContentIdLoader(this.notAutoCommittingJdbcTemplate, this.defaultTransactionTemplateFactory.get(), this.queryFactory, this.directoryLoader);
    }

    @Bean
    public Saver<RecordHolding, RecordHolding> recordHoldingSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new RecordHoldingToEntityConverter()).withClearedCacheName(RecordHoldingEntity.class.getSimpleName()).build();
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<RecordHoldingDeletionRequest> recordHoldingDeletionRequestDefaulter() {
        return new RecordHoldingDeletionRequestDefaulter();
    }

    @Bean
    public BooleanValueEditorModifier<RecordHoldingDeletionRequest> recordHoldingDeletionAcceptingExemplarsDeletionEditorModifier() {
        return new RecordHoldingDeletionRequest.RecordHoldingDeletionAcceptingExemplarsDeletionEditorModifier(this.recordLoader, this.singleNodeDepartmentedRecordHasExemplarsPredicate);
    }

    @Bean
    public Deleter<RecordHoldingDeletionCommand> recordHoldingDeleter() {
        RecordDeleterDelegatingRecordHoldingDeleter bean = new RecordDeleterDelegatingRecordHoldingDeleter((ByIdLoadable)this.recordLoader, this.recordDeleter());
        return new SecuredRecordHoldingDeleter((Deleter)bean, this.securityManager);
    }

    @Bean
    public RecordHoldingDiscarder recordHoldingDiscarder() {
        RecordDeleterDelegatingRecordHoldingDiscarder bean = new RecordDeleterDelegatingRecordHoldingDiscarder((ByIdLoadable)this.recordLoader, this.recordDiscarder(), this.singleNodeDepartmentedRecordHasExemplarsPredicate);
        return new SecuredRecordHoldingDiscarder(bean, this.securityManager);
    }

    @Bean
    public FieldTypeIdByBindingLoader fieldTypeIdByPicLoader() {
        return new FieldTypeIdByBindingLoader(this.fieldTypesByFondLoader);
    }

    @Bean
    public Saver<List<UUID>, List<UUID>> taskQueueRefreshRecorIdsSaver() {
        AllColumnsJdbcChunkSaver taskQueueRecorIdsSaver = new AllColumnsJdbcChunkSaver(this.notAutoCommittingJdbcTemplate.getJdbcOperations(), "task_queue", 100, Consumers.nop(), uUID -> List.of("record_id", "typ"), (ps, recordId) -> {
            Object uuidDbValue = this.queryFactory.getDbSpecifics().convertUuidParametersToString() ? recordId.toString() : recordId;
            ps.setObject(1, uuidDbValue);
            ps.setInt(2, 4);
        });
        return ids -> {
            taskQueueRecorIdsSaver.save(ids);
            return ids;
        };
    }

    @Bean
    public RecordRefresher recordRefresher() {
        return new RecordRefresher(this.queryFactory.getDbSpecifics(), (Provider)StaticProvider.of((Object)20000), this.notAutoCommittingJdbcTemplate, this.defaultTransactionTemplateFactory.get(), this.dbProcInvalidator, this.taskQueueRefreshRecorIdsSaver());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerModule() {
        this.converterRegisterer.registerForStringId(RecordAutoSavingPolicyRequest.class, (ByIdLoadable)RecordAutoSavingPolicyRequest.CODEBOOK).registerForStringId(UserInteractionRecordEditation.class, (ByIdLoadable)this.recordEditationRepository());
        this.registerPermissions();
    }

    private void registerPermissions() {
        PermissionResolver editFond = PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_LIBRARIAN"}), (auth, ctx, fond) -> {
            List editableFonds = this.currentAuthEditableFondsLoader.getAllByAuth(auth, ctx);
            return PermissionResult.ifCan((boolean)editableFonds.contains(fond), (UserAuthentication)auth).withReasonWhenForbid((Text)MultiText.ofTexts((Text[])new Text[]{Texts.ofNative((String)"You dont have permission to edit fond"), fond.getText(), Texts.ofNative((String)"You can edit only"), Texts.ofNative((String)StringUtil.listToStringOfIds((Collection)editableFonds, (String)", "))}).withSpaceDelimiter());
        }});
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE_ANY, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(2201)), this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(7201))}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE_OF_KIND, (auth, ctx, kind) -> {
            PermissionResult createAnyRecordPerm = this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_CREATE_ANY).can(auth, ctx, null);
            if (createAnyRecordPerm.forbidden()) {
                return createAnyRecordPerm;
            }
            if (kind.equals("authority")) {
                PermissionResult authorityCreateAction = this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(7201)).can(auth, ctx, null);
                if (authorityCreateAction.forbidden()) {
                    return authorityCreateAction;
                }
                if (this.currentAuthEditableFondsLoader.getAllByAuth(auth, ctx).stream().noneMatch(FondTypeResolver::isAuthorityFond)) {
                    return PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)"You dont have user permission (in Verbis) to edit any authority fond"));
                }
                return PermissionResult.allow();
            }
            PermissionResult documentCreateAction = this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(2201)).can(auth, ctx, null);
            if (documentCreateAction.forbidden()) {
                return documentCreateAction;
            }
            if (this.currentAuthEditableFondsLoader.getAllByAuth(auth, ctx).stream().noneMatch(FondTypeResolver::isDocumentFond)) {
                return PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)"You dont have user permission (in Verbis) to edit any document fond"));
            }
            return PermissionResult.allow();
        });
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE_OF_DOCUMENT_FOND, (auth, ctx, unused) -> this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_CREATE_OF_KIND).can(auth, ctx, (Object)"document"));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE_OF_AUTHORITY_FOND, (auth, ctx, unused) -> this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_CREATE_OF_KIND).can(auth, ctx, (Object)"authority"));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE_OF_FOND, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, fond) -> {
            String subkind = FondTypeResolver.isDocumentFond((Fond)fond) ? "document" : "authority";
            return this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_CREATE_OF_KIND).can(auth, ctx, (Object)subkind);
        }, editFond}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_DRAFT_SAVE, this.permissionFactory.currentEvidedAuthenticActive());
        this.permissionRegistry.add(RecordSecurityActions.RECORD_PUBLISH, (PermissionResolver)PermissionResolver.adaptingSubject(Record::getFond, (PermissionResolver)this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_CREATE_OF_FOND)));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_CREATE_DRAFT_OF_FOND, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_CREATE_OF_FOND), this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_READER"})}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_LOCK_OR_UNLOCK, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.adaptingSubject(Record::getFond, (auth, ctx, fond) -> {
            int actionId = FondTypeResolver.isDocumentFond((Fond)fond) ? 2202 : 7202;
            return this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(actionId)).can(auth, ctx, null);
        }), PermissionResolver.adaptingSubject(Record::getFond, (PermissionResolver)editFond)}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_EDIT_FAST, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> this.recordLockedContextualPredicate().getOn(record, ctx) == false ? PermissionResult.allow() : PermissionResult.disallowedState((Text)Texts.ofNative((String)"Record is locked")), PermissionResolver.adaptingSubject(Record::getFond, (auth, ctx, fond) -> {
            int actionId = FondTypeResolver.isDocumentFond((Fond)fond) ? 2202 : 7202;
            return this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(actionId)).can(auth, ctx, null);
        }), PermissionResolver.adaptingSubject(Record::getFond, (PermissionResolver)editFond)}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_EDIT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> !record.isDeleted() ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Record is already deleted")), this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_EDIT_FAST), this.currentEvidedAuthenticActiveLibrarianWithSufficientEditLevelToEditRecord(), this.editedRecordHasHoldingsOnEditableDepartmentsOfCurrentCtxSubtree()}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_HOLDING_DELETE_OF_RECORD, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> !record.isDeleted() ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Record is already deleted")), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> !record.isActive() ? PermissionResult.allow() : PermissionResult.forbid(), PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> {
            int actionId = FondTypeResolver.isDocumentFond((Record)record) ? 2204 : 7204;
            return this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(actionId)).can(auth, ctx, null);
        }, PermissionResolver.adaptingSubject(Record::getFond, (PermissionResolver)editFond)})})}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_HOLDING_DISCARD_OF_RECORD, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> !record.isDeleted() ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Record is already deleted")), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> !record.isActive() ? PermissionResult.allow() : PermissionResult.forbid(), (auth, ctx, record) -> {
            int actionId = FondTypeResolver.isDocumentFond((Record)record) ? 2204 : 7204;
            return this.permissionFactory.currentEvidedAuthenticEditWithCatalogLicencedAction(Integer.valueOf(actionId)).can(auth, ctx, null);
        }})}));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_HOLDING_DELETE, (PermissionResolver)PermissionResolver.adaptingSubject(recordHolding -> (Record)this.nonDetailedRichRecordLoader.getById((Object)recordHolding.getRecordId()), (PermissionResolver)this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_HOLDING_DELETE_OF_RECORD)));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_HOLDING_DISCARD, (PermissionResolver)PermissionResolver.adaptingSubject(recordHolding -> (Record)this.nonDetailedRichRecordLoader.getById((Object)recordHolding.getRecordId()), (PermissionResolver)this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_HOLDING_DISCARD_OF_RECORD)));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_MERGE_FROM, this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_HOLDING_DELETE_OF_RECORD));
        this.permissionRegistry.add(RecordSecurityActions.RECORD_MERGE_TO, this.permissionRegistry.getLazy(RecordSecurityActions.RECORD_EDIT));
    }

    private PermissionResolver<Record> currentEvidedAuthenticActiveLibrarianWithSufficientEditLevelToEditRecord() {
        return PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_LIBRARIAN"}), (auth, ctx, record) -> {
            EditLevel lastRecordEditLevel;
            Stream editorAccounts = auth.getActiveUser().roleStreamOn(EditorAccount.class, ctx);
            if (editorAccounts.noneMatch(arg_0 -> RecordEditConfig.lambda$currentEvidedAuthenticActiveLibrarianWithSufficientEditLevelToEditRecord$1(lastRecordEditLevel = this.recordEditLevelProvider.getRecordEditLevel(record), arg_0))) {
                return PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)("Record (" + String.valueOf(record.getId()) + ") is locked (You have not sufficient edit level to edit/delete record)")));
            }
            return PermissionResult.allow();
        }});
    }

    private PermissionResolver<Record> editedRecordHasHoldingsOnEditableDepartmentsOfCurrentCtxSubtree() {
        return (auth, ctx, record) -> {
            List recordHoldingDepartments = ListUtil.convert((Iterable)this.recordHoldingLoader.getAllByRecordId((UUID)record.getId()), RecordHolding::getDepartment);
            if (recordHoldingDepartments.isEmpty()) {
                return PermissionResult.allow();
            }
            List ctxFamilyDepartments = this.contextHierarchyLoader.getAllByScope((Object)ctx, HierarchyLoadScope.FAMILY);
            List ctxFilteredHoldingDepartments = ListUtil.intersection((Collection)recordHoldingDepartments, (Collection)ctxFamilyDepartments);
            if (ctxFilteredHoldingDepartments.isEmpty()) {
                return PermissionResult.cannot((UserAuthentication)auth, (Text)Texts.ofNative((String)"You cannot edit record %s which does not have any holding on your editable departments (recordHoldingCtx: %s, ctxFamilyDepartments: %s)".formatted(record.getId(), recordHoldingDepartments.toString(), ctxFamilyDepartments.toString())));
            }
            return PermissionResolver.orSubjects((PermissionResolver)this.permissionFactory.editSubjectWithDepartment(), (UserAuthentication)auth, (Department)ctx, (Collection)ctxFilteredHoldingDepartments);
        };
    }

    @ConstructorProperties(value={"appserverXmlMapper", "mappingAppserver", "securityManager", "recordSaver", "contextHierarchyLoader", "detailRecordPropertiesGenerator", "subfieldTypeLoader", "enabledFondsProvider", "defaultNonPeriodicalDocumentFondProvider", "defaultPeriodicalDocumentFondProvider", "defaultAuthorityFondProvider", "recordCache", "settingLoader", "currentAuthEditableFondsLoader", "subtreeDepartmentedRecordExemplarsDeleter", "converterRegisterer", "customSettingLoader", "customSettingSaver", "permissionRegistry", "permissionFactory", "fondLoader", "nonDetailedRichRecordLoader", "nonDetailedRecordSearchSqlLoader", "detailedRecordSearchSqlLoader", "recordEditLevelProvider", "recordHoldingLoader", "defaultFieldValueLoader", "recordValidator", "fieldTypeLoader", "fieldTypesByFondLoader", "recordLoader", "recordFieldsLoader", "recordEntryFieldTypeIdResolver", "conversionService", "enabledDocumentFondsProvider", "acceptableValuesProviderLoader", "valueEditorByDatatypeLoader", "recordFieldStringToInstantConverter", "recordFieldStringToDateRangeConverter", "recordFieldStringToDatetimeRangeConverter", "saverBuilderFactory", "singleNodeDepartmentedRecordHasExemplarsPredicate", "defaultFieldValueResolver", "recordHoldingUpserter", "notAutoCommittingJdbcTemplate", "queryFactory", "databaseProperties", "saveTransactionAuthenticator", "defaultTransactionTemplateFactory", "appserverConfigService", "directoryLoader", "userLoader", "recordDayIdLoader", "enabledIncludableFondsExpander", "defaultTimeZoneProvider", "enabledFondInheritanceLoader", "fieldTypeSearchFieldLoader", "dbProcInvalidator", "fieldMetadataResolver", "recordConstraintsSearchRestrictionConstructor"})
    @Generated
    public RecordEditConfig(@NonNull ObjectMapper appserverXmlMapper, @NonNull MappingAppserverService mappingAppserver, @NonNull SecurityManager securityManager, @NonNull RecordSaver recordSaver, @NonNull HierarchyLoader<Department> contextHierarchyLoader, @NonNull DetailRecordPropertiesGenerator detailRecordPropertiesGenerator, @NonNull ByIdLoadable<FieldType<?>, FieldTypeId> subfieldTypeLoader, @NonNull AllValuesProvider<Fond> enabledFondsProvider, @NonNull @NonNull Provider<@NonNull Fond> defaultNonPeriodicalDocumentFondProvider, @NonNull @NonNull Provider<@NonNull Fond> defaultPeriodicalDocumentFondProvider, @NonNull @NonNull Provider<@NonNull Fond> defaultAuthorityFondProvider, @NonNull DynamicCache<Record> recordCache, @NonNull SettingLoader settingLoader, @NonNull CurrentAuthFondsLoader currentAuthEditableFondsLoader, @NonNull ContextualConsumer<RecordDeletionCommand, Department> subtreeDepartmentedRecordExemplarsDeleter, @NonNull ConverterRegisterer converterRegisterer, @NonNull CustomSettingLoader customSettingLoader, @NonNull Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull ByIdLoadable<Fond, Integer> fondLoader, @NonNull IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, Record> nonDetailedRecordSearchSqlLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, Record> detailedRecordSearchSqlLoader, @NonNull CachingRecordEditLevelProvider recordEditLevelProvider, @NonNull RecordHoldingLoader recordHoldingLoader, @NonNull AllValuesProvider<IdentifiedValue<DefaultFieldValueId, @NotBlank String>> defaultFieldValueLoader, @NonNull RecordValidator recordValidator, @NonNull ByIdLoadable<FieldType<?>, FieldTypeId> fieldTypeLoader, @NonNull FieldTypesByFondLoader fieldTypesByFondLoader, @NonNull IdAndIdsLoadable<Record, UUID> recordLoader, @NonNull RecordFieldsLoader recordFieldsLoader, @NonNull RecordEntryFieldTypeIdResolver recordEntryFieldTypeIdResolver, @NonNull ConversionService conversionService, @NonNull AllValuesProvider<Fond> enabledDocumentFondsProvider, @NonNull ByIdLoadable<@Nullable AllValuesProvider<? extends LabeledIdentified<?>>, ScalarDatatype> acceptableValuesProviderLoader, @NonNull ValueEditorByDatatypeLoader valueEditorByDatatypeLoader, @NonNull @NonNull Converter<@NonNull String, @NonNull Instant> recordFieldStringToInstantConverter, @NonNull StringToDateRangeConverter recordFieldStringToDateRangeConverter, @NonNull TimezonedStringToDatetimeRangeConverter recordFieldStringToDatetimeRangeConverter, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull ContextualFunction<Record, Department, Boolean> singleNodeDepartmentedRecordHasExemplarsPredicate, @NonNull DefaultFieldValueResolver defaultFieldValueResolver, @NonNull RecordHoldingUpserter recordHoldingUpserter, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull DatabaseProperties databaseProperties, @NonNull Runnable saveTransactionAuthenticator, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull AppserverConfigService appserverConfigService, @NonNull DirectoryLoader directoryLoader, @NonNull UserByBasicUserLoader userLoader, @NonNull RecordDayIdLoader recordDayIdLoader, @NonNull Function<Fond, List<Fond>> enabledIncludableFondsExpander, @NonNull @NonNull Provider<@NonNull ZoneId> defaultTimeZoneProvider, @NonNull FondInheritanceLoader enabledFondInheritanceLoader, @NonNull ByIdAndByIdOptLoadable<FieldTypeSearchField, String> fieldTypeSearchFieldLoader, @NonNull DependentRecordFieldDbProcInvalidator dbProcInvalidator, @NonNull FieldMetadataResolver fieldMetadataResolver, @NonNull RecordConstraintsSearchRestrictionConstructor recordConstraintsSearchRestrictionConstructor) {
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(recordSaver, "recordSaver is marked non-null but is null");
        Objects.requireNonNull(contextHierarchyLoader, "contextHierarchyLoader is marked non-null but is null");
        Objects.requireNonNull(detailRecordPropertiesGenerator, "detailRecordPropertiesGenerator is marked non-null but is null");
        Objects.requireNonNull(subfieldTypeLoader, "subfieldTypeLoader is marked non-null but is null");
        Objects.requireNonNull(enabledFondsProvider, "enabledFondsProvider is marked non-null but is null");
        Objects.requireNonNull(defaultNonPeriodicalDocumentFondProvider, "defaultNonPeriodicalDocumentFondProvider is marked non-null but is null");
        Objects.requireNonNull(defaultPeriodicalDocumentFondProvider, "defaultPeriodicalDocumentFondProvider is marked non-null but is null");
        Objects.requireNonNull(defaultAuthorityFondProvider, "defaultAuthorityFondProvider is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableFondsLoader, "currentAuthEditableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(subtreeDepartmentedRecordExemplarsDeleter, "subtreeDepartmentedRecordExemplarsDeleter is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedRichRecordLoader, "nonDetailedRichRecordLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedRecordSearchSqlLoader, "nonDetailedRecordSearchSqlLoader is marked non-null but is null");
        Objects.requireNonNull(detailedRecordSearchSqlLoader, "detailedRecordSearchSqlLoader is marked non-null but is null");
        Objects.requireNonNull(recordEditLevelProvider, "recordEditLevelProvider is marked non-null but is null");
        Objects.requireNonNull(recordHoldingLoader, "recordHoldingLoader is marked non-null but is null");
        Objects.requireNonNull(defaultFieldValueLoader, "defaultFieldValueLoader is marked non-null but is null");
        Objects.requireNonNull(recordValidator, "recordValidator is marked non-null but is null");
        Objects.requireNonNull(fieldTypeLoader, "fieldTypeLoader is marked non-null but is null");
        Objects.requireNonNull(fieldTypesByFondLoader, "fieldTypesByFondLoader is marked non-null but is null");
        Objects.requireNonNull(recordLoader, "recordLoader is marked non-null but is null");
        Objects.requireNonNull(recordFieldsLoader, "recordFieldsLoader is marked non-null but is null");
        Objects.requireNonNull(recordEntryFieldTypeIdResolver, "recordEntryFieldTypeIdResolver is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(enabledDocumentFondsProvider, "enabledDocumentFondsProvider is marked non-null but is null");
        Objects.requireNonNull(acceptableValuesProviderLoader, "acceptableValuesProviderLoader is marked non-null but is null");
        Objects.requireNonNull(valueEditorByDatatypeLoader, "valueEditorByDatatypeLoader is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToInstantConverter, "recordFieldStringToInstantConverter is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToDateRangeConverter, "recordFieldStringToDateRangeConverter is marked non-null but is null");
        Objects.requireNonNull(recordFieldStringToDatetimeRangeConverter, "recordFieldStringToDatetimeRangeConverter is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(singleNodeDepartmentedRecordHasExemplarsPredicate, "singleNodeDepartmentedRecordHasExemplarsPredicate is marked non-null but is null");
        Objects.requireNonNull(defaultFieldValueResolver, "defaultFieldValueResolver is marked non-null but is null");
        Objects.requireNonNull(recordHoldingUpserter, "recordHoldingUpserter is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(appserverConfigService, "appserverConfigService is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(recordDayIdLoader, "recordDayIdLoader is marked non-null but is null");
        Objects.requireNonNull(enabledIncludableFondsExpander, "enabledIncludableFondsExpander is marked non-null but is null");
        Objects.requireNonNull(defaultTimeZoneProvider, "defaultTimeZoneProvider is marked non-null but is null");
        Objects.requireNonNull(enabledFondInheritanceLoader, "enabledFondInheritanceLoader is marked non-null but is null");
        Objects.requireNonNull(fieldTypeSearchFieldLoader, "fieldTypeSearchFieldLoader is marked non-null but is null");
        Objects.requireNonNull(dbProcInvalidator, "dbProcInvalidator is marked non-null but is null");
        Objects.requireNonNull(fieldMetadataResolver, "fieldMetadataResolver is marked non-null but is null");
        Objects.requireNonNull(recordConstraintsSearchRestrictionConstructor, "recordConstraintsSearchRestrictionConstructor is marked non-null but is null");
        this.appserverXmlMapper = appserverXmlMapper;
        this.mappingAppserver = mappingAppserver;
        this.securityManager = securityManager;
        this.recordSaver = recordSaver;
        this.contextHierarchyLoader = contextHierarchyLoader;
        this.detailRecordPropertiesGenerator = detailRecordPropertiesGenerator;
        this.subfieldTypeLoader = subfieldTypeLoader;
        this.enabledFondsProvider = enabledFondsProvider;
        this.defaultNonPeriodicalDocumentFondProvider = defaultNonPeriodicalDocumentFondProvider;
        this.defaultPeriodicalDocumentFondProvider = defaultPeriodicalDocumentFondProvider;
        this.defaultAuthorityFondProvider = defaultAuthorityFondProvider;
        this.recordCache = recordCache;
        this.settingLoader = settingLoader;
        this.currentAuthEditableFondsLoader = currentAuthEditableFondsLoader;
        this.subtreeDepartmentedRecordExemplarsDeleter = subtreeDepartmentedRecordExemplarsDeleter;
        this.converterRegisterer = converterRegisterer;
        this.customSettingLoader = customSettingLoader;
        this.customSettingSaver = customSettingSaver;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.fondLoader = fondLoader;
        this.nonDetailedRichRecordLoader = nonDetailedRichRecordLoader;
        this.nonDetailedRecordSearchSqlLoader = nonDetailedRecordSearchSqlLoader;
        this.detailedRecordSearchSqlLoader = detailedRecordSearchSqlLoader;
        this.recordEditLevelProvider = recordEditLevelProvider;
        this.recordHoldingLoader = recordHoldingLoader;
        this.defaultFieldValueLoader = defaultFieldValueLoader;
        this.recordValidator = recordValidator;
        this.fieldTypeLoader = fieldTypeLoader;
        this.fieldTypesByFondLoader = fieldTypesByFondLoader;
        this.recordLoader = recordLoader;
        this.recordFieldsLoader = recordFieldsLoader;
        this.recordEntryFieldTypeIdResolver = recordEntryFieldTypeIdResolver;
        this.conversionService = conversionService;
        this.enabledDocumentFondsProvider = enabledDocumentFondsProvider;
        this.acceptableValuesProviderLoader = acceptableValuesProviderLoader;
        this.valueEditorByDatatypeLoader = valueEditorByDatatypeLoader;
        this.recordFieldStringToInstantConverter = recordFieldStringToInstantConverter;
        this.recordFieldStringToDateRangeConverter = recordFieldStringToDateRangeConverter;
        this.recordFieldStringToDatetimeRangeConverter = recordFieldStringToDatetimeRangeConverter;
        this.saverBuilderFactory = saverBuilderFactory;
        this.singleNodeDepartmentedRecordHasExemplarsPredicate = singleNodeDepartmentedRecordHasExemplarsPredicate;
        this.defaultFieldValueResolver = defaultFieldValueResolver;
        this.recordHoldingUpserter = recordHoldingUpserter;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
        this.databaseProperties = databaseProperties;
        this.saveTransactionAuthenticator = saveTransactionAuthenticator;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.appserverConfigService = appserverConfigService;
        this.directoryLoader = directoryLoader;
        this.userLoader = userLoader;
        this.recordDayIdLoader = recordDayIdLoader;
        this.enabledIncludableFondsExpander = enabledIncludableFondsExpander;
        this.defaultTimeZoneProvider = defaultTimeZoneProvider;
        this.enabledFondInheritanceLoader = enabledFondInheritanceLoader;
        this.fieldTypeSearchFieldLoader = fieldTypeSearchFieldLoader;
        this.dbProcInvalidator = dbProcInvalidator;
        this.fieldMetadataResolver = fieldMetadataResolver;
        this.recordConstraintsSearchRestrictionConstructor = recordConstraintsSearchRestrictionConstructor;
    }

    private static /* synthetic */ boolean lambda$currentEvidedAuthenticActiveLibrarianWithSufficientEditLevelToEditRecord$1(EditLevel lastRecordEditLevel, EditorAccount editorAccount) {
        return editorAccount.getEditLevel().isBetterThan(lastRecordEditLevel);
    }
}

