/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.google.common.cache.CacheBuilder;
import cz.kpsys.portaro.action.ActionSaver;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.auth.listen.AuthenticationSuccessMultipleListener;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.ListToModifiedListExtendingConverter;
import cz.kpsys.portaro.commons.convert.PrefixRemovingStringToEConverter;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.FilteredAllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.ProviderByIdProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByAllValuesProviderAdapter;
import cz.kpsys.portaro.commons.object.repo.AllProvidingRepository;
import cz.kpsys.portaro.commons.object.repo.BulkSaver;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdsLoadableRepository;
import cz.kpsys.portaro.commons.object.repo.CacheProxyRepository;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.CompositeRepository;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.InMemoryBulkSaver;
import cz.kpsys.portaro.commons.object.repo.InMemoryRepository;
import cz.kpsys.portaro.commons.object.repo.LimitedSizeRepository;
import cz.kpsys.portaro.commons.object.repo.PriorityDualRepository;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.SwitchableDataSourceSaver;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.event.Event;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.event.SelectableEventer;
import cz.kpsys.portaro.exemplar.ExemplarLoader;
import cz.kpsys.portaro.export.CompositeExportDescriptorLoader;
import cz.kpsys.portaro.export.ExportDescriptorLoader;
import cz.kpsys.portaro.export.Exporter;
import cz.kpsys.portaro.export.ExporterResolver;
import cz.kpsys.portaro.export.MultipleItemsExporterBySingleItemExporter;
import cz.kpsys.portaro.export.XlsFileExporterByCsvExporter;
import cz.kpsys.portaro.formconfig.valueeditor.AcceptableValuesResolver;
import cz.kpsys.portaro.formconfig.valueeditor.AuthenticatedAcceptableValuesResolver;
import cz.kpsys.portaro.hierarchy.HierarchyLoadScope;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.licence.FeatureEnabledProvider;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.loan.LoanSetting;
import cz.kpsys.portaro.mail.MailService;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.ViewableRecord;
import cz.kpsys.portaro.record.collection.DefaultRecordCollectionContainQuery;
import cz.kpsys.portaro.record.collection.RecordCollectionConstants;
import cz.kpsys.portaro.record.collection.RecordCollectionContainQuery;
import cz.kpsys.portaro.record.collection.RecordCollectionCreator;
import cz.kpsys.portaro.record.collection.RecordCollectionItemInserter;
import cz.kpsys.portaro.record.collection.RecordCollectionItemOrderProvider;
import cz.kpsys.portaro.record.collection.RecordCollectionItemRemover;
import cz.kpsys.portaro.record.collection.RecordCollectionOrderProvider;
import cz.kpsys.portaro.record.collection.RecordCollectionRemover;
import cz.kpsys.portaro.record.collection.RecordCollectionSecurityActions;
import cz.kpsys.portaro.record.collection.RecordCollectionUpdater;
import cz.kpsys.portaro.record.collection.UserFavouritesCollectionByUserLoader;
import cz.kpsys.portaro.record.collection.api.RecordCollectionCreationRequest;
import cz.kpsys.portaro.record.collection.api.RecordCollectionEditationRequest;
import cz.kpsys.portaro.record.collection.api.RecordCollectionInsertRequest;
import cz.kpsys.portaro.record.collection.api.RecordCollectionPageApiController;
import cz.kpsys.portaro.record.collection.api.RecordCollectionTemplatedBodyMailSendRequest;
import cz.kpsys.portaro.record.collection.api.RecordCollectionsApiController;
import cz.kpsys.portaro.record.collection.api.ToViewableRecordCollectionConverter;
import cz.kpsys.portaro.record.collection.export.RecordCollectionAdapterExporter;
import cz.kpsys.portaro.record.collection.export.RecordCollectionTemplatedExporter;
import cz.kpsys.portaro.record.collection.hierarchy.RecordCollectionHierarchyTreeLoader;
import cz.kpsys.portaro.record.collection.index.DefaultRecordCollectionsIndexer;
import cz.kpsys.portaro.record.collection.index.RecordCollectionsIndexer;
import cz.kpsys.portaro.record.collection.index.RecordIdCollectionIdPair;
import cz.kpsys.portaro.record.collection.index.SpringDbRecordCollectionIdByRecordIdSearchLoader;
import cz.kpsys.portaro.record.collection.recordcollection.InMemoryRecordCollectionSearchLoader;
import cz.kpsys.portaro.record.collection.recordcollection.RecordCollection;
import cz.kpsys.portaro.record.collection.recordcollection.RecordCollectionEntity;
import cz.kpsys.portaro.record.collection.recordcollection.RecordCollectionToEntityConverter;
import cz.kpsys.portaro.record.collection.recordcollection.SpringDbRecordCollectionIdSearchLoader;
import cz.kpsys.portaro.record.collection.recordcollectioncategory.EntitiesToRecordCollectionCategoriesConverter;
import cz.kpsys.portaro.record.collection.recordcollectioncategory.RecordCollectionCategory;
import cz.kpsys.portaro.record.collection.recordcollectioncategory.RecordCollectionCategoryEntity;
import cz.kpsys.portaro.record.collection.recordcollectionitem.EntitiesToRecordCollectionItemsConverter;
import cz.kpsys.portaro.record.collection.recordcollectionitem.InMemoryRecordCollectionItemSearchLoader;
import cz.kpsys.portaro.record.collection.recordcollectionitem.RecordCollectionItem;
import cz.kpsys.portaro.record.collection.recordcollectionitem.RecordCollectionItemEntity;
import cz.kpsys.portaro.record.collection.recordcollectionitem.RecordCollectionItemToEntityConverter;
import cz.kpsys.portaro.record.collection.recordcollectionitem.SpringDbRecordCollectionItemIdSearchLoader;
import cz.kpsys.portaro.record.collection.treelist.RecordCollectionAcceptableEditorOption;
import cz.kpsys.portaro.record.collection.treelist.RecordCollectionsToTreeListConverter;
import cz.kpsys.portaro.record.collection.treelist.TreeListToRecordCollectionAcceptableEditorOptionsConverter;
import cz.kpsys.portaro.record.collection.userrecordcollection.EntitiesToUserRecordCollectionsConverter;
import cz.kpsys.portaro.record.collection.userrecordcollection.SpringDbUserRecordCollectionIdSearchLoader;
import cz.kpsys.portaro.record.collection.userrecordcollection.UserRecordCollection;
import cz.kpsys.portaro.record.collection.userrecordcollection.UserRecordCollectionEntity;
import cz.kpsys.portaro.record.collection.userrecordcollection.UserRecordCollectionToEntityConverter;
import cz.kpsys.portaro.record.collection.utils.InMemoryFirstRecordCollectionProvider;
import cz.kpsys.portaro.record.collection.utils.OptimizedRecordCollectionLoader;
import cz.kpsys.portaro.record.collection.utils.PersistentFirstRecordCollectionProvider;
import cz.kpsys.portaro.record.collection.utils.RecordCollectionDualSearchLoader;
import cz.kpsys.portaro.record.collection.utils.RecordCollectionFavouritesSearchPredicate;
import cz.kpsys.portaro.record.collection.utils.RecordCollectionItemDualSearchLoader;
import cz.kpsys.portaro.record.collection.utils.RecordCollectionItemToPersistentStorageMover;
import cz.kpsys.portaro.record.collection.utils.RecordCollectionUserCollectionEntitiesByCollectionIdSearchLoader;
import cz.kpsys.portaro.record.collection.utils.RecordCollectionsTreeMaxDepthGuard;
import cz.kpsys.portaro.record.collection.utils.SecuritySearchParamsProvider;
import cz.kpsys.portaro.record.collection.utils.ShowableRecordCollectionsSearchParameter;
import cz.kpsys.portaro.record.export.csv.CsvFileRecordsExporter;
import cz.kpsys.portaro.search.CompositeSearchableRepository;
import cz.kpsys.portaro.search.FirstItemCreatingSearchableRepository;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.RangePaging;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.search.SearchParamsPredicate;
import cz.kpsys.portaro.search.SearchableRepository;
import cz.kpsys.portaro.search.StaticParamsModifier;
import cz.kpsys.portaro.search.SwitchableDataSourceSearchLoader;
import cz.kpsys.portaro.search.SwitchableDataSourceSearchableRepository;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.BasicTemplateDescriptor;
import cz.kpsys.portaro.template.TemplateDescriptor;
import cz.kpsys.portaro.template.TemplateDescriptorLoader;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.template.TemplateLoadingExportDescriptorLoader;
import cz.kpsys.portaro.template.Templates;
import cz.kpsys.portaro.user.AuthableUser;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.contact.ContactManager;
import cz.kpsys.portaro.user.contact.Email;
import cz.kpsys.portaro.view.ViewableItemsTypedConverter;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class RecordCollectionConfig {
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final AllValuesProvider<Department> departmentLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> richRecordLoader;
    @NonNull
    private final AuthenticationSuccessMultipleListener interactiveAuthenticationSuccessEventListener;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final Provider<Department> currentDepartmentProvider;
    @NonNull
    private final Eventer eventer;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final ContactManager contactManager;
    @NonNull
    private final TemplateDescriptorLoader templateDescriptorLoader;
    @NonNull
    private final MailService mailService;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final ExemplarLoader exemplarLoader;
    @NonNull
    private final ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordParagraphItemsConverter;
    @NonNull
    private final ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordItemsWithoutExportsConverter;
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final ExporterResolver exporterResolver;
    @NonNull
    private final TemplateLoadingExportDescriptorLoader templateLoadingExportDescriptorLoader;
    @NonNull
    private final CsvFileRecordsExporter recordsCsvExporter;
    @NonNull
    private final XlsFileExporterByCsvExporter<List<Record>> documentsXlsExporter;
    @NonNull
    private final MultipleItemsExporterBySingleItemExporter<Record> documentsRisExporter;
    @NonNull
    private final Function<String, Exporter<List<Record>>> documentsDocExporterByPathLoader;
    @NonNull
    private final ContextualProvider<Department, LoanSetting> loanSettingProvider;
    @NonNull
    private final CompositeExportDescriptorLoader exportDescriptorLoader;
    @NonNull
    private final HierarchyLoader<Department> departmentAccessor;
    @NonNull
    private final AllByIdsLoadable<Event, UUID> eventLoader;
    @NonNull
    private final Eventer onlyCreatingEventer;
    @NonNull
    private final @NonNull ContextualProvider<Department, Converter<UUID, @NonNull String>> recordIdToRecordDetailUrlConverterProvider;

    @Bean
    public RecordCollectionsApiController recordCollectionApiController() {
        return new RecordCollectionsApiController(this.recordCollectionSearchableRepository(), this.recordCollectionItemSearchableRepository(), this.recordCollectionItemInserter(), this.recordCollectionItemRemover(), this.switchableDataSourceRecordCollectionItemEntitySearchLoader(), this.recordCollectionCreator(), this.recordCollectionRemover(), this.recordCollectionUpdater(), this.securitySearchParamsProvider(), this.toViewableRecordCollectionConverter(), this.recordCollectionPrivateCategoryProvider(), this.recordCollectionFavouritesCategoryProvider(), this.recordCollectionPublicCategoriesAllValuesProvider(), (ByIdLoadable)new ByIdLoadableByAllByIdsLoadable(this.eventLoader, Event.class), this.recordCollectionHierarchyTreeLoader(), this.recordCollectionItemBulkSaver(), this.recordsToViewableRecordItemsWithoutExportsConverter);
    }

    @Bean
    public RecordCollectionPageApiController recordCollectionPageApiController() {
        return new RecordCollectionPageApiController(this.mailService, this.templateEngine, this.translator, this.recordsByCollectionIdLoaderDepartmentedProvider(), this.exemplarLoader, this.recordsToViewableRecordParagraphItemsConverter, this.actionSaver, this.loanSettingProvider, (Provider)new FeatureEnabledProvider(this.featureManager, "exports"), (ExportDescriptorLoader)this.exportDescriptorLoader, this.recordIdToRecordDetailUrlConverterProvider);
    }

    @Bean
    IdAndIdsLoadable<RecordCollection, UUID> optimizedRecordCollectionLoader() {
        return new OptimizedRecordCollectionLoader(new RecordCollectionUserCollectionEntitiesByCollectionIdSearchLoader(this.jdbcTemplate, this.queryFactory), (AllByIdsLoadable)new AllByIdsLoadableByAllValuesProviderAdapter(this.departmentLoader), (AllByIdsLoadable)new AllByIdsLoadableByAllValuesProviderAdapter((AllValuesProvider)this.recordCollectionCategoryLoader()), (AllByIdsLoadable)this.basicUserLoader);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RecordCollection> optimizedRecordCollectionSearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.recordCollectionIdSearchLoader(), (AllByIdsLoadable)ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)this.optimizedRecordCollectionRepository()).withChunkSize(250)).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> recordCollectionIdSearchLoader() {
        SpringDbRecordCollectionIdSearchLoader modelIdSearchLoader = new SpringDbRecordCollectionIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelIdSearchLoader).build();
    }

    @Bean
    public Saver<RecordCollection, RecordCollection> recordCollectionSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new RecordCollectionToEntityConverter()).withClearedCacheName(RecordCollectionEntity.class.getSimpleName()).build();
    }

    @Bean
    public Deleter<RecordCollection> recordCollectionDeleter() {
        return this.modelBeanBuilder.hibernateHardDeleter(RecordCollectionEntity.class, (Converter)new RecordCollectionToEntityConverter()).build();
    }

    @Bean
    public ByIdsLoadableRepository<RecordCollection, UUID> optimizedRecordCollectionRepository() {
        CompositeRepository repository = new CompositeRepository(this.optimizedRecordCollectionLoader(), this.recordCollectionSaver(), this.recordCollectionDeleter());
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(15L)).maximumSize(4000L);
        return new CacheProxyRepository((ByIdsLoadableRepository)repository, cacheBuilder.build());
    }

    @Bean
    public SearchableRepository<MapBackedParams, RecordCollection, UUID> basicPersistentRecordCollectionSearchableRepository() {
        return new CompositeSearchableRepository(this.optimizedRecordCollectionRepository(), this.optimizedRecordCollectionSearchLoader());
    }

    @Bean
    public SearchableRepository<MapBackedParams, RecordCollection, UUID> persistentRecordCollectionSearchableRepository() {
        return new FirstItemCreatingSearchableRepository(this.basicPersistentRecordCollectionSearchableRepository(), (Provider)new PersistentFirstRecordCollectionProvider(this.recordCollectionCreator(), this.authenticationHolder, this.currentDepartmentProvider, this.translator, this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.recordCollectionFavouritesCategoryProvider()), (SearchParamsPredicate)new RecordCollectionFavouritesSearchPredicate(this.recordCollectionFavouritesCategoryProvider()));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RecordIdCollectionIdPair> recordCollectionIdByRecordIdSearchLoader() {
        SpringDbRecordCollectionIdByRecordIdSearchLoader modelIdSearchLoader = new SpringDbRecordCollectionIdByRecordIdSearchLoader(this.jdbcTemplate, this.queryFactory, this.recordCollectionPublicCategoriesAllValuesProvider());
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelIdSearchLoader).build();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public InMemoryRepository<RecordCollection, UUID> inMemoryRecordCollectionRepository() {
        return InMemoryRepository.ofIdentified();
    }

    @Bean
    public SearchableRepository<MapBackedParams, RecordCollection, UUID> inMemoryRecordCollectionSearchableRepository() {
        InMemoryRepository sourceRepo = this.inMemoryRecordCollectionRepository();
        ParameterizedSearchLoader sourceSearchLoader = this.modelBeanBuilder.searchLoader(MapBackedParams::createEmpty, (PageSearchLoader)new InMemoryRecordCollectionSearchLoader((AllValuesProvider)this.inMemoryRecordCollectionRepository())).build();
        return new FirstItemCreatingSearchableRepository((SearchableRepository)new CompositeSearchableRepository((ByIdsLoadableRepository)sourceRepo, sourceSearchLoader), (Provider)new InMemoryFirstRecordCollectionProvider(sourceRepo, this.authenticationHolder, this.currentDepartmentProvider, this.recordCollectionFavouritesCategoryProvider(), this.onlyCreatingEventer), (SearchParamsPredicate)new RecordCollectionFavouritesSearchPredicate(this.recordCollectionFavouritesCategoryProvider()));
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public SearchableRepository<MapBackedParams, RecordCollection, UUID> recordCollectionSearchableRepository() {
        SwitchableDataSourceSearchableRepository bean = new SwitchableDataSourceSearchableRepository((SearchableRepository)new CompositeSearchableRepository((ByIdsLoadableRepository)new PriorityDualRepository((ByIdsLoadableRepository)this.inMemoryRecordCollectionSearchableRepository(), (ByIdsLoadableRepository)this.basicPersistentRecordCollectionSearchableRepository()), (ParameterizedSearchLoader)new RecordCollectionDualSearchLoader((ParameterizedSearchLoader)this.inMemoryRecordCollectionSearchableRepository(), (ParameterizedSearchLoader)this.basicPersistentRecordCollectionSearchableRepository())), this.persistentRecordCollectionSearchableRepository(), () -> this.securityManager.can(RecordCollectionSecurityActions.FAVOURITES_PERSIST, this.authenticationHolder.getCurrentAuth(), (Department)this.currentDepartmentProvider.get()));
        if (bean.canBeSwitched()) {
            bean.switchToPermanentDataSource();
        } else {
            this.interactiveAuthenticationSuccessEventListener.registerListener(event -> bean.switchToPermanentDataSource());
        }
        return bean;
    }

    @Bean
    public IdAndIdsLoadable<RecordCollectionItem, UUID> recordCollectionItemLoader() {
        EntitiesToRecordCollectionItemsConverter entitiesToRecordCollectionItemsConverter = new EntitiesToRecordCollectionItemsConverter((AllByIdsLoadable)this.richRecordLoader);
        return this.modelBeanBuilder.allByIdsLoader(RecordCollectionItemEntity.class, (Converter)entitiesToRecordCollectionItemsConverter).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> recordCollectionItemIdSearchLoader() {
        SpringDbRecordCollectionItemIdSearchLoader modelIdSearchLoader = new SpringDbRecordCollectionItemIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelIdSearchLoader).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RecordCollectionItem> recordCollectionItemSearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.recordCollectionItemIdSearchLoader(), (AllByIdsLoadable)ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)this.recordCollectionItemLoader()).withChunkSize(250)).build();
    }

    @Bean
    public Saver<RecordCollectionItem, RecordCollectionItem> recordCollectionItemSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new RecordCollectionItemToEntityConverter()).withClearedCacheName(RecordCollectionItemEntity.class.getSimpleName()).build();
    }

    @Bean
    public Saver<List<RecordCollectionItem>, List<RecordCollectionItem>> persistentRecordCollectionItemBulkSaver() {
        return new BulkSaver(this.saverBuilderFactory.saver().intermediateConverting(BulkSaver.converter((Converter)new RecordCollectionItemToEntityConverter())).withClearedCacheName(RecordCollectionItemEntity.class.getSimpleName()).build());
    }

    @Bean
    public Deleter<RecordCollectionItem> recordCollectionItemDeleter() {
        return this.modelBeanBuilder.hibernateHardDeleter(RecordCollectionItemEntity.class, (Converter)new RecordCollectionItemToEntityConverter()).build();
    }

    @Bean
    public SearchableRepository<MapBackedParams, RecordCollectionItem, UUID> persistentRecordCollectionItemSearchableRepository() {
        return new CompositeSearchableRepository((ByIdsLoadableRepository)new CompositeRepository(this.recordCollectionItemLoader(), this.recordCollectionItemSaver(), this.recordCollectionItemDeleter()), this.recordCollectionItemSearchLoader());
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public AllProvidingRepository<RecordCollectionItem, UUID> inMemoryRecordCollectionItemRepository() {
        return new LimitedSizeRepository((AllProvidingRepository)InMemoryRepository.ofIdentified(), Integer.valueOf(50));
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public Saver<List<RecordCollectionItem>, List<RecordCollectionItem>> inMemoryRecordCollectionItemBulkSaver() {
        return new InMemoryBulkSaver((Saver)this.inMemoryRecordCollectionItemRepository());
    }

    private ParameterizedSearchLoader<MapBackedParams, RecordCollectionItem> inMemoryRecordCollectionItemSearchLoader() {
        return this.modelBeanBuilder.searchLoader(MapBackedParams::createEmpty, (PageSearchLoader)new InMemoryRecordCollectionItemSearchLoader((AllValuesProvider)this.inMemoryRecordCollectionItemRepository(), (Repository)this.inMemoryRecordCollectionRepository())).build();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public SearchableRepository<MapBackedParams, RecordCollectionItem, UUID> recordCollectionItemSearchableRepository() {
        SwitchableDataSourceSearchableRepository bean = new SwitchableDataSourceSearchableRepository((SearchableRepository)new CompositeSearchableRepository((ByIdsLoadableRepository)new PriorityDualRepository((ByIdsLoadableRepository)this.inMemoryRecordCollectionItemRepository(), (ByIdsLoadableRepository)this.persistentRecordCollectionItemSearchableRepository()), (ParameterizedSearchLoader)new RecordCollectionItemDualSearchLoader(this.inMemoryRecordCollectionItemSearchLoader(), (ParameterizedSearchLoader)this.persistentRecordCollectionItemSearchableRepository())), this.persistentRecordCollectionItemSearchableRepository(), () -> this.securityManager.can(RecordCollectionSecurityActions.FAVOURITES_PERSIST, this.authenticationHolder.getCurrentAuth(), (Department)this.currentDepartmentProvider.get()));
        RecordCollectionItemToPersistentStorageMover toPersistentStorageMover = new RecordCollectionItemToPersistentStorageMover(this.userFavouritesCollectionByUserLoader(), this.recordCollectionItemEntitySearchLoader(), this.recordCollectionItemOrderProvider(), this.authenticationHolder, this.inMemoryRecordCollectionItemSearchLoader(), (Deleter)this.inMemoryRecordCollectionItemRepository(), (Saver)this.persistentRecordCollectionItemSearchableRepository());
        if (bean.canBeSwitched()) {
            bean.switchToPermanentDataSource();
            toPersistentStorageMover.move();
        } else {
            this.interactiveAuthenticationSuccessEventListener.registerListener(event -> {
                bean.switchToPermanentDataSource();
                toPersistentStorageMover.move();
            });
        }
        return bean;
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    Saver<List<RecordCollectionItem>, List<RecordCollectionItem>> recordCollectionItemBulkSaver() {
        SwitchableDataSourceSaver bean = new SwitchableDataSourceSaver(this.inMemoryRecordCollectionItemBulkSaver(), this.persistentRecordCollectionItemBulkSaver(), () -> this.securityManager.can(RecordCollectionSecurityActions.FAVOURITES_PERSIST, this.authenticationHolder.getCurrentAuth(), (Department)this.currentDepartmentProvider.get()));
        if (bean.canBeSwitched()) {
            bean.switchToPermanentDataSource();
        } else {
            this.interactiveAuthenticationSuccessEventListener.registerListener(event -> bean.switchToPermanentDataSource());
        }
        return bean;
    }

    @Bean
    public IdAndIdsLoadable<RecordCollectionItemEntity, UUID> recordCollectionItemEntityLoader() {
        return this.modelBeanBuilder.allByIdsLoader(RecordCollectionItemEntity.class);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RecordCollectionItemEntity> recordCollectionItemEntitySearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.recordCollectionItemIdSearchLoader(), (AllByIdsLoadable)ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)this.recordCollectionItemEntityLoader()).withChunkSize(250)).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, RecordCollectionItemEntity> inMemoryRecordCollectionItemEntitySearchLoader() {
        ResultConvertingPageSearchLoader modelSearchLoader = new ResultConvertingPageSearchLoader((PageSearchLoader)new InMemoryRecordCollectionItemSearchLoader((AllValuesProvider)this.inMemoryRecordCollectionItemRepository(), (Repository)this.inMemoryRecordCollectionRepository()), (Converter)new ListToModifiedListExtendingConverter((Converter)new RecordCollectionItemToEntityConverter()));
        return this.modelBeanBuilder.searchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelSearchLoader).build();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public ParameterizedSearchLoader<MapBackedParams, RecordCollectionItemEntity> switchableDataSourceRecordCollectionItemEntitySearchLoader() {
        SwitchableDataSourceSearchLoader bean = new SwitchableDataSourceSearchLoader((ParameterizedSearchLoader)new RecordCollectionItemDualSearchLoader(this.inMemoryRecordCollectionItemEntitySearchLoader(), this.recordCollectionItemEntitySearchLoader()), this.recordCollectionItemEntitySearchLoader(), () -> this.securityManager.can(RecordCollectionSecurityActions.FAVOURITES_PERSIST, this.authenticationHolder.getCurrentAuth(), (Department)this.currentDepartmentProvider.get()));
        if (bean.canBeSwitched()) {
            bean.switchToPermanentDataSource();
        } else {
            this.interactiveAuthenticationSuccessEventListener.registerListener(event -> bean.switchToPermanentDataSource());
        }
        return bean;
    }

    @Bean
    public IdAndIdsLoadable<UserRecordCollection, UUID> userRecordCollectionLoader() {
        return this.modelBeanBuilder.allByIdsLoader(UserRecordCollectionEntity.class, (Converter)new EntitiesToUserRecordCollectionsConverter(this.basicUserLoader)).build();
    }

    @Bean
    public Saver<UserRecordCollection, UserRecordCollection> userRecordCollectionSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new UserRecordCollectionToEntityConverter()).withClearedCacheName(UserRecordCollectionEntity.class.getSimpleName()).build();
    }

    @Bean
    public Deleter<UserRecordCollection> userRecordCollectionDeleter() {
        return this.modelBeanBuilder.hibernateHardDeleter(UserRecordCollectionEntity.class, (Converter)new UserRecordCollectionToEntityConverter()).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UUID> userRecordCollectionIdSearchLoader() {
        SpringDbUserRecordCollectionIdSearchLoader modelIdSearchLoader = new SpringDbUserRecordCollectionIdSearchLoader(this.jdbcTemplate, this.queryFactory);
        return this.modelBeanBuilder.idSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)modelIdSearchLoader).build();
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, UserRecordCollection> userRecordCollectionSearchLoader() {
        return this.modelBeanBuilder.modelSearchLoaderByIdSearchLoader(MapBackedParams::createEmpty, (PageSearchLoader)this.userRecordCollectionIdSearchLoader(), (AllByIdsLoadable)ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)this.userRecordCollectionLoader()).withChunkSize(250)).build();
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
    public Eventer selectableEventer() {
        SelectableEventer bean = new SelectableEventer(this.onlyCreatingEventer, this.eventer);
        if (this.securityManager.can(RecordCollectionSecurityActions.FAVOURITES_PERSIST, this.authenticationHolder.getCurrentAuth(), (Department)this.currentDepartmentProvider.get())) {
            bean.selectSecondaryEventer();
        } else {
            this.interactiveAuthenticationSuccessEventListener.registerListener(event -> bean.selectSecondaryEventer());
        }
        return bean;
    }

    @Bean
    public ToViewableRecordCollectionConverter toViewableRecordCollectionConverter() {
        return new ToViewableRecordCollectionConverter(this.securityManager, (ParameterizedSearchLoader)this.recordCollectionSearchableRepository());
    }

    @Bean
    public RecordCollectionsIndexer recordCollectionsIndexer() {
        return new DefaultRecordCollectionsIndexer(this.recordCollectionIdByRecordIdSearchLoader());
    }

    @Bean
    public Codebook<RecordCollectionCategory, UUID> recordCollectionCategoryLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(RecordCollectionCategoryEntity.class).converted((Converter)new EntitiesToRecordCollectionCategoriesConverter()).staticCached(RecordCollectionCategory.class.getSimpleName()).build();
    }

    @Bean
    public Provider<RecordCollectionCategory> recordCollectionFavouritesCategoryProvider() {
        return ProviderByIdProvider.ofStaticId((ByIdLoadable)this.recordCollectionCategoryLoader(), (Object)RecordCollectionCategory.FAVOURITES_CATEGORY_ID);
    }

    @Bean
    public Provider<RecordCollectionCategory> recordCollectionPrivateCategoryProvider() {
        return ProviderByIdProvider.ofStaticId((ByIdLoadable)this.recordCollectionCategoryLoader(), (Object)RecordCollectionCategory.PRIVATE_CATEGORY_ID);
    }

    @Bean
    public AllValuesProvider<RecordCollectionCategory> recordCollectionPublicCategoriesAllValuesProvider() {
        return new FilteredAllValuesProvider((AllValuesProvider)this.recordCollectionCategoryLoader(), category -> !category.isFavouriteOrPrivateCategory());
    }

    @Bean
    public AllValuesProvider<RecordCollectionCategory> recordCollectionCategoryAllWithoutFavouritesProvider() {
        return new FilteredAllValuesProvider((AllValuesProvider)this.recordCollectionCategoryLoader(), category -> !category.isFavouritesCategory());
    }

    @Bean
    public AcceptableValuesResolver<RecordCollectionCreationRequest, RecordCollectionCategory> recordCollectionCreationRequestRecordCategoryProvider() {
        return new RecordCollectionCreationRequest.RecordCollectionCreationRequestRecordCategoryProvider(this.recordCollectionCategoryAllWithoutFavouritesProvider());
    }

    @Bean
    public AcceptableValuesResolver<RecordCollectionEditationRequest, RecordCollectionCategory> recordCollectionEditationRequestRecordCategoryProvider() {
        return new RecordCollectionEditationRequest.RecordCollectionEditationRequestRecordCategoryProvider(this.recordCollectionCategoryAllWithoutFavouritesProvider());
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<RecordCollectionCreationRequest> recordCollectionCreationRequestDefaulter() {
        return new RecordCollectionCreationRequest.RecordCollectionCreationRequestDefaulter(this.recordCollectionPrivateCategoryProvider());
    }

    @Bean
    public RecordCollectionItemOrderProvider recordCollectionItemOrderProvider() {
        return new RecordCollectionItemOrderProvider(this.switchableDataSourceRecordCollectionItemEntitySearchLoader());
    }

    @Bean
    RecordCollectionOrderProvider recordCollectionOrderProvider() {
        return new RecordCollectionOrderProvider((ParameterizedSearchLoader)this.basicPersistentRecordCollectionSearchableRepository());
    }

    @Bean
    public RecordCollectionItemInserter recordCollectionItemInserter() {
        return new RecordCollectionItemInserter(this.recordCollectionItemSearchableRepository(), this.recordCollectionItemOrderProvider(), (Repository)this.recordCollectionSearchableRepository(), this.selectableEventer());
    }

    @Bean
    public RecordCollectionItemRemover recordCollectionItemRemover() {
        return new RecordCollectionItemRemover(this.recordCollectionItemSearchableRepository(), (Repository)this.recordCollectionSearchableRepository(), this.selectableEventer());
    }

    @Bean
    public RecordCollectionsTreeMaxDepthGuard recordCollectionsTreeMaxDepthGuard() {
        return new RecordCollectionsTreeMaxDepthGuard((ByIdLoadable)this.basicPersistentRecordCollectionSearchableRepository());
    }

    @Bean
    RecordCollectionCreator recordCollectionCreator() {
        return new RecordCollectionCreator((Saver)this.basicPersistentRecordCollectionSearchableRepository(), this.userRecordCollectionSaver(), this.eventer, this.recordCollectionOrderProvider(), this.recordCollectionsTreeMaxDepthGuard());
    }

    @Bean
    RecordCollectionRemover recordCollectionRemover() {
        return new RecordCollectionRemover(this.persistentRecordCollectionSearchableRepository(), this.persistentRecordCollectionItemSearchableRepository(), this.userRecordCollectionDeleter(), this.userRecordCollectionSearchLoader());
    }

    @Bean
    RecordCollectionUpdater recordCollectionUpdater() {
        return new RecordCollectionUpdater(this.recordCollectionSearchableRepository(), this.recordCollectionOrderProvider(), this.recordCollectionsTreeMaxDepthGuard(), this.eventer);
    }

    @Bean
    public UserFavouritesCollectionByUserLoader userFavouritesCollectionByUserLoader() {
        return new UserFavouritesCollectionByUserLoader((ParameterizedSearchLoader)this.recordCollectionSearchableRepository(), this.recordCollectionFavouritesCategoryProvider());
    }

    @Bean
    public AuthenticatedAcceptableValuesResolver<RecordCollectionEditationRequest, RecordCollection> availableParentCollectionsByUserProvider() {
        return new RecordCollectionEditationRequest.AvailableParentCollectionsByUserProvider(this.recordCollectionCategoryAllWithoutFavouritesProvider(), this.recordCollectionSearchableRepository());
    }

    @Bean
    public AllValuesProvider<RecordCollection> insertableRecordCollectionsProvider() {
        return () -> {
            StaticParamsModifier userCollsParams = StaticParamsModifier.of((Property)RecordCollectionConstants.SearchParams.RECORD_COLLECTION_OWNER, List.of((Integer)this.authenticationHolder.getCurrentAuth().getActiveUser().getId()), (Property)RecordCollectionConstants.SearchParams.RECORD_COLLECTION_CATEGORY, (Object)this.recordCollectionCategoryAllWithoutFavouritesProvider().getAll());
            List usersCollections = this.recordCollectionSearchableRepository().getContent(RangePaging.forAll(), (Consumer)userCollsParams);
            StaticParamsModifier publicCollsParams = StaticParamsModifier.of((Property)RecordCollectionConstants.SearchParams.RECORD_COLLECTION_CATEGORY, (Object)this.recordCollectionPublicCategoriesAllValuesProvider().getAll());
            List publicCollections = this.recordCollectionSearchableRepository().getContent(RangePaging.forAll(), (Consumer)publicCollsParams);
            return ListUtil.filter((Collection)ListUtil.union((Collection[])new Collection[]{usersCollections, publicCollections}), collection -> this.securityManager.can(RecordCollectionSecurityActions.RECORD_COLLECTION_INSERT, this.authenticationHolder.getCurrentAuth(), (Department)this.currentDepartmentProvider.get(), collection));
        };
    }

    @Bean
    public Function<Record, List<RecordCollection>> insertableRecordCollectionsByRecordResolver() {
        return record -> {
            List allCollections = this.insertableRecordCollectionsProvider().getAll();
            StaticParamsModifier params = StaticParamsModifier.of((Property)RecordCollectionConstants.SearchParams.RECORD, List.of((UUID)record.getId()));
            List collectionsContainingRecord = this.recordCollectionSearchableRepository().getContent(RangePaging.forAll(), (Consumer)params);
            return ListUtil.removeAll((Collection)allCollections, (Collection)collectionsContainingRecord);
        };
    }

    @Bean
    public AllValuesProvider<RecordCollectionAcceptableEditorOption> recordCollectionsBulkInsertableCollectionsProvider() {
        return () -> {
            RecordCollectionsToTreeListConverter recordCollectionsToTreeListConverter = new RecordCollectionsToTreeListConverter();
            TreeListToRecordCollectionAcceptableEditorOptionsConverter treeListToRecordCollectionNodeConverter = new TreeListToRecordCollectionAcceptableEditorOptionsConverter();
            return treeListToRecordCollectionNodeConverter.convert(recordCollectionsToTreeListConverter.convert(this.insertableRecordCollectionsProvider().getAll()));
        };
    }

    @Bean
    public AcceptableValuesResolver<RecordCollectionInsertRequest, RecordCollectionAcceptableEditorOption> recordCollectionsSingleRecordInsertableCollectionsResolver() {
        return (request, ctx) -> {
            RecordCollectionsToTreeListConverter recordCollectionsToTreeListConverter = new RecordCollectionsToTreeListConverter();
            TreeListToRecordCollectionAcceptableEditorOptionsConverter treeListToRecordCollectionNodeConverter = new TreeListToRecordCollectionAcceptableEditorOptionsConverter();
            return treeListToRecordCollectionNodeConverter.convert(recordCollectionsToTreeListConverter.convert((List)this.insertableRecordCollectionsByRecordResolver().apply(request.record())));
        };
    }

    @Bean
    public RecordCollectionContainQuery recordCollectionPersistentStorageContainQuery() {
        return new DefaultRecordCollectionContainQuery((ParameterizedSearchLoader)this.persistentRecordCollectionSearchableRepository());
    }

    @Bean
    public RecordCollectionHierarchyTreeLoader recordCollectionHierarchyTreeLoader() {
        return new RecordCollectionHierarchyTreeLoader(this.recordCollectionSearchableRepository(), this.securitySearchParamsProvider(), this.recordCollectionPrivateCategoryProvider(), this.recordCollectionPublicCategoriesAllValuesProvider());
    }

    @Bean
    public ContextualProvider<Department, ByIdLoadable<List<Record>, UUID>> recordsByCollectionIdLoaderDepartmentedProvider() {
        return department -> collectionId -> {
            StaticParamsModifier params = StaticParamsModifier.of((Property)RecordCollectionConstants.SearchParams.RECORD_COLLECTION_ANCESTOR, (Object)collectionId, (Property)RecordCollectionConstants.SearchParams.SHOWABLE_RECORD_COLLECTIONS_SEARCH_PARAMETER, (Object)((ShowableRecordCollectionsSearchParameter)this.securitySearchParamsProvider().getParameter((Property)RecordCollectionConstants.SearchParams.SHOWABLE_RECORD_COLLECTIONS_SEARCH_PARAMETER).create((BasicUser)this.authenticationHolder.getCurrentAuth().getActiveUser(), department, List.of((RecordCollectionCategory)this.recordCollectionPrivateCategoryProvider().get(), (RecordCollectionCategory)this.recordCollectionFavouritesCategoryProvider().get()), this.recordCollectionPublicCategoriesAllValuesProvider().getAll())));
            List collectionItems = this.recordCollectionItemSearchableRepository().getContent(RangePaging.forAll(), (Consumer)params);
            return ListUtil.convert((Iterable)collectionItems, RecordCollectionItem::getRecord);
        };
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<RecordCollectionTemplatedBodyMailSendRequest> recordCollectionTemplatedBodyMailSendRequestDefaulter() {
        return (formObject, department, currentAuth) -> {
            AuthableUser activeUser;
            Optional<String> email;
            if (formObject.recipientEmail() == null && (email = this.contactManager.getEmail((BasicUser)(activeUser = currentAuth.getActiveUser())).map(Email::value)).isPresent()) {
                formObject = formObject.withRecipientEmail(email.get());
            }
            if (formObject.subject() == null) {
                Locale locale = (Locale)this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE).getOn((Object)department);
                formObject = formObject.withSubject(Texts.ofMessageCoded((String)"recordCollections.recordCollectionMailSubject").localize(this.translator, (Object)department, locale));
            }
            if (formObject.template() == null) {
                formObject = formObject.withTemplate(Templates.TEMPLATE_RECORD_COLLECTION_MAIL);
            }
            return formObject;
        };
    }

    @Bean
    public AcceptableValuesResolver<RecordCollectionTemplatedBodyMailSendRequest, TemplateDescriptor> recordCollectionTemplatedBodyMailSendRequestAcceptableTemplatesResolver() {
        return (request, ctx) -> this.templateDescriptorLoader.getAllByType(Templates.TEMPLATE_RECORD_COLLECTION_MAIL.getType());
    }

    @Bean
    SecuritySearchParamsProvider securitySearchParamsProvider() {
        return new SecuritySearchParamsProvider();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForUuidId(RecordCollection.class, (ByIdLoadable)this.recordCollectionSearchableRepository());
        this.converterRegisterer.registerForUuidId(RecordCollectionItem.class, (ByIdLoadable)this.recordCollectionItemSearchableRepository());
        this.converterRegisterer.registerForUuidId(RecordCollectionCategory.class, (ByIdLoadable)this.recordCollectionCategoryLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        ContextualProvider departmentWithSubdepartments = ctx -> this.departmentAccessor.getAllByScope(ctx, HierarchyLoadScope.SUBTREE);
        ContextualProvider departmentsDepartmentFamily = ctx -> this.departmentAccessor.getAllByScope(ctx, HierarchyLoadScope.FAMILY);
        Function<RecordCollection, Boolean> isPublicCollection = recordCollection -> !recordCollection.getRecordCollectionCategory().isFavouriteOrPrivateCategory();
        BiFunction<BasicUser, RecordCollection, Boolean> isOwnerOfCollection = (user, recordCollection) -> recordCollection.getOwner().equals(user);
        this.permissionRegistry.add(RecordCollectionSecurityActions.RECORD_COLLECTIONS_SHOW_USERS_COLLECTIONS, this.permissionFactory.currentIsSubjectUser());
        this.permissionRegistry.add(RecordCollectionSecurityActions.RECORD_COLLECTION_CREATE_SUBCOLLECTION, (auth, ctx, recordCollection) -> {
            PermissionResult edit = this.permissionFactory.edit().can(auth, ctx, null);
            if (edit.forbidden()) {
                return edit;
            }
            if (((Boolean)isOwnerOfCollection.apply((BasicUser)auth.getActiveUser(), (RecordCollection)recordCollection)).booleanValue() && ctx.equals((Object)recordCollection.getDepartment())) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.permissionRegistry.add(RecordCollectionSecurityActions.RECORD_COLLECTION_CREATE, (auth, ctx, creationRequest) -> {
            if (!auth.getActiveUser().equals((Object)creationRequest.creator())) {
                return PermissionResult.cannot((UserAuthentication)auth);
            }
            PermissionResult edit = this.permissionFactory.edit().can(auth, ctx, null);
            if (edit.forbidden()) {
                return PermissionResult.cannot((UserAuthentication)auth);
            }
            if (!((List)departmentWithSubdepartments.getOn((Object)ctx)).contains(creationRequest.department())) {
                return PermissionResult.cannot((UserAuthentication)auth);
            }
            if (Optional.ofNullable(creationRequest.parentCollection()).map(parentCollection -> (Boolean)isOwnerOfCollection.apply(creationRequest.creator(), (RecordCollection)parentCollection) != false && creationRequest.department().equals((Object)parentCollection.getDepartment())).orElse(true).booleanValue()) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.permissionRegistry.add(RecordCollectionSecurityActions.RECORD_COLLECTION_SHOW_CONTENT, (auth, ctx, recordCollection) -> {
            if (((Boolean)isPublicCollection.apply((RecordCollection)recordCollection)).booleanValue() && ((List)departmentsDepartmentFamily.getOn((Object)ctx)).contains(recordCollection.getDepartment())) {
                return PermissionResult.allow();
            }
            if (((Boolean)isOwnerOfCollection.apply((BasicUser)auth.getActiveUser(), (RecordCollection)recordCollection)).booleanValue() && ((List)departmentsDepartmentFamily.getOn((Object)ctx)).contains(recordCollection.getDepartment())) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.securitySearchParamsProvider().register((Property)RecordCollectionConstants.SearchParams.SHOWABLE_RECORD_COLLECTIONS_SEARCH_PARAMETER, (user, department, privateCategories, publicCategories) -> new ShowableRecordCollectionsSearchParameter(user, ListUtil.requireNotEmpty((List)privateCategories), ListUtil.requireNotEmpty((List)publicCategories), (List)departmentsDepartmentFamily.getOn((Object)department)));
        this.permissionRegistry.add(RecordCollectionSecurityActions.RECORD_COLLECTION_INSERT, (auth, ctx, recordCollection) -> {
            if (!((Boolean)isPublicCollection.apply((RecordCollection)recordCollection)).booleanValue() && ((Boolean)isOwnerOfCollection.apply((BasicUser)auth.getActiveUser(), (RecordCollection)recordCollection)).booleanValue()) {
                return PermissionResult.allow();
            }
            if (((List)departmentWithSubdepartments.getOn((Object)ctx)).contains(recordCollection.getDepartment()) && (((Boolean)isOwnerOfCollection.apply((BasicUser)auth.getActiveUser(), (RecordCollection)recordCollection)).booleanValue() || this.permissionFactory.edit().can(auth, ctx, null).allowed())) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.permissionRegistry.add(RecordCollectionSecurityActions.RECORD_COLLECTION_EDIT, (auth, ctx, recordCollection) -> {
            if (((Boolean)isPublicCollection.apply((RecordCollection)recordCollection)).booleanValue() && this.permissionFactory.edit().can(auth, ctx, null).allowed() && ((List)departmentWithSubdepartments.getOn((Object)ctx)).contains(recordCollection.getDepartment())) {
                return PermissionResult.allow();
            }
            if (((Boolean)isOwnerOfCollection.apply((BasicUser)auth.getActiveUser(), (RecordCollection)recordCollection)).booleanValue()) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.permissionRegistry.add(RecordCollectionSecurityActions.RECORD_COLLECTION_DELETE, (auth, ctx, recordCollection) -> {
            if (((Boolean)isPublicCollection.apply((RecordCollection)recordCollection)).booleanValue() && auth.getRole().contains("ROLE_ADMIN") && ((List)departmentWithSubdepartments.getOn((Object)ctx)).contains(recordCollection.getDepartment())) {
                return PermissionResult.allow();
            }
            List recordCollectionsToBeRemoved = this.recordCollectionSearchableRepository().getContent(RangePaging.forAll(), (Consumer)StaticParamsModifier.of((Property)RecordCollectionConstants.SearchParams.RECORD_COLLECTION_ANCESTOR, (Object)recordCollection.getId()));
            if (recordCollectionsToBeRemoved.stream().allMatch(collection -> (Boolean)isOwnerOfCollection.apply((BasicUser)auth.getActiveUser(), (RecordCollection)collection))) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.permissionRegistry.add(RecordCollectionSecurityActions.RECORD_COLLECTION_SUBTREE_DELETE, (auth, ctx, subtree) -> {
            if (subtree.getRecordCollections().stream().allMatch(collection -> (Boolean)isPublicCollection.apply((RecordCollection)collection) != false && auth.getRole().contains("ROLE_ADMIN") && ((List)departmentWithSubdepartments.getOn((Object)ctx)).contains(collection.getDepartment()) || (Boolean)isOwnerOfCollection.apply((BasicUser)auth.getActiveUser(), (RecordCollection)collection) != false)) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.permissionRegistry.add(RecordCollectionSecurityActions.FAVOURITES_PERSIST, (auth, ctx, unused) -> {
            if (auth.getActiveUser().isEvided()) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.permissionRegistry.add(RecordCollectionSecurityActions.COLLECTIONS_INSERT_RECORD, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, record) -> !record.isDeleted() ? PermissionResult.allow() : PermissionResult.pointless((Text)Texts.ofNative((String)"Record is deleted")), this.permissionFactory.edit()}));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
        if (this.featureManager.isEnabled("exports")) {
            Function<String, Exporter> printRecordCollectionExporterByPathLoader = templatePath -> new RecordCollectionTemplatedExporter("records.html", (TemplateDescriptor)BasicTemplateDescriptor.parse((String)templatePath), this.templateEngine, this.translator, this.recordsByCollectionIdLoaderDepartmentedProvider(), this.recordIdToRecordDetailUrlConverterProvider, this.recordsToViewableRecordParagraphItemsConverter);
            this.exporterResolver.addFactory("record-collection-records-print:", (Function)new PrefixRemovingStringToEConverter("record-collection-records-print:", printRecordCollectionExporterByPathLoader));
            RecordCollectionAdapterExporter recordCollectionCsvExporter = new RecordCollectionAdapterExporter((Exporter)this.recordsCsvExporter, this.recordsByCollectionIdLoaderDepartmentedProvider());
            this.exporterResolver.addStatic("record-collection-records-csv:", (Exporter)recordCollectionCsvExporter);
            RecordCollectionAdapterExporter recordCollectionXlsExporter = new RecordCollectionAdapterExporter((Exporter)this.documentsXlsExporter, this.recordsByCollectionIdLoaderDepartmentedProvider());
            this.exporterResolver.addStatic("record-collection-records-xls:", (Exporter)recordCollectionXlsExporter);
            Function<String, Exporter> recordCollectionDocExporterByPathLoader = templatePath -> new RecordCollectionAdapterExporter((Exporter)this.documentsDocExporterByPathLoader.apply(templatePath), this.recordsByCollectionIdLoaderDepartmentedProvider());
            this.exporterResolver.addFactory("record-collection-records-doc:", (Function)new PrefixRemovingStringToEConverter("record-collection-records-doc:", recordCollectionDocExporterByPathLoader));
            RecordCollectionAdapterExporter recordCollectionRisExporterByPathLoader = new RecordCollectionAdapterExporter((Exporter)this.documentsRisExporter, this.recordsByCollectionIdLoaderDepartmentedProvider());
            this.exporterResolver.addStatic("record-collection-records-ris:", (Exporter)recordCollectionRisExporterByPathLoader);
        }
        this.templateLoadingExportDescriptorLoader.registerTemplated(List.of("record-collection-records", "html", "print"), "record-collection-records-print:", Templates.TEMPLATE_RECORD_COLLECTION_PRINT.getType()).registerTemplated(List.of("record-collection-records", "csv", "download"), "record-collection-records-csv:", Templates.TEMPLATE_RECORDS_CSV.getType(), Texts.ofMessageCoded((String)"export.CsvButton")).registerTemplated(List.of("record-collection-records", "xls", "download"), "record-collection-records-xls:", Templates.TEMPLATE_RECORDS_CSV.getType(), Texts.ofMessageCoded((String)"export.XlsButton")).registerTemplated(List.of("record-collection-records", "doc", "download"), "record-collection-records-doc:", Templates.TEMPLATE_DOCUMENTS_DOC.getType(), Texts.ofMessageCoded((String)"export.DocButton")).registerTemplated(List.of("record-collection-records", "ris", "download"), "record-collection-records-ris:", Templates.TEMPLATE_DOCUMENT_RIS.getType(), Texts.ofMessageCoded((String)"export.RisButton"));
    }

    @ConstructorProperties(value={"converterRegisterer", "jdbcTemplate", "queryFactory", "saverBuilderFactory", "modelBeanBuilder", "codebookLoaderBuilderFactory", "settingLoader", "basicUserLoader", "departmentLoader", "richRecordLoader", "interactiveAuthenticationSuccessEventListener", "securityManager", "authenticationHolder", "currentDepartmentProvider", "eventer", "permissionRegistry", "permissionFactory", "actionSaver", "translator", "contactManager", "templateDescriptorLoader", "mailService", "templateEngine", "exemplarLoader", "recordsToViewableRecordParagraphItemsConverter", "recordsToViewableRecordItemsWithoutExportsConverter", "featureManager", "exporterResolver", "templateLoadingExportDescriptorLoader", "recordsCsvExporter", "documentsXlsExporter", "documentsRisExporter", "documentsDocExporterByPathLoader", "loanSettingProvider", "exportDescriptorLoader", "departmentAccessor", "eventLoader", "onlyCreatingEventer", "recordIdToRecordDetailUrlConverterProvider"})
    @Generated
    public RecordCollectionConfig(@NonNull ConverterRegisterer converterRegisterer, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SettingLoader settingLoader, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull AllValuesProvider<Department> departmentLoader, @NonNull IdAndIdsLoadable<Record, UUID> richRecordLoader, @NonNull AuthenticationSuccessMultipleListener interactiveAuthenticationSuccessEventListener, @NonNull SecurityManager securityManager, @NonNull AuthenticationHolder authenticationHolder, @NonNull Provider<Department> currentDepartmentProvider, @NonNull Eventer eventer, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull ActionSaver actionSaver, @NonNull Translator<Department> translator, @NonNull ContactManager contactManager, @NonNull TemplateDescriptorLoader templateDescriptorLoader, @NonNull MailService mailService, @NonNull TemplateEngine templateEngine, @NonNull ExemplarLoader exemplarLoader, @NonNull ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordParagraphItemsConverter, @NonNull ViewableItemsTypedConverter<Record, ViewableRecord> recordsToViewableRecordItemsWithoutExportsConverter, @NonNull FeatureManager featureManager, @NonNull ExporterResolver exporterResolver, @NonNull TemplateLoadingExportDescriptorLoader templateLoadingExportDescriptorLoader, @NonNull CsvFileRecordsExporter recordsCsvExporter, @NonNull XlsFileExporterByCsvExporter<List<Record>> documentsXlsExporter, @NonNull MultipleItemsExporterBySingleItemExporter<Record> documentsRisExporter, @NonNull Function<String, Exporter<List<Record>>> documentsDocExporterByPathLoader, @NonNull ContextualProvider<Department, LoanSetting> loanSettingProvider, @NonNull CompositeExportDescriptorLoader exportDescriptorLoader, @NonNull HierarchyLoader<Department> departmentAccessor, @NonNull AllByIdsLoadable<Event, UUID> eventLoader, @NonNull Eventer onlyCreatingEventer, @NonNull @NonNull ContextualProvider<Department, Converter<UUID, @NonNull String>> recordIdToRecordDetailUrlConverterProvider) {
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(interactiveAuthenticationSuccessEventListener, "interactiveAuthenticationSuccessEventListener is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(currentDepartmentProvider, "currentDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(eventer, "eventer is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(contactManager, "contactManager is marked non-null but is null");
        Objects.requireNonNull(templateDescriptorLoader, "templateDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(mailService, "mailService is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(exemplarLoader, "exemplarLoader is marked non-null but is null");
        Objects.requireNonNull(recordsToViewableRecordParagraphItemsConverter, "recordsToViewableRecordParagraphItemsConverter is marked non-null but is null");
        Objects.requireNonNull(recordsToViewableRecordItemsWithoutExportsConverter, "recordsToViewableRecordItemsWithoutExportsConverter is marked non-null but is null");
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(exporterResolver, "exporterResolver is marked non-null but is null");
        Objects.requireNonNull(templateLoadingExportDescriptorLoader, "templateLoadingExportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(recordsCsvExporter, "recordsCsvExporter is marked non-null but is null");
        Objects.requireNonNull(documentsXlsExporter, "documentsXlsExporter is marked non-null but is null");
        Objects.requireNonNull(documentsRisExporter, "documentsRisExporter is marked non-null but is null");
        Objects.requireNonNull(documentsDocExporterByPathLoader, "documentsDocExporterByPathLoader is marked non-null but is null");
        Objects.requireNonNull(loanSettingProvider, "loanSettingProvider is marked non-null but is null");
        Objects.requireNonNull(exportDescriptorLoader, "exportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(eventLoader, "eventLoader is marked non-null but is null");
        Objects.requireNonNull(onlyCreatingEventer, "onlyCreatingEventer is marked non-null but is null");
        Objects.requireNonNull(recordIdToRecordDetailUrlConverterProvider, "recordIdToRecordDetailUrlConverterProvider is marked non-null but is null");
        this.converterRegisterer = converterRegisterer;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.settingLoader = settingLoader;
        this.basicUserLoader = basicUserLoader;
        this.departmentLoader = departmentLoader;
        this.richRecordLoader = richRecordLoader;
        this.interactiveAuthenticationSuccessEventListener = interactiveAuthenticationSuccessEventListener;
        this.securityManager = securityManager;
        this.authenticationHolder = authenticationHolder;
        this.currentDepartmentProvider = currentDepartmentProvider;
        this.eventer = eventer;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.actionSaver = actionSaver;
        this.translator = translator;
        this.contactManager = contactManager;
        this.templateDescriptorLoader = templateDescriptorLoader;
        this.mailService = mailService;
        this.templateEngine = templateEngine;
        this.exemplarLoader = exemplarLoader;
        this.recordsToViewableRecordParagraphItemsConverter = recordsToViewableRecordParagraphItemsConverter;
        this.recordsToViewableRecordItemsWithoutExportsConverter = recordsToViewableRecordItemsWithoutExportsConverter;
        this.featureManager = featureManager;
        this.exporterResolver = exporterResolver;
        this.templateLoadingExportDescriptorLoader = templateLoadingExportDescriptorLoader;
        this.recordsCsvExporter = recordsCsvExporter;
        this.documentsXlsExporter = documentsXlsExporter;
        this.documentsRisExporter = documentsRisExporter;
        this.documentsDocExporterByPathLoader = documentsDocExporterByPathLoader;
        this.loanSettingProvider = loanSettingProvider;
        this.exportDescriptorLoader = exportDescriptorLoader;
        this.departmentAccessor = departmentAccessor;
        this.eventLoader = eventLoader;
        this.onlyCreatingEventer = onlyCreatingEventer;
        this.recordIdToRecordDetailUrlConverterProvider = recordIdToRecordDetailUrlConverterProvider;
    }
}

