/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.action.ActionSaver;
import cz.kpsys.portaro.auth.context.AuthenticatedContextualProvider;
import cz.kpsys.portaro.auth.context.TypedAuthenticatedContextualObjectModifier;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.business.update.SubjectClassDispatchingSubjectUpdater;
import cz.kpsys.portaro.business.update.SubjectUpdater;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.ProviderByIdProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.GenericHookableSaver;
import cz.kpsys.portaro.commons.object.repo.HookableSaver;
import cz.kpsys.portaro.commons.object.repo.PostConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.conversation.ActionRequestUrlGenerator;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.HierarchicalDepartment;
import cz.kpsys.portaro.department.HierarchicalDepartmentLoaderByDepartmentLoader;
import cz.kpsys.portaro.finance.AmountType;
import cz.kpsys.portaro.finance.AmountTypeEntity;
import cz.kpsys.portaro.finance.AmountTypeLoader;
import cz.kpsys.portaro.finance.CodebookBackedAmountTypeLoader;
import cz.kpsys.portaro.finance.EntityToAmountTypeConverter;
import cz.kpsys.portaro.form.conversation.SubmittingFormPackage;
import cz.kpsys.portaro.formconfig.valueeditor.AcceptableValueResolver;
import cz.kpsys.portaro.formconfig.valueeditor.AuthenticatedAcceptableValuesResolver;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.payment.CreditBalanceDebtHandler;
import cz.kpsys.portaro.payment.DepartmentedTypedUserAmount;
import cz.kpsys.portaro.payment.DepartmentedUserTypedBilanceEntity;
import cz.kpsys.portaro.payment.EntityListToDepartmentedTypedUserAmountListConverter;
import cz.kpsys.portaro.payment.Payment;
import cz.kpsys.portaro.payment.PaymentBasicCreator;
import cz.kpsys.portaro.payment.PaymentEntity;
import cz.kpsys.portaro.payment.PaymentFromEntityConverter;
import cz.kpsys.portaro.payment.PaymentItem;
import cz.kpsys.portaro.payment.PaymentItemEntity;
import cz.kpsys.portaro.payment.PaymentItemsCreator;
import cz.kpsys.portaro.payment.PaymentItemsFromPaymentItemEntitiesConverter;
import cz.kpsys.portaro.payment.PaymentItemsToPaymentItemEntitiesConverter;
import cz.kpsys.portaro.payment.PaymentProvider;
import cz.kpsys.portaro.payment.PaymentProviderOwnerPair;
import cz.kpsys.portaro.payment.PaymentSecurityActions;
import cz.kpsys.portaro.payment.PaymentService;
import cz.kpsys.portaro.payment.PaymentSettingKeys;
import cz.kpsys.portaro.payment.PaymentToEntityConverter;
import cz.kpsys.portaro.payment.PaymentUtil;
import cz.kpsys.portaro.payment.SecuredPaymentService;
import cz.kpsys.portaro.payment.SpringDbPaymentSearchLoader;
import cz.kpsys.portaro.payment.SpringDbTransactionLoader;
import cz.kpsys.portaro.payment.SpringDbTypedUserBilanceEntitySearchLoader;
import cz.kpsys.portaro.payment.SwitchableHierarchyBilanceSearchLoader;
import cz.kpsys.portaro.payment.SwitchableHierarchyTransactionLoader;
import cz.kpsys.portaro.payment.Transaction;
import cz.kpsys.portaro.payment.TransactionCreator;
import cz.kpsys.portaro.payment.TransactionDeleter;
import cz.kpsys.portaro.payment.TransactionEntity;
import cz.kpsys.portaro.payment.TransactionEntityListToTransactionListConverter;
import cz.kpsys.portaro.payment.TransactionEntityRowMapper;
import cz.kpsys.portaro.payment.TransactionListToEntityListConverter;
import cz.kpsys.portaro.payment.TransactionLoader;
import cz.kpsys.portaro.payment.TransactionsRefunder;
import cz.kpsys.portaro.payment.TypedUserAmount;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ParametersConvertingPageSearchLoader;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.search.TransactionalPageSearchLoader;
import cz.kpsys.portaro.security.FlattingAndingPermissionResolver;
import cz.kpsys.portaro.security.MappingPermissionResolver;
import cz.kpsys.portaro.security.NullSubjectForwardingPermissionResolver;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.payment.provider.DispatchingPaymentLoader;
import cz.kpsys.portaro.user.payment.provider.DispatchingPaymentService;
import cz.kpsys.portaro.user.payment.provider.PaymentItemLoader;
import cz.kpsys.portaro.user.payment.provider.PaymentItemRowMapper;
import cz.kpsys.portaro.user.payment.provider.PaymentLoader;
import cz.kpsys.portaro.user.payment.provider.PaymentLoaderProvider;
import cz.kpsys.portaro.user.payment.provider.PaymentProviderSettingKeys;
import cz.kpsys.portaro.user.payment.provider.PaymentRowMapper;
import cz.kpsys.portaro.user.payment.provider.PaymentServiceRegistrar;
import cz.kpsys.portaro.user.payment.provider.PaymentSplitterService;
import cz.kpsys.portaro.user.payment.provider.PaymentWithTransactionsSaver;
import cz.kpsys.portaro.user.payment.provider.PendingPaymentsUpdater;
import cz.kpsys.portaro.user.payment.provider.SearchingPendingPaymentsUpdater;
import cz.kpsys.portaro.user.payment.provider.SpringDbPaymentItemLoader;
import cz.kpsys.portaro.user.payment.provider.SpringDbPaymentLoader;
import cz.kpsys.portaro.user.payment.provider.manual.BasicPaymentSavingPaymentService;
import cz.kpsys.portaro.user.payment.provider.manual.ManualPaymentProviderSettingKeys;
import cz.kpsys.portaro.user.relation.UserRelationsHelper;
import cz.kpsys.portaro.view.web.page.PaymentPrintPageController;
import cz.kpsys.portaro.view.web.page.PrintReceiptOfPaymentRequest;
import cz.kpsys.portaro.view.web.rest.finance.AmountTypeApiController;
import cz.kpsys.portaro.view.web.rest.finance.CreditTransferRequest;
import cz.kpsys.portaro.view.web.rest.finance.TransactionApiController;
import cz.kpsys.portaro.view.web.rest.finance.TransactionsPrintRequest;
import cz.kpsys.portaro.view.web.rest.finance.TransationPrintApiController;
import cz.kpsys.portaro.view.web.rest.payment.PayApiController;
import cz.kpsys.portaro.view.web.rest.payment.PayRequest;
import cz.kpsys.portaro.view.web.rest.payment.PayRequestAllowedDepartmentsResolver;
import cz.kpsys.portaro.view.web.rest.payment.PayRequestDefaulter;
import cz.kpsys.portaro.view.web.rest.payment.PayRequestFormSubmitPackageModifier;
import cz.kpsys.portaro.view.web.rest.payment.PaymentAmountsCalculator;
import cz.kpsys.portaro.view.web.rest.payment.PaymentApiController;
import cz.kpsys.portaro.web.page.ModelAndPageViewFactory;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class PaymentConfig {
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ByIdLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final AllByIdsLoadable<BasicUser, Integer> basicUsersLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final @NonNull Provider<@NonNull User> portaroUserProvider;
    @NonNull
    private final HierarchicalDepartmentLoaderByDepartmentLoader hierarchicalDepartmentLoaderByDepartmentLoader;
    @NonNull
    private final ActionRequestUrlGenerator actionRequestUrlGenerator;
    @NonNull
    private final @NonNull Provider<@NonNull Department> rootDepartmentProvider;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final UserRelationsHelper userRelationsHelper;
    @NonNull
    private final ModelAndPageViewFactory modelAndPageViewFactory;
    @NonNull
    private final AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final Runnable saveTransactionAuthenticator;
    @NonNull
    private final TransactionTemplateFactory readonlyTransactionTemplateFactory;
    @NonNull
    private final DatabaseProperties databaseProperties;

    @Bean
    public PayApiController payApiController() {
        return new PayApiController(this.actionSaver, this.paymentService(), this.portaroUserProvider, this.actionRequestUrlGenerator, this.transactionCreator(), this.creditBalanceDebtHandler());
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<SubmittingFormPackage<PayRequest>> payRequestFormSubmitPackageModifier() {
        return new PayRequestFormSubmitPackageModifier(this.creditPaymentEnabledProvider());
    }

    @Bean
    public AuthenticatedAcceptableValuesResolver<PayRequest, Department> payRequestAllowedDepartmentsResolver() {
        return new PayRequestAllowedDepartmentsResolver(this.editableDepartmentsAuthenticatedContextualProvider);
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<PayRequest> payRequestDefaulter() {
        return new PayRequestDefaulter(this.paymentAmountsCalculator(), this.payRequestAllowedDepartmentsResolver());
    }

    @Bean
    public PaymentAmountsCalculator paymentAmountsCalculator() {
        return new PaymentAmountsCalculator(this.typedUserBilanceSearchLoader(), (HierarchyLoader)this.departmentAccessor, this.settingLoader.getDepartmentedProvider(PaymentProviderSettingKeys.FORBIDDEN_GATEWAY_PAYMENT_TYPES), (AllValuesProvider)this.amountTypeLoader(), this.userRelationsHelper);
    }

    @Bean
    public Converter<List<DepartmentedUserTypedBilanceEntity>, List<? extends DepartmentedTypedUserAmount>> entityListToDepartmentedTypedUserAmountListConverter() {
        return new EntityListToDepartmentedTypedUserAmountListConverter(this.departmentLoader, this.basicUsersLoader, (ByIdLoadable)this.amountTypeLoader());
    }

    @Bean
    public PaymentApiController paymentApiController() {
        return new PaymentApiController(this.concretePaymentLoader(), (SubjectUpdater)this.paymentUpdater(), (PendingPaymentsUpdater)this.pendingPaymentsUpdater());
    }

    @Bean
    public TransationPrintApiController transationPrintApiController() {
        return new TransationPrintApiController(this.publicContextPath);
    }

    @Bean
    public AcceptableValueResolver<TransactionsPrintRequest, HierarchicalDepartment> transactionsPrintAllowedParentDepartmentResolver() {
        return new TransactionsPrintRequest.TransactionsPrintAllowedParentDepartmentResolver(this.hierarchicalDepartmentLoaderByDepartmentLoader);
    }

    @Bean
    public AuthenticatedAcceptableValuesResolver<CreditTransferRequest, AmountType> creditTransferSourceTypeResolver() {
        return new CreditTransferRequest.CreditTransferSourceTypeResolver(this.amountTypeLoader(), this.typedUserBilanceSearchLoader());
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<CreditTransferRequest> creditTransferRequestDefaulter() {
        return new CreditTransferRequest.CreditTransferRequestDefaulter(this.creditTransferSourceTypeResolver());
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<TransactionsPrintRequest> transactionsPrintRequestDefaulter() {
        return new TransactionsPrintRequest.TransactionsPrintRequestDefaulter((HierarchyLoader)this.departmentAccessor);
    }

    @Bean
    public PaymentPrintPageController paymentPrintPageController() {
        return new PaymentPrintPageController(this.templateEngine, this.transactionLoader(), this.departmentAccessor, this.currentAuthEditableDepartmentsLoader, this.modelAndPageViewFactory);
    }

    @Bean
    public TypedAuthenticatedContextualObjectModifier<PrintReceiptOfPaymentRequest> printReceiptOfPaymentRequestDefaulter() {
        return new PrintReceiptOfPaymentRequest.PrintReceiptOfPaymentRequestDefaulter();
    }

    @Bean
    public TransactionApiController transactionApiController() {
        return new TransactionApiController(this.transactionLoader(), (HierarchyLoader)this.departmentAccessor, this.transactionsDeleter());
    }

    @Bean
    public CreditBalanceDebtHandler creditBalanceDebtHandler() {
        return new CreditBalanceDebtHandler(this.transactionLoader(), this.transactionCreator(), this.portaroUserProvider, this.defaultTransactionTemplateFactory.get(), this.paymentCreator());
    }

    @Bean
    public TransactionDeleter transactionsDeleter() {
        return new TransactionDeleter((Saver)this.transactionsSaver(), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public AmountTypeApiController amountTypeApiController() {
        return new AmountTypeApiController(this.amountTypeLoader());
    }

    @Bean
    public TransactionLoader transactionLoader() {
        return new SwitchableHierarchyTransactionLoader(this.settingLoader.getOnRootProvider(PaymentSettingKeys.DEPARTMENT_HIERARCHY_ENABLED), (TransactionLoader)new SpringDbTransactionLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory, this.readonlyTransactionTemplateFactory.get(), (RowMapper)this.transactionEntityRowMapper(), (Converter)new TransactionEntityListToTransactionListConverter(this.departmentLoader, this.basicUsersLoader, (ByIdLoadable)this.amountTypeLoader())));
    }

    @Bean
    public TransactionEntityRowMapper transactionEntityRowMapper() {
        return new TransactionEntityRowMapper();
    }

    @Bean
    public HookableSaver<List<Transaction>, List<Transaction>> transactionsSaver() {
        TransactionalSaver saverWithConverters = new TransactionalSaver((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new TransactionListToEntityListConverter(), arg_0 -> ((SimpleJpaRepository)new SimpleJpaRepository(TransactionEntity.class, this.entityManager)).saveAllAndFlush(arg_0)), (Converter)new TransactionEntityListToTransactionListConverter(this.departmentLoader, this.basicUsersLoader, (ByIdLoadable)this.amountTypeLoader())), this.defaultTransactionTemplateFactory.get());
        GenericHookableSaver saver = new GenericHookableSaver((Saver)saverWithConverters);
        saver.addPreHook(this.saveTransactionAuthenticator);
        return saver;
    }

    @Bean
    public TransactionCreator transactionCreator() {
        return new TransactionCreator((ContextualProvider)this.transactionIdGenerator(), (Saver)this.transactionsSaver(), this.securityManager);
    }

    @Bean
    public TransactionsRefunder transactionsRefunder() {
        return new TransactionsRefunder((Saver)this.transactionsSaver(), this.transactionLoader(), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public ContextIgnoringContextualProvider<Department, @NonNull Integer> transactionIdGenerator() {
        return ContextIgnoringContextualProvider.of((Provider)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_id_platby", (String)"platby_id_platby_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties));
    }

    @Bean
    public AmountTypeLoader amountTypeLoader() {
        Codebook codebook = this.codebookLoaderBuilderFactory.create().providedByJpa(AmountTypeEntity.class, "order").convertedEachBy((Converter)new EntityToAmountTypeConverter()).staticCached(AmountType.class.getSimpleName()).build();
        return new CodebookBackedAmountTypeLoader(codebook);
    }

    @Bean
    public Provider<AmountType> registrationFeeAmountTypeProvider() {
        return ProviderByIdProvider.ofStaticId((ByIdLoadable)this.amountTypeLoader(), (Object)5);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, DepartmentedTypedUserAmount> typedUserBilanceSearchLoader() {
        SpringDbTypedUserBilanceEntitySearchLoader pureSearchLoader = new SpringDbTypedUserBilanceEntitySearchLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory);
        ParametersConvertingPageSearchLoader paramsConvertingSearchLoader = new ParametersConvertingPageSearchLoader((PageSearchLoader)pureSearchLoader);
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new TransactionalPageSearchLoader((PageSearchLoader)new SwitchableHierarchyBilanceSearchLoader(this.settingLoader.getOnRootProvider(PaymentSettingKeys.DEPARTMENT_HIERARCHY_ENABLED), (PageSearchLoader)new ResultConvertingPageSearchLoader((PageSearchLoader)paramsConvertingSearchLoader, this.entityListToDepartmentedTypedUserAmountListConverter())), this.readonlyTransactionTemplateFactory.get()));
    }

    @Bean
    public Map<String, Class<?>> providerNamesToPaymentTypes() {
        HashMap map = new HashMap();
        map.put("cash", Payment.class);
        map.put("terminal-virtual", Payment.class);
        return map;
    }

    @Bean
    public ContextualProvider<Department, @NonNull Boolean> creditPaymentEnabledProvider() {
        return this.settingLoader.getDepartmentedProvider(PaymentSettingKeys.PAYMENT_CREDIT_ENABLED);
    }

    @Bean
    public Map<Class<? extends Payment>, ByIdLoadable<? extends Payment, Integer>> paymentTypesToLoaders() {
        HashMap<Class<? extends Payment>, ByIdLoadable<? extends Payment, Integer>> map = new HashMap<Class<? extends Payment>, ByIdLoadable<? extends Payment, Integer>>();
        map.put((Class<? extends Payment>)Payment.class, (ByIdLoadable<? extends Payment, Integer>)this.purePaymentLoader());
        return map;
    }

    @Bean
    public PaymentLoaderProvider paymentLoaderProvider() {
        return new PaymentLoaderProvider(this.providerNamesToPaymentTypes(), this.paymentTypesToLoaders());
    }

    @Bean
    public PaymentLoader purePaymentLoader() {
        return new SpringDbPaymentLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory, this.paymentRowMapper());
    }

    @Bean
    public ByIdLoadable<Payment, Integer> concretePaymentLoader() {
        return new DispatchingPaymentLoader((ByIdLoadable)this.purePaymentLoader(), this.paymentLoaderProvider());
    }

    @Bean
    public RowMapper<Payment> paymentRowMapper() {
        return new PaymentRowMapper(this.basicUserLoader, this.departmentLoader, this.paymentItemLoader());
    }

    @Bean
    public DispatchingPaymentService dispatchingPaymentService() {
        return new DispatchingPaymentService().withAlwaysEnabled("cash", Integer.valueOf(100), this.basicPaymentSavingPaymentService()).withConditionalyEnabled("terminal-virtual", Integer.valueOf(200), this.settingLoader.getDepartmentedProvider(ManualPaymentProviderSettingKeys.TERMINAL_VIRTUAL_ENABLED), this.basicPaymentSavingPaymentService());
    }

    @Bean
    public PaymentService paymentService() {
        return new SecuredPaymentService(this.securityManager, (PaymentService)this.dispatchingPaymentService());
    }

    @Bean
    public ContextualProvider<Department, List<String>> enabledPaymentProviderNames() {
        return department -> this.dispatchingPaymentService().getAllEnabled(department);
    }

    @Bean
    public PaymentSplitterService paymentSplitterService() {
        return new PaymentSplitterService(this.typedUserBilanceSearchLoader(), this.amountTypeLoader(), (HierarchyLoader)this.departmentAccessor);
    }

    @Bean
    public Saver<Payment, Payment> paymentSaver() {
        return new GenericHookableSaver((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new PaymentToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(PaymentEntity.class, this.entityManager))), (Converter)new PaymentFromEntityConverter(this.basicUserLoader, this.departmentLoader, this.transactionLoader())));
    }

    @Bean
    public Saver<List<PaymentItem>, List<PaymentItem>> paymentItemsSaver() {
        return new GenericHookableSaver((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new PaymentItemsToPaymentItemEntitiesConverter(), arg_0 -> ((SimpleJpaRepository)new SimpleJpaRepository(PaymentItemEntity.class, this.entityManager)).saveAll(arg_0)), (Converter)new PaymentItemsFromPaymentItemEntitiesConverter(this.basicUsersLoader, (ByIdLoadable)this.amountTypeLoader())));
    }

    @Bean
    public Saver<Payment, Payment> paymentWithTransactionsSaver() {
        return new PaymentWithTransactionsSaver(this.transactionLoader(), this.paymentSplitterService(), this.transactionCreator(), this.transactionsRefunder(), this.paymentSaver());
    }

    @Bean
    public PaymentBasicCreator paymentCreator() {
        return new PaymentBasicCreator((ContextualProvider)ContextIgnoringContextualProvider.of((Provider)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_id_platby_placeni", (String)"platby_placeni_id_platby_placeni_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.defaultTransactionTemplateFactory.get(), this.paymentWithTransactionsSaver());
    }

    @Bean
    public PaymentItemsCreator paymentItemsCreator() {
        return new PaymentItemsCreator(this.paymentItemsSaver(), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public PaymentService basicPaymentSavingPaymentService() {
        return new BasicPaymentSavingPaymentService(this.paymentCreator(), this.defaultTransactionTemplateFactory.get(), this.paymentItemsCreator());
    }

    @Bean
    public RowMapper<TypedUserAmount> paymentItemRowMapper() {
        return new PaymentItemRowMapper(this.basicUserLoader, (ByIdLoadable)this.amountTypeLoader());
    }

    @Bean
    public PaymentItemLoader paymentItemLoader() {
        return new SpringDbPaymentItemLoader(this.notAutoCommittingJdbcTemplate, this.queryFactory, this.paymentItemRowMapper());
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Integer> paymentIdSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new SpringDbPaymentSearchLoader(this.jdbcTemplate, this.queryFactory));
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Payment> paymentSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.paymentIdSearchLoader(), (AllByIdsLoadable)this.purePaymentLoader()));
    }

    @Bean
    public PaymentProvider cashPaymentProvider() {
        return new PaymentProvider("cash");
    }

    @Bean
    public PaymentProvider gpePaymentProvider() {
        return new PaymentProvider("terminal-gpe");
    }

    @Bean
    public PaymentProvider virtualTerminalPaymentProvider() {
        return new PaymentProvider("terminal-virtual");
    }

    @Bean
    public List<PaymentProvider> paymentProviders() {
        return new ArrayList<PaymentProvider>(List.of(this.cashPaymentProvider(), this.virtualTerminalPaymentProvider(), this.gpePaymentProvider()));
    }

    @Bean
    public SubjectClassDispatchingSubjectUpdater<Payment, Department> paymentUpdater() {
        return new SubjectClassDispatchingSubjectUpdater();
    }

    @Bean
    public SearchingPendingPaymentsUpdater pendingPaymentsUpdater() {
        DispatchingPaymentLoader concretePaymentLoader = new DispatchingPaymentLoader((ByIdLoadable)this.purePaymentLoader(), this.paymentLoaderProvider());
        return new SearchingPendingPaymentsUpdater(this.paymentIdSearchLoader(), (ByIdLoadable)concretePaymentLoader, (SubjectUpdater)this.paymentUpdater(), this.rootDepartmentProvider);
    }

    @Bean
    public PaymentServiceRegistrar paymentServiceRegistrar() {
        return new PaymentServiceRegistrar(this.providerNamesToPaymentTypes(), this.paymentTypesToLoaders(), this.dispatchingPaymentService(), this.paymentUpdater(), this.paymentProviders(), this.pendingPaymentsUpdater());
    }

    @Bean
    public Task<Void> paymentSynchronizersSyncTask() {
        return Tasks.recurring((String)"payment-synchronizers-sync-task", (Schedule)Schedules.daily((ZoneId)CoreConstants.CZECH_TIME_ZONE_ID, (LocalTime[])new LocalTime[]{LocalTime.parse("22:00:00")})).execute((taskInstance, executionContext) -> this.pendingPaymentsUpdater().checkAllPending());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(AmountType.class, (ByIdLoadable)this.amountTypeLoader()).registerForIntegerId(Transaction.class, (ByIdLoadable)this.transactionLoader());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        PermissionResolver canPayAnyOfUser = PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence(), this.permissionFactory.editOnReadableDepartmentsOfUser()});
        @NonNull ContextualProvider gatewayAllowedUserIdsProvider = this.settingLoader.getDepartmentedProvider(PaymentProviderSettingKeys.GATEWAY_ALLOWED_USER_IDS);
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_SHOW_ALL, this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6112)));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_SHOW_DEBUG, this.permissionFactory.adminOrEditWithServicePrivileges());
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_SHOW_OF_USER, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentIsSubjectUser(), PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.getLazy(PaymentSecurityActions.PAYMENTS_SHOW_ALL))}));
        this.permissionRegistry.add(PaymentSecurityActions.DEBT_CREATE, (PermissionResolver)PermissionResolver.adaptingSubject(Transaction::getOwner, (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6161))})));
        this.permissionRegistry.add(PaymentSecurityActions.DEBT_PAY_FROM_CREDIT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentIsSubjectUser(), PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.getLazy(PaymentSecurityActions.PAYMENTS_SHOW_ALL)), (userAuthentication, ctx, basicUser) -> PermissionResult.ifCan((boolean)((Boolean)this.creditPaymentEnabledProvider().getOn((Object)ctx)))}));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_CREATE_ANY_OF_USER_BY_PROVIDER, (auth, ctx, pair) -> {
            String paymentProviderName = pair.provider();
            if (PaymentUtil.isOfType((String)paymentProviderName, (String)"gateway")) {
                NullSubjectForwardingPermissionResolver canByFeature = NullSubjectForwardingPermissionResolver.of((PermissionResolver)this.permissionFactory.feature("payment-gateway"));
                PermissionResolver canByAllowedUsersSetting = (a, c, unused) -> {
                    List gatewayAllowedUserIds = (List)gatewayAllowedUserIdsProvider.getOn((Object)c);
                    if (gatewayAllowedUserIds.isEmpty() || gatewayAllowedUserIds.contains(a.getActiveUser().getId())) {
                        return PermissionResult.allow();
                    }
                    return PermissionResult.disabledFeature((Text)Texts.ofMessageCoded((String)"payment.GatewayAvailableToSelectedUsers"));
                };
                return PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{canByFeature, canByAllowedUsersSetting}).can(auth, ctx, null);
            }
            if (PaymentUtil.isOfType((String)paymentProviderName, (String)"cash") || PaymentUtil.isOfType((String)paymentProviderName, (String)"terminal")) {
                return PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{MappingPermissionResolver.of(PaymentProviderOwnerPair::owner, (PermissionResolver)canPayAnyOfUser), NullSubjectForwardingPermissionResolver.of((PermissionResolver)this.permissionFactory.editAction(Integer.valueOf(6111)))}).can(auth, ctx, pair);
            }
            throw new UnsupportedOperationException("Unsupported payment provider type %s".formatted(paymentProviderName));
        });
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_CREATE, (PermissionResolver)FlattingAndingPermissionResolver.of(payCommand -> payCommand.items().getTransactions().stream().map(paymentItem -> new PaymentProviderOwnerPair(payCommand.provider(), paymentItem.getOwner())), (PermissionResolver)this.permissionRegistry.getLazy(PaymentSecurityActions.PAYMENT_CREATE_ANY_OF_USER_BY_PROVIDER)));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_CONFIRM_OF_OWNER, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6111))}));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_CONFIRM, (PermissionResolver)FlattingAndingPermissionResolver.of(payment -> payment.getItems().stream().map(TypedUserAmount::getOwner), (PermissionResolver)this.permissionRegistry.getLazy(PaymentSecurityActions.PAYMENT_CONFIRM_OF_OWNER)));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENT_DELETE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6163))}));
        this.permissionRegistry.add(PaymentSecurityActions.DEBT_DELETE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6164))}));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_RETURN_DEPOSIT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), canPayAnyOfUser, this.permissionFactory.editAction(Integer.valueOf(6165))}));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_PRINT, this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6134)));
        this.permissionRegistry.add(PaymentSecurityActions.PAYMENTS_RECEIPT_PRINT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvided(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6133)), this.permissionFactory.editOnReadableDepartmentsOfUser()})})}));
    }

    @ConstructorProperties(value={"publicContextPath", "jdbcTemplate", "queryFactory", "permissionRegistry", "codebookLoaderBuilderFactory", "templateEngine", "departmentAccessor", "basicUserLoader", "basicUsersLoader", "departmentLoader", "permissionFactory", "settingLoader", "securityManager", "currentAuthEditableDepartmentsLoader", "actionSaver", "portaroUserProvider", "hierarchicalDepartmentLoaderByDepartmentLoader", "actionRequestUrlGenerator", "rootDepartmentProvider", "converterRegisterer", "userRelationsHelper", "modelAndPageViewFactory", "editableDepartmentsAuthenticatedContextualProvider", "entityManager", "notAutoCommittingJdbcTemplate", "defaultTransactionTemplateFactory", "saveTransactionAuthenticator", "readonlyTransactionTemplateFactory", "databaseProperties"})
    @Generated
    public PaymentConfig(@NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull PermissionRegistry permissionRegistry, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull TemplateEngine templateEngine, @NonNull DepartmentAccessor departmentAccessor, @NonNull ByIdLoadable<BasicUser, Integer> basicUserLoader, @NonNull AllByIdsLoadable<BasicUser, Integer> basicUsersLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull PermissionFactory permissionFactory, @NonNull SettingLoader settingLoader, @NonNull SecurityManager securityManager, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull ActionSaver actionSaver, @NonNull @NonNull Provider<@NonNull User> portaroUserProvider, @NonNull HierarchicalDepartmentLoaderByDepartmentLoader hierarchicalDepartmentLoaderByDepartmentLoader, @NonNull ActionRequestUrlGenerator actionRequestUrlGenerator, @NonNull @NonNull Provider<@NonNull Department> rootDepartmentProvider, @NonNull ConverterRegisterer converterRegisterer, @NonNull UserRelationsHelper userRelationsHelper, @NonNull ModelAndPageViewFactory modelAndPageViewFactory, @NonNull AuthenticatedContextualProvider<Department, List<Department>> editableDepartmentsAuthenticatedContextualProvider, @NonNull EntityManager entityManager, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull Runnable saveTransactionAuthenticator, @NonNull TransactionTemplateFactory readonlyTransactionTemplateFactory, @NonNull DatabaseProperties databaseProperties) {
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(basicUsersLoader, "basicUsersLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(portaroUserProvider, "portaroUserProvider is marked non-null but is null");
        Objects.requireNonNull(hierarchicalDepartmentLoaderByDepartmentLoader, "hierarchicalDepartmentLoaderByDepartmentLoader is marked non-null but is null");
        Objects.requireNonNull(actionRequestUrlGenerator, "actionRequestUrlGenerator is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(userRelationsHelper, "userRelationsHelper is marked non-null but is null");
        Objects.requireNonNull(modelAndPageViewFactory, "modelAndPageViewFactory is marked non-null but is null");
        Objects.requireNonNull(editableDepartmentsAuthenticatedContextualProvider, "editableDepartmentsAuthenticatedContextualProvider is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        Objects.requireNonNull(readonlyTransactionTemplateFactory, "readonlyTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        this.publicContextPath = publicContextPath;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.permissionRegistry = permissionRegistry;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.templateEngine = templateEngine;
        this.departmentAccessor = departmentAccessor;
        this.basicUserLoader = basicUserLoader;
        this.basicUsersLoader = basicUsersLoader;
        this.departmentLoader = departmentLoader;
        this.permissionFactory = permissionFactory;
        this.settingLoader = settingLoader;
        this.securityManager = securityManager;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.actionSaver = actionSaver;
        this.portaroUserProvider = portaroUserProvider;
        this.hierarchicalDepartmentLoaderByDepartmentLoader = hierarchicalDepartmentLoaderByDepartmentLoader;
        this.actionRequestUrlGenerator = actionRequestUrlGenerator;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.converterRegisterer = converterRegisterer;
        this.userRelationsHelper = userRelationsHelper;
        this.modelAndPageViewFactory = modelAndPageViewFactory;
        this.editableDepartmentsAuthenticatedContextualProvider = editableDepartmentsAuthenticatedContextualProvider;
        this.entityManager = entityManager;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.saveTransactionAuthenticator = saveTransactionAuthenticator;
        this.readonlyTransactionTemplateFactory = readonlyTransactionTemplateFactory;
        this.databaseProperties = databaseProperties;
    }
}

