/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import cz.kpsys.portaro.commons.concurrent.GlobalLocker;
import cz.kpsys.portaro.commons.concurrent.ReentrantLockLocker;
import cz.kpsys.portaro.commons.object.FallbackingProvider;
import cz.kpsys.portaro.commons.object.LockingProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SavingProvider;
import cz.kpsys.portaro.commons.object.ValidatingProvider;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.LicenceUpdaterConfig;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.licence.BusinessVersion;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.LicenceKeyDecoder;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceKeyExpiredPredicate;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceProvider;
import cz.kpsys.portaro.licence.LicenceKeyExpiredException;
import cz.kpsys.portaro.licence.LicenceServerFetchingLicenceKeyProvider;
import cz.kpsys.portaro.licence.portaro.VcsPortaroVersion;
import cz.kpsys.portaro.platform.PlatformUtils;
import cz.kpsys.portaro.repo.save.RetryableSaver;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingEntity;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.DelegatingValueCustomSettingSaver;
import cz.kpsys.portaro.setting.IniNotSetException;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.view.web.LicenceApiController;
import cz.kpsys.portaro.view.web.LicenceKeyApiController;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.web.client.RestOperations;

@Configuration
public class LicenceUpdaterConfig {
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver;
    @NonNull
    private final @NonNull Provider<@NonNull String> rootSerialCodeProvider;
    private final @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider;
    @NonNull
    private final VcsPortaroVersion portaroVersion;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider;
    @NonNull
    private final @NonNull Provider<@NonNull Integer> rootDepartmentIdProvider;
    @NonNull
    private final LicenceKeyDecoder licenceKeyDecoder;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final HealthIndicator databaseStructureHealthIndicator;
    @NonNull
    private final HealthIndicator fieldTypeHealthIndicator;

    @Bean
    public LicenceKeyApiController licenceKeyApiController() {
        return new LicenceKeyApiController(this.settingLoader.getDepartmentedProvider(SettingKeys.LICENCE_KEY));
    }

    @Bean
    public LicenceApiController licenceApiController() {
        return new LicenceApiController(this.licenceProvider(), this.savingLicenceServerJwtLicenceKeyProvider());
    }

    @Bean
    public Provider<@NonNull Licence> licenceProvider() {
        return new LicenceKeyDecodingLicenceProvider((Supplier)this.jwtLicenceKeyProvider(), this.licenceKeyDecoder);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Bean
    public Provider<@NonNull String> jwtLicenceKeyProvider() {
        @NonNull Provider fromIniProvider = this.settingLoader.getOnRootProvider(SettingKeys.LICENCE_KEY).throwingWhenNull();
        @NonNull LicenceKeyDecodingLicenceKeyExpiredPredicate keyExpired = new LicenceKeyDecodingLicenceKeyExpiredPredicate(this.licenceKeyDecoder);
        @NonNull ValidatingProvider validatingFromIniProvider = ValidatingProvider.invalidWhen((Provider)fromIniProvider, (Predicate)keyExpired, expiredJwt -> new LicenceKeyExpiredException());
        return new FallbackingProvider((Provider)validatingFromIniProvider, this.savingLicenceServerJwtLicenceKeyProvider()).fallbackOnException(IniNotSetException.class).fallbackOnException(LicenceKeyExpiredException.class);
    }

    @Bean
    public Provider<@NonNull String> savingLicenceServerJwtLicenceKeyProvider() {
        LicenceServerFetchingLicenceKeyProvider fromLicenceServerProvider = new LicenceServerFetchingLicenceKeyProvider(this.rest, this.rootSerialCodeProvider, this.settingLoader.getOnRootProvider(SettingKeys.KPSYS_API_KEY).throwingWhenNull()).withExtraData("seatable.provided_url", this.rootServerUrlProvider).withExtraData("seatable.current_licence_version", () -> ((BusinessVersion)this.licenceVersionProvider.get()).getValue()).withExtraData("seatable.db_structure_health", () -> this.databaseStructureHealthIndicator.getHealth(false).getStatus().getCode()).withExtraData("seatable.field_type_structure_health", () -> this.fieldTypeHealthIndicator.getHealth(false).getStatus().getCode()).withExtraData("seatable.portaro_version", () -> ((VcsPortaroVersion)this.portaroVersion).getValue()).withExtraData("seatable.portaro_branch", () -> ((VcsPortaroVersion)this.portaroVersion).getBranch()).withExtraData("seatable.portaro_business_version", () -> ((BusinessVersion)this.currentVersionProvider.get()).getValue()).withExtraData("seatable.portaro_java_version", () -> SystemUtils.JAVA_VERSION).withExtraData("seatable.portaro_os_type", () -> switch (1.$SwitchMap$cz$kpsys$portaro$platform$OsCheck$OSType[PlatformUtils.getOperatingSystemType().ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> "windows";
            case 2 -> "linux";
            case 3 -> "macos";
            case 4 -> "other";
        }).withExtraData("seatable.portaro_os_version", () -> SystemUtils.OS_VERSION);
        SavingProvider savingProvider = new SavingProvider((Provider)fromLicenceServerProvider, this.licenceKeySaver());
        return new LockingProvider((Provider)savingProvider, (GlobalLocker)new ReentrantLockLocker());
    }

    @Bean
    public Saver<String, String> licenceKeySaver() {
        DelegatingValueCustomSettingSaver pureSaver = new DelegatingValueCustomSettingSaver(this.customSettingSaver, (SettingTypeId)SettingKeys.LICENCE_KEY, this.rootDepartmentIdProvider, this.customSettingLoader);
        TransactionalSaver transactionalSaver = new TransactionalSaver((Saver)pureSaver, this.defaultTransactionTemplateFactory.get());
        return RetryableSaver.ofFixedBackoff((Saver)transactionalSaver, (int)3, (Duration)Duration.ofSeconds(2L), List.of(DataIntegrityViolationException.class));
    }

    @Bean
    public Task<Void> licenceUpdateTask() {
        return Tasks.recurring((String)"licence-update-task", (Schedule)Schedules.fixedDelay((Duration)Duration.ofHours(9L))).execute((taskInstance, executionContext) -> this.savingLicenceServerJwtLicenceKeyProvider().get());
    }

    @ConstructorProperties(value={"rest", "settingLoader", "customSettingSaver", "rootSerialCodeProvider", "rootServerUrlProvider", "portaroVersion", "currentVersionProvider", "licenceVersionProvider", "rootDepartmentIdProvider", "licenceKeyDecoder", "customSettingLoader", "defaultTransactionTemplateFactory", "databaseStructureHealthIndicator", "fieldTypeHealthIndicator"})
    @Generated
    public LicenceUpdaterConfig(@NonNull RestOperations rest, @NonNull SettingLoader settingLoader, @NonNull Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver, @NonNull @NonNull Provider<@NonNull String> rootSerialCodeProvider, @NonNull Provider<@NullableNotBlank String> rootServerUrlProvider, @NonNull VcsPortaroVersion portaroVersion, @NonNull @NonNull Provider<@NonNull BusinessVersion> currentVersionProvider, @NonNull @NonNull Provider<@NonNull BusinessVersion> licenceVersionProvider, @NonNull @NonNull Provider<@NonNull Integer> rootDepartmentIdProvider, @NonNull LicenceKeyDecoder licenceKeyDecoder, @NonNull CustomSettingLoader customSettingLoader, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull HealthIndicator databaseStructureHealthIndicator, @NonNull HealthIndicator fieldTypeHealthIndicator) {
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(rootSerialCodeProvider, "rootSerialCodeProvider is marked non-null but is null");
        Objects.requireNonNull(rootServerUrlProvider, "rootServerUrlProvider is marked non-null but is null");
        Objects.requireNonNull(portaroVersion, "portaroVersion is marked non-null but is null");
        Objects.requireNonNull(currentVersionProvider, "currentVersionProvider is marked non-null but is null");
        Objects.requireNonNull(licenceVersionProvider, "licenceVersionProvider is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentIdProvider, "rootDepartmentIdProvider is marked non-null but is null");
        Objects.requireNonNull(licenceKeyDecoder, "licenceKeyDecoder is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(databaseStructureHealthIndicator, "databaseStructureHealthIndicator is marked non-null but is null");
        Objects.requireNonNull(fieldTypeHealthIndicator, "fieldTypeHealthIndicator is marked non-null but is null");
        this.rest = rest;
        this.settingLoader = settingLoader;
        this.customSettingSaver = customSettingSaver;
        this.rootSerialCodeProvider = rootSerialCodeProvider;
        this.rootServerUrlProvider = rootServerUrlProvider;
        this.portaroVersion = portaroVersion;
        this.currentVersionProvider = currentVersionProvider;
        this.licenceVersionProvider = licenceVersionProvider;
        this.rootDepartmentIdProvider = rootDepartmentIdProvider;
        this.licenceKeyDecoder = licenceKeyDecoder;
        this.customSettingLoader = customSettingLoader;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.databaseStructureHealthIndicator = databaseStructureHealthIndicator;
        this.fieldTypeHealthIndicator = fieldTypeHealthIndicator;
    }
}

