/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.commons.cache.AllCacheObjectIgnoringCleanerAdapter;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheCleaningSaver;
import cz.kpsys.portaro.commons.cache.CacheDeletableByObject;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.MultiCacheDeletableByObject;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.image.ExifRotatingImageResizer;
import cz.kpsys.portaro.commons.image.ImageResizer;
import cz.kpsys.portaro.commons.image.ImageResizerScalr;
import cz.kpsys.portaro.commons.io.FallbackingFilesystemService;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.io.FilesystemService;
import cz.kpsys.portaro.commons.io.LocalFilesystemService;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.AndBooleanProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdAndByIdOptLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdOptLoadable;
import cz.kpsys.portaro.commons.object.repo.CachedCodebook;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.PostConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.PreConvertingDeleter;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalDeleter;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.commons.pdf.PdfMerger;
import cz.kpsys.portaro.commons.util.DateUtils;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.CachedCodebookAssembly;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.database.FlushingJpaDeleter;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.FileConfig;
import cz.kpsys.portaro.file.FileIndexConfig;
import cz.kpsys.portaro.file.FileProcessingState;
import cz.kpsys.portaro.file.FileSettingKeys;
import cz.kpsys.portaro.file.FileStreamerConfig;
import cz.kpsys.portaro.file.FilepathFileCreator;
import cz.kpsys.portaro.file.FilepathFileFromEntityConverter;
import cz.kpsys.portaro.file.FilepathFileToEntityConverter;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.IdentifiedFileEntity;
import cz.kpsys.portaro.file.IdentifiedFileFromEntityConverter;
import cz.kpsys.portaro.file.IdentifiedFileSpringDbSoftDeleter;
import cz.kpsys.portaro.file.IdentifiedFileToEntityConverter;
import cz.kpsys.portaro.file.ImageDownloader;
import cz.kpsys.portaro.file.LoadedIdentifiedFileEntity;
import cz.kpsys.portaro.file.LoadedIdentifiedFileFromEntityConverter;
import cz.kpsys.portaro.file.LoadedIdentifiedFileJpaCreator;
import cz.kpsys.portaro.file.LoadedIdentifiedFileSaver;
import cz.kpsys.portaro.file.LoadedIdentifiedFileToEntityConverter;
import cz.kpsys.portaro.file.RemoteFilesystemService;
import cz.kpsys.portaro.file.StubFile;
import cz.kpsys.portaro.file.clean.CleanupFilesPathSettingNullSetter;
import cz.kpsys.portaro.file.clean.FileCleanupService;
import cz.kpsys.portaro.file.clean.FilePathsLoader;
import cz.kpsys.portaro.file.custom.CodebookDelegatingRootCustomDirectoryAccessor;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.custom.CustomFileLoaderByFileLoader;
import cz.kpsys.portaro.file.custom.CustomFileResourceContextualResolver;
import cz.kpsys.portaro.file.custom.EntitiesToRootCustomDirectoriesConverter;
import cz.kpsys.portaro.file.custom.HierarchyTraversingCustomFileLoader;
import cz.kpsys.portaro.file.custom.ProvidedDepartmentCustomFileResourceProtocolResolver;
import cz.kpsys.portaro.file.custom.RootCustomDirectory;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryAccessor;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryEntity;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryFromEntityConverter;
import cz.kpsys.portaro.file.custom.RootCustomDirectoryToEntityConverter;
import cz.kpsys.portaro.file.directory.Directory;
import cz.kpsys.portaro.file.directory.DirectoryInsightLoader;
import cz.kpsys.portaro.file.directory.DirectoryInsightLoaderByFileSearch;
import cz.kpsys.portaro.file.directory.DirectoryLoader;
import cz.kpsys.portaro.file.directory.ParentableDirectory;
import cz.kpsys.portaro.file.directory.ParentableDirectoryCreator;
import cz.kpsys.portaro.file.directory.ParentableDirectoryDeleter;
import cz.kpsys.portaro.file.directory.ParentableDirectoryEntity;
import cz.kpsys.portaro.file.directory.ParentableDirectoryFromEntityConverter;
import cz.kpsys.portaro.file.directory.ParentableDirectoryToEntityConverter;
import cz.kpsys.portaro.file.directory.ParentableDirectoryUpdater;
import cz.kpsys.portaro.file.filecategory.FileCategory;
import cz.kpsys.portaro.file.image.FileImageConfig;
import cz.kpsys.portaro.file.security.FileSecurityActions;
import cz.kpsys.portaro.file.security.IdentifiedFileSaveCommand;
import cz.kpsys.portaro.file.text.FileTextConfig;
import cz.kpsys.portaro.file.text.FileTextIndexConfig;
import cz.kpsys.portaro.file.text.pdf.PdfByIdentifiedFilesMerger;
import cz.kpsys.portaro.filter.Filter;
import cz.kpsys.portaro.filter.FilterLoader;
import cz.kpsys.portaro.filter.LazyFilter;
import cz.kpsys.portaro.hierarchy.HierarchyLoader;
import cz.kpsys.portaro.id.IDdFile;
import cz.kpsys.portaro.resource.ClasspathResourceContextualResolver;
import cz.kpsys.portaro.resource.FirstMatchingResourceResolver;
import cz.kpsys.portaro.resource.PrefixDispatchingResourceResolver;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingEntity;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.DelegatingValueCustomSettingSaver;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.view.web.ImageResizerController;
import jakarta.persistence.EntityManager;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@Import(value={FileConfig.class, FileIndexConfig.class, FileStreamerConfig.class, FileTextConfig.class, FileTextIndexConfig.class, FileImageConfig.class})
@Lazy
public class FileImplConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileImplConfig.class);
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ImageDownloader imageDownloader;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final FilterLoader filterLoader;
    @NonNull
    private final HttpServletRequest httpServletRequest;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final CachedCodebookAssembly codebookAssembler;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final ConfigurableApplicationContext applicationContext;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final DirectoryLoader directoryLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final Codebook<FileAccessType, Integer> fileAccessTypeLoader;
    @NonNull
    private final Codebook<FileCategory, Integer> fileCategoryLoader;
    @NonNull
    private final FileDataStreamer fileDataStreamer;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final DatabaseProperties databaseProperties;
    @NonNull
    private final @NonNull Provider<@NonNull Boolean> blobDirEnabled;
    @NonNull
    private final LocalFilesystemService localFilesystemService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final MappingAppserverService nonAuthorizingMappingAppserver;
    @NonNull
    private final @NonNull Provider<@NonNull Boolean> blobDirDirectLoadEnabled;
    @NonNull
    private final Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    @NonNull
    private final @NonNull Provider<@NonNull Integer> rootDepartmentIdProvider;
    @NonNull
    private final @NonNull Provider<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LocalFilesystemService.BlobDir> blobDirProvider;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final @NonNull Provider<@NonNull Boolean> deleteFilesFromToDeleteEnabled;
    @NonNull
    private final @NonNull Provider<@NonNull Boolean> restoreFilesFromToDeleteEnabled;

    @Bean
    public DirectoryInsightLoader directoryInsightLoader() {
        return new DirectoryInsightLoaderByFileSearch(this.directoryLoader, (PageSearchLoader)this.fileSearchLoader);
    }

    @Bean
    public ImageResizerController imageResizerController() {
        return new ImageResizerController(this.imageDownloader, this.imageResizer());
    }

    @Bean
    public ImageResizer imageResizer() {
        return new ExifRotatingImageResizer((ImageResizer)new ImageResizerScalr(true), false);
    }

    @Bean
    public PdfMerger pdfMerger() {
        return new PdfMerger();
    }

    @Bean
    public PdfByIdentifiedFilesMerger pdfByIdentifiedFilesMerger() {
        return new PdfByIdentifiedFilesMerger(this.pdfMerger(), this.fileDataStreamer);
    }

    @Bean
    public ByIdAndByIdOptLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader() {
        return new HierarchyTraversingCustomFileLoader(this.departmentLoader, (HierarchyLoader)this.departmentAccessor, (ByIdOptLoadable)this.customFileLoader());
    }

    @Bean
    public CachedCodebook<CustomFile, String> customFileLoader() {
        CustomFileLoaderByFileLoader bean = new CustomFileLoaderByFileLoader((AllValuesProvider)this.rootCustomdirectoryLoader(), this.directoryLoader, this.fileSearchLoader);
        CachedCodebook codebook = this.codebookAssembler.createStaticCached((AllValuesProvider)bean, CustomFile.class.getSimpleName());
        this.applicationContext.addProtocolResolver((ProtocolResolver)new ProvidedDepartmentCustomFileResourceProtocolResolver((ByIdOptLoadable)codebook, this.fileDataStreamer, this.rootDepartmentProvider));
        return codebook;
    }

    @Bean
    public PrefixDispatchingResourceResolver<Department> prefixDispatchingResourceResolver() {
        return new PrefixDispatchingResourceResolver().addResolver("classpath:", (ContextualFunction)new ClasspathResourceContextualResolver()).addResolver("custom:", (ContextualFunction)new CustomFileResourceContextualResolver((ByIdOptLoadable)this.hierarchyTraversingCustomFileLoader(), this.fileDataStreamer));
    }

    @Bean
    public Function<List<String>, ? extends ContextualProvider<Department, @NonNull Resource>> firstMatchingResourceResolverFactory() {
        return FirstMatchingResourceResolver.createFactoryForFailOnNoneExisting((PrefixDispatchingResourceResolver)this.prefixDispatchingResourceResolver());
    }

    @Bean
    public CacheDeletableByObject<IdentifiedFile> customFileCacheCleaner() {
        CachedCodebook customFileCache = this.customFileLoader();
        return clearedFile -> {
            for (CustomFile customFile : customFileCache.getAll()) {
                if (!((Long)clearedFile.getId()).equals(customFile.getFileId())) continue;
                customFileCache.clearCache();
                return;
            }
        };
    }

    @Bean
    public CacheDeletableByObject<IdentifiedFileSaveCommand> customLoadedFileCacheCleaner() {
        CachedCodebook customFileCache = this.customFileLoader();
        return command -> {
            for (CustomFile customFile : customFileCache.getAll()) {
                if (!((Long)command.file().getId()).equals(customFile.getFileId())) continue;
                customFileCache.clearCache();
                return;
            }
        };
    }

    @Bean
    public Saver<RootCustomDirectory, RootCustomDirectory> rootCustomDirectorySaver() {
        return CacheCleaningSaver.fromGenericCleaner((Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new RootCustomDirectoryToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(RootCustomDirectoryEntity.class, this.entityManager))), (Converter)new RootCustomDirectoryFromEntityConverter((ByIdLoadable)this.directoryLoader)), (CacheCleaner)this.cacheService.createCleanerFor(RootCustomDirectory.class.getSimpleName()));
    }

    @Bean
    public Codebook<RootCustomDirectory, Integer> rootCustomdirectoryLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(RootCustomDirectoryEntity.class, "departmentId").converted((Converter)new EntitiesToRootCustomDirectoriesConverter((AllByIdsLoadable)this.directoryLoader)).staticCached(RootCustomDirectory.class.getSimpleName()).build();
    }

    @Bean
    public RootCustomDirectoryAccessor rootCustomDirectoryAccessor() {
        return new CodebookDelegatingRootCustomDirectoryAccessor(this.rootCustomdirectoryLoader());
    }

    @Bean
    public Deleter<IDdFile> pureIdentifiedFileDeleter() {
        return new IdentifiedFileSpringDbSoftDeleter(this.notAutoCommittingJdbcTemplate, this.queryFactory);
    }

    @Bean
    public Saver<IdentifiedFile, IdentifiedFile> identifiedFileSaver() {
        return new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new IdentifiedFileToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(IdentifiedFileEntity.class, this.entityManager))), (Converter)new IdentifiedFileFromEntityConverter((ByIdLoadable)this.fileCategoryLoader, this.directoryLoader, (ByIdLoadable)this.fileAccessTypeLoader));
    }

    @Bean
    public Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver() {
        MultiCacheDeletableByObject cacheCleaner = new MultiCacheDeletableByObject(List.of(this.customLoadedFileCacheCleaner(), new AllCacheObjectIgnoringCleanerAdapter(new CacheCleaner[]{this.cacheService.createCleanerFor(IdentifiedFile.class.getSimpleName())})));
        return CacheCleaningSaver.fromObjectCleaner((Saver)new LoadedIdentifiedFileSaver(this.defaultTransactionTemplateFactory.get(), this.blobDirEnabled, new LoadedIdentifiedFileJpaCreator(Provider.of((Supplier)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_fulltext", (String)"fulltext_soubory_id_fulltext_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.defaultTransactionTemplateFactory.get(), (Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new LoadedIdentifiedFileToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(LoadedIdentifiedFileEntity.class, this.entityManager))), (Converter)new LoadedIdentifiedFileFromEntityConverter((ByIdLoadable)this.fileCategoryLoader, this.directoryLoader, (ByIdLoadable)this.fileAccessTypeLoader))), this.fallbackingFilesystemService(), this.localFilesystemService, this.filepathFileCreator()), (CacheDeletableByObject)cacheCleaner);
    }

    @Bean
    public FilepathFileCreator filepathFileCreator() {
        return new FilepathFileCreator(Provider.of((Supplier)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_fulltext", (String)"fulltext_soubory_id_fulltext_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.defaultTransactionTemplateFactory.get(), (Saver)new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new FilepathFileToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(LoadedIdentifiedFileEntity.class, this.entityManager))), (Converter)new FilepathFileFromEntityConverter((ByIdLoadable)this.fileCategoryLoader, this.directoryLoader, (ByIdLoadable)this.fileAccessTypeLoader, this.localFilesystemService, this.blobDirDirectLoadEnabled)));
    }

    @Bean
    public Saver<ParentableDirectory, ParentableDirectory> directorySaver() {
        return new PostConvertingSaver((Saver)new PreConvertingSaver((Converter)new ParentableDirectoryToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(ParentableDirectoryEntity.class, this.entityManager))), (Converter)new ParentableDirectoryFromEntityConverter((ByIdLoadable)this.fileAccessTypeLoader));
    }

    @Bean
    public ParentableDirectoryCreator parentableDirectoryCreator() {
        return new ParentableDirectoryCreator(Provider.of((Supplier)IntegerValueDatabaseLoader.ofSequenceValueDbDependent((String)"seq_fulltext_skupiny", (String)"fulltext_skupiny_id_fulltext_skupiny_seq", (NamedParameterJdbcOperations)this.notAutoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (DatabaseProperties)this.databaseProperties)), this.directorySaver(), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public ParentableDirectoryUpdater parentableDirectoryUpdater() {
        return new ParentableDirectoryUpdater(this.directorySaver(), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public Deleter<ParentableDirectory> pureParentableDirectoryDeleter() {
        return new PreConvertingDeleter((Converter)new ParentableDirectoryToEntityConverter(), (Deleter)new FlushingJpaDeleter((JpaRepository)new SimpleJpaRepository(ParentableDirectoryEntity.class, this.entityManager)));
    }

    @Bean
    public Deleter<ParentableDirectory> parentableDirectoryDeleter() {
        return new TransactionalDeleter((Deleter)new ParentableDirectoryDeleter(this.pureParentableDirectoryDeleter(), this.directoryInsightLoader()), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public FilesystemService fallbackingFilesystemService() {
        return new FallbackingFilesystemService((Provider)AndBooleanProvider.of((Provider[])new Provider[]{this.settingLoader.getOnRootProvider(FileSettingKeys.BLOB_DIR_ENABLED), this.settingLoader.getOnRootProvider(FileSettingKeys.PORTARO_BLOB_DIR_FILES_DIRECT_LOAD)}), (FilesystemService)this.localFilesystemService, (FilesystemService)new RemoteFilesystemService(this.nonAuthorizingMappingAppserver));
    }

    @Bean
    public Provider<@NullableNotBlank String> cleanUpFilesLastPathProvider() {
        return this.settingLoader.getOnRootProvider(FileSettingKeys.CLEAN_UP_FILES_LAST_PATH);
    }

    @Bean
    public FileCleanupService fileCleanupService() {
        return new FileCleanupService(this.cleanUpFilesLastPathProvider(), this.cleanupFilesPathSettingNullSetter(), this.blobDirProvider, this.localFilesystemService, this.filePathsLoader(), this.cleanUpFilesSettingSaver());
    }

    @Bean
    public FilePathsLoader filePathsLoader() {
        return new FilePathsLoader(this.jdbcTemplate, this.queryFactory, this.databaseProperties);
    }

    @Bean
    public Saver<String, String> cleanUpFilesSettingSaver() {
        return new TransactionalSaver((Saver)new DelegatingValueCustomSettingSaver(this.customSettingSaver, (SettingTypeId)FileSettingKeys.CLEAN_UP_FILES_LAST_PATH, this.rootDepartmentIdProvider, this.customSettingLoader), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public Saver<String, String> restoreFilesFromToDeleteSaver() {
        return new TransactionalSaver((Saver)new DelegatingValueCustomSettingSaver(this.customSettingSaver, (SettingTypeId)FileSettingKeys.RESTORE_FILES_FROM_TO_DELETE_ENABLED, this.rootDepartmentIdProvider, this.customSettingLoader), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public CleanupFilesPathSettingNullSetter cleanupFilesPathSettingNullSetter() {
        return new CleanupFilesPathSettingNullSetter(this.customSettingSaver, (SettingTypeId)FileSettingKeys.CLEAN_UP_FILES_LAST_PATH, this.rootDepartmentIdProvider, this.customSettingLoader);
    }

    @Scheduled(cron="0 0 1 * * ?")
    public void cleanupOrphanFiles() {
        if (((Boolean)this.blobDirEnabled.get()).booleanValue() && ((Boolean)this.blobDirDirectLoadEnabled.get()).booleanValue()) {
            String lastPath = (String)this.cleanUpFilesLastPathProvider().get();
            if (StringUtil.isNullOrEmpty((String)lastPath) && !DateUtils.isFirstDayOfMonth()) {
                return;
            }
            this.fileCleanupService().cleanupFiles();
        }
    }

    @Scheduled(cron="0 0 1 15 * ?")
    public void deleteFilesFromToDeleteDirectory() {
        if (((Boolean)this.blobDirEnabled.get()).booleanValue() && ((Boolean)this.blobDirDirectLoadEnabled.get()).booleanValue() && ((Boolean)this.deleteFilesFromToDeleteEnabled.get()).booleanValue()) {
            this.localFilesystemService.deleteFilesFromToDeleteDir();
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void restoreToDeleteFiles() {
        try {
            if (((Boolean)this.blobDirEnabled.get()).booleanValue() && ((Boolean)this.blobDirDirectLoadEnabled.get()).booleanValue() && ((Boolean)this.restoreFilesFromToDeleteEnabled.get()).booleanValue()) {
                this.fileCleanupService().restoreToDeleteFiles();
                this.restoreFilesFromToDeleteSaver().save((Object)"false");
            }
        }
        catch (Exception e) {
            log.warn("Unable to restore files from to-delete directory.", (Throwable)e);
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(Directory.class, (ByIdLoadable)this.directoryLoader).registerForLongId(IDdFile.class, StubFile::new).registerForLongId(IdentifiedFile.class, this.identifiedFileLoader).registerForIntegerId(FileAccessType.class, (ByIdLoadable)this.fileAccessTypeLoader).registerForIntegerId(FileCategory.class, (ByIdLoadable)this.fileCategoryLoader).registerForIntegerId(FileProcessingState.class, (ByIdLoadable)FileProcessingState.CODEBOOK).registerForIntegerId(ParentableDirectory.class, (ByIdLoadable)this.directoryLoader);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        LazyFilter showFilter = new LazyFilter(Integer.valueOf(1), this.filterLoader);
        LazyFilter showThumbnailFilter = new LazyFilter(Integer.valueOf(5), this.filterLoader);
        LazyFilter exportFilter = new LazyFilter(Integer.valueOf(2), this.filterLoader);
        this.permissionRegistry.add(FileSecurityActions.FILES_MANAGE, this.permissionFactory.edit());
        this.permissionRegistry.add(FileSecurityActions.FILES_SHOW, PermissionResolver.allowing());
        this.permissionRegistry.add(FileSecurityActions.FILE_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionFactory.edit()), this.permissionFactory.webAccessFilter((Filter)showFilter, this.httpServletRequest)}));
        this.permissionRegistry.add(FileSecurityActions.THUMBNAIL_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionFactory.edit()), this.permissionFactory.webAccessFilter((Filter)showThumbnailFilter, this.httpServletRequest)}));
        this.permissionRegistry.add(FileSecurityActions.FILE_EXPORT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionFactory.edit()), this.permissionFactory.webAccessFilter((Filter)exportFilter, this.httpServletRequest)}));
    }

    @ConstructorProperties(value={"cacheService", "departmentLoader", "departmentAccessor", "imageDownloader", "permissionRegistry", "permissionFactory", "filterLoader", "httpServletRequest", "codebookLoaderBuilderFactory", "codebookAssembler", "converterRegisterer", "applicationContext", "rootDepartmentProvider", "directoryLoader", "fileSearchLoader", "identifiedFileLoader", "fileAccessTypeLoader", "fileCategoryLoader", "fileDataStreamer", "entityManager", "defaultTransactionTemplateFactory", "notAutoCommittingJdbcTemplate", "queryFactory", "databaseProperties", "blobDirEnabled", "localFilesystemService", "settingLoader", "nonAuthorizingMappingAppserver", "blobDirDirectLoadEnabled", "customSettingSaver", "customSettingLoader", "rootDepartmentIdProvider", "blobDirProvider", "jdbcTemplate", "deleteFilesFromToDeleteEnabled", "restoreFilesFromToDeleteEnabled"})
    @Generated
    public FileImplConfig(@NonNull CacheService cacheService, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull ImageDownloader imageDownloader, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull FilterLoader filterLoader, @NonNull HttpServletRequest httpServletRequest, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull CachedCodebookAssembly codebookAssembler, @NonNull ConverterRegisterer converterRegisterer, @NonNull ConfigurableApplicationContext applicationContext, @NonNull Provider<Department> rootDepartmentProvider, @NonNull DirectoryLoader directoryLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, IdentifiedFile> fileSearchLoader, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull Codebook<FileAccessType, Integer> fileAccessTypeLoader, @NonNull Codebook<FileCategory, Integer> fileCategoryLoader, @NonNull FileDataStreamer fileDataStreamer, @NonNull EntityManager entityManager, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull DatabaseProperties databaseProperties, @NonNull @NonNull Provider<@NonNull Boolean> blobDirEnabled, @NonNull LocalFilesystemService localFilesystemService, @NonNull SettingLoader settingLoader, @NonNull MappingAppserverService nonAuthorizingMappingAppserver, @NonNull @NonNull Provider<@NonNull Boolean> blobDirDirectLoadEnabled, @NonNull Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver, @NonNull CustomSettingLoader customSettingLoader, @NonNull @NonNull Provider<@NonNull Integer> rootDepartmentIdProvider, @NonNull @NonNull Provider<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LocalFilesystemService.BlobDir> blobDirProvider, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull @NonNull Provider<@NonNull Boolean> deleteFilesFromToDeleteEnabled, @NonNull @NonNull Provider<@NonNull Boolean> restoreFilesFromToDeleteEnabled) {
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(imageDownloader, "imageDownloader is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(filterLoader, "filterLoader is marked non-null but is null");
        Objects.requireNonNull(httpServletRequest, "httpServletRequest is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(codebookAssembler, "codebookAssembler is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(applicationContext, "applicationContext is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(directoryLoader, "directoryLoader is marked non-null but is null");
        Objects.requireNonNull(fileSearchLoader, "fileSearchLoader is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(fileAccessTypeLoader, "fileAccessTypeLoader is marked non-null but is null");
        Objects.requireNonNull(fileCategoryLoader, "fileCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(fileDataStreamer, "fileDataStreamer is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(blobDirEnabled, "blobDirEnabled is marked non-null but is null");
        Objects.requireNonNull(localFilesystemService, "localFilesystemService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(nonAuthorizingMappingAppserver, "nonAuthorizingMappingAppserver is marked non-null but is null");
        Objects.requireNonNull(blobDirDirectLoadEnabled, "blobDirDirectLoadEnabled is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentIdProvider, "rootDepartmentIdProvider is marked non-null but is null");
        Objects.requireNonNull(blobDirProvider, "blobDirProvider is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(deleteFilesFromToDeleteEnabled, "deleteFilesFromToDeleteEnabled is marked non-null but is null");
        Objects.requireNonNull(restoreFilesFromToDeleteEnabled, "restoreFilesFromToDeleteEnabled is marked non-null but is null");
        this.cacheService = cacheService;
        this.departmentLoader = departmentLoader;
        this.departmentAccessor = departmentAccessor;
        this.imageDownloader = imageDownloader;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.filterLoader = filterLoader;
        this.httpServletRequest = httpServletRequest;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.codebookAssembler = codebookAssembler;
        this.converterRegisterer = converterRegisterer;
        this.applicationContext = applicationContext;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.directoryLoader = directoryLoader;
        this.fileSearchLoader = fileSearchLoader;
        this.identifiedFileLoader = identifiedFileLoader;
        this.fileAccessTypeLoader = fileAccessTypeLoader;
        this.fileCategoryLoader = fileCategoryLoader;
        this.fileDataStreamer = fileDataStreamer;
        this.entityManager = entityManager;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.queryFactory = queryFactory;
        this.databaseProperties = databaseProperties;
        this.blobDirEnabled = blobDirEnabled;
        this.localFilesystemService = localFilesystemService;
        this.settingLoader = settingLoader;
        this.nonAuthorizingMappingAppserver = nonAuthorizingMappingAppserver;
        this.blobDirDirectLoadEnabled = blobDirDirectLoadEnabled;
        this.customSettingSaver = customSettingSaver;
        this.customSettingLoader = customSettingLoader;
        this.rootDepartmentIdProvider = rootDepartmentIdProvider;
        this.blobDirProvider = blobDirProvider;
        this.jdbcTemplate = jdbcTemplate;
        this.deleteFilesFromToDeleteEnabled = deleteFilesFromToDeleteEnabled;
        this.restoreFilesFromToDeleteEnabled = restoreFilesFromToDeleteEnabled;
    }
}

