/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByAllValuesProviderAdapter;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.database.FlushingJpaSaver;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.event.Event;
import cz.kpsys.portaro.event.EventEntity;
import cz.kpsys.portaro.event.EventEntityLoader;
import cz.kpsys.portaro.event.EventEntityToEventConverter;
import cz.kpsys.portaro.event.EventToEntityConverter;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.event.OnlyCreatingEventer;
import cz.kpsys.portaro.event.SavingEventer;
import cz.kpsys.portaro.eventbus.EventBus;
import cz.kpsys.portaro.sse.SseController;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.BasicUser;
import jakarta.persistence.EntityManager;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

@Configuration
public class EventConfig {
    @NonNull
    private final RepositoryFactorySupport jpaRepositoryFactory;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final AllValuesProvider<Department> departmentLoader;
    @NonNull
    private final EntityManager entityManager;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;

    @Bean
    public Saver<Event, ?> eventSaver() {
        return new TransactionalSaver((Saver)new PreConvertingSaver((Converter)new EventToEntityConverter(), (Saver)new FlushingJpaSaver((JpaRepository)new SimpleJpaRepository(EventEntity.class, this.entityManager))), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public Eventer onlyCreatingEventer() {
        return new OnlyCreatingEventer(this.objectMapper);
    }

    @Bean
    public Eventer eventer() {
        return new SavingEventer(this.onlyCreatingEventer(), this.eventSaver());
    }

    @Bean
    public EventBus eventBus() {
        return new EventBus();
    }

    @Bean
    public SseController sseController() {
        return new SseController(this.eventBus());
    }

    @Bean
    public AllByIdsLoadable<Event, UUID> eventLoader() {
        EventEntityToEventConverter eventEntityToEventConverter = new EventEntityToEventConverter((AllByIdsLoadable)this.basicUserLoader, (AllByIdsLoadable)new AllByIdsLoadableByAllValuesProviderAdapter(this.departmentLoader));
        return ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)this.modelBeanBuilder.allByIdsLoader(EventEntity.class, (Converter)eventEntityToEventConverter).build());
    }

    @Bean
    public EventEntityLoader eventEntityLoader() {
        return (EventEntityLoader)this.jpaRepositoryFactory.getRepository(EventEntityLoader.class);
    }

    @ConstructorProperties(value={"jpaRepositoryFactory", "modelBeanBuilder", "objectMapper", "basicUserLoader", "departmentLoader", "entityManager", "defaultTransactionTemplateFactory"})
    @Generated
    public EventConfig(@NonNull RepositoryFactorySupport jpaRepositoryFactory, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull ObjectMapper objectMapper, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull AllValuesProvider<Department> departmentLoader, @NonNull EntityManager entityManager, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory) {
        Objects.requireNonNull(jpaRepositoryFactory, "jpaRepositoryFactory is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(entityManager, "entityManager is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        this.jpaRepositoryFactory = jpaRepositoryFactory;
        this.modelBeanBuilder = modelBeanBuilder;
        this.objectMapper = objectMapper;
        this.basicUserLoader = basicUserLoader;
        this.departmentLoader = departmentLoader;
        this.entityManager = entityManager;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
    }
}

