/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.SideThreadAuthenticationIsolator;
import cz.kpsys.portaro.batchimport.BatchImportController;
import cz.kpsys.portaro.batchimport.BatchImportSettingKeys;
import cz.kpsys.portaro.batchimport.BatchImporter;
import cz.kpsys.portaro.batchimport.BatchProcessor;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.TransactionalSaver;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.database.AdhocQueryer;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.LoadedIdentifiedFileCreator;
import cz.kpsys.portaro.file.directory.ParentableDirectoryCreator;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingEntity;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.DelegatingValueCustomSettingSaver;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.sql.generator.DbSpecificsFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.User;
import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BatchImportConfig {
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver;
    @NonNull
    private final @NonNull Provider<@NonNull Integer> rootDepartmentIdProvider;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final LoadedIdentifiedFileCreator loadedIdentifiedFileCreator;
    @NonNull
    private final @NonNull Provider<@NonNull Integer> portaroUserIdProvider;
    @NonNull
    private final @NonNull Provider<@NonNull User> portaroUserProvider;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final @NonNull Provider<@NonNull Department> rootDepartmentProvider;
    @NonNull
    private final @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider;
    @NonNull
    private final ParentableDirectoryCreator parentableDirectoryCreator;
    @NonNull
    private final Eventer eventer;
    @NonNull
    private final @NonNull Provider<@NonNull ZoneId> databaseColumnsTimeZoneProvider;
    @NonNull
    private final DatabaseProperties dbUpdateDatabaseProperties;
    @NonNull
    private final DbSpecificsFactory dbSpecificsFactory;

    @Bean
    public BatchImportController batchImportController() {
        return new BatchImportController(this.batchImporter());
    }

    @Bean
    public BatchImporter batchImporter() {
        return new BatchImporter(this.batchImportLastPathProvider(), this.batchImportLastPathSettingSaver(), this.batchProcessor(), this.eventer, (Department)this.rootDepartmentProvider.get(), new SideThreadAuthenticationIsolator(this.authenticationHolder, this.portaroUserProvider, this.executorService));
    }

    @Bean
    public BatchProcessor batchProcessor() {
        return new BatchProcessor(this.loadedIdentifiedFileCreator, this.parentableDirectoryCreator, this.portaroUserIdProvider, new SideThreadAuthenticationIsolator(this.authenticationHolder, this.portaroUserProvider, this.executorService), (Department)this.rootDepartmentProvider.get(), (FileAccessType)this.defaultFileAccessTypeProvider.get(), AdhocQueryer.createAlwaysEnabled((Provider)this.databaseColumnsTimeZoneProvider, (ContextualProvider)ContextIgnoringContextualProvider.of((Object)this.dbUpdateDatabaseProperties), (DbSpecificsFactory)this.dbSpecificsFactory));
    }

    @Bean
    public Saver<String, String> batchImportLastPathSettingSaver() {
        return new TransactionalSaver((Saver)new DelegatingValueCustomSettingSaver(this.customSettingSaver, (SettingTypeId)BatchImportSettingKeys.BATCH_IMPORT_LAST_PATH, this.rootDepartmentIdProvider, this.customSettingLoader), this.defaultTransactionTemplateFactory.get());
    }

    @Bean
    public Provider<@NullableNotBlank String> batchImportLastPathProvider() {
        return this.settingLoader.getOnRootProvider(BatchImportSettingKeys.BATCH_IMPORT_LAST_PATH);
    }

    @ConstructorProperties(value={"settingLoader", "customSettingSaver", "rootDepartmentIdProvider", "customSettingLoader", "defaultTransactionTemplateFactory", "loadedIdentifiedFileCreator", "portaroUserIdProvider", "portaroUserProvider", "authenticationHolder", "executorService", "rootDepartmentProvider", "defaultFileAccessTypeProvider", "parentableDirectoryCreator", "eventer", "databaseColumnsTimeZoneProvider", "dbUpdateDatabaseProperties", "dbSpecificsFactory"})
    @Generated
    public BatchImportConfig(@NonNull SettingLoader settingLoader, @NonNull Saver<CustomSetting<String>, CustomSettingEntity> customSettingSaver, @NonNull @NonNull Provider<@NonNull Integer> rootDepartmentIdProvider, @NonNull CustomSettingLoader customSettingLoader, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull LoadedIdentifiedFileCreator loadedIdentifiedFileCreator, @NonNull @NonNull Provider<@NonNull Integer> portaroUserIdProvider, @NonNull @NonNull Provider<@NonNull User> portaroUserProvider, @NonNull AuthenticationHolder authenticationHolder, @NonNull ExecutorService executorService, @NonNull @NonNull Provider<@NonNull Department> rootDepartmentProvider, @NonNull @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider, @NonNull ParentableDirectoryCreator parentableDirectoryCreator, @NonNull Eventer eventer, @NonNull @NonNull Provider<@NonNull ZoneId> databaseColumnsTimeZoneProvider, @NonNull DatabaseProperties dbUpdateDatabaseProperties, @NonNull DbSpecificsFactory dbSpecificsFactory) {
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentIdProvider, "rootDepartmentIdProvider is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileCreator, "loadedIdentifiedFileCreator is marked non-null but is null");
        Objects.requireNonNull(portaroUserIdProvider, "portaroUserIdProvider is marked non-null but is null");
        Objects.requireNonNull(portaroUserProvider, "portaroUserProvider is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(defaultFileAccessTypeProvider, "defaultFileAccessTypeProvider is marked non-null but is null");
        Objects.requireNonNull(parentableDirectoryCreator, "parentableDirectoryCreator is marked non-null but is null");
        Objects.requireNonNull(eventer, "eventer is marked non-null but is null");
        Objects.requireNonNull(databaseColumnsTimeZoneProvider, "databaseColumnsTimeZoneProvider is marked non-null but is null");
        Objects.requireNonNull(dbUpdateDatabaseProperties, "dbUpdateDatabaseProperties is marked non-null but is null");
        Objects.requireNonNull(dbSpecificsFactory, "dbSpecificsFactory is marked non-null but is null");
        this.settingLoader = settingLoader;
        this.customSettingSaver = customSettingSaver;
        this.rootDepartmentIdProvider = rootDepartmentIdProvider;
        this.customSettingLoader = customSettingLoader;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.loadedIdentifiedFileCreator = loadedIdentifiedFileCreator;
        this.portaroUserIdProvider = portaroUserIdProvider;
        this.portaroUserProvider = portaroUserProvider;
        this.authenticationHolder = authenticationHolder;
        this.executorService = executorService;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.defaultFileAccessTypeProvider = defaultFileAccessTypeProvider;
        this.parentableDirectoryCreator = parentableDirectoryCreator;
        this.eventer = eventer;
        this.databaseColumnsTimeZoneProvider = databaseColumnsTimeZoneProvider;
        this.dbUpdateDatabaseProperties = dbUpdateDatabaseProperties;
        this.dbSpecificsFactory = dbSpecificsFactory;
    }
}

