/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.ThisThreadAuthenticatingContextualRunner;
import cz.kpsys.portaro.business.consume.MultipleItemsConsumer;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.convert.ListToModifiedListConverter;
import cz.kpsys.portaro.commons.io.Failoverer;
import cz.kpsys.portaro.commons.io.FileDataStreamer;
import cz.kpsys.portaro.commons.io.NoopFailoverer;
import cz.kpsys.portaro.commons.object.ConvertingCachingProvider;
import cz.kpsys.portaro.commons.object.FilteredList;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.SimpleTransferer;
import cz.kpsys.portaro.commons.object.Transferer;
import cz.kpsys.portaro.commons.object.filter.WhitelistObjectFilter;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdOptLoadable;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.GenericHookableSaver;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.ext.obalkyknih.ObalkyknihSettingKeys;
import cz.kpsys.portaro.file.FileAccessType;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.file.ImageDownloader;
import cz.kpsys.portaro.file.custom.CustomFile;
import cz.kpsys.portaro.file.directory.ParentableDirectoryCreator;
import cz.kpsys.portaro.file.security.FileSecurityActions;
import cz.kpsys.portaro.file.security.IdentifiedFileSaveCommand;
import cz.kpsys.portaro.id.IDdFile;
import cz.kpsys.portaro.logging.Logged;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordEntity;
import cz.kpsys.portaro.record.RecordSettingKeys;
import cz.kpsys.portaro.record.file.RecordWithAttachmentSaveCommand;
import cz.kpsys.portaro.record.file.RecordWithAttachmentSaver;
import cz.kpsys.portaro.record.file.cover.BatchCoverImporter;
import cz.kpsys.portaro.record.file.cover.CoverDownloader;
import cz.kpsys.portaro.record.file.cover.CoverFactory;
import cz.kpsys.portaro.record.file.cover.CoverLoader;
import cz.kpsys.portaro.record.file.cover.CoverLoaderCustomFileTemplateByFond;
import cz.kpsys.portaro.record.file.cover.CoverSearchManager;
import cz.kpsys.portaro.record.file.cover.CoverService;
import cz.kpsys.portaro.record.file.cover.CoversToSearchLoader;
import cz.kpsys.portaro.record.file.cover.CoversTransferService;
import cz.kpsys.portaro.record.file.cover.FailoveredCoverDownloader;
import cz.kpsys.portaro.record.file.cover.GoogleBooksCoverLoader;
import cz.kpsys.portaro.record.file.cover.MultiLoaderCoverLoader;
import cz.kpsys.portaro.record.file.cover.NamedCoverLoader;
import cz.kpsys.portaro.record.file.cover.NamesByFondMapCoverLoaderClasspathFile;
import cz.kpsys.portaro.record.file.cover.OpenLibraryCoverLoader;
import cz.kpsys.portaro.record.file.cover.SpringDbCoversToSearchLoader;
import cz.kpsys.portaro.record.file.cover.SpringDbUnfoundCoverDeleter;
import cz.kpsys.portaro.record.file.cover.SpringDbUnfoundCoverSaver;
import cz.kpsys.portaro.record.file.cover.UnfoundCoverDeleter;
import cz.kpsys.portaro.record.file.cover.UnfoundCoverSaver;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.security.crud.SecuredAuthCommandSaver;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.tx.TransactionTemplateFactory;
import cz.kpsys.portaro.user.User;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestOperations;

@Configuration
@Lazy
public class AttachmentConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentConfig.class);
    @NonNull
    private final ByIdOptLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader;
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final FileDataStreamer securedFileThumbnailDataStreamer;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Deleter<IDdFile> identifiedFileDeleter;
    @NonNull
    private final @NonNull Provider<@NonNull Department> rootDepartmentProvider;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> richRecordLoader;
    @NonNull
    private final IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final Provider<User> portaroUserProvider;
    @NonNull
    private final ImageDownloader imageDownloader;
    @NonNull
    private final NamedCoverLoader obalkyknihCoverLoader;
    @NonNull
    private final TransactionTemplateFactory defaultTransactionTemplateFactory;
    @NonNull
    private final TransactionTemplateFactory readonlyTransactionTemplateFactory;
    @NonNull
    private final CoverFactory coverFactory;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final Saver<Record, RecordEntity> recordHeaderSaver;
    @NonNull
    private final @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider;
    @NonNull
    private final ParentableDirectoryCreator parentableDirectoryCreator;
    @NonNull
    private final Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver;
    @NonNull
    private final NamedParameterJdbcOperations notAutoCommittingJdbcTemplate;
    @NonNull
    private final Runnable saveTransactionAuthenticator;

    @Bean
    public CoverService coverService() {
        return new CoverService(this.securedFileThumbnailDataStreamer, this.fallbackCoverLoader(), this.allWebCoverLoader(), this.recordWithAttachmentSaver(), this.identifiedFileDeleter, this.securityManager, this.defaultTransactionTemplateFactory.get(), this.settingLoader.getDepartmentedProvider(RecordSettingKeys.FORBIDDEN_RECORDS), this.settingLoader.getDepartmentedProvider(RecordSettingKeys.FORBIDDEN_RECORD_STATUSES));
    }

    @Bean
    public CoverLoader fallbackCoverLoader() {
        CoverLoaderCustomFileTemplateByFond customCoversLoader = new CoverLoaderCustomFileTemplateByFond(this.hierarchyTraversingCustomFileLoader, this.securedFileThumbnailDataStreamer, "design", "default_cover_{fond}.png");
        NamesByFondMapCoverLoaderClasspathFile builtInCoversLoader = new NamesByFondMapCoverLoaderClasspathFile(this.coverFactory, "resources/img/covers/{name}.png", this.settingLoader.getOnRootProvider(SettingKeys.BUILT_IN_COVERS_BY_FONDS), "book");
        this.cacheService.registerCleaner((CacheCleaner)builtInCoversLoader);
        MultiLoaderCoverLoader multiLoader = new MultiLoaderCoverLoader("LocalDatabase", new CoverLoader[]{customCoversLoader, builtInCoversLoader});
        multiLoader.setThrowExceptions(true);
        return multiLoader;
    }

    @Bean
    public CoverDownloader coverDownloader() {
        return new FailoveredCoverDownloader(this.imageDownloader, (Failoverer)new NoopFailoverer(), this.coverFactory);
    }

    @Bean
    public List<NamedCoverLoader> webCoverLoaders() {
        return new FilteredList(List.of(this.obalkyknihCoverLoader, new OpenLibraryCoverLoader(this.coverDownloader()), new GoogleBooksCoverLoader(this.rest, this.coverDownloader())), (Predicate)new WhitelistObjectFilter((Collection)this.settingLoader.getOnRootProvidedList(SettingKeys.SERVICES), NamedCoverLoader::getServiceName));
    }

    @Bean
    public Provider<List<BatchCoverImporter>> coverImporters() {
        return ConvertingCachingProvider.of(() -> new ArrayList(this.webCoverLoaders()), (Converter)new ListToModifiedListConverter(webCoverLoader -> new BatchCoverImporter(webCoverLoader, this.recordWithAttachmentSaver(), this.unfoundCoverSaver(), this.defaultTransactionTemplateFactory.get())));
    }

    @Bean
    public CoverLoader allWebCoverLoader() {
        Provider obalkyKnihEnabledProvider = this.settingLoader.getOnRootProvider(ObalkyknihSettingKeys.OBALKYKNIH_ENABLED);
        ProvidedProxiedList webCoverLoaders = new ProvidedProxiedList(() -> {
            if (((Boolean)obalkyKnihEnabledProvider.get()).booleanValue()) {
                ArrayList<NamedCoverLoader> loaders = new ArrayList<NamedCoverLoader>(this.webCoverLoaders());
                loaders.remove(this.obalkyknihCoverLoader);
                loaders.addFirst(this.obalkyknihCoverLoader);
                return loaders;
            }
            return this.webCoverLoaders();
        });
        MultiLoaderCoverLoader multiLoader = new MultiLoaderCoverLoader("AllWebCoverLoaders", (List)webCoverLoaders);
        multiLoader.setThrowExceptions(false);
        return multiLoader;
    }

    @Bean
    public CoversToSearchLoader vyhledavaneObalkyDokumentuLoader() {
        return new SpringDbCoversToSearchLoader(this.jdbcTemplate, this.queryFactory, (AllByIdsLoadable)this.richRecordLoader, this.settingLoader.getOnRootProvidedList(RecordSettingKeys.FORBIDDEN_RECORD_STATUSES));
    }

    @Bean
    public UnfoundCoverDeleter unfoundCoverDeleter() {
        return new SpringDbUnfoundCoverDeleter(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public CoverSearchManager coverSearchManager() {
        return new CoverSearchManager(this.coverImporters(), this.vyhledavaneObalkyDokumentuLoader(), this.unfoundCoverDeleter(), this.executorService, this.readonlyTransactionTemplateFactory.get());
    }

    @Logged
    @Scheduled(cron="0 0 20 * * *")
    public void startCoverSearchingCron() {
        this.coverSearchingRunner().accept((Department)this.rootDepartmentProvider.get());
    }

    @Bean
    public Consumer<Department> coverSearchingRunner() {
        return new ThisThreadAuthenticatingContextualRunner(this.authenticationHolder, this.portaroUserProvider, currentAuth -> this.coverSearchManager().startCoverSearching((Department)this.rootDepartmentProvider.get(), currentAuth));
    }

    @Bean
    public UnfoundCoverSaver unfoundCoverSaver() {
        return new SpringDbUnfoundCoverSaver(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public CoversTransferService coversTransferService() {
        return new CoversTransferService((Transferer)new SimpleTransferer(), new MultipleItemsConsumer(this.recordWithAttachmentSaver(), true), this.nonDetailedRichRecordLoader, this.coverFactory);
    }

    @Bean
    public Saver<RecordWithAttachmentSaveCommand, IdentifiedFile> recordWithAttachmentSaver() {
        RecordWithAttachmentSaver delegate = new RecordWithAttachmentSaver(this.recordHeaderSaver, this.loadedIdentifiedFileSaver, this.defaultFileAccessTypeProvider, this.parentableDirectoryCreator, this.notAutoCommittingJdbcTemplate, this.queryFactory, this.defaultTransactionTemplateFactory.get());
        return new GenericHookableSaver((Saver)new SecuredAuthCommandSaver((Saver)delegate, FileSecurityActions.FILES_MANAGE, this.securityManager)).addPreHook(this.saveTransactionAuthenticator);
    }

    @ConstructorProperties(value={"hierarchyTraversingCustomFileLoader", "rest", "securedFileThumbnailDataStreamer", "cacheService", "settingLoader", "identifiedFileDeleter", "rootDepartmentProvider", "jdbcTemplate", "queryFactory", "executorService", "richRecordLoader", "nonDetailedRichRecordLoader", "authenticationHolder", "portaroUserProvider", "imageDownloader", "obalkyknihCoverLoader", "defaultTransactionTemplateFactory", "readonlyTransactionTemplateFactory", "coverFactory", "securityManager", "recordHeaderSaver", "defaultFileAccessTypeProvider", "parentableDirectoryCreator", "loadedIdentifiedFileSaver", "notAutoCommittingJdbcTemplate", "saveTransactionAuthenticator"})
    @Generated
    public AttachmentConfig(@NonNull ByIdOptLoadable<CustomFile, String> hierarchyTraversingCustomFileLoader, @NonNull RestOperations rest, @NonNull FileDataStreamer securedFileThumbnailDataStreamer, @NonNull CacheService cacheService, @NonNull SettingLoader settingLoader, @NonNull Deleter<IDdFile> identifiedFileDeleter, @NonNull @NonNull Provider<@NonNull Department> rootDepartmentProvider, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ExecutorService executorService, @NonNull IdAndIdsLoadable<Record, UUID> richRecordLoader, @NonNull IdAndIdsLoadable<Record, UUID> nonDetailedRichRecordLoader, @NonNull AuthenticationHolder authenticationHolder, @NonNull Provider<User> portaroUserProvider, @NonNull ImageDownloader imageDownloader, @NonNull NamedCoverLoader obalkyknihCoverLoader, @NonNull TransactionTemplateFactory defaultTransactionTemplateFactory, @NonNull TransactionTemplateFactory readonlyTransactionTemplateFactory, @NonNull CoverFactory coverFactory, @NonNull SecurityManager securityManager, @NonNull Saver<Record, RecordEntity> recordHeaderSaver, @NonNull @NonNull Provider<@NonNull FileAccessType> defaultFileAccessTypeProvider, @NonNull ParentableDirectoryCreator parentableDirectoryCreator, @NonNull Saver<IdentifiedFileSaveCommand, IdentifiedFile> loadedIdentifiedFileSaver, @NonNull NamedParameterJdbcOperations notAutoCommittingJdbcTemplate, @NonNull Runnable saveTransactionAuthenticator) {
        Objects.requireNonNull(hierarchyTraversingCustomFileLoader, "hierarchyTraversingCustomFileLoader is marked non-null but is null");
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(securedFileThumbnailDataStreamer, "securedFileThumbnailDataStreamer is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(identifiedFileDeleter, "identifiedFileDeleter is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(richRecordLoader, "richRecordLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedRichRecordLoader, "nonDetailedRichRecordLoader is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(portaroUserProvider, "portaroUserProvider is marked non-null but is null");
        Objects.requireNonNull(imageDownloader, "imageDownloader is marked non-null but is null");
        Objects.requireNonNull(obalkyknihCoverLoader, "obalkyknihCoverLoader is marked non-null but is null");
        Objects.requireNonNull(defaultTransactionTemplateFactory, "defaultTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(readonlyTransactionTemplateFactory, "readonlyTransactionTemplateFactory is marked non-null but is null");
        Objects.requireNonNull(coverFactory, "coverFactory is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(recordHeaderSaver, "recordHeaderSaver is marked non-null but is null");
        Objects.requireNonNull(defaultFileAccessTypeProvider, "defaultFileAccessTypeProvider is marked non-null but is null");
        Objects.requireNonNull(parentableDirectoryCreator, "parentableDirectoryCreator is marked non-null but is null");
        Objects.requireNonNull(loadedIdentifiedFileSaver, "loadedIdentifiedFileSaver is marked non-null but is null");
        Objects.requireNonNull(notAutoCommittingJdbcTemplate, "notAutoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        this.hierarchyTraversingCustomFileLoader = hierarchyTraversingCustomFileLoader;
        this.rest = rest;
        this.securedFileThumbnailDataStreamer = securedFileThumbnailDataStreamer;
        this.cacheService = cacheService;
        this.settingLoader = settingLoader;
        this.identifiedFileDeleter = identifiedFileDeleter;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.executorService = executorService;
        this.richRecordLoader = richRecordLoader;
        this.nonDetailedRichRecordLoader = nonDetailedRichRecordLoader;
        this.authenticationHolder = authenticationHolder;
        this.portaroUserProvider = portaroUserProvider;
        this.imageDownloader = imageDownloader;
        this.obalkyknihCoverLoader = obalkyknihCoverLoader;
        this.defaultTransactionTemplateFactory = defaultTransactionTemplateFactory;
        this.readonlyTransactionTemplateFactory = readonlyTransactionTemplateFactory;
        this.coverFactory = coverFactory;
        this.securityManager = securityManager;
        this.recordHeaderSaver = recordHeaderSaver;
        this.defaultFileAccessTypeProvider = defaultFileAccessTypeProvider;
        this.parentableDirectoryCreator = parentableDirectoryCreator;
        this.loadedIdentifiedFileSaver = loadedIdentifiedFileSaver;
        this.notAutoCommittingJdbcTemplate = notAutoCommittingJdbcTemplate;
        this.saveTransactionAuthenticator = saveTransactionAuthenticator;
    }
}

