<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>

<div class="container uc-sdi-requests">
    <div class="row">
        <div class="col-lg-6 col-xs-12">
            <h1>${loc.loc("sdi.SdiRequests")?noEsc}</h1>
        </div>
        <div class="col-lg-6 col-xs-12 show-all-switch" ng-show="$ctrl.showAllOption">
            <kp-svelte-component-wrapper
                    component="::$ctrl.kpValueEditorComponent"
                    props="{
                        type: 'boolean',
                        editorId: 'show-for-all-users-switch',
                        model: $ctrl.showAll}"
                    ng-on-model-change="$ctrl.showAll = $event.originalEvent.detail; $ctrl.loadSdiRequests();">
            </kp-svelte-component-wrapper>
            <label for="show-for-all-users-switch" ng-click="$ctrl.showAll = !$ctrl.showAll; $ctrl.loadSdiRequests();">
                ${loc.loc("commons.ShowForAllUsers")}
            </label>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12">
            <div ng-repeat="request in $ctrl.requests" class="panel panel-default" ng-class="{'text-success': request.active, 'text-muted': !request.active}">
                <div class="panel-body">
                    <kp-sdi-request-list-item request="request" requests="$ctrl.requests" show-user="true"></kp-sdi-request-list-item>
                </div>
            </div>

            <div ng-show="$ctrl.requests.length === 0">
                ${loc.loc("commons.ZadnePolozky")}
            </div>
        </div>
    </div>
</div>