<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>

<div class="selectable-exemplar-card">

    <div class="panel panel-default"
         ng-class="{
            'panel-success': $ctrl.isAvailable() && !$ctrl.isSelected,
            'panel-danger': $ctrl.isNotAvailable() && !$ctrl.isSelected,
            'panel-primary': $ctrl.isSelected}">

        <div class="panel-heading">
            <span>{{$ctrl.exemplar.designation}}</span>
            <span ng-if="$ctrl.exemplar.document.name"> - {{$ctrl.exemplar.document.name}}</span>
        </div>

        <div class="panel-body">
            <span>{{$ctrl.exemplar.loanCategory | loc}}</span>
            <br/>
            <span ng-if="$ctrl.exemplar.availability">
                    ${loc.loc("commons.dostupnost")?noEsc}:

                    <span ng-class="{'text-success': $ctrl.isAvailable(), 'text-danger': $ctrl.isNotAvailable()}">
                        <strong>
                            {{$ctrl.exemplar.availability | loc}}
                            <span ng-if="$ctrl.exemplar.holder">
                                - <a ui-sref="user({userId: $ctrl.exemplar.holder.id})">{{$ctrl.exemplar.holder | loc}}</a>
                            </span>
                        </strong>
                    </span>
                </span>
        </div>
    </div>

</div>