<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>


<div jp-loading="xs" ng-show="!$ctrl.exemplarList">${loc.loc("detail.nacitamExemplare")?noEsc}</div>

<h3 ng-if="$ctrl.exemplarList.type === 'bindings' && ($ctrl.exemplarList.canCreateAny() || $ctrl.exemplarList && !$ctrl.exemplarList.empty)">${loc.loc("detail.svazaneRocniky")?noEsc}</h3>

<div class="text-muted" ng-if="!$ctrl.exemplarList.canEditAny() && $ctrl.exemplarList && $ctrl.exemplarList.empty && !$ctrl.document.downloadable">
    <span ng-if="$ctrl.document.status.id === 2 || $ctrl.document.status.id === 3">${loc.loc("detail.DokumentJeVeZpracovani")?noEsc}</span>
    <span ng-if="$ctrl.document.status.id !== 2 && $ctrl.document.status.id !== 3" ng-switch="$ctrl.exemplarList.type">
        <span ng-switch-when="issues">${loc.loc("detail.ZadneExemplareKDispozici")?noEsc}</span>
        <span ng-switch-when="bindings">${loc.loc("detail.dokumentNemaZadneSvazaneRocniky")?noEsc}</span>
        <span ng-switch-default>${loc.loc("detail.ZadneExemplareKDispozici")?noEsc}</span>
    </span>
</div>

<div ng-if="$ctrl.exemplarList && (!$ctrl.exemplarList.empty || $ctrl.exemplarList.canCreateAny())">
    <uib-tabset ng-class="{'tabs-thin': $ctrl.exemplarList.divisionsLength > 5, 'tabs-extra-thin': $ctrl.exemplarList.divisionsLength > 10}">
        <uib-tab ng-repeat="division in $ctrl.exemplarList.divisions">
            <uib-tab-heading ng-class="{'text-muted': division.exemplars.length === 0}">
                <span ng-if="$ctrl.settings.exemplarTabsByBuildingsEnabled">
                    {{division.building | loc}}
                    <span class="text-muted" ng-bind="division.exemplars.length"></span>
                </span>

                <span ng-if="!$ctrl.settings.exemplarTabsByBuildingsEnabled">
                    <span ng-if="$ctrl.exemplarList.type === 'exemplars'">${loc.loc("detail.exemplare")?noEsc}</span>
                    <span ng-if="$ctrl.exemplarList.type === 'bindings'">${loc.loc("detail.svazaneRocniky")?noEsc}</span>
                    <span class="text-muted" ng-bind="division.exemplars.length"></span>
                </span>
            </uib-tab-heading>

            <div class="panel panel-default">
                <kp-exemplar-list
                        exemplars="division.exemplars"
                        type="$ctrl.exemplarList.type"
                        document="$ctrl.document"
                        properties="$ctrl.properties"
                        exemplar-filter="$ctrl.exemplarList.exemplarFilter">
                </kp-exemplar-list>

                <div class="panel-body text-center" ng-if="$ctrl.exemplarList.canCreateWithDepartment(division.building)">
                    <button type="button" class="btn btn-default btn-sm" ng-click="$ctrl.createExemplar(division.building)" data-qa="create-new-exemplar-button">${loc.loc("commons.pridatExemplar")?noEsc}</button>
                </div>
            </div>
        </uib-tab>
    </uib-tabset>
</div>
