<#ftl outputFormat="HTML">
<#import "../../../../freemarker/_localization.ftl" as loc>

<div class="edited-fields-container" ng-form="$ctrl.editationForm">

    <div ng-repeat="fieldType in $ctrl.editation.editation().usedFieldTypes track by fieldType.id" class="field-type-block" ng-class="{'field-type-block-repeatable': fieldType.repeatable}">

        <!-- jednotlive vyskyty tohoto pole -->
        <div id="{{field.code}}{{::'#'}}{{$index}}" class="panel panel-success field-block field_{{field.code}}" ng-repeat="field in $ctrl.editation.fields().filter($ctrl.ofCode(fieldType.code)) track by field.id">

            <#-- FIELD HEADER -->
            <div ng-click="$ctrl.editation.toggleFieldCollapsed(field)" class="panel-heading field-heading container-fluid" ng-class="{'btn btn-block btn-sm': $ctrl.editation.isFieldManuallyCollapsible(field)}">

                <div class="col-md-4">
                    <div>
                        <span ng-if="$ctrl.showFieldIdentifiers" class="subfield-type-code">{{fieldType.code}}</span>
                        <strong>{{fieldType | loc}}</strong>
                    </div>
                    <div ng-if="fieldType.editNote" class="text-muted small">
                        <kp-string-collapser value="fieldType.editNote" characters-limit="160" />
                    </div>
                </div>

                <#-- EDITACE POLE -->
                <div class="col-md-7 field-heading-editor">
                    <div ng-if="field.primaryField" ng-init="subfieldType = $ctrl.editation.getEditableSubfieldTypeById(field.primaryField.typeId); field.primaryField.originalValue = field.primaryField.value; view = {editing: $ctrl.editation.isInitiallyEdited(field.primaryField)}" ngf-drop="$ctrl.onFileDrop(field.primaryField, $files)" ngf-drag-over-class="'file-drag-over'" ng-class="{'entry-subfield-type': subfieldType.entryElement}" class="primary-subfield-block field_{{field.primaryField.code}} subfield_{{field.primaryField.code}}">
                        <#-- WARNING: `subfieldType` can be undefined (e.g. if editation style is not set) -->
                        <kp-svelte-component-wrapper ng-if="subfieldType"
                                                     component="::$ctrl.fieldEditFormComponent"
                                                     props="{
                                                                forceSettings: [
                                                                    {type: 'acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'single-acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'multiple-acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'text', options: {switchToTextareaThreshold: 80}, strategy: 'merge'},
                                                                    {type: 'record', options: {editParams: {focusedFieldTypeId: subfieldType.targetAuthorityLinkedSubfieldType.value}}, strategy: 'merge'},
                                                                    {type: 'field7', options: {createParams: {fond: $ctrl.editation.editation().fond}, editParams: {fond: $ctrl.editation.editation().fond}}, strategy: 'merge'},
                                                                    {type: 'field8', options: {createParams: {fond: $ctrl.editation.editation().fond}, editParams: {fond: $ctrl.editation.editation().fond}}, strategy: 'merge'}],
                                                                fieldOrSubfieldType: subfieldType,
                                                                field: field.primaryField,
                                                                showRecordLink: subfieldType.editor.type === 'record' && field.primaryField.value}"
                                                     ng-on-field-value-submit="$ctrl.submitFieldValue(field.primaryField)">
                        </kp-svelte-component-wrapper>
                    </div>

                    <div ng-if="!field.primaryField && fieldType.editor">
                        <kp-svelte-component-wrapper component="::$ctrl.fieldEditFormComponent"
                                                     props="{
                                                                forceSettings: [
                                                                    {type: 'acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'single-acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'multiple-acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'text', options: {switchToTextareaThreshold: 80}, strategy: 'merge'},
                                                                    {type: 'record', options: {editParams: {focusedFieldTypeId: fieldType.targetAuthorityLinkedSubfieldType.value}}, strategy: 'merge'},
                                                                    {type: 'field7', options: {createParams: {fond: $ctrl.editation.editation().fond}, editParams: {fond: $ctrl.editation.editation().fond}}, strategy: 'merge'},
                                                                    {type: 'field8', options: {createParams: {fond: $ctrl.editation.editation().fond}, editParams: {fond: $ctrl.editation.editation().fond}}, strategy: 'merge'}],
                                                                fieldOrSubfieldType: fieldType,
                                                                field: field}"
                                                     ng-on-field-value-submit="$ctrl.submitFieldValue(field)">
                        </kp-svelte-component-wrapper>
                    </div>

                    <div ng-if="!field.primaryField && !fieldType.editor">
                        <#-- VYPSANA PODPOLE -->
                        <span class="field-heading-inlined-subfields">
                            <span ng-if="!field.value.id" ng-attr-title="{{field | loc}}">
                                {{field | loc}}
                            </span>
                            <span ng-if="field.value.id">
                                <a kp-href="/records/{{field.value.id}}" target="_blank">{{field | loc}}</a>
                            </span>
                        </span>
                    </div>
                </div>

                <#-- SMAZAT POLE -->
                <div class="col-md-1">
                    <div class="overlaid-dropdown field-delete-container btn-group pull-right" jp-visible-on-hover-parent=".field-type-block">
                        <div class="field-delete-dropdown dropdown-toggle">
                            <span class="glyphicon glyphicon-option-horizontal"></span>
                        </div>
                        <ul class="field-delete-button dropdown-menu open">
                            <li>
                                <a href="" ng-click="$ctrl.editation.deleteField(field); $event.stopPropagation();" class="btn-xs">
                                    Smazat výskyt
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <#-- FIELD BODY -->
            <div ng-if="!$ctrl.editation.isFieldCollapsed(field)" class="panel-body datafield-body">

                <#-- FIELD INDICATORS -->
                <div class="indicators-editation" ng-if="::$ctrl.showIndicators && fieldType.indicator1Type && fieldType.indicator2Type" ng-init="view = {editing: false}">
                    <#-- exclude control fields that dont have indicators -->
                    <div class="col-md-4">
                        <span class="indicators-title">
                            ${loc.loc("commons.indikatory")?noEsc}
                        </span>
                    </div>
                    <div class="col-md-8">

                        <span ng-if="!view.editing">
                            <span class="indicator" ng-attr-title="{{field.ind1 | loc}}">{{field.ind1.id}}</span><span class="indicator" ng-attr-title="{{field.ind2 | loc}}">{{field.ind2.id}}</span>
                        </span>

                        <span ng-if="!view.editing" jp-visible-on-hover-parent=".indicators-editation">
                            <button ng-click="view.editing = true" class="btn btn-default btn-xs indicators-edit-button">
                                <span class="glyphicon glyphicon-pencil"></span>
                            </button>
                        </span>

                        <span ng-if="view.editing" class="pull-left">
                            <kp-svelte-component-wrapper component="::$ctrl.indicatorsEditFormComponent"
                                                         props="{fieldType: fieldType, field: field}"
                                                         ng-on-save="view.editing = false; $ctrl.editation.setFieldIndicators(field)"
                                                         ng-on-cancel="view.editing = false">
                            </kp-svelte-component-wrapper>
                        </span>

                    </div>
                    <div class="cleaner"></div>
                </div>

                <#-- SUBFIELD LIST -->
                <div class="subfields-list">

                    <div ng-repeat="subfield in field.fields track by subfield.id" ng-init="subfieldType = $ctrl.editation.getEditableSubfieldTypeById(subfield.typeId); subfield.originalValue = subfield.value; view = {editing: $ctrl.editation.isInitiallyEdited(subfield)}" ngf-drop="$ctrl.onFileDrop(subfield, $files)" ngf-drag-over-class="'file-drag-over'" ng-class="{'entry-subfield-type': subfieldType.entryElement}" class="subfield-block field_{{subfield.code}} subfield_{{subfield.code}}">
                        <#-- WARNING: `subfieldType` can be undefined (e.g. if editation style is not set) -->
                        <div class="col-md-4" ng-init="helpExpanded = false">
                            <div>
                                <span ng-if="$ctrl.showFieldIdentifiers" class="subfield-type-code">{{subfieldType.code}}</span>
                                <span>{{subfieldType | loc}}</span>
                            </div>
                            <div ng-if="subfieldType.editNote" class="text-muted small">
                                <kp-string-collapser value="subfieldType.editNote" characters-limit="50" />
                            </div>
                        </div>

                        <div class="col-md-5">
                            <kp-svelte-component-wrapper ng-if="subfieldType"
                                                         component="::$ctrl.fieldEditFormComponent"
                                                         props="{
                                                                forceSettings: [
                                                                    {type: 'acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'single-acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'multiple-acceptable', options: {switchToInlineModeThreshold: 1, optionIdAsModel: true}, strategy: 'merge'},
                                                                    {type: 'text', options: {switchToTextareaThreshold: 80}, strategy: 'merge'},
                                                                    {type: 'record', options: {editParams: {focusedFieldTypeId: subfieldType.targetAuthorityLinkedSubfieldType.value}}, strategy: 'merge'}],
                                                                fieldOrSubfieldType: subfieldType,
                                                                field: subfield,
                                                                showRecordLink: subfieldType.editor.type === 'record' && subfield.value}"
                                                         ng-on-field-value-submit="$ctrl.submitFieldValue(subfield)">
                            </kp-svelte-component-wrapper>
                        </div>

                        <div class="col-md-3">
                            <span ng-if="!subfield.empty" jp-visible-on-hover-parent=".subfield-block">
                                <button type="button" ng-click="$ctrl.editation.clearFieldValue(subfield)" class="btn btn-default btn-xs field-value-delete-button">
                                    <span class="glyphicon glyphicon-trash"></span>
                                    ${loc.loc("commons.Smazat")?noEsc}
                                </button>
                            </span>

                            <span class="pull-right" jp-visible-on-hover-parent=".subfield-block">
                                <button ng-click="$ctrl.editation.moveSubfieldUp(subfield)" ng-class="{'jp-hidden': $first}" class="btn btn-default btn-xs subfield-move-button">
                                    <span class="glyphicon glyphicon-arrow-up"></span>
                                </button>
                                <button ng-click="$ctrl.editation.moveSubfieldDown(subfield)" ng-class="{'jp-hidden': $last}" class="btn btn-default btn-xs subfield-move-button">
                                    <span class="glyphicon glyphicon-arrow-down"></span>
                                </button>
                            </span>
                        </div>

                        <div class="cleaner"></div>

                    </div>

                </div>
                <#-- KONEC SUBFIELDS LIST -->

                <#-- Přidání dalšího podpole -->
                <div jp-visible-on-hover-parent=".field-block">
                    <kp-svelte-component-wrapper ng-if="field.addableFieldTypes"
                                                 component="::$ctrl.emptyFieldAddMenuComponent"
                                                 props="{addableFieldTypes: field.addableFieldTypes, localizedText: '${loc.loc("editace.PridejDalsiPodpole")?noEsc}', size: 'sm'}"
                                                 ng-on-add-field="$ctrl.editation.addEmptySubfield(field, $event.originalEvent.detail)">
                    </kp-svelte-component-wrapper>
                </div>

            </div>
        </div>

        <#-- Pridani opakovani pole -->
        <div ng-if="fieldType.repeatable">
            <button ng-click="$ctrl.editation.addEmptyField(fieldType)" jp-visible-on-hover-parent=".field-type-block" class="btn btn-default btn-block btn-xs field-repeat-button">
                <span class="glyphicon glyphicon-plus"></span>
                ${loc.loc("editace.PridejDalsiPole")?noEsc} {{fieldType | loc | characters:30}}
            </button>
        </div>

    </div>

    <#-- Pridani dalsiho pole -->
    <kp-svelte-component-wrapper ng-if="$ctrl.editation.editation().addableFieldTypes"
                                 component="::$ctrl.emptyFieldAddMenuComponent"
                                 props="{addableFieldTypes: $ctrl.editation.editation().addableFieldTypes, localizedText: '${loc.loc("editace.PridejDalsiPole")?noEsc}'}"
                                 ng-on-add-field="$ctrl.addEmptyField($event.originalEvent.detail)">
    </kp-svelte-component-wrapper>
</div>