<#ftl outputFormat="HTML">
<#import "../../../../../freemarker/_localization.ftl" as loc>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true" ng-click="$ctrl.close()">&times;</button>
    <h3 class="modal-title">
        <span ng-show="$ctrl.recordEditationService.text()" data-qa="record-editation-record-name">{{$ctrl.recordEditationService.text()}}</span>
        <span ng-show="!$ctrl.recordEditationService.text()">${loc.loc("editace.Untitled")?noEsc}</span>
        <span ng-show="$ctrl.recordEditationService.isDraft()" class="text-muted">(${loc.loc("editace.draft")?noEsc})</span>
    </h3>
</div>

<div class="modal-body record-editation modal-record-editation">

    <div class="row">
        <div class="col-xs-7">
            <button ng-show="$ctrl.recordEditationService.isDraft()" ng-click="$ctrl.publishDraftAndClose()" class="btn btn-primary" data-qa="record-editation-publish-and-close">
                ${loc.loc("editace.PublishAndClose")?noEsc}
            </button>

            <button ng-show="!$ctrl.recordEditationService.isDraft()" ng-click="$ctrl.saveAndClose()" class="btn btn-primary" data-qa="record-editation-save-and-close">
                ${loc.loc("editace.SaveAndClose")?noEsc}
            </button>

            <button ng-show="$ctrl.recordEditationService.isDraft()" ng-click="$ctrl.deleteDraftAndClose()" class="btn btn-default" data-qa="record-editation-discard-concept">
                ${loc.loc("editace.DiscardConcept")?noEsc}
            </button>

            <button ng-show="!$ctrl.recordEditationService.isDraft()" ng-click="$ctrl.discardAndClose()" class="btn btn-default" data-qa="record-editation-close">
                ${loc.loc("commons.zavrit")?noEsc}
            </button>

            <span style="margin-left: 10px;">
                <span ng-show="$ctrl.recordEditationService.state() !== 'PROCESSING' && $ctrl.recordEditationService.isRevisionSaved()" class="text-muted">
                    <span class="glyphicon glyphicon-ok"></span>
                    <span>${loc.loc("editace.AllChangesSaved")?noEsc}</span>
                </span>
                <span jp-loading="xs" ng-show="$ctrl.recordEditationService.state() === 'PROCESSING'"></span>
            </span>
        </div>

        <div class="col-xs-5">
            <form class="form-inline pull-right" ng-if="$ctrl.recordEditationService.fondSelectionEditor()" ng-submit="$ctrl.recordEditationService.setFond($ctrl.recordEditationService.editation().fond.id)" name="fondSelectForm">
                <div class="form-group">
                    <label for="record-editation-modal-fond-select">${loc.loc("editace.vyberFond")?noEsc}:</label>
                    <kp-svelte-component-wrapper component="::$ctrl.kpValueEditorForceSettingsWrapper"
                                                 props="{
                                                    forceSettings: [
                                                        {type: 'acceptable', options: {switchToInlineModeThreshold: 1}},
                                                        {type: 'single-acceptable', options: {switchToInlineModeThreshold: 1}},
                                                        {type: 'multiple-acceptable', options: {switchToInlineModeThreshold: 1}}],
                                                    type: $ctrl.recordEditationService.fondSelectionEditor().type,
                                                    editorId: 'record-editation-modal-fond-select',
                                                    options: $ctrl.recordEditationService.fondSelectionEditor().options,
                                                    validations: $ctrl.recordEditationService.fondSelectionEditor().validations,
                                                    model: $ctrl.recordEditationService.editation().fond,
                                                    size: 'sm'}"
                                                 ng-on-model-change="$ctrl.recordEditationService.setFond($event.originalEvent.detail)">
                    </kp-svelte-component-wrapper>
                </div>
            </form>
        </div>
    </div>

    <kp-record-editation editation="$ctrl.recordEditationService"
                         show-indicators="$ctrl.recordEditationService.showIndicators()"
                         show-field-identifiers="$ctrl.recordEditationService.showFieldIdentifiers()">
    </kp-record-editation>

</div>
