<#ftl outputFormat="HTML">
<#import "../../../../../freemarker/_localization.ftl" as loc>

<div class="panel-heading">
    <div class="pull-left">
        <ng-transclude>
            <h2 class="unset-style">
                <strong>${loc.loc("commons.ProvozniDoba")?noEsc}</strong>
            </h2>
        </ng-transclude>
    </div>
    <div ng-if="occc.data.notice" class="pull-right"><strong>{{occc.data.notice}}</strong></div>
    <div class="clearfix"></div>
</div>
<div class="panel-body">
    <table>
        <tbody>
            <tr ng-repeat="day in occc.data.days" ng-class="{'current-day': day.current}">
                <td class="day-name">{{day.dayText}}</td>
                <td ng-repeat="range in day.ranges track by $index"><span ng-if="range">{{range.fromTime}} - {{range.toTime}}</span></td>
            </tr>
        </tbody>
        <tfoot>
            <tr ng-repeat="note in occc.data.notes">
                <td colspan="{{occc.data.count + 1}}">{{note}}</td>
            </tr>
        </tfoot>
    </table>
</div>