<#ftl outputFormat="HTML">
<#import "../../../../../freemarker/_localization.ftl" as loc>

<div class="pull-right" ng-if="!$ctrl.request.active">${loc.loc("commons.Vypnuto")?noEsc}</div>

<p ng-class="{'overwritten-value': !$ctrl.request.active}">
    <span ng-bind-html="'${loc.loc("sdi.ZasilaniX")?noEsc}' | strParams : $ctrl.request.text"></span>
    <span ng-if="$ctrl.showUser">(<a ui-sref="user({userId: $ctrl.request.user.id})">{{$ctrl.request.user | loc}}</a>)</span>
    <br />
    - {{$ctrl.request.periodicity | loc}} <span
            ng-show="$ctrl.request.terminationDate">${loc.loc("commons.to")?noEsc} {{$ctrl.request.terminationDate | jpDate : 'd.M.yyyy'}}</span>
</p>

<p class="text-muted">${loc.loc("commons.Vytvoreno")?noEsc} {{$ctrl.request.createDate | jpDate : 'd.M.yyyy'}}</p>

<p>
<div class="btn-group" uib-dropdown>
    <button type="button" class="btn btn-default btn-xs" ng-click="$ctrl.toggleSdiRequestActive()">
        <span ng-if="$ctrl.request.active">${loc.loc("commons.Vypnout")?noEsc}</span>
        <span ng-if="!$ctrl.request.active">${loc.loc("commons.Zapnout")?noEsc}</span>
    </button>

    <button type="button"
            class="btn btn-default btn-xs dropdown-toggle"
            ng-if="$ctrl.request.deletable || $ctrl.currentAuthService.hasRole('ROLE_ADMIN')"
            uib-dropdown-toggle>
        <span class="caret"></span>
    </button>

    <ul ng-if="$ctrl.request.deletable || $ctrl.currentAuthService.hasRole('ROLE_ADMIN')" uib-dropdown-menu>
        <li><a class="btn-xs" href="" ng-click="$ctrl.removeSdiRequest()">${loc.loc("commons.Smazat")?noEsc}</a></li>
    </ul>
</div>

<a class="btn btn-default btn-xs" kp-href="search?finalRawQuery={{$ctrl.request.query | encodeUri}}">${loc.loc("sdi.ZobrazitVyhledaneZaznamy")?noEsc}</a>

<kp-action-request-button ng-if="$ctrl.currentAuthService.hasRole('ROLE_ADMIN')"
                         css-class="btn btn-default btn-xs"
                         path="{{CONTEXT_PATH}}/api/sdi/send?request={{$ctrl.request.id}}&force=true">Send
</kp-action-request-button>

<button type="button" class="btn btn-xs btn-default" ng-click="$ctrl.showSendings()">
    <span class="glyphicon glyphicon-zoom-in" ng-hide="$ctrl.isSendingsVisible"></span>
    <span class="glyphicon glyphicon-zoom-out" ng-show="$ctrl.isSendingsVisible"></span>
</button>
</p>

<div ng-show="$ctrl.isSendingsVisible">
    <div ng-if="!$ctrl.sendings" jp-loading="xs"></div>
    <div class="text-muted" ng-if="$ctrl.sendings && $ctrl.sendings.length === 0">${loc.loc("commons.ZadnePolozky")?noEsc}</div>

    <ul ng-if="$ctrl.sendings">
        <li ng-repeat="sending in $ctrl.sendings">
            <span ng-class="{'text-muted': sending.recordsCount === 0}">${loc.loc("commons.Vyhledano")?noEsc} {{sending.date | date:'d.M.yyyy HH:mm'}}, {{'${loc.loc("sdi.NalezenoXNovinek")?noEsc}' | strParams : sending.recordsCount}}</span>
            <span class="text-danger" ng-show="sending.error">CHYBA</span>

            <kp-action-request-button ng-if="$ctrl.currentAuthService.hasRole('ROLE_ADMIN')" css-class="btn btn-link btn-xs"
                                     path="{{CONTEXT_PATH}}/api/sdi/resend?sending={{sending.id}}">resend
            </kp-action-request-button>
        </li>
    </ul>
</div>