<#ftl outputFormat="HTML">
<#import "../../../../../freemarker/_localization.ftl" as loc>

<div class="detail-blok detail-blok-komentare" ng-cloak>

    <uib-tabset>
        <uib-tab active="true">
            <uib-tab-heading>
                ${loc.loc("detail.komentare")?noEsc}
            </uib-tab-heading>
            <div class="panel panel-default">
                <div class="panel-body text-muted text-center" ng-if="$ctrl.comments.length === 0">
                    ${loc.loc("commons.ZadnePolozky")?noEsc}
                </div>
                <ul class="list-group">
                    <li class="comment-list list-group-item clearfix" ng-repeat="c in $ctrl.comments">
                        <div class="comment-header">
                            <button type="button" class="btn btn-default btn-xs comment-delete-btn pull-right" ng-show="c.deletable" ng-click="$ctrl.deleteComment(c)">${loc.loc("commons.Smazat")?noEsc}</button>
                        </div>
                        <div class="comment-body">{{c.content}}</div>
                        <div class="comment-footer">
                            <span class="comment-metadata text-muted pull-right">
                                <span class="comment-author">
                                    <span ng-show="c.creator">{{c.creator | loc}}</span>
                                    <span ng-show="!c.creator">${loc.loc("commons.anonymniCtenar")?noEsc}</span>
                                </span>
                                <span class="comment-date">{{c.date | jpDate:'d.M.yyyy HH:mm'}}</span>
                            </span>
                        </div>
                    </li>
                </ul>
                <div class="panel-body text-center">
                    <div>
                        <button type="button" class="btn btn-default btn-sm" ng-click="$ctrl.addNonAnonymousComment()">${loc.loc("comments.AddNonAnonymousComment")?noEsc}</button>
                        <button type="button" class="btn btn-default btn-sm" ng-show="$ctrl.anonymousComments" ng-click="$ctrl.addAnonymousComment()">${loc.loc("comments.AddAnonymousComment")?noEsc}</button>
                    </div>
                    <div class="text-muted login-rappel" ng-if="!$ctrl.currentAuth.evided">
                        <span ng-if="$ctrl.anonymousComments">
                            ${loc.loc("detail.nejstePrihlasenProNeanonymniKomentarSePrihaste")?noEsc}
                        </span>
                        <span ng-if="!$ctrl.anonymousComments">
                            ${loc.loc("detail.proPridaniKomentareSePrihlaste")?noEsc}
                        </span>
                    </div>
                </div>
            </div>
        </uib-tab>
    </uib-tabset>
</div>
