Portaro Front End
==================

Build Scripts
-------------

- **BUILD**

	- `build`
		
		Development build. No minification.
	
	- `build:prod`
	
		Production build. Before build, it executes tests on local chromium. Minification enabled for JS and CSS. Source maps is generated without source.
		
	- `build:develWithGradle`
	
		Development build with watching of changes. If some file is modified, build is triggered and after then, 
		gradle triggers task `processResources` without dependencies.
		
	- `build:prodWithGradle`

		Production build with watching of changes. Minification is turned on and source maps are full. If some file is modified, build is triggered and after then,
		gradle triggers task `processResources` without dependencies.

	- `profile`
	
		Development build with profile report, which is generated into file `stats.json`. Use [https://webpack.github.io/analyse/](https://webpack.github.io/analyse/) analyzer.
		
	- `profile:prod`
	
		Production build with profile report.
	
- **DOCUMENTATION**

	- `docs:build`

		Build documentation to `/docs` directory.

	- `docs:serve`

		Run server with documentation on [localhost:3002](localhost:3002).
		
	- _`docs:grunt`_
	
		Internal task for generation documentation.
		
- **TESTING**

    All tests generates test coverage report to folder `/reports/coverage`.

	- `test`
	
		Run test on chromium browser.
		
	- `test:chromium`
	
		Same as `test`.
		
	- `test:browserstack`
	
		Run test on browserstack (FF, Chrome, IE, Edge).
		
	- `test:selenium`
	
		Run test on local Selenium Grid. Selenium Hub IP configuration is available in `/test/karma.conf/selenium-grid.conf.js` file.
		
- **OTHER**

    - `quality`

        Generates code quality report to folder `/reports/quality`.

	- _`gradle`_
		
		Internal task for execute gradle processResources task. Gradle has to be installed.