<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <script type="text/javascript">
        window.model.view = ${objectMapper.writeValueAsString(statsView)?noEsc};
    </script>


    <div ng-controller="PublicStatsCtrl as vm" ng-init="vm.init()" class="container normalniContentSMezerouNahore statistiky layout1c">


        <div class="sedyPanelVHlavicceObsahu notForPrint">
            <form class="form-horizontal" name="form" ng-submit="vm.onSubmit()">
                <div class="form-group" ng-repeat="field in vm.formFields" style="margin-right: 10px">
                    <label for="{{field.editor.editorId}}" class="control-label col-sm-2">
                        {{field.label}}
                    </label>
                    <div class="col-sm-10">
                        <kp-svelte-component-wrapper
                                component="::vm.kpValueEditorComponent"
                                props="field.editor"
                                ng-on-model-change="vm.onChange($event.originalEvent, field.fieldName)">
                        </kp-svelte-component-wrapper>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary col-sm-offset-2" ng-disabled="vm.isLoading">OK</button>
            </form>
        </div>


        <jp-loading ng-if="vm.isLoading"></jp-loading>


        <div ng-show="!vm.isLoading">


            <h1>{{vm.params.fromDate|jpDate:'d.M.yyyy HH:mm'}} - {{vm.params.toDate|jpDate:'d.M.yyyy HH:mm'}}</h1>


            <div ng-if="vm.stats.searchTypesCounts.counts.length > 0" class="inlineStat">
                <h2>${loc.loc("statistiky.podilyHledani")?noEsc}</h2>
                <div id="searchTypesCountsChart" google-chart chart="vm.charts.searchTypesCounts.chartObject" style="width:450px; height:300px;"></div>
            </div>


            <div ng-if="vm.stats.movementsCounts.counts.length > 0" class="inlineStat">
                <h2>${loc.loc("statistiky.pohybyCtenaru")?noEsc}</h2>
                <div id="pohybyCtenaruChart" google-chart chart="vm.charts.movementsCounts.chartObject" style="width:480px; height:300px;"></div>
            </div>


            <div ng-if="vm.stats.entersAndLoginsCounts.counts.length > 0" style="margin-top: 40px;">
                <h2>${loc.loc("statistiky.vstupyAPrihlaseniDoSystemu")?noEsc}</h2>
                <div id="entersAndLoginsCountsChart" google-chart chart="vm.charts.entersAndLoginsCounts.chartObject" style="width:980px; height:400px;"></div>
            </div>


            <div ng-if="vm.stats.enterTypesCounts.counts.length > 0" class="stat-entries-origin" style="margin-top: 40px; ">
                <h2>${loc.loc("statistiky.vstupyCtenaruZKnihovnyAMimo")?noEsc}</h2>
                <div id="enterTypesCountsChart" google-chart chart="vm.charts.enterTypesCounts.chartObject" style="width:450px; height:300px;"></div>
            </div>


            <div style="margin-top: 40px;">

                <h1>
                    ${loc.loc("statistiky.Souhrny")?noEsc}
                </h1>

                <div ng-if="!vm.stats.documentsByDatabasesCounts" class="inlineStat">
                    <h2>${loc.loc("statistiky.celkoveStatistiky")?noEsc}</h2>
                    <table class="table table-condensed table-hover" style="width: 350px;">
                        <thead>
                            <tr>
                                <th style="width: 250px;">${loc.loc("commons.nazev")?noEsc}</th>
                                <th>${loc.loc("commons.pocet")?noEsc}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>${loc.loc("statistiky.pocetZaregistrovanychCtenaru")?noEsc}</td>
                                <td>{{vm.stats.registeredReadersCount.count}}</td>
                            </tr>
                            <tr>
                                <td>${loc.loc("statistiky.pocetDokumentuVKnihovne")?noEsc}</td>
                                <td>{{vm.stats.documentsCount.count}}</td>
                            </tr>
                            <tr>
                                <td>${loc.loc("statistiky.pocetExemplaruVKnihovne")?noEsc}</td>
                                <td>{{vm.stats.exemplarsCount.count}}</td>
                            </tr>
                            <tr>
                                <td>${loc.loc("statistiky.pocetAktivnichVypujcek")?noEsc}</td>
                                <td>{{vm.stats.activeLoansCount.count}}</td>
                            </tr>
                            <tr>
                                <td>${loc.loc("statistiky.pocetAktivnichEVypujcek")?noEsc}</td>
                                <td>{{vm.stats.activeELoansCount.count}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div ng-if="vm.stats.documentsByDatabasesCounts" class="inlineStat">
                    <h2>${loc.loc("statistiky.StatistikyDatabazi")?noEsc}</h2>
                    <table class="table table-condensed table-hover" style="width: 500px;">
                        <thead>
                            <tr>
                                <th style="width: 200px;">${loc.loc("commons.Databaze")?noEsc}</th>
                                <th>${loc.loc("statistiky.pocetDokumentu")?noEsc}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr ng-repeat="count in vm.stats.documentsByDatabasesCounts.counts">
                                <td>{{count.name}}</td>
                                <td>{{count.value}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div ng-if="vm.stats.documentsAndExemplarsCountsByFonds.counts.length > 0" class="inlineStat" style="margin-left: 50px;">
                    <h2>${loc.loc("statistiky.statistikyFondu")?noEsc}</h2>
                    <table class="table table-condensed table-hover" style="width: 500px;">
                        <thead>
                            <tr>
                                <th style="width: 200px;">${loc.loc("commons.fond")?noEsc}</th>
                                <th>${loc.loc("statistiky.pocetDokumentu")?noEsc}</th>
                                <th ng-if="vm.stats.documentsAndExemplarsCountsByFonds.counts[0].value.second">${loc.loc("statistiky.pocetExemplaru")?noEsc}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr ng-repeat="count in vm.stats.documentsAndExemplarsCountsByFonds.counts">
                                <td>{{count.name}}</td>
                                <td>{{count.value.first}}</td>
                                <td ng-if="count.value.second">{{count.value.second}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div ng-if="vm.currentAuth.evided && vm.currentAuth.role.includes('ROLE_LIBRARIAN')" style="margin-top: 40px;">
                <div ng-if="vm.stats.discSpaceConsumptionStatProvider.counts.length > 0" class="inlineStat">
                    <h2>${loc.loc("file.DiskUsage")?noEsc}</h2>
                    <table class="table table-condensed table-hover" style="width: 500px;">
                        <thead>
                            <tr>
                                <th>${loc.loc("file.FileType")?noEsc}</th>
                                <th>${loc.loc("file.TotalSize")?noEsc}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr ng-repeat="count in vm.stats.discSpaceConsumptionStatProvider.counts">
                                <td>{{count.name}}</td>
                                <td>{{count.value|bytes:3}}</td>
                            </tr>
                        </tbody>
                        <tfoot class="sumary">
                            <tr>
                                <td>${loc.loc("commons.Total")?noEsc}</td>
                                <td>{{vm.stats.discSpaceConsumptionStatProvider.sum|bytes:3}}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

        </div>
    </div>
</@layouts.full>