<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <script type="text/javascript">
        window.model.view = ${objectMapper.writeValueAsString(statsView)?noEsc};
    </script>


    <div ng-controller="OverallStatsCtrl as vm" ng-init="vm.init()" class="container stats normalniContentSMezerouNahore layout1c stats-overall">


        <div class="sedyPanelVHlavicceObsahu notForPrint">
            <form class="form-horizontal" name="form" ng-submit="vm.onSubmit()">
                <div class="form-group" ng-repeat="field in vm.formFields" style="margin-right: 10px">
                    <label for="{{field.editor.editorId}}" class="col-sm-3 control-label">
                        {{field.label}}
                    </label>
                    <div class="col-sm-9">
                        <kp-svelte-component-wrapper
                                component="::vm.kpValueEditorComponent"
                                props="field.editor"
                                ng-on-model-change="vm.onChange($event.originalEvent, field.fieldName)">
                        </kp-svelte-component-wrapper>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary col-sm-offset-3" ng-disabled="vm.isLoading">OK</button>
            </form>
        </div>


        <jp-loading ng-if="vm.isLoading"></jp-loading>


        <div ng-show="!vm.isLoading">

            <span class="tisknout pull-right">
                <button type="button" onclick="window.print();" class="btn btn-primary">${loc.loc("commons.tisk")?noEsc}</button>
            </span>


            <h1>
                ${loc.loc("statistiky.OverallStats")?noEsc}
                {{vm.params.fromDate|jpDate:'d.M.yyyy HH:mm'}} - {{vm.params.toDate|jpDate:'d.M.yyyy HH:mm'}}
            </h1>


            <hr />


            <h2>
                <span ng-show="vm.params.department.length > 0">
                    ${loc.loc("commons.budova")?noEsc}
                    {{vm.params.department|prop:'text'|inline:', '}}
                </span>
                <span ng-show="vm.params.location.length > 0">
                    ${loc.loc("commons.lokace")?noEsc}
                    {{vm.params.location|prop:'text'|inline:', '}}
                </span>
            </h2>


            <div class="row">

                <div class="col-md-4">
                    <h3>Přírůstky podle fondů</h3>
                    <table class="table table-striped table-condensed table-hover overall-stats-block">
                        <tr ng-repeat="count in vm.data.exemplarIncreasesByFonds.counts">
                            <td colspan="2">{{count.name}}</td>
                            <td>{{count.value}}</td>
                        </tr>
                        <tfoot class="sumary">
                            <tr>
                                <td colspan="2">Celkem</td>
                                <td>{{vm.data.exemplarIncreasesByFonds.sum}}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="col-md-4">
                    <h3>Přírůstky podle tem. skupin</h3>
                    <table class="table table-striped table-condensed table-hover overall-stats-block">
                        <tr ng-repeat="count in vm.data.exemplarIncreasesByThematicGroups.counts">
                            <td colspan="2">{{count.name}}</td>
                            <td>{{count.value}}</td>
                        </tr>
                        <tfoot class="sumary">
                            <tr>
                                <td colspan="2">Celkem</td>
                                <td>{{vm.data.exemplarIncreasesByThematicGroups.sum}}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="col-md-4">
                    <h3>Přírůstky podle zp. nabytí</h3>
                    <table class="table table-striped table-condensed table-hover overall-stats-block">
                        <tr ng-repeat="count in vm.data.exemplarIncreasesByAcquisitionWays.counts">
                            <td colspan="2">{{count.name}}</td>
                            <td>{{count.value}}</td>
                        </tr>
                        <tfoot class="sumary">
                            <tr>
                                <td colspan="2">Celkem</td>
                                <td>{{vm.data.exemplarIncreasesByAcquisitionWays.sum}}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

            </div>


            <div class="row">

                <div class="col-md-4">
                    <h3>Úbytky podle fondů</h3>
                    <table class="table table-striped table-condensed table-hover overall-stats-block">
                        <tr ng-repeat="count in vm.data.exemplarDecreasesByFonds.counts">
                            <td colspan="2">{{count.name}}</td>
                            <td>{{count.value}}</td>
                        </tr>
                        <tfoot class="sumary">
                            <tr>
                                <td colspan="2">Celkem</td>
                                <td>{{vm.data.exemplarDecreasesByFonds.sum}}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="col-md-4">
                    <h3>Úbytky podle tem. skupin</h3>
                    <table class="table table-striped table-condensed table-hover overall-stats-block">
                        <tr ng-repeat="count in vm.data.exemplarDecreasesByThematicGroups.counts">
                            <td colspan="2">{{count.name}}</td>
                            <td>{{count.value}}</td>
                        </tr>
                        <tfoot class="sumary">
                            <tr>
                                <td colspan="2">Celkem</td>
                                <td>{{vm.data.exemplarDecreasesByThematicGroups.sum}}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="col-md-4">
                    <h3>Úbytky podle zp. nabytí</h3>
                    <table class="table table-striped table-condensed table-hover overall-stats-block">
                        <tr ng-repeat="count in vm.data.exemplarDecreasesByAcquisitionWays.counts">
                            <td colspan="2">{{count.name}}</td>
                            <td>{{count.value}}</td>
                        </tr>
                        <tfoot class="sumary">
                            <tr>
                                <td colspan="2">Celkem</td>
                                <td>{{vm.data.exemplarDecreasesByAcquisitionWays.sum}}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

            </div>


            <hr />

            <h2>
                <span ng-show="vm.params.buildings.length > 0">${loc.loc("commons.budova")?noEsc}</span>
                {{vm.params.buildings|prop:'text'|inline:', '}}
            </h2>

            <div class="row">

                <div class="col-md-6">

                    <h3>Uživatelé</h3>

                    <table class="table table-striped table-condensed table-hover overall-stats-block">
                        <tr>
                            <td colspan="2">${loc.locDefault("stats.overall.POC_REG_CTEN", "Registrovaní uživtelé ve sledovaném období")?noEsc}</td>
                            <td>{{vm.data.stats['POC_REG_CTEN']}}</td>
                        </tr>
                        <tr>
                            <td colspan="2">${loc.locDefault("stats.overall.POC_REG_CTEN15", "Z toho registrovaní uživatelé do 15 let")?noEsc}</td>
                            <td>{{vm.data.stats['POC_REG_CTEN15']}}</td>
                        </tr>
                        <tr>
                            <td colspan="2">${loc.locDefault("stats.overall.PNK_CELKEM", "Návštěvníci celkem")?noEsc}</td>
                            <td>{{vm.data.stats['PNK_CELKEM']}}</td>
                        </tr>
                        <tr>
                            <td colspan="2">${loc.locDefault("stats.overall.PNK_FYZ", "Návštěvníci knihovny (fyzičtí)")?noEsc}</td>
                            <td>{{vm.data.stats['PNK_FYZ']}}</td>
                        </tr>
                        <tr>
                            <td rowspan="4">V tom</td>
                            <td colspan="1">${loc.locDefault("stats.overall.PNK_VYP", "Návštěvníci půjčoven s studoven")?noEsc}</td>
                            <td>{{vm.data.stats['PNK_VYP']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.PNK_INT", "Návštěvníci využívající internet v knihovně")?noEsc}</td>
                            <td>{{vm.data.stats['PNK_INT']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.PNK_KULT", "Návštěvníci kulturních akcí")?noEsc}</td>
                            <td>{{vm.data.stats['PNK_KULT']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.PNK_VZDEL", "Návštěvníci vzdělávacích akcí")?noEsc}</td>
                            <td>{{vm.data.stats['PNK_VZDEL']}}</td>
                        </tr>
                        <tr>
                            <td colspan="2">${loc.locDefault("stats.overall.PNK_ONLINE", "Návštěvníci on-line služeb")?noEsc}</td>
                            <td>{{vm.data.stats['PNK_ONLINE']}}</td>
                        </tr>
                    </table>


                </div>

                <div class="col-md-6">

                    <h3>Výpůjčky</h3>

                    <table class="table table-striped table-condensed table-hover overall-stats-block">
                        <tr>
                            <td colspan="2">${loc.locDefault("stats.overall.VYP_CELKEM", "Výpůjčky celkem")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_CELKEM']}}</td>
                        </tr>
                        <tr>
                            <td rowspan="14">V tom</td>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_DN", "Naučná literatura dospělým uživatelům (knihy)")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_DN']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_DB", "Krásná literatura dospělým uživatelům (knihy)")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_DB']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_MN", "Naučná literatura dětem (knihy)")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_MN']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_MB", "Krásná literatura dětem (knihy)")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_MB']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_PER", "Výpůjčky periodik")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_PER']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_RUK", "Rukopisy")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_RUK']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_MIKRO", "Mikrografické dokumenty")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_MIKRO']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_KARTO", "Kartografické dokumenty")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_KARTO']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_HUD", "Tištěné hudebniny")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_HUD']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_ZVUK", "Zvukové")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_ZVUK']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_ZVOB", "Zvukově obrazové")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_ZVOB']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_OBR", "Obrazové")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_OBR']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_ELE", "Elektronické dokumenty")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_ELE']}}</td>
                        </tr>
                        <tr>
                            <td colspan="1">${loc.locDefault("stats.overall.VYP_OST", "Jiné")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_OST']}}</td>
                        </tr>
                        <tr>
                            <td colspan="2">${loc.locDefault("stats.overall.VYP_PREZ", "Prezenční výpůjčky evidované")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_PREZ']}}</td>
                        </tr>
                        <tr>
                            <td colspan="2">${loc.locDefault("stats.overall.VYP_PROL", "Prolongace")?noEsc}</td>
                            <td>{{vm.data.stats['VYP_PROL']}}</td>
                        </tr>
                    </table>
                </div>

            </div>


            <h3>Další údaje</h3>

            <table class="table table-striped table-condensed table-hover overall-stats-block">
                <tr>
                    <td rowspan="4">Meziknihovní výpůjční služba v rámci státu</td>
                    <td rowspan="2">Obdržené požadavky z jiných knihoven</td>
                    <td colspan="1">${loc.locDefault("stats.overall.MVS_AKT_CELK", "Počet požadavků")?noEsc}</td>
                    <td>{{vm.data.stats['MVS_AKT_CELK']}}</td>
                </tr>
                <tr>
                    <td colspan="1">${loc.locDefault("stats.overall.MVS_AKT_OK", "Počet kladně vyřízených požadavků")?noEsc}</td>
                    <td>{{vm.data.stats['MVS_AKT_OK']}}</td>
                </tr>
                <tr>
                    <td rowspan="2">Zaslané požadavky jiným knihovnám</td>
                    <td colspan="1">${loc.locDefault("stats.overall.MVS_AKT_CELK", "Počet požadavků")?noEsc}</td>
                    <td>{{vm.data.stats['MVS_AKT_CELK']}}</td>
                </tr>
                <tr>
                    <td colspan="1">${loc.locDefault("stats.overall.MVS_AKT_OK", "Počet kladně vyřízených požadavků")?noEsc}</td>
                    <td>{{vm.data.stats['MVS_AKT_OK']}}</td>
                </tr>
                <tr>
                    <td rowspan="4">Mezinárodní meziknihovní výpůjční služba</td>
                    <td rowspan="2">Požadavky z jiných zemí</td>
                    <td colspan="1">${loc.locDefault("stats.overall.MMVS_AKT_CELK", "Počet požadavků")?noEsc}</td>
                    <td>{{vm.data.stats['MMVS_AKT_CELK']}}</td>
                </tr>
                <tr>
                    <td colspan="1">${loc.locDefault("stats.overall.MMVS_AKT_OK", "Počet kladně vyřízených požadavků")?noEsc}</td>
                    <td>{{vm.data.stats['MMVS_AKT_OK']}}</td>
                </tr>
                <tr>
                    <td rowspan="2">Požadavky do jiných zemí</td>
                    <td colspan="1">${loc.locDefault("stats.overall.MMVS_AKT_CELK", "Počet požadavků")?noEsc}</td>
                    <td>{{vm.data.stats['MMVS_AKT_CELK']}}</td>
                </tr>
                <tr>
                    <td colspan="1">${loc.locDefault("stats.overall.MMVS_AKT_OK", "Počet kladně vyřízených požadavků")?noEsc}</td>
                    <td>{{vm.data.stats['MMVS_AKT_OK']}}</td>
                </tr>
                <tr>
                    <td rowspan="4">Výměnné fondy</td>
                    <td rowspan="2">Půjčené jiným knihovnám</td>
                    <td colspan="1">${loc.locDefault("stats.overall.VF_AKT_SOUB", "Počet souborů")?noEsc}</td>
                    <td>{{vm.data.stats['VF_AKT_SOUB']}}</td>
                </tr>
                <tr>
                    <td colspan="1">${loc.locDefault("stats.overall.VF_AKT_POC", "Počet svazků")?noEsc}</td>
                    <td>{{vm.data.stats['VF_AKT_POC']}}</td>
                </tr>
                <tr>
                    <td rowspan="2">Půjčené od jiných knihoven</td>
                    <td colspan="1">${loc.locDefault("stats.overall.VF_PAS_SOUB", "Počet souborů")?noEsc}</td>
                    <td>{{vm.data.stats['VF_PAS_SOUB']}}</td>
                </tr>
                <tr>
                    <td colspan="1">${loc.locDefault("stats.overall.VF_PAS_POC", "Počet svazků")?noEsc}</td>
                    <td>{{vm.data.stats['VF_PAS_POC']}}</td>
                </tr>
                <tr>
                    <td colspan="3">${loc.locDefault("stats.overall.POR_KONZ_RF", "Poradenská a konzultační činnost pro knihovníky a v rámci RF")?noEsc}</td>
                    <td>{{vm.data.stats['POR_KONZ_RF']}}</td>
                </tr>
                <tr>
                    <td colspan="3">${loc.locDefault("stats.overall.MET_NAV", "Metodické návštěvy - celkem")?noEsc}</td>
                    <td>{{vm.data.stats['MET_NAV']}}</td>
                </tr>
                <tr>
                    <td rowspan="2">Vzdělávací akce (a porady) pro knihovníky a v rámci RF</td>
                    <td colspan="2">${loc.locDefault("stats.overall.MET_AKCE_CELK", "Počet akcí")?noEsc}</td>
                    <td>{{vm.data.stats['MET_AKCE_CELK']}}</td>
                </tr>
                <tr>
                    <td colspan="2">${loc.locDefault("stats.overall.MET_AKCE_NAV", "Počet knihovníků")?noEsc}</td>
                    <td>{{vm.data.stats['MET_AKCE_NAV']}}</td>
                </tr>
            </table>


        </div>


    </div>
</@layouts.full>