<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>


<@layouts.full>
    <div class="container settings" ng-controller="settingsController as $ctrl" ng-init="$ctrl.init()">

        <div class="row">
            <div class="col-md-6">
                <h1></h1>
                <kp-action-request-button css-class="btn btn-primary btn-sm" path="/api/cache/invalidate-all">${loc.loc("util.smazCache")?noEsc}</kp-action-request-button>
            </div>
            <div class="col-md-6">
                <h1></h1>
                <table class="table">
                    <tr>
                        <td>${loc.loc("util.VerzePortara")?noEsc}</td>
                        <td>{{$ctrl.serverState.version}}</td>
                    </tr>
                    <tr>
                        <td>${loc.loc("util.VerzeAplikacnihoServeru")?noEsc}</td>
                        <td>{{$ctrl.serverState.appserverVersion}}</td>
                    </tr>
                </table>
            </div>
        </div>

        <div>

            <h1>Ini</h1>

            <div>
                <span class="section-list" ng-repeat="section in $ctrl.sections">
                    <button type="button" class="btn btn-default btn-xs" ng-class="{'active': $ctrl.activeSection === section}" ng-click="$ctrl.setActiveSection(section)">{{section.id}}</button>
                </span>
            </div>

            <h2>{{$ctrl.activeSection.id}}</h2>

            <div class="table-responsive" ng-show="$ctrl.activeSection">

                <table class="table table-hover">
                    <tbody>
                    <tr title="{{setting.description}}" ng-repeat="setting in $ctrl.settings" data-id="{{setting.id}}">
                        <td class="nowrap">
                            {{setting.name}}
                        </td>
                        <td>
                            <settings-item setting="setting"></settings-item>
                        </td>
                    </tr>
                    </tbody>
                </table>

            </div>

        </div>

    </div>
</@layouts.full>