<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>

<#assign debugMode = false>

<@layouts.full>
    <script type="text/javascript">
        window.model.searchFields = ${objectMapper.writeValueAsString(searchFields)?noEsc};
        window.model.basicModeFieldsCount = ${objectMapper.writeValueAsString(basicModeFieldsCount)?noEsc};
        window.model.searchParametersHistoryEnabled = ${objectMapper.writeValueAsString(searchParametersHistoryEnabled)?noEsc};
    </script>

    <div class="container search search-form-simple" ng-controller="SearchFormController as $ctrl" ng-init="$ctrl.init();" ng-cloak>

        <div class="row">
            <div class="col-xs-8">
                <h1>${loc.loc("hledani.RozsireneVyhledavani")?noEsc}</h1>
                <div class="pull-right">
                        <span ng-show="$ctrl.isAnyCriterionFilled()">
                            <a href="" ng-click="$ctrl.resetForm()">
                                ${loc.loc("commons.ResetForm")?noEsc}
                            </a>
                            <span style="margin-left: 5px; margin-right: 5px;">|</span>
                        </span>
                    <span>
                            <label>
                                <input type="checkbox" ng-checked="$ctrl.expertMode" ng-click="$ctrl.setExpertModeAndFillCriterions(!$ctrl.expertMode)">
                                ${loc.loc("hledani.ExpertniRezim")?noEsc}
                            </label>
                        </span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="main-panel-hlavni col-sm-8">

                <form class="form-horizontal" ng-submit="$ctrl.submitForm()">
                    <div class="panel panel-default">
                        <div class="panel-body">

                            <div ng-repeat="crit in $ctrl.getCriterions()">

                                <#if debugMode>
                                    <div>{{crit.operator}}</div>
                                    <div>{{crit.value}}</div>
                                    <div>EMPTY? {{crit.isEmpty()}}</div>
                                </#if>

                                <!-- AND/OR/NOT -->
                                <div class="row" style="margin-bottom: 8px" ng-if="$ctrl.expertMode && !$first">
                                    <div class="col-sm-12">
                                        <span style="width: 250px">
                                            <input type="radio" id="radioAnd_{{$index}}" ng-value="$ctrl.OPERATORS.AND" ng-model="crit.operator" ng-change="$ctrl.buildQueryIfAdmin()">
                                            <label for="radioAnd_{{$index}}">${loc.loc("hledani.aZaroven")?noEsc}</label>
                                        </span>
                                        <span style="width: 250px">
                                            <input type="radio" id="radioOr_{{$index}}" ng-value="$ctrl.OPERATORS.OR" ng-model="crit.operator" ng-change="$ctrl.buildQueryIfAdmin()">
                                            <label for="radioOr_{{$index}}">${loc.loc("hledani.nebo")?noEsc}</label>
                                        </span>
                                        <span style="width: 250px">
                                            <input type="radio" id="radioNot_{{$index}}" ng-value="$ctrl.OPERATORS.AND_NOT" ng-model="crit.operator" ng-change="$ctrl.buildQueryIfAdmin()">
                                            <label for="radioNot_{{$index}}">${loc.loc("hledani.aZarovenNeni")?noEsc}</label>
                                        </span>
                                    </div>
                                </div>

                                <div class="row" style="margin-bottom: 8px" ng-init="fieldLabelContext = $ctrl.createFieldLabelContext(crit.field)">
                                    <label id="{{fieldLabelContext.labelId}}" class="col-sm-3 control-label" for="{{crit.field.id}}" ng-if="!$ctrl.expertMode">{{crit.field | loc}}</label>
                                    <div class="col-sm-3" style="padding-right: 0px;" ng-if="$ctrl.expertMode">
                                        <select class="form-control input-sm"
                                                ng-model="crit.field"
                                                ng-options="fs as fs | loc for fs in $ctrl.searchFields track by fs.id"
                                                ng-change="$ctrl.updateCriterionByField(crit, crit.field)">
                                        </select>
                                    </div>

                                    <div class="col-sm-8" style="padding-left: 8px;" ng-init="valueEditorSvelteContext = $ctrl.setFieldLabelContext(fieldLabelContext)">
                                        <kp-svelte-component-wrapper
                                                component="::$ctrl.kpValueEditorComponent"
                                                props="{
                                                    type: crit.field.editor.type,
                                                    options: crit.field.editor.options,
                                                    validations: crit.field.editor.validations,
                                                    localizations: crit.field.editor.localizations,
                                                    editorId: crit.field.id,
                                                    placeholder: crit.field.editor.placeholder,
                                                    model: crit.value
                                                }"
                                                additional-context="valueEditorSvelteContext"
                                                ng-on-model-change="crit.value = $event.originalEvent.detail; $ctrl.buildQueryIfAdmin();">
                                        </kp-svelte-component-wrapper>

                                    </div>

                                    <div class="col-sm-1" ng-if="$ctrl.expertMode">
                                        <span ng-if="!$first" class="btn btn-link" ng-click="$ctrl.removeCriterion(crit)">
                                            <span class="glyphicon glyphicon-remove"></span>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="row" style="margin-top: 10px" ng-if="$ctrl.expertMode">
                                <div class="col-sm-3">
                                    <select class="form-control input-sm"
                                            ng-model="$ctrl.fieldToAdd"
                                            ng-options="ks as ks | loc for ks in $ctrl.searchFields"
                                            ng-change="$ctrl.addCriterion($ctrl.fieldToAdd); $ctrl.fieldToAdd = null;">
                                        <option value="">+ ${loc.loc("hledani.pridatKriterium")?noEsc}</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-submit">
                                <div class="col-sm-6 col-sm-offset-3">
                                    <button class="btn btn-primary btn-block" type="submit">
                                        ${loc.loc("commons.hledat")?noEsc}
                                    </button>
                                </div>
                                <div ng-if="$ctrl.currentAuthService.hasRole('ROLE_ADMIN')">
                                    <code class="col-sm-12 text-muted" style="margin-top: 20px; white-space: pre-wrap;">{{$ctrl.restrictionString}}</code>
                                    <code class="col-sm-12 text-muted" style="margin-top: 20px;">{{$ctrl.luceneQueryString}}</code>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <aside class="main-panel-pravy col-sm-4">
                <section class="search-history-panel panel panel-default" aria-labelledby="search-history-panel-label" ng-show="$ctrl.history.length > 0" ng-cloak>
                    <div class="panel-heading" id="search-history-panel-label">
                        <a kp-href="/search-history">${loc.loc("hledani.HistorieHledani")?noEsc}</a>
                    </div>
                    <ul class="history-list list-group">
                        <li class="list-group-item" ng-repeat="search in $ctrl.history">
                            <div style="text-overflow: ellipsis; overflow: hidden;">
                                <samp>{{search.title | characters:300}}</samp>
                            </div>
                            <div>
                                <span ng-show="search.importable">
                                    <a href="" ng-click="$ctrl.useFromHistory(search)">${loc.loc("hledani.FillToForm")?noEsc}</a>
                                    |
                                </span>
                                <span><a ng-href="{{search.url}}">${loc.loc("commons.hledat")?noEsc}</a></span>
                                <span class="pull-right text-muted small">{{search.date | jpDate:'d.M.yyyy HH:mm'}}</span>
                            </div>
                        </li>
                    </ul>
                </section>
                <kp-svelte-component-wrapper component="::$ctrl.kpFavouritesPanelComponent"></kp-svelte-component-wrapper>
                <kp-svelte-component-wrapper component="::$ctrl.kpVisitedPanelComponent"></kp-svelte-component-wrapper>
            </aside>
        </div>
    </div>
</@layouts.full>