<#ftl outputFormat="HTML">
<#import "_layouts.ftl" as layouts>
<#import "_localization.ftl" as loc>
<#import "_util.ftl" as util>

<#-- @ftlvariable name="record" type="cz.kpsys.portaro.record.Record" -->
<#-- @ftlvariable name="viewableRecord" type="cz.kpsys.portaro.search.view.ExportingRichDocument" -->
<#-- @ftlvariable name="recordPrinter" type="cz.kpsys.portaro.record.print.RecordDetailPlainHtmlPrinter" -->


<@layouts.full>
    <script type="text/javascript">
        window.model.view = ${objectMapper.writeValueAsString(view)?noEsc};
    </script>


    <div ng-controller="AuthorityCtrl" ng-init="init()" class="container" id="authority-detail">

        <div class="row">
            <div class="col-sm-12">
                <h1 class="authority-name">${viewableRecord.name?esc}</h1>
                <h1 class="authority-100abcd">${recordPrinter.group(viewableRecord.query('100.abcd'))?noEsc}</h1>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="detail-blok-main authority-detail-blok-main">

                    <#-- obalka -->
                    <div ng-if="record.cover" class="cover-container cover-container-authority-detail">
                        <kp-svelte-component-wrapper component="::kpCoverComponent" props="::{record: record, target: 'cover', fillTo: 'width'}"></kp-svelte-component-wrapper>
                    </div>

                    <#-- Sprava zaznamu -->
                    <div>
                        <div ng-show="view.editable || view.deletable || view.copyable || view.filesManageable" style="margin: 5px 0 15px 0;">
                            <a ng-if="view.editable" ng-href="{{::CONTEXT_PATH}}/records/{{::record.id}}/edit" class="btn btn-primary">${loc.loc("commons.editovat")?noEsc}</a>
                            <a ng-if="view.editable" ng-click="updateWithExternalRecord()" class="btn btn-default" title="${loc.loc("detail.UpdateRecordTooltip")?noEsc}">${loc.loc("detail.UpdateRecord")?noEsc}</a>
                            <button ng-if="view.copyable" class="btn btn-default" ng-click="copyRecord()">${loc.loc("commons.Zkopirovat")?noEsc}</button>
                            <a ng-if="view.filesManageable" ng-href="{{CONTEXT_PATH}}/media-viewer?rootDirectory={{record.directoryId}}&edit=true&origin={{$window.location.href | encodeUri}}" class="btn btn-default">${loc.loc("file.PripojeneSoubory")?noEsc}</a>
                            <span ng-if="view.deletable">
                                <a ng-if="recordHoldings.length === 1" href="" ng-click="deleteRecordHolding(recordHoldings[0])" class="btn btn-default">${loc.loc("detail.DeleteAuthority")?noEsc}</a>
                                <span ng-if="recordHoldings.length > 1" class="record-deletion-dropdown btn-group">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                        ${loc.loc("detail.DeleteAuthority")?noEsc} <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li ng-repeat="recordHolding in recordHoldings track by recordHolding.id"><a href="" ng-click="deleteRecordHolding(recordHolding)">z {{recordHolding.department | loc}}</a></li>
                                    </ul>
                                </span>
                            </span>
                        </div>

                        <jp-custom-paragraph content="view.paragraph" class="paragraph-template odstavec_autorita"></jp-custom-paragraph>
                    </div>

                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <#-- ng-if == await for hierarchyTrees promise to resolve -->
                <kp-svelte-component-wrapper ng-if="hierarchyTrees" component="::kpRecordHierarchyTreesComponent" props="::{hierarchyTrees: hierarchyTrees}"></kp-svelte-component-wrapper>
            </div>
        </div>


        <div class="row detail-blok detail-blok-details" ng-cloak>
            <div class="col-sm-12">

                <uib-tabset active="detailTabs.activeTabId">

                    <uib-tab ng-if="directoryInsight.sampleFiles.length > 0 || directoryInsight.withNonCoverFiles || directoryInsight.withSubdirectories" index="'ATTACHMENTS'" ng-init="detailTabs.registerTab('ATTACHMENTS')">
                        <uib-tab-heading class="tab-button-attachments">
                            ${loc.loc("detail.PrilohyKeStazeni")?noEsc}
                        </uib-tab-heading>
                        <div class="list-group tab-content-attachments">
                            <a ng-repeat="file in directoryInsight.sampleFiles" ng-href="{{CONTEXT_PATH}}/media-viewer?rootDirectory={{record.directoryId}}&origin={{$window.location.href | encodeUri}}#!?file={{file.id}}" class="list-group-item">
                                <div ng-if="file.viewForms.includes('THUMBNAIL')" class="pull-left">
                                    <img ng-src="{{CONTEXT_PATH}}/files/{{file.id}}?height=40" height="40" style="max-width: 60px; border: 1px solid #DDD;"/>
                                </div>
                                <div style="margin-left: 80px;">{{file.name}}</div>
                                <div class="cleaner"></div>
                            </a>
                        </div>
                    </uib-tab>

                    <uib-tab style="display:none;" index="'NONE'" ng-init="detailTabs.registerTab('NONE')">
                        <div class="panel panel-default"></div>
                    </uib-tab>

                    <uib-tab ng-if="view.detailTabShowing" index="'DETAIL'" ng-init="detailTabs.registerTab('DETAIL')">
                        <uib-tab-heading class="tab-button-detail">
                            ${loc.loc("detail.detail")?noEsc}
                        </uib-tab-heading>
                        <div class="panel panel-default tab-content-detail">
                            <kp-svelte-component-wrapper
                                    component="::kpRecordDetailTable"
                                    props="{rows: view.detailTableRows}"
                            ></kp-svelte-component-wrapper>
                        </div>
                    </uib-tab>

                    <uib-tab ng-if="view.marcTabShowing" index="'MARC'" ng-init="detailTabs.registerTab('MARC')">
                        <uib-tab-heading class="tab-button-marc">
                            ${loc.loc("detail.marc")?noEsc}
                        </uib-tab-heading>
                        <div class="panel panel-default tab-content-marc">
                            <@util.recordMarcTable view.fields />
                        </div>
                    </uib-tab>

                    <uib-tab ng-if="view.operationsShowing" index="'OPERATIONS'" ng-init="detailTabs.registerTab('OPERATIONS')" select="loadOperations()">
                        <uib-tab-heading class="tab-button-operations">
                            ${loc.loc("record.ProcessingHistory")?noEsc}
                        </uib-tab-heading>
                        <div class="panel panel-default tab-content-operations">
                            <kp-paginated-panel-list pagination="operationListSearchManager.getPagination()">
                                <kp-record-operation-list-item record-operation="$parent.item"></kp-record-operation-list-item>
                            </kp-paginated-panel-list>
                        </div>
                    </uib-tab>

                </uib-tabset>

            </div>
        </div>



        <div ng-if="images && images.length > 0" class="row" style="margin-top: 30px;">
            <div class="col-sm-12">

                <ul class="list-inline">
                    <li ng-repeat="file in images">
                        <a ng-href="{{CONTEXT_PATH}}/media-viewer?rootDirectory={{record.directoryId}}&origin={{$window.location.href | encodeUri}}#!?file={{file.id}}"><img ng-src="{{CONTEXT_PATH}}/files/{{file.id}}/thumbnail" height="100" /></a>
                    </li>
                </ul>

            </div>
        </div>



        <jp-search static-params="{type: 'by-authority', recordRelatedRecord: record.id}" style="margin-top: 80px; border-top: 1px solid lightgray;"></jp-search>



        <div class="upperFooter row col-sm-12">
            ${loc.loc("detail.permantentniLink")?noEsc}
            <#assign permalink="${currentPage.serverUrl}/records/${viewableRecord.id}">
            <input type="text" value="${permalink}" size="${permalink?length}" style="font-family: monospace; /*width: ${permalink?length*7}px*/" onclick="this.focus(); this.select();" class="permalink-value" /><br/>
        </div>

    </div>
</@layouts.full>