<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div ng-controller="SearchedInventoryCtrl as $ctrl" ng-init="$ctrl.init(record);" class="row">

    <div class="col-xs-4">
        <div>
            <strong>{{record|loc}}</strong>
            <strong>- {{record.state|loc}}</strong>
        </div>
        <div><span class="text-muted">Datum</span> {{record.date|jpDate:'d.M.yyyy'}}</div>
        <div><span class="text-muted">Vytvořeno</span> {{record.createDate|jpDate:'d.M.yyyy'}}</div>
        <div><span class="text-muted">Uzavřeno</span> {{record.closeDate|jpDate:'d.M.yyyy'}}</div>
        <div><span class="text-muted">Založil</span> <a kp-href="/#!/users/{{record.creator.id}}">{{record.creator|loc}}</a></div>
        <div><span class="text-muted">Naposledy změnil</span> <a kp-href="/#!/users/{{record.lastEditor.id}}">{{record.lastEditor|loc}}</a></div>
    </div>

    <div class="col-xs-6">
        <div><span class="text-muted">${loc.loc("exemplar.OnLocations")?noEsc}</span> {{record.locations|prop:'text'|inline:', '}}</div>
        <div><span class="text-muted">Na oddělení</span> {{record.department|loc}}</div>
        <div><span class="text-muted">Fond</span> {{record.fond|loc}}</div>
        <div ng-show="record.firstAccessNumber || record.lastAccessNumber">
            <span class="text-muted">${loc.loc('exemplar.AccessNumber.abbr')}</span>
            <span ng-show="record.firstAccessNumber">
                <span class="text-muted">od</span> {{record.firstAccessNumber}}
            </span>
            <span ng-show="record.lastAccessNumber">
                <span class="text-muted">až po</span> {{record.lastAccessNumber}}
            </span>
        </div>
        <div ng-show="record.signaturePrefix || record.lastSignature">
            <span class="text-muted">${loc.loc('exemplar.Signature.abbr')}</span>
            <span ng-show="record.signaturePrefix">
                <span class="text-muted">prefix</span> {{record.signaturePrefix}}
            </span>
            <span ng-show="record.lastSignature">
                <span class="text-muted">až po</span> {{record.lastSignature}}
            </span>
        </div>
    </div>

    <div class="col-xs-2">
        <div><a kp-href="/search?type=capture-search&kind=capture&inventory={{record.id}}">Nálezy</a></div>
        <div><a kp-href="/search?type=match-search&kind=match&inventory={{record.id}}">Výsledky</a></div>
        <div><button type="button" ng-click="$ctrl.showCapturingForm()" class="btn btn-default btn-sm">Načítat kódy</button></div>
    </div>

</div>