<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>

<#-- ng-init injects values from scope (modal window or more specialized form) into controller -->
<div ng-controller="UniversalFormController as $ctrl" ng-init="$ctrl.init(model.formSetting, model.formObject, model.submitFunction, modalWindowActions.submitPromise, model.customTransferifyFunction)">

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true" ng-click="modalWindowActions.cancel()">&times;</button>
        <h3 class="modal-title"><span ng-bind-html="$ctrl.formSetting | loc"></span></h3>
    </div>

    <div class="modal-body">
        <kp-svelte-component-wrapper ng-if="$ctrl.formSetting"
                                     component="::$ctrl.kpUniversalFormForceSettingsWrapper"
                                     props="$ctrl.getProps({
                                            forceSettings: $ctrl.createUniversalFormForceSettings($ctrl.formSetting),
                                            formSettings: $ctrl.formSetting,
                                            model: $ctrl.formObject,
                                            forceShowErrors: $ctrl.formSubmitted})"
                                     get-svelte-component="$ctrl.getFormController($svelteComponentInstant.getFormController())"
                                     ng-on-model-change="$ctrl.refreshScope()"
                                     ng-on-submit="$ctrl.submit()">
        </kp-svelte-component-wrapper>
    </div>

    <div class="modal-footer">
        <button type="button" class="btn btn-primary" ng-click="$ctrl.submit()" data-qa="universal-form-ok-button" >
            OK
        </button>
        <button type="button" class="btn btn-default" data-dismiss="modal" ng-click="modalWindowActions.cancel()" data-qa="universal-form-cancel-button">
            ${loc.loc("commons.zavrit")?noEsc}
        </button>
    </div>

</div>
