<#ftl outputFormat="HTML">
<#import "../_localization.ftl" as loc>


<div>

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true" ng-click="modalWindowActions.cancel()">&times;</button>
        <h3 class="modal-title">Zaplatit</h3>
    </div>

    <div class="modal-body">
        <p class="text-center">
            <strong>K zaplacení je celkem {{model.sumToPay}}Kč</strong>
        </p>
        <table class="table table-hover">
            <tr ng-repeat="debt in model.debts">
                <td style="width: 50%">{{debt.type|loc}}</td>
                <td>{{debt.sum}}Kč</td>
            </tr>
        </table>
        <p>
            <a ng-href="{{model.redirectUrl}}" class="btn btn-primary btn-block">Zaplatit {{model.sumToPay}}Kč</a>
        </p>
        <p class="text-muted">
            {{model.infoText}}
        </p>
        <p ng-if="model.termsAndConditionsLink">
            <kp-link link="model.termsAndConditionsLink"></kp-link>
        </p>
    </div>

    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal" ng-click="modalWindowActions.cancel()">
            ${loc.loc("commons.zavrit")?noEsc}
        </button>
    </div>

</div>
