/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config.database;

import com.zaxxer.hikari.HikariDataSource;
import cz.kpsys.portaro.commons.concurrent.ExecutorServiceHelper;
import cz.kpsys.portaro.commons.contextual.ContextualConsumer;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.database.DatabaseScriptCaller;
import cz.kpsys.portaro.databaseproperties.DataSourceFactory;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.portaro.databaseproperties.DatabaseProperties;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.user.User;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class ClearDynamicDataCaller
implements ContextualConsumer<String, Department> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClearDynamicDataCaller.class);
    @NonNull
    private final ExecutorServiceHelper executorServiceHelper;
    @NonNull
    private final Provider<User> suUserProvider;
    @NonNull
    private final DatabaseProperties dbUpdateDatabaseProperties;
    @NonNull
    private final Provider<ZoneId> databaseColumnsTimeZoneProvider;

    public void acceptOn(@NonNull String command, @NonNull Department ctx) {
        Objects.requireNonNull(command, "command is marked non-null but is null");
        Objects.requireNonNull(ctx, "ctx is marked non-null but is null");
        this.executorServiceHelper.awaitCompletion(Duration.ofSeconds(15L));
        try (HikariDataSource dataSource = DataSourceFactory.createDbUpdateDataSource((DatabaseConnectionSettings)this.dbUpdateDatabaseProperties, (ZoneId)((ZoneId)this.databaseColumnsTimeZoneProvider.get()), cfg -> {});){
            List<String> protectedUsernames = List.of("SU", "OPAC", "verbisanonymous", "system-sba-server", "verbisapplication", "verbisappserver", "verbissip2server", "cpk", "mojeid", "uptimerobot", "ahrefsbot", "applelebot", "bingbot", "googlebot", "mj12bot", "petalbot", "semrushbot", "seznambot", "yandexbot");
            List protectedUserIds = new NamedParameterJdbcTemplate((DataSource)dataSource).queryForList("select id_uziv from uzivatele where username in (:usernames)", Map.of("usernames", protectedUsernames), Long.class);
            String protectedUserIdsString = protectedUserIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            List<String> sqls = List.of("delete from task_queue", "execute procedure relog_user(%s)".formatted(((User)this.suUserProvider.get()).getId()), "delete from log_debbug_vypuc", "delete from log_vypuc", "delete from vypuc_reze_pujcovny", "delete from vypuc_timeslot", "delete from vypuc_titper", "delete from vypuc", "delete from vypuc2", "delete from opac_log_akce", "delete from opac_rating", "delete from log_cten", "delete from uziv_adresy where fk_uziv not in (%s)".formatted(protectedUserIdsString), "delete from adresy", "delete from record_operation", "delete from vykony_dok", "delete from record_link", "delete from kat1_7", "delete from %s".formatted(this.dbUpdateDatabaseProperties.getType().equals("firebird") ? "kat1_3" : "record_keyword_relation"), "delete from %s".formatted(this.dbUpdateDatabaseProperties.getType().equals("firebird") ? "kat1_2" : "record_keyword"), "delete from kat1_1", "delete from opac_log_sessions", "delete from karantena", "delete from kat1_5", "delete from kat1_7", "delete from kat1_4 where id_zaz != 0", "delete from uziv_kontakty where fk_uziv not in (%s)".formatted(protectedUserIdsString), "delete from uziv_prefs where fk_uziv not in (%s)".formatted(protectedUserIdsString), "delete from uziv_vazby where fk_uziv not in (%s)".formatted(protectedUserIdsString), "delete from uziv_service_prop where user_id not in (%s)".formatted(protectedUserIdsString), "delete from vaz_cten_pujc where fk_uziv_cten not in (%s)".formatted(protectedUserIdsString), "delete from vaz_uziv_pujc where fk_uziv not in (%s)".formatted(protectedUserIdsString), "delete from log_exemp", "delete from platby", "update event set initiator_user_id = %s where initiator_user_id not in (%s)".formatted(((User)this.suUserProvider.get()).getId(), protectedUserIdsString), "update kataut_4 set fk_uziv = %s where fk_uziv not in (%s)".formatted(((User)this.suUserProvider.get()).getId(), protectedUserIdsString), "update kataut_4 set fk_uziv_korp = %s where fk_uziv_korp not in (%s)".formatted(((User)this.suUserProvider.get()).getId(), protectedUserIdsString), "delete from ctenari where fk_uziv not in (%s)".formatted(protectedUserIdsString), "delete from log_vypuc", "delete from dodavatele", "delete from knihovny", "delete from instituce", "delete from def_uziv where fk_uziv not in (%s)".formatted(protectedUserIdsString), "delete from osoby where fk_uziv not in (%s)".formatted(protectedUserIdsString), "delete from user_record_collection", "delete from record_collection", "delete from record_holding_source", "delete from record_holding", "delete from obalkyknih", "delete from vykony_aut", "delete from task_queue", "delete from kataut_1", "delete from kataut_3", "delete from kataut_2", "update kataut_4 set fk_aut = null where fk_aut is not null", "delete from kataut_4", "delete from record_key", "delete from record where id != (select record_id from KAT1_4 where id_zaz = 0)", "delete from uzivatele where id_uziv not in (%s)".formatted(protectedUserIdsString));
            new DatabaseScriptCaller((DataSource)dataSource, sqls).call();
        }
    }

    @ConstructorProperties(value={"executorServiceHelper", "suUserProvider", "dbUpdateDatabaseProperties", "databaseColumnsTimeZoneProvider"})
    @Generated
    public ClearDynamicDataCaller(@NonNull ExecutorServiceHelper executorServiceHelper, @NonNull Provider<User> suUserProvider, @NonNull DatabaseProperties dbUpdateDatabaseProperties, @NonNull Provider<ZoneId> databaseColumnsTimeZoneProvider) {
        Objects.requireNonNull(executorServiceHelper, "executorServiceHelper is marked non-null but is null");
        Objects.requireNonNull(suUserProvider, "suUserProvider is marked non-null but is null");
        Objects.requireNonNull(dbUpdateDatabaseProperties, "dbUpdateDatabaseProperties is marked non-null but is null");
        Objects.requireNonNull(databaseColumnsTimeZoneProvider, "databaseColumnsTimeZoneProvider is marked non-null but is null");
        this.executorServiceHelper = executorServiceHelper;
        this.suUserProvider = suUserProvider;
        this.dbUpdateDatabaseProperties = dbUpdateDatabaseProperties;
        this.databaseColumnsTimeZoneProvider = databaseColumnsTimeZoneProvider;
    }
}

