/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cz.kpsys.portaro.auth.Authenticity;
import cz.kpsys.portaro.auth.UserAuthenticationFunctions;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.auth.licence.ConditionallyAllowingUserLicenceChecker;
import cz.kpsys.portaro.auth.licence.FallbackingUserLicenceChecker;
import cz.kpsys.portaro.auth.licence.GlobalLicenceCheckingUserLicenceChecker;
import cz.kpsys.portaro.auth.licence.SerialAndUserValidationCodeCheckingUserLicenceChecker;
import cz.kpsys.portaro.auth.licence.UserLicenceChecker;
import cz.kpsys.portaro.auth.multifactor.MultifactorAuthSettingKeys;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.SwitchContextualProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.HierarchyContextsByModeLoader;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.permission.ActionPermissionAccessor;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserDepartmentsLoader;
import cz.kpsys.portaro.user.UserFunctions;
import cz.kpsys.portaro.user.relation.RepresentableUserLoader;
import cz.kpsys.portaro.user.sec.DefaultPermissionFactory;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UserPermissionsConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPermissionsConfig.class);
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final RepresentableUserLoader representableUserLoader;
    @NonNull
    private final UserDepartmentsLoader readableUserDepartmentsLoader;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final ActionPermissionAccessor actionPermissionAccessor;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final @NonNull Provider<@NonNull Licence> licenceProvider;
    @NonNull
    private final Provider<User> portaroUserProvider;

    @Bean
    public PermissionFactory permissionFactory() {
        return new DefaultPermissionFactory(this.actionPermissionAccessor, (UserLicenceChecker)this.userLicenceChecker(), this.featureManager, this.currentAuthEditableDepartmentsLoader, this.representableUserLoader, this.readableUserDepartmentsLoader, (HierarchyContextsByModeLoader)this.departmentAccessor, (ContextualProvider)new SwitchContextualProvider(this.settingLoader.getDepartmentedProvider(MultifactorAuthSettingKeys.SECOND_FACTOR_ENABLED), (Object)Authenticity.ONE_PUBLIC_FACTOR, (Object)Authenticity.TWO_ANY_FACTORS));
    }

    @Bean
    public ConditionallyAllowingUserLicenceChecker userLicenceChecker() {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(100L).build();
        SerialAndUserValidationCodeCheckingUserLicenceChecker userValidationCodeChecking = new SerialAndUserValidationCodeCheckingUserLicenceChecker(cache);
        this.cacheService.registerCleaner((CacheCleaner)userValidationCodeChecking);
        GlobalLicenceCheckingUserLicenceChecker globalLicenceChecking = new GlobalLicenceCheckingUserLicenceChecker(this.licenceProvider);
        FallbackingUserLicenceChecker fallbackingChecker = new FallbackingUserLicenceChecker((UserLicenceChecker)userValidationCodeChecking, (UserLicenceChecker)globalLicenceChecking);
        return new ConditionallyAllowingUserLicenceChecker((UserLicenceChecker)fallbackingChecker).whenAuth(UserAuthenticationFunctions.hasAdminAndLibrarianRole()).permitBoth().whenUser(UserFunctions.isUser((Provider)this.portaroUserProvider)).permitBoth();
    }

    @ConstructorProperties(value={"featureManager", "departmentAccessor", "settingLoader", "representableUserLoader", "readableUserDepartmentsLoader", "currentAuthEditableDepartmentsLoader", "actionPermissionAccessor", "cacheService", "licenceProvider", "portaroUserProvider"})
    @Generated
    public UserPermissionsConfig(@NonNull FeatureManager featureManager, @NonNull DepartmentAccessor departmentAccessor, @NonNull SettingLoader settingLoader, @NonNull RepresentableUserLoader representableUserLoader, @NonNull UserDepartmentsLoader readableUserDepartmentsLoader, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull ActionPermissionAccessor actionPermissionAccessor, @NonNull CacheService cacheService, @NonNull @NonNull Provider<@NonNull Licence> licenceProvider, @NonNull Provider<User> portaroUserProvider) {
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(representableUserLoader, "representableUserLoader is marked non-null but is null");
        Objects.requireNonNull(readableUserDepartmentsLoader, "readableUserDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(actionPermissionAccessor, "actionPermissionAccessor is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        Objects.requireNonNull(portaroUserProvider, "portaroUserProvider is marked non-null but is null");
        this.featureManager = featureManager;
        this.departmentAccessor = departmentAccessor;
        this.settingLoader = settingLoader;
        this.representableUserLoader = representableUserLoader;
        this.readableUserDepartmentsLoader = readableUserDepartmentsLoader;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.actionPermissionAccessor = actionPermissionAccessor;
        this.cacheService = cacheService;
        this.licenceProvider = licenceProvider;
        this.portaroUserProvider = portaroUserProvider;
    }
}

