/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.appserver.GenericTableWriteSaver;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.TableWriteGenerator;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.AuthenticationSetter;
import cz.kpsys.portaro.auth.Authenticity;
import cz.kpsys.portaro.auth.UserAuthentication;
import cz.kpsys.portaro.auth.cas.CasAuthSettingKeys;
import cz.kpsys.portaro.auth.credreg.CredentialsRegistrationSecurityActions;
import cz.kpsys.portaro.auth.ezak.EzakAuthSettingKeys;
import cz.kpsys.portaro.auth.internal.BarCodeAndBirthYearStringPairUserProvider;
import cz.kpsys.portaro.auth.internal.InternalAuthSecurityActions;
import cz.kpsys.portaro.auth.internal.InternalLoginCredentialsProperties;
import cz.kpsys.portaro.auth.internal.PasswordCheckingStringPairUserProvider;
import cz.kpsys.portaro.auth.internal.credentials.PasswordChangeRequest;
import cz.kpsys.portaro.auth.internal.credentials.PasswordChanger;
import cz.kpsys.portaro.auth.internal.credentials.PasswordRecreatableContextualEmailUsersLoader;
import cz.kpsys.portaro.auth.internal.credentials.PasswordRecreationLinkService;
import cz.kpsys.portaro.auth.internal.credentials.ProvidedPersonLoginIdentifierValueProvider;
import cz.kpsys.portaro.auth.internal.credentials.TokenedPasswordChangeMailRequest;
import cz.kpsys.portaro.auth.internal.credentials.UserCredentialsApiController;
import cz.kpsys.portaro.auth.internal.credentials.UserCredentialsDeleter;
import cz.kpsys.portaro.auth.internal.credentials.UserCredentialsDeleterAppserver;
import cz.kpsys.portaro.auth.ldap.LdapAuthSettingKeys;
import cz.kpsys.portaro.auth.oauth2.authorizationcode.OAuth2AuthorizationCodeAuthSettingKeys;
import cz.kpsys.portaro.auth.openid.OpenIdAuthSettingKeys;
import cz.kpsys.portaro.auth.openid.OpenIdXrdsDocumentController;
import cz.kpsys.portaro.auth.password.PasswordChecker;
import cz.kpsys.portaro.auth.password.PasswordEncoderDelegatingPasswordChecker;
import cz.kpsys.portaro.auth.password.UniversalPasswordPasswordChecker;
import cz.kpsys.portaro.auth.saml2.sp.Saml2ServiceProviderSettingKeys;
import cz.kpsys.portaro.auth.view.AuthenticationSystemView;
import cz.kpsys.portaro.auth.view.FormAuthenticationSystemView;
import cz.kpsys.portaro.auth.view.LoginPageRedirectingAuthenticationSystemView;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.barcode.EanBarcodeValidator;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheCleaningSaver;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.contextual.ContextualFunction;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.ConversionException;
import cz.kpsys.portaro.commons.convert.EToEConverter;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.convert.StringToLongConverter;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.ChainingStringProvider;
import cz.kpsys.portaro.commons.object.FilteredAndSortedAllValuesProvider;
import cz.kpsys.portaro.commons.object.FilteredList;
import cz.kpsys.portaro.commons.object.IdSettable;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByAllValuesProviderAdapter;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByIdLoaderAdapter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.DefaultProvider;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.HookableSaver;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.commons.util.StringUtil;
import cz.kpsys.portaro.commons.validation.nullablenotblank.NullableNotBlank;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.conversation.ActionRequestUrlGenerator;
import cz.kpsys.portaro.datatype.DatatypableStringConverter;
import cz.kpsys.portaro.department.ContextHierarchySelection;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.HierarchyContextsByModeLoader;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.ExemplarSecurityActions;
import cz.kpsys.portaro.finance.AmountType;
import cz.kpsys.portaro.form.editor.ValueEditorByDatatypeLoader;
import cz.kpsys.portaro.form.editor2.FieldsWhiteListResolverAllValuesProviderFactory;
import cz.kpsys.portaro.form.editor2.LocalizationsAwareValueEditor;
import cz.kpsys.portaro.form.editor2.ValueEditor;
import cz.kpsys.portaro.form.editor2.ValueEditorModifier;
import cz.kpsys.portaro.form.editor2.ValueEditorPrototypeResolver;
import cz.kpsys.portaro.form.editor2.password.PasswordValueEditor;
import cz.kpsys.portaro.form.editor2.text.TextValueEditorModifier;
import cz.kpsys.portaro.form.property.AcceptableValuesResolver;
import cz.kpsys.portaro.licence.FeatureManager;
import cz.kpsys.portaro.mail.MailService;
import cz.kpsys.portaro.object.TypedDepartmentedObjectModifier;
import cz.kpsys.portaro.payment.Transaction;
import cz.kpsys.portaro.payment.TransactionLoader;
import cz.kpsys.portaro.payment.TypedUserAmount;
import cz.kpsys.portaro.record.sec.UserEditableFondsLoader;
import cz.kpsys.portaro.search.CoreSearchParams;
import cz.kpsys.portaro.search.ItemCustomizableContextualSearchFunction;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.StaticParamsModifier;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.security.permission.ActionPermissionAccessor;
import cz.kpsys.portaro.security.permission.DefaultPermissionEntity;
import cz.kpsys.portaro.security.permission.UserPermissionEntity;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.token.Auth0JwtTemporalTokenRepository;
import cz.kpsys.portaro.token.TemporalTokenClaimExtender;
import cz.kpsys.portaro.token.TemporalTokenRepository;
import cz.kpsys.portaro.token.UserTemporalToken;
import cz.kpsys.portaro.token.UserTemporalTokenClaimExtender;
import cz.kpsys.portaro.user.AllUserTypesSupportingUserRequiredPropsSetting;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.CardNumberSearchingUserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.ForcedUsernameUserProvider;
import cz.kpsys.portaro.user.Institution;
import cz.kpsys.portaro.user.Person;
import cz.kpsys.portaro.user.ReauthenticatingUserSaver;
import cz.kpsys.portaro.user.RegistrationExtensionAgreementSettings;
import cz.kpsys.portaro.user.SearchingContextualEmailBasicUsersLoader;
import cz.kpsys.portaro.user.SearchingUserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.StringPairUserProvider;
import cz.kpsys.portaro.user.User;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.UserByContextualIdentifierLoader;
import cz.kpsys.portaro.user.UserConstants;
import cz.kpsys.portaro.user.UserEditationPropsSetting;
import cz.kpsys.portaro.user.UserLoader;
import cz.kpsys.portaro.user.UserRequiredPropsSetting;
import cz.kpsys.portaro.user.UserSaverAppserver;
import cz.kpsys.portaro.user.UserSettingKeys;
import cz.kpsys.portaro.user.auth.PersonUserMerger;
import cz.kpsys.portaro.user.cardnumber.CardNumberSequenceEntity;
import cz.kpsys.portaro.user.cardnumber.CardNumberSequenceItemToEntityConverter;
import cz.kpsys.portaro.user.contact.Address;
import cz.kpsys.portaro.user.contact.AddressesDeleterAppserver;
import cz.kpsys.portaro.user.contact.AddressesSaveTableWriteGenerator;
import cz.kpsys.portaro.user.contact.AddressesSaverAppserver;
import cz.kpsys.portaro.user.contact.UserAddressDeleter;
import cz.kpsys.portaro.user.contact.UserAddressDeleterAppserver;
import cz.kpsys.portaro.user.contact.UserAddressLoader;
import cz.kpsys.portaro.user.edit.UserEditationFactory;
import cz.kpsys.portaro.user.edit.UserEditationRequestApplier;
import cz.kpsys.portaro.user.edit.form.FormSettingsChecker;
import cz.kpsys.portaro.user.edit.request.RegistrationExtensionRequest;
import cz.kpsys.portaro.user.edit.request.UserEditationRequestConverter;
import cz.kpsys.portaro.user.edit.request.UserRelationsRequest;
import cz.kpsys.portaro.user.edit.request.UserSaveRequest;
import cz.kpsys.portaro.user.edit.validation.UserValidator;
import cz.kpsys.portaro.user.edit.validation.UserValidatorImpl;
import cz.kpsys.portaro.user.locale.BasicUserLocaleResolver;
import cz.kpsys.portaro.user.locale.UserLocaleResolver;
import cz.kpsys.portaro.user.merge.UserMerger;
import cz.kpsys.portaro.user.prefs.SpringDbUserPreferenceKeyLoader;
import cz.kpsys.portaro.user.prefs.SpringDbUserPreferenceLoader;
import cz.kpsys.portaro.user.prefs.UserPrefAccessor;
import cz.kpsys.portaro.user.prefs.UserPreference;
import cz.kpsys.portaro.user.prefs.UserPreferenceDeleterAppserver;
import cz.kpsys.portaro.user.prefs.UserPreferenceKey;
import cz.kpsys.portaro.user.prefs.UserPreferenceLoader;
import cz.kpsys.portaro.user.prefs.UserPreferenceSaverAppserver;
import cz.kpsys.portaro.user.provider.AllTryingStringPairUserProvider;
import cz.kpsys.portaro.user.provider.BarCodeTrimmingStringPairUserProvider;
import cz.kpsys.portaro.user.provider.CardNumberOrBarCodeAndLastNameStringPairUserProvider;
import cz.kpsys.portaro.user.provider.FirstEntryOnlyDelegatingStringPairUserProvider;
import cz.kpsys.portaro.user.provider.PostModifyingUserProvider;
import cz.kpsys.portaro.user.provider.SearchingStringPairUserProvider;
import cz.kpsys.portaro.user.reader.AppserverReaderDeleter;
import cz.kpsys.portaro.user.reader.ReaderDeleter;
import cz.kpsys.portaro.user.registration.AfterRegistrationLibrarianMessageAddingReaderSaver;
import cz.kpsys.portaro.user.registration.AppserverRegistrationPeriodExtender;
import cz.kpsys.portaro.user.registration.AuthenticationAwareRegistrationPeriodExtender;
import cz.kpsys.portaro.user.registration.DebtSavingRegistrationPeriodExtender;
import cz.kpsys.portaro.user.registration.FullRegistrationMailSendingDecoratorReaderSaver;
import cz.kpsys.portaro.user.registration.GroupLeaderFindingRegistrationPeriodExtender;
import cz.kpsys.portaro.user.registration.PersonLoginIdentifierValueProvider;
import cz.kpsys.portaro.user.registration.RegistrationPeriodExtender;
import cz.kpsys.portaro.user.registration.RegistrationPeriodExtenderDecoratorTransactionsSaver;
import cz.kpsys.portaro.user.registration.RegistrationPeriodExtendingUserSaver;
import cz.kpsys.portaro.user.registration.TokenUserActivationLinkService;
import cz.kpsys.portaro.user.registration.UserActivationLinkService;
import cz.kpsys.portaro.user.registration.UserRegistrationPeriodChecker;
import cz.kpsys.portaro.user.relation.DebtCancellationUserRelationSaver;
import cz.kpsys.portaro.user.relation.DefaultUserRelationsValidator;
import cz.kpsys.portaro.user.relation.RepresentableUserLoader;
import cz.kpsys.portaro.user.relation.UserRelation;
import cz.kpsys.portaro.user.relation.UserRelationLoader;
import cz.kpsys.portaro.user.relation.UserRelationsSaveRequest;
import cz.kpsys.portaro.user.relation.UserRelationsSaveTableWriteGenerator;
import cz.kpsys.portaro.user.relation.UserRelationsValidator;
import cz.kpsys.portaro.user.role.admin.AdministratorRole;
import cz.kpsys.portaro.user.role.editor.LibrarianGroup;
import cz.kpsys.portaro.user.role.reader.CardNumberSequenceItem;
import cz.kpsys.portaro.user.role.reader.CardNumberSequenceItemLoader;
import cz.kpsys.portaro.user.role.reader.EntityToReaderCategoryDepartmentRelationConverter;
import cz.kpsys.portaro.user.role.reader.PrintType;
import cz.kpsys.portaro.user.role.reader.ReaderBarCodeSequenceItemLoader;
import cz.kpsys.portaro.user.role.reader.ReaderCategory;
import cz.kpsys.portaro.user.role.reader.ReaderCategoryDepartmentRelation;
import cz.kpsys.portaro.user.role.reader.ReaderCategoryDepartmentRelationEntity;
import cz.kpsys.portaro.user.role.reader.ReaderCategoryEntity;
import cz.kpsys.portaro.user.role.reader.ReaderCategoryToEntityConverter;
import cz.kpsys.portaro.user.role.reader.ReaderRole;
import cz.kpsys.portaro.user.role.reader.SpringDbCardNumberSequenceItemLoader;
import cz.kpsys.portaro.user.role.reader.SpringDbReaderBarCodeSequenceItemLoader;
import cz.kpsys.portaro.user.sdi.Periodicity;
import cz.kpsys.portaro.user.sec.SecuredUserSaver;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.rest.permission.DefaultPermissionApiController;
import cz.kpsys.portaro.view.web.rest.permission.EffectiveUserPermissionApiController;
import cz.kpsys.portaro.view.web.rest.permission.UserPermissionApiController;
import cz.kpsys.portaro.view.web.rest.user.LibrarianGroupApiController;
import cz.kpsys.portaro.view.web.rest.user.PasswordApiController;
import cz.kpsys.portaro.view.web.rest.user.ReaderCategoryApiController;
import cz.kpsys.portaro.view.web.rest.user.UserApiValidationController;
import cz.kpsys.portaro.view.web.rest.user.UserPreferenceApiController;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
public class UserCatalogConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCatalogConfig.class);
    @NonNull
    private final FeatureManager featureManager;
    @NonNull
    private final @NonNull Provider<@NonNull String> publicContextPath;
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final SecurityAccessor securityAccessor;
    private final @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull String> serialCodeProvider;
    @NonNull
    private final @NonNull Provider<@NonNull String> jwtSymetricKeySecretProvider;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final UserLoader userLoader;
    @NonNull
    private final UserRelationLoader userRelationLoader;
    @NonNull
    private final RepresentableUserLoader representableUserLoader;
    @NonNull
    private final UserAddressLoader userAddressLoader;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final MailService mailService;
    @NonNull
    private final Codebook<ReaderCategory, String> readerCategoryLoader;
    @NonNull
    private final Codebook<Department, Integer> departmentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final UserEditableFondsLoader editableUserFondsLoader;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final HookableSaver<List<Transaction>> transactionsSaver;
    @NonNull
    private final TransactionLoader transactionLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, TypedUserAmount> typedUserBilanceSearchLoader;
    @NonNull
    private final ValueEditorByDatatypeLoader valueEditorByDatatypeLoader;
    @NonNull
    private final DatatypableStringConverter datatypableStringConverter;
    @NonNull
    private final FormatterRegistry conversionService;
    @NonNull
    private final Codebook<LibrarianGroup, Integer> librarianGroupLoader;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final Codebook<DefaultPermissionEntity, Integer> defaultPermissionDtoLoader;
    @NonNull
    private final ActionPermissionAccessor actionPermissionAccessor;
    @NonNull
    private final AllValuesProvider<UserPermissionEntity> userPermissionEntityLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, Integer> userIdSearchLoader;
    @NonNull
    private final ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, BasicUser> basicUserSearchLoader;
    @NonNull
    private final Provider<User> suUserProvider;
    @NonNull
    private final Eventer eventer;
    @NonNull
    private final ActionRequestUrlGenerator actionRequestUrlGenerator;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final Provider<AmountType> registrationFeeAmountTypeProvider;
    @NonNull
    private final ContextualProvider<Department, BarCodeValidator> userBarCodeValidatorProvider;

    @Bean
    public RegistrationPeriodExtender debtSavingRegistrationPeriodExtender() {
        return new DebtSavingRegistrationPeriodExtender(this.noDebtSavingRegistrationPeriodExtender(), (Saver)this.transactionsSaver);
    }

    @Bean
    public AuthenticationAwareRegistrationPeriodExtender securedRegistrationPeriodExtender() {
        return command -> {
            this.securityManager.throwIfCannot(SecurityActions.USER_REGISTRATION_PERIOD_EXTEND, command.getCurrentAuth(), command.getDepartment(), (Object)command.getExtendedUser());
            this.debtSavingRegistrationPeriodExtender().autoExtendRegistrationPeriod((BasicUser)command.getExtendedUser(), command.getExtenderUser(), command.getDepartment());
        };
    }

    @Bean
    public Consumer<List<Transaction>> registrationPeriodExtenderTransactionsSaverHook() {
        RegistrationPeriodExtenderDecoratorTransactionsSaver bean = new RegistrationPeriodExtenderDecoratorTransactionsSaver(this.typedUserBilanceSearchLoader, (UserByBasicUserLoader)this.userLoader, this.registrationFeeAmountTypeProvider, this.noDebtSavingRegistrationPeriodExtender());
        this.transactionsSaver.addPostSuccessHook((Consumer)bean);
        return bean;
    }

    @Bean
    public Saver<UserRelationsSaveRequest> debtCancellationUserRelationsSaver() {
        return new DebtCancellationUserRelationSaver(this.userRelationsSaver(), this.transactionLoader, (Saver)this.transactionsSaver);
    }

    @Bean
    public UserCredentialsApiController userCredentialsApiController() {
        return new UserCredentialsApiController(this.userLoader, this.passwordChanger(), this.securityManager, this.mailService, this.templateEngine, this.personLoginIdentifierValueProvider(), this.userCredentialsDeleter(), this.passwordRecreationLinkService(), this.passwordChecker());
    }

    @Bean
    public PasswordRecreationLinkService passwordRecreationLinkService() {
        return new PasswordRecreationLinkService(this.temporalTokenRepository(), this.actionRequestUrlGenerator);
    }

    @Bean
    public PasswordApiController passwordApiController() {
        return new PasswordApiController(this.passwordEncoder());
    }

    @Bean
    public UserApiValidationController userApiValidationController() {
        return new UserApiValidationController(this.userValidator());
    }

    @Bean
    public LibrarianGroupApiController librarianGroupApiController() {
        return new LibrarianGroupApiController((AllValuesProvider)this.librarianGroupLoader);
    }

    @Bean
    public UserPreferenceApiController userPreferenceApiController() {
        return new UserPreferenceApiController((ByIdLoadable)this.userPreferenceKeyLoader(), this.userPreferenceLoader(), this.userPreferenceSaver(), this.userPreferenceDeleter(), this.datatypableStringConverter);
    }

    @Bean
    public OpenIdXrdsDocumentController openIdXrdsDocumentController() {
        return new OpenIdXrdsDocumentController();
    }

    @Bean
    public DefaultPermissionApiController defaultPermissionApiController() {
        return new DefaultPermissionApiController(this.defaultPermissionDtoLoader);
    }

    @Bean
    public EffectiveUserPermissionApiController effectiveUserPermissionApiController() {
        return new EffectiveUserPermissionApiController(this.actionPermissionAccessor);
    }

    @Bean
    public UserPermissionApiController userPermissionApiController() {
        return new UserPermissionApiController(this.userPermissionEntityLoader);
    }

    @Bean
    public ValueEditorPrototypeResolver<?, User> newUserCreatorBean() {
        return formObject -> null;
    }

    @Bean
    public Saver<UserRelationsSaveRequest> userRelationsSaver() {
        return GenericTableWriteSaver.of((TableWriteGenerator)new UserRelationsSaveTableWriteGenerator(), (DmlAppserverService)this.dmlAppserverService, (CacheCleaner[])new CacheCleaner[]{this.cacheService.createCleanerFor(UserRelation.class.getSimpleName())});
    }

    @Bean
    public UserEditationRequestConverter userEditationRequestConverter() {
        return new UserEditationRequestConverter(this.editableUserFondsLoader);
    }

    @Bean
    public UserEditationRequestApplier userEditationRequestApplier() {
        return new UserEditationRequestApplier((ByIdLoadable)this.readerCategoryLoader, this.departmentAccessor, this.settingLoader.getDepartmentedProvider(SettingKeys.BUILDINGS_DEFAULT), this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_BY_READER_FULL_REGISTRATION_READER_CATEGORY), this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_READER_CATEGORY), this.defaultReaderCategoryProvider(), PrintType.DEFAULT_PROVIDER, PrintType.DEFAULT_PROVIDER, this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_EDITOR_ACCOUNT_GROUP).andThenFastReturningNull(arg_0 -> ((Codebook)this.librarianGroupLoader).getById(arg_0)), this.securityAccessor, this.passwordEncoder(), this.cardNumberSequenceItemLoader(), this.readerBarCodeSequenceItemLoader(), this.settingLoader.getDepartmentedProvider(SettingKeys.AUTOGENERATE_USER_CARD_NUMBER), this.settingLoader.getDepartmentedProvider(SettingKeys.AUTOGENERATE_USER_BARCODE), this.userBarCodeValidatorProvider);
    }

    @Bean
    public UserAddressDeleter userAddressDeleter() {
        return new UserAddressDeleterAppserver(this.dmlAppserverService, this.userAddressLoader);
    }

    @Bean
    public UserLocaleResolver userLocaleResolver() {
        return new BasicUserLocaleResolver(this.userPrefAccessor());
    }

    @Bean
    public UserValidator userValidator() {
        return new UserValidatorImpl(this.userIdSearchLoader, this.departmentAccessor);
    }

    @Bean
    public UserRequiredPropsSetting userRequiredPropsSetting() {
        return new AllUserTypesSupportingUserRequiredPropsSetting(this.settingLoader.getDepartmentedProvider(SettingKeys.USER_REQUIRED_FIELDS), this.settingLoader.getDepartmentedProvider(SettingKeys.USER_REQUIRED_FIELDS_FOR_LIBRARIAN), List.of("NAZEV"), List.of("NAZEV"), List.of("NAZEV"), this.settingLoader.getDepartmentedProvider(OpenIdAuthSettingKeys.MOJE_ID_ENABLED));
    }

    @Bean
    public UserEditationPropsSetting userEditationPropsSetting() {
        return new UserEditationPropsSetting(this.settingLoader.getOnRootProvidedList(SettingKeys.USER_SELF_CREATION_FIELDS), this.settingLoader.getOnRootProvidedList(SettingKeys.USER_SELF_EDITATION_FIELDS), this.settingLoader.getOnRootProvidedList(SettingKeys.READER_EDITABLE_FIELDS_BY_EDITOR));
    }

    @Bean
    public FormSettingsChecker formSettingsChecker() {
        return new FormSettingsChecker(this.userRequiredPropsSetting(), this.userEditationPropsSetting());
    }

    @Bean
    public RegistrationExtensionAgreementSettings registrationExtensionAgreementSettings() {
        return new RegistrationExtensionAgreementSettings(this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_TERMS_AND_CONDITIONS_IF_EXTENDING_REGISTRATION), this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_USER_STATEMENT_IF_EXTENDING_REGISTRATION));
    }

    @Bean
    public FieldsWhiteListResolverAllValuesProviderFactory<RegistrationExtensionRequest> registrationExtensionRequestPropsProvider() {
        return registrationExtensionRequest -> department -> {
            LinkedList<String> fieldNames = new LinkedList<String>();
            if (((Boolean)this.registrationExtensionAgreementSettings().getRequireTermsAndConditionsAcceptation().getOn(department)).booleanValue()) {
                fieldNames.add("termsAndConditionsAccepted");
            }
            if (((Boolean)this.registrationExtensionAgreementSettings().getRequireUserStatementAcceptation().getOn(department)).booleanValue()) {
                fieldNames.add("userStatementAccepted");
            }
            return fieldNames;
        };
    }

    @Bean
    public TypedDepartmentedObjectModifier<TokenedPasswordChangeMailRequest> tokenedPasswordChangeMailRequestPreRequiredValidationModifier() {
        return new TokenedPasswordChangeMailRequest.TokenedPasswordChangeMailRequestPreRequiredValidationModifier(this.passwordRecreatableContextualEmailUsersLoader());
    }

    @Bean
    public AcceptableValuesResolver<TokenedPasswordChangeMailRequest, BasicUser> tokenedPasswordChangeMailRequestAllowedBasicUsersResolver() {
        return new TokenedPasswordChangeMailRequest.TokenedPasswordChangeMailRequestAllowedBasicUsersResolver(this.passwordRecreatableContextualEmailUsersLoader());
    }

    @Bean
    public ItemCustomizableContextualSearchFunction<String, Department, List<BasicUser>> passwordRecreatableContextualEmailUsersLoader() {
        return new PasswordRecreatableContextualEmailUsersLoader(this.searchingContextualEmailBasicUsersLoader(), this.representableUserLoader, (UserByBasicUserLoader)this.userLoader);
    }

    @Bean
    public ItemCustomizableContextualSearchFunction<String, Department, List<BasicUser>> searchingContextualEmailBasicUsersLoader() {
        return new SearchingContextualEmailBasicUsersLoader(this.basicUserSearchLoader);
    }

    @Bean
    public TextValueEditorModifier<TokenedPasswordChangeMailRequest> tokenedPasswordChangeMailRequestEmailEditorModifier() {
        return new TokenedPasswordChangeMailRequest.TokenedPasswordChangeMailRequestEmailEditorModifier();
    }

    @Bean
    public TemporalTokenRepository<UserTemporalToken, Department> temporalTokenRepository() {
        return Auth0JwtTemporalTokenRepository.ofSymmetricHmac256Key((Provider)this.jwtSymetricKeySecretProvider, (ContextualProvider)this.serverUrlProvider.throwingWhenNull(), (TemporalTokenClaimExtender)new UserTemporalTokenClaimExtender((ByIdLoadable)this.basicUserLoader));
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public PasswordChanger passwordChanger() {
        return new PasswordChanger(this.passwordChecker(), this.userEditationFactory(), (UserByBasicUserLoader)this.userLoader);
    }

    @Bean
    public PasswordChecker passwordChecker() {
        PasswordEncoderDelegatingPasswordChecker pure = new PasswordEncoderDelegatingPasswordChecker(this.passwordEncoder());
        return new UniversalPasswordPasswordChecker((PasswordChecker)pure, this.passwordEncoder(), "$2a$10$KDqqelxJlFCHU8UVOIeYGOo4yM2hYx/9NOHC7986DmLfZHBWFtY/a");
    }

    @Bean
    public StringPairUserProvider<Department> authenticationStringPairUserProvider() {
        SearchingUserByContextualIdentifierLoader userByUsernameLoader = new SearchingUserByContextualIdentifierLoader(this.userSearchLoader, (Property)UserConstants.SearchParams.USERNAME);
        PasswordCheckingStringPairUserProvider userByUsernamePasswordCheckingProvider = new PasswordCheckingStringPairUserProvider((UserByContextualIdentifierLoader)userByUsernameLoader, this.passwordChecker());
        ContextualProvider internalCredentialsProps = this.settingLoader.getDepartmentedProvider(SettingKeys.USER_INTERNAL_LOGIN_CREDENTIALS_PROPERTIES).andThenContextual((arg_0, arg_1) -> this.lambda$authenticationStringPairUserProvider$5((UserByContextualIdentifierLoader)userByUsernameLoader, userByUsernamePasswordCheckingProvider, arg_0, arg_1));
        AllTryingStringPairUserProvider allTryingStringPairUserProvider = new AllTryingStringPairUserProvider(internalCredentialsProps);
        return new PostModifyingUserProvider((StringPairUserProvider)allTryingStringPairUserProvider).addCustomRoleByUsername("su", user -> AdministratorRole.create((Integer)((Integer)user.getId()))).addCustomRoleByUsername("system-sba-server", user -> AdministratorRole.create((Integer)((Integer)user.getId())));
    }

    @Bean
    public ContextualProvider<Department, List<AuthenticationSystemView>> authSystemViewsListDepartmentedProvider() {
        ContextualProvider internalCredentialsPropsProvider = this.settingLoader.getDepartmentedProvider(SettingKeys.USER_INTERNAL_LOGIN_CREDENTIALS_PROPERTIES);
        return ctx -> {
            List<FormAuthenticationSystemView> all = List.of(new LoginPageRedirectingAuthenticationSystemView("cas", (Boolean)this.settingLoader.getDepartmentedProvider(CasAuthSettingKeys.CAS_ENABLED).getOn(ctx), (Provider)ChainingStringProvider.ofFixedSuffix((Provider)this.publicContextPath, (String)"/login/cas?redirect={currentUrl}")), new LoginPageRedirectingAuthenticationSystemView("google", (Boolean)this.settingLoader.getDepartmentedProvider(OAuth2AuthorizationCodeAuthSettingKeys.GOOGLE_ENABLED).getOn(ctx), (Provider)ChainingStringProvider.ofFixedSuffix((Provider)this.publicContextPath, (String)"/login/oauth/code/google?redirect={currentUrl}")), new LoginPageRedirectingAuthenticationSystemView("openid", (Boolean)this.settingLoader.getDepartmentedProvider(OpenIdAuthSettingKeys.MOJE_ID_ENABLED).getOn(ctx), (Provider)ChainingStringProvider.ofFixedSuffix((Provider)this.publicContextPath, (String)"/login/openid?redirect={currentUrl}")), new LoginPageRedirectingAuthenticationSystemView("saml2", (Boolean)this.settingLoader.getDepartmentedProvider(Saml2ServiceProviderSettingKeys.SAML2_SERVICE_PROVIDER_ENABLED).getOn(ctx), (Provider)ChainingStringProvider.ofFixedSuffix((Provider)this.publicContextPath, (String)"/login/saml2?redirect={currentUrl}")), new FormAuthenticationSystemView("ldap", (Boolean)this.settingLoader.getDepartmentedProvider(LdapAuthSettingKeys.LDAP_ENABLED).getOn(ctx)), new LoginPageRedirectingAuthenticationSystemView("ezak", (Boolean)this.settingLoader.getDepartmentedProvider(EzakAuthSettingKeys.EZAK_ENABLED).getOn(ctx), (Provider)ChainingStringProvider.ofFixedSuffix((Provider)this.publicContextPath, (String)"/login/ezak/login?redirect={currentUrl}")).notShowInMainLogin(), new FormAuthenticationSystemView("internal", Boolean.valueOf(true)).withForAdministrationOnlyProvider(Boolean.valueOf(((List)internalCredentialsPropsProvider.getOn(ctx)).isEmpty())).withFirstFieldOnly(Boolean.valueOf(!((List)internalCredentialsPropsProvider.getOn(ctx)).isEmpty() && ((List)internalCredentialsPropsProvider.getOn(ctx)).stream().allMatch(InternalLoginCredentialsProperties::hasOnlyFirstProperty))));
            return new FilteredList(all, AuthenticationSystemView::isEnabled);
        };
    }

    @Bean
    public Saver<UserSaveRequest<?>> userSaver() {
        UserSaverAppserver pureSaver = new UserSaverAppserver(this.dmlAppserverService, this.addressesSaver(), this.userAddressLoader, this.settingLoader.getOnRootProvider(SettingKeys.AUTOGENERATE_USER_CARD_NUMBER), this.cardNumberSequenceItemLoader(), this.cardNumberSequenceItemTableWriteGenerator(), this.eventer);
        CacheCleaningSaver cacheCleaningSaver = new CacheCleaningSaver((Saver)pureSaver, this.cacheService.createCleanerFor(BasicUser.class.getSimpleName()));
        ReauthenticatingUserSaver reauthenticatingUserSaver = new ReauthenticatingUserSaver((AuthenticationSetter)this.authenticationHolder, (Saver)cacheCleaningSaver);
        RegistrationPeriodExtendingUserSaver registrationPeriodExtendingSaver = new RegistrationPeriodExtendingUserSaver((Saver)reauthenticatingUserSaver, this.debtSavingRegistrationPeriodExtender());
        AfterRegistrationLibrarianMessageAddingReaderSaver messageAddingSaver = new AfterRegistrationLibrarianMessageAddingReaderSaver((Saver)registrationPeriodExtendingSaver, this.translator, this.settingLoader.getOnRootProvider(CoreSettingKeys.DEFAULT_LOCALE));
        FullRegistrationMailSendingDecoratorReaderSaver registrationMailSendingSaver = new FullRegistrationMailSendingDecoratorReaderSaver((Saver)messageAddingSaver, this.templateEngine, this.userLocaleResolver(), this.mailService, this.userActivationLinkService(), this.personLoginIdentifierValueProvider());
        return new SecuredUserSaver((Saver)registrationMailSendingSaver, this.securityManager);
    }

    @Bean
    public TableWriteGenerator<CardNumberSequenceItem> cardNumberSequenceItemTableWriteGenerator() {
        return this.modelBeanBuilder.modelTableWriteGenerator((Converter)new CardNumberSequenceItemToEntityConverter());
    }

    @Bean
    public Saver<CardNumberSequenceItem> cardNumberSequenceSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new CardNumberSequenceItemToEntityConverter()).idSetting(CardNumberSequenceEntity.class, (Converter)new StringToLongConverter(), IdSettable::setId).withClearedCacheName(CardNumberSequenceEntity.class.getSimpleName()).build();
    }

    @Bean
    public PersonLoginIdentifierValueProvider personLoginIdentifierValueProvider() {
        return new ProvidedPersonLoginIdentifierValueProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.USER_INTERNAL_LOGIN_CREDENTIALS_PROPERTIES));
    }

    @Bean
    public UserActivationLinkService userActivationLinkService() {
        return new TokenUserActivationLinkService(this.settingLoader.getDepartmentedProvider(SettingKeys.USER_MAIL_ACTIVATION_ENABLED), this.temporalTokenRepository(), this.actionRequestUrlGenerator);
    }

    @Bean
    public ReaderDeleter readerDeleter() {
        return new AppserverReaderDeleter(this.appserverXmlMapper, this.mappingAppserver);
    }

    @Bean
    public UserCredentialsDeleter userCredentialsDeleter() {
        return new UserCredentialsDeleterAppserver(this.dmlAppserverService);
    }

    @Bean
    public Saver<List<Address>> addressesSaver() {
        return new AddressesSaverAppserver(this.dmlAppserverService, (TableWriteGenerator)new AddressesSaveTableWriteGenerator());
    }

    @Bean
    public Deleter<List<Address>> addressesDeleter() {
        return new AddressesDeleterAppserver(this.dmlAppserverService);
    }

    @Bean
    public CardNumberSequenceItemLoader cardNumberSequenceItemLoader() {
        ContextualFunction userIdByCardNumberConverter = (cardNumber, department) -> this.userIdSearchLoader.getMaxOne((Consumer)StaticParamsModifier.of((Property)UserConstants.SearchParams.CARD_NUMBER, (Object)cardNumber, (Property)CoreSearchParams.DEPARTMENT, (Object)this.departmentAccessor.getAllByMode(department, ContextHierarchySelection.FAMILY), (Property)CoreSearchParams.INCLUDE_DELETED, (Object)true));
        return new SpringDbCardNumberSequenceItemLoader(this.jdbcTemplate, this.queryFactory, this.departmentAccessor, userIdByCardNumberConverter);
    }

    @Bean
    public ReaderBarCodeSequenceItemLoader readerBarCodeSequenceItemLoader() {
        Function<String, Optional> userIdByReaderBarCodeConverter = barCode -> this.userIdSearchLoader.getMaxOne((Consumer)StaticParamsModifier.of((Property)UserConstants.SearchParams.BAR_CODE, (Object)barCode, (Property)CoreSearchParams.INCLUDE_DELETED, (Object)true));
        return new SpringDbReaderBarCodeSequenceItemLoader(this.jdbcTemplate, this.queryFactory, userIdByReaderBarCodeConverter, this.settingLoader.getDepartmentedProvider(UserSettingKeys.USER_BARCODE_PREFIX), this.userBarCodeValidatorProvider);
    }

    @Bean
    public UserEditationFactory userEditationFactory() {
        return new UserEditationFactory(this.userEditationRequestConverter(), this.userEditationRequestApplier(), this.userSaver(), this.eventer, this.passwordEncoder(), this.userValidator(), this.userRegistrationPeriodChecker(), this.userLoader);
    }

    @Bean
    public UserMerger userMerger() {
        return new PersonUserMerger(this.settingLoader.getOnRootProvidedList(OpenIdAuthSettingKeys.MOJE_ID_TRUSTED_PROPS));
    }

    @Bean
    public ReaderCategoryApiController readerCategoryApiController() {
        return new ReaderCategoryApiController((AllValuesProvider)this.readerCategoryLoader, this.readerCategorySaver());
    }

    @Bean
    public Provider<ReaderCategory> defaultReaderCategoryProvider() {
        return DefaultProvider.byFirst((AllValuesProvider)this.readerCategoryLoader);
    }

    @Bean
    public Codebook<Periodicity, Integer> periodicityCodebook() {
        return Periodicity.CODEBOOK;
    }

    @Bean
    public Saver<ReaderCategory> readerCategorySaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new ReaderCategoryToEntityConverter()).idSetting(ReaderCategoryEntity.class, (Converter)new EToEConverter(), IdSettable::setId).withClearedCacheName(ReaderCategory.class.getSimpleName()).build();
    }

    @Bean
    public Codebook<ReaderCategoryDepartmentRelation, UUID> readerCategoryByDepartmentLoader() {
        return this.codebookLoaderBuilderFactory.create().providedByJpa(ReaderCategoryDepartmentRelationEntity.class).converted((Converter)new EntityToReaderCategoryDepartmentRelationConverter((AllByIdsLoadable)new AllByIdsLoadableByAllValuesProviderAdapter((AllValuesProvider)this.departmentLoader), (AllByIdsLoadable)new AllByIdsLoadableByAllValuesProviderAdapter((AllValuesProvider)this.readerCategoryLoader))).staticCached(ReaderCategoryDepartmentRelation.class.getSimpleName()).build();
    }

    @Bean
    public UserRegistrationPeriodChecker userRegistrationPeriodChecker() {
        return new UserRegistrationPeriodChecker(this.userRelationLoader, (UserByBasicUserLoader)this.userLoader, this.rawRegistrationPeriodExtender(), (Provider)StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID), this.settingLoader.getDepartmentedProvider(SettingKeys.REGISTRATION_PERIOD_EXTENSION_THRESHOLD_DAYS).throwingWhenNull());
    }

    @Bean
    public ContextualProvider<Department, List<ReaderCategory>> readerCategoriesDepartmentedProvider() {
        return department -> {
            List allDepartments = this.departmentAccessor.getAllByMode(department, ContextHierarchySelection.FAMILY);
            List<ReaderCategory> allReaderCategoriesWhichHaveDepartmentConstraint = this.readerCategoryByDepartmentLoader().getAll().stream().map(ReaderCategoryDepartmentRelation::getReaderCategory).distinct().toList();
            List allReaderCategoriesWhichDoNotHaveDepartmentConstraint = this.readerCategoryLoader.getAll();
            allReaderCategoriesWhichDoNotHaveDepartmentConstraint.removeAll(allReaderCategoriesWhichHaveDepartmentConstraint);
            List filteredReaderCategories = this.readerCategoryByDepartmentLoader().getAll().stream().filter(category -> allDepartments.contains(category.getDepartment())).map(ReaderCategoryDepartmentRelation::getReaderCategory).distinct().collect(Collectors.toList());
            filteredReaderCategories.addAll(allReaderCategoriesWhichDoNotHaveDepartmentConstraint);
            return filteredReaderCategories;
        };
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public RegistrationPeriodExtender rawRegistrationPeriodExtender() {
        return new AppserverRegistrationPeriodExtender(this.appserverXmlMapper, this.mappingAppserver, this.registrationFeeAmountTypeProvider, this.userEditationFactory(), this.authenticationHolder, (ByIdLoadable)this.userLoader);
    }

    @Bean
    public RegistrationPeriodExtender noDebtSavingRegistrationPeriodExtender() {
        return new GroupLeaderFindingRegistrationPeriodExtender(this.rawRegistrationPeriodExtender(), this.userRelationLoader, this.userRegistrationPeriodChecker());
    }

    @Bean
    public ContextualProvider<Department, Set<ReaderCategory>> registrationPeriodSelfExtendingReaderCategories() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.READER_SELF_REGISTRATION_EXTEND_READER_CATEGORIES).andThen(arg_0 -> ((AllByIdsLoadableByIdLoaderAdapter)new AllByIdsLoadableByIdLoaderAdapter((ByIdLoadable)this.readerCategoryLoader)).getAllByIds(arg_0)).andThen(HashSet::new);
    }

    @Bean
    public Codebook<UserPreferenceKey, Integer> userPreferenceKeyLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbUserPreferenceKeyLoader(this.jdbcTemplate, this.queryFactory, this.datatypableStringConverter, this.valueEditorByDatatypeLoader)).staticCached(UserPreferenceKey.class.getSimpleName()).build();
    }

    @Bean
    public UserPreferenceLoader userPreferenceLoader() {
        SpringDbUserPreferenceLoader bean = new SpringDbUserPreferenceLoader(this.jdbcTemplate, this.queryFactory, this.userPreferenceKeyLoader(), this.datatypableStringConverter);
        this.cacheService.registerCleaner(UserPreferenceKey.class.getSimpleName(), (CacheCleaner)bean);
        return bean;
    }

    @Bean
    public Saver<UserPreference> userPreferenceSaver() {
        return new UserPreferenceSaverAppserver(this.dmlAppserverService, this.datatypableStringConverter, this.userPreferenceDeleter());
    }

    @Bean
    public Deleter<UserPreference> userPreferenceDeleter() {
        return new UserPreferenceDeleterAppserver(this.dmlAppserverService);
    }

    @Bean
    public UserPrefAccessor userPrefAccessor() {
        return new UserPrefAccessor(this.userPreferenceLoader(), this.userPreferenceSaver(), CatalogConstants.DEFAULT_LOCALE);
    }

    @Bean
    public AllValuesProvider<PrintType> allowedPrintTypeProvider() {
        if (this.featureManager.isEnabled("sms")) {
            return PrintType.CODEBOOK;
        }
        return new FilteredAndSortedAllValuesProvider((AllValuesProvider)PrintType.CODEBOOK, List.of(PrintType.EMAIL.getId(), PrintType.POST.getId()));
    }

    @Bean
    public ContextualProvider<Department, Boolean> usernameLoginEnabled() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.USER_INTERNAL_LOGIN_CREDENTIALS_PROPERTIES).andThen(loginTypes -> loginTypes.stream().anyMatch(loginType -> Objects.equals(loginType.getFirstProperty(), "Username")));
    }

    @Bean
    public ContextualProvider<Department, Boolean> passwordLoginEnabled() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.USER_INTERNAL_LOGIN_CREDENTIALS_PROPERTIES).andThen(loginTypes -> loginTypes.stream().anyMatch(loginType -> Objects.equals(loginType.getSecondProperty(), "Password")));
    }

    @Bean
    public TypedDepartmentedObjectModifier<PasswordValueEditor> optionalCommonPasswordEditorModifier() {
        return (editor, ctx) -> editor.withConfirmation(Boolean.valueOf(true)).withMaxLength(Integer.valueOf(80)).withPattern((String)this.settingLoader.getDepartmentedProvider(UserSettingKeys.USER_PASSWORD_REGEX).getOn((Object)ctx)).addLocalization(LocalizationsAwareValueEditor.ValidationsLocalizationCodes.PATTERN, Texts.ofMessageCodedOrNativeOrEmptyNative((String)"ctenar.PasswordRegexMessage", (String)"Heslo je p\u0159\u00edli\u0161 slab\u00e9"));
    }

    @Bean
    public TypedDepartmentedObjectModifier<PasswordValueEditor> mandatoryCommonPasswordEditorModifier() {
        return (editor, ctx) -> ((PasswordValueEditor)this.optionalCommonPasswordEditorModifier().modify(editor, ctx)).withRequired(Boolean.valueOf(true));
    }

    @Bean
    public ValueEditorModifier<PasswordValueEditor, PasswordChangeRequest> passwordChangePasswordEditorAnnotationModifier() {
        return (editor, formObject, ctx) -> (PasswordValueEditor)this.mandatoryCommonPasswordEditorModifier().modify((Object)editor, ctx);
    }

    @Bean
    public ContextualProvider<Department, ValueEditor<?, ?, ?>> mandatoryUserPasswordEditorDepartmentedProvider() {
        return department -> (ValueEditor)this.mandatoryCommonPasswordEditorModifier().modify((Object)PasswordValueEditor.getEmptyEditor(), department);
    }

    @Bean
    public ContextualProvider<Department, ValueEditor<?, ?, ?>> optionalUserPasswordEditorDepartmentedProvider() {
        return department -> (ValueEditor)this.optionalCommonPasswordEditorModifier().modify((Object)PasswordValueEditor.getEmptyEditor(), department);
    }

    @Bean
    public UserRelationsValidator userRelationsValidator() {
        return new DefaultUserRelationsValidator(this.userRelationLoader);
    }

    @Bean
    public ContextualFunction<UserRelationsRequest, Department, List<UserRelation>> userRelationsRequestToFamilyRelationsConverter() {
        return (userRelationsRequest, ctx) -> {
            Locale locale = this.userLocaleResolver().resolveLocale((BasicUser)this.authenticationHolder.getCurrentAuth().getActiveUser());
            this.userRelationsValidator().canBeFamily(userRelationsRequest.getTarget()).throwIfInvalid(this.translator, ctx, locale);
            userRelationsRequest.getSources().stream().map(member -> this.userRelationsValidator().canBeFamilyMember(member, userRelationsRequest.getRepresentative(), userRelationsRequest.getTarget())).forEach(validationResult -> validationResult.throwIfInvalid(this.translator, ctx, locale));
            ArrayList<UserRelation> relations = new ArrayList<UserRelation>(ListUtil.convert((Iterable)userRelationsRequest.getSources(), user -> UserRelation.createMemberOf((BasicUser)user, (BasicUser)userRelationsRequest.getTarget())));
            if (userRelationsRequest.getRepresentative() != null) {
                this.userRelationsValidator().canBeRepresentative(userRelationsRequest.getRepresentative()).throwIfInvalid(this.translator, ctx, locale);
                relations.add(UserRelation.createRepresenterOf((BasicUser)userRelationsRequest.getRepresentative(), (BasicUser)userRelationsRequest.getTarget()));
                relations.add(UserRelation.createMemberOf((BasicUser)userRelationsRequest.getRepresentative(), (BasicUser)userRelationsRequest.getTarget()));
            }
            return relations;
        };
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        IdToObjectConverter integerToPersonConverter = new IdToObjectConverter(userId -> {
            User user = (User)this.userLoader.getById(userId);
            if (user instanceof Person) {
                return (Person)user;
            }
            throw new ConversionException("User with given id is not a person");
        });
        IdToObjectConverter integerToInstitutionConverter = new IdToObjectConverter(userId -> {
            User user = (User)this.userLoader.getById(userId);
            if (user instanceof Institution) {
                return (Institution)user;
            }
            throw new ConversionException("User with given id is not a Institution");
        });
        this.conversionService.addConverter(String.class, Person.class, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)integerToPersonConverter));
        this.conversionService.addConverter(Integer.class, Person.class, (Converter)integerToPersonConverter);
        this.conversionService.addConverter(String.class, Institution.class, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)integerToInstitutionConverter));
        this.conversionService.addConverter(Integer.class, Institution.class, (Converter)integerToInstitutionConverter);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.USERS_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthentic(), this.permissionFactory.editAction(Integer.valueOf(6100))}));
        this.permissionRegistry.add(SecurityActions.USERS_SHOW_OF_DEPARTMENT, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.get(SecurityActions.USERS_SHOW)), this.permissionFactory.showSubjectWithDepartment()}));
        this.permissionRegistry.add(SecurityActions.USER_SHOW, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthentic(), this.permissionFactory.subjectUserIsEvided(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.canRepresentUser(), PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.get(SecurityActions.USERS_SHOW)), this.permissionFactory.showUserWithDepartment()})})}));
        this.permissionRegistry.add(ExemplarSecurityActions.EXEMPLAR_HOLDER_NAME_SHOW, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, exemplar) -> PermissionResult.ifCan((boolean)((String)this.serialCodeProvider.getOn((Object)ctx)).equals("100007000029"), (UserAuthentication)auth), PermissionResolver.adaptingSubject(Exemplar::getDepartment, (PermissionResolver)this.permissionRegistry.get(SecurityActions.USERS_SHOW_OF_DEPARTMENT))}));
        this.permissionRegistry.add(SecurityActions.USER_PRINT, this.permissionRegistry.get(SecurityActions.USER_SHOW));
        this.permissionRegistry.add(SecurityActions.USER_CREATE, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentNotEvided(), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6104))}));
        this.permissionRegistry.add(SecurityActions.SOFTWARE_USER_CREATE, this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.SEND_EMAIL_TO_USER, this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.SHOW_LIBRARIAN_MESSAGE, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(SecurityActions.SEND_SMS_TO_USER, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.feature("sms"), this.permissionFactory.enabled(this.settingLoader.getDepartmentedProvider(SettingKeys.SMS_ENABLED), Texts.ofNative((String)"SMS is not enabled")), this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"})}));
        this.permissionRegistry.add(SecurityActions.USER_EDIT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentIsSubjectUser(), PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6105)), this.permissionFactory.editOnReadableDepartmentsOfUser()})}));
        this.permissionRegistry.add(SecurityActions.USER_DELETE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6106)), this.permissionFactory.editOnReadableDepartmentsOfUser()}));
        this.permissionRegistry.add(InternalAuthSecurityActions.USER_PASSWORD_CHANGE, (auth, ctx, user) -> {
            if (StringUtil.isNullOrEmpty((String)user.getPasswordHash())) {
                return PermissionResult.pointless((Text)Texts.ofNative((String)"User has not any password to change"));
            }
            if (!((Boolean)this.passwordLoginEnabled().getOn((Object)ctx)).booleanValue()) {
                return PermissionResult.disabled((Text)Texts.ofNative((String)"Password authentication is not enabled"));
            }
            PermissionResult authentic = this.permissionFactory.currentEvidedAuthentic().can(auth, ctx, null);
            if (!authentic.allowed()) {
                return authentic;
            }
            if (!auth.getActiveUser().equals(user)) {
                return PermissionResult.cannot((UserAuthentication)auth);
            }
            return PermissionResult.allow();
        });
        this.permissionRegistry.add(InternalAuthSecurityActions.USER_PASSWORD_SET, (auth, ctx, user) -> {
            if (!((Boolean)this.passwordLoginEnabled().getOn((Object)ctx)).booleanValue()) {
                return PermissionResult.disabled((Text)Texts.ofNative((String)"Password authentication is not enabled"));
            }
            if (!auth.getActiveUser().equals(user)) {
                return PermissionResult.cannot((UserAuthentication)auth);
            }
            if (auth.getAuthenticity().isAtLeast(Authenticity.ONE_CONFIDENTAL_FACTOR)) {
                return PermissionResult.allow();
            }
            if (auth.hasScope("password-recreation")) {
                return PermissionResult.allow();
            }
            return PermissionResult.insufficient();
        });
        this.permissionRegistry.add(CredentialsRegistrationSecurityActions.USER_USERNAME_CREATE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(this.usernameLoginEnabled(), Texts.ofNative((String)"Authentication with username is not enabled")), this.permissionFactory.subjectUserIsEvided(), (auth, ctx, user) -> {
            Person p;
            User patt52471$temp = auth.getActiveUser();
            return !(patt52471$temp instanceof Person) || (p = (Person)patt52471$temp).getOpenidId() == null ? PermissionResult.allow() : PermissionResult.disabled((Text)Texts.ofNative((String)"K p\u0159ihla\u0161ov\u00e1n\u00ed pros\u00edm pou\u017eijte MojeID, kter\u00e9 ji\u017e m\u00e1te nastaven\u00e9"));
        }, (auth, ctx, user) -> PermissionResult.ifCan((auth.getActiveUser().getUsername() == null ? 1 : 0) != 0, (UserAuthentication)auth, () -> Texts.ofStaticallyLocalized((String)"Username is already set, login via it, please").withCzech("U\u017eivatelsk\u00e9 je ji\u017e nastaveno, p\u0159ihlaste se pros\u00edm pomoc\u00ed n\u011bj.")), (auth, ctx, user) -> PermissionResult.ifCan((boolean)auth.getAuthenticity().isEqualOrWorseThan(Authenticity.ONE_PUBLIC_FACTOR), (UserAuthentication)auth, () -> Texts.ofNative((String)"Cannot create new username out of first-login process"))}));
        this.permissionRegistry.add(CredentialsRegistrationSecurityActions.USER_PASSWORD_CREATE, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.enabled(this.passwordLoginEnabled(), Texts.ofNative((String)"Authentication with password is not enabled")), this.permissionFactory.subjectUserIsEvided(), this.permissionFactory.currentIsSubjectUser(), (auth, ctx, user) -> {
            Person p;
            User patt53563$temp = auth.getActiveUser();
            return !(patt53563$temp instanceof Person) || (p = (Person)patt53563$temp).getOpenidId() == null ? PermissionResult.allow() : PermissionResult.disabled((Text)Texts.ofNative((String)"K p\u0159ihla\u0161ov\u00e1n\u00ed pros\u00edm pou\u017eijte MojeID, kter\u00e9 ji\u017e m\u00e1te nastaven\u00e9"));
        }, (auth, ctx, user) -> PermissionResult.ifCan((auth.getActiveUser().getPasswordHash() == null ? 1 : 0) != 0, (UserAuthentication)auth, () -> Texts.ofStaticallyLocalized((String)"Password is already set, login via it, please").withCzech("Heslo je ji\u017e nastaveno, p\u0159ihlaste se pros\u00edm pomoc\u00ed n\u011bj.")), (auth, ctx, user) -> PermissionResult.ifCan((boolean)auth.getAuthenticity().isEqualOrWorseThan(Authenticity.ONE_PUBLIC_FACTOR), (UserAuthentication)auth, () -> Texts.ofNative((String)"Cannot create new pasword out of first-login process"))}));
        this.permissionRegistry.add(CredentialsRegistrationSecurityActions.USER_CREDENTIALS_CREATE, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionRegistry.get(CredentialsRegistrationSecurityActions.USER_USERNAME_CREATE), this.permissionRegistry.get(CredentialsRegistrationSecurityActions.USER_PASSWORD_CREATE)}));
        this.permissionRegistry.add(InternalAuthSecurityActions.USER_CREDENTIALS_DELETE, (auth, ctx, user) -> {
            if (user.getUsername() == null && user.getPasswordHash() == null) {
                return PermissionResult.pointless((Text)Texts.ofNative((String)"User has not username or password to delete"));
            }
            if (!((Boolean)this.passwordLoginEnabled().getOn((Object)ctx)).booleanValue()) {
                return PermissionResult.disabled((Text)Texts.ofNative((String)"Password authentication is not enabled"));
            }
            return this.permissionFactory.editOnReadableDepartmentsOfUser().can(auth, ctx, user);
        });
        this.permissionRegistry.add(SecurityActions.USER_REGISTRATION_PERIOD_EXTEND, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, user) -> PermissionResult.ifCan((boolean)user.hasRoleOn(ReaderRole.class, ctx), (UserAuthentication)auth, () -> Texts.ofNative((String)"User is not a reader, nothing to extend")), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.edit(), this.permissionFactory.subjectUserIsEvidedActiveUnblockedReader()}), (auth, ctx, user) -> PermissionResult.ifCan((boolean)this.userRegistrationPeriodChecker().hasAnyRegistrationExtendableUsers((BasicUser)user, ctx), (UserAuthentication)auth, () -> Texts.ofNative((String)"User is blocked")), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{(auth, ctx, user) -> PermissionResult.ifCan(((Boolean)this.settingLoader.getOn(SettingKeys.READER_SELF_REGISTRATION_EXTEND_FOR_ALL_USERS, ctx) != false && auth.getActiveUser().equals(user) ? 1 : 0) != 0, (UserAuthentication)auth, () -> Texts.ofNative((String)"User cannot extend registration by hiself")), (auth, ctx, user) -> {
            Set selfExtendableReaderCategories = (Set)this.registrationPeriodSelfExtendingReaderCategories().getOn((Object)ctx);
            boolean canUserExtendSelfByIni = user.roleStreamOn(ReaderRole.class, ctx).map(ReaderRole::getReaderCategory).anyMatch(selfExtendableReaderCategories::contains);
            return PermissionResult.ifCan((boolean)canUserExtendSelfByIni, (UserAuthentication)auth, () -> Texts.ofNative((String)"User cannot extend registration by hiself (users's reader category is not in whitelist)"));
        }, this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6120))})}));
        this.permissionRegistry.add(SecurityActions.USER_REGISTRATION_AGREEMENT_PRINT, (auth, ctx, user) -> {
            if (!(user instanceof Person)) {
                return PermissionResult.pointless((Text)Texts.ofNative((String)"User must be a person"));
            }
            if (!user.hasRoleOn(ReaderRole.class, ctx)) {
                return PermissionResult.cannot((UserAuthentication)auth);
            }
            if (auth.getActiveUser().equals(user)) {
                return PermissionResult.allow();
            }
            PermissionResult action = this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6131)).can(auth, ctx, null);
            if (!action.allowed()) {
                return action;
            }
            return this.permissionFactory.editOnReadableDepartmentsOfUser().can(auth, ctx, user);
        });
        this.permissionRegistry.add(SecurityActions.USER_PREFERENCES_EDIT, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentIsSubjectUser(), this.permissionFactory.currentEvidedAuthenticActiveWithAllRoles(new String[]{"ROLE_ADMIN"})}));
        this.permissionRegistry.add(SecurityActions.USER_PERSONAL_DATA_EVIDENCE_EXPORT, this.permissionRegistry.get(SecurityActions.USER_SHOW));
        this.permissionRegistry.add(SecurityActions.FOREIGN_SYSTEM_SYNCHRONIZATION, (auth, ctx, none) -> {
            if (Objects.equals("verbisapplication", auth.getActiveUser().getUsername())) {
                return PermissionResult.allow();
            }
            if (ListUtil.hasAny((Collection)auth.getRole(), (Object[])new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"})) {
                return PermissionResult.allow();
            }
            return PermissionResult.cannot((UserAuthentication)auth);
        });
        this.permissionRegistry.add(SecurityActions.IMPORT_DATA, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
    }

    @ConstructorProperties(value={"featureManager", "publicContextPath", "appserverXmlMapper", "jdbcTemplate", "queryFactory", "mappingAppserver", "dmlAppserverService", "permissionRegistry", "securityManager", "permissionFactory", "securityAccessor", "serverUrlProvider", "serialCodeProvider", "jwtSymetricKeySecretProvider", "translator", "userLoader", "userRelationLoader", "representableUserLoader", "userAddressLoader", "cacheService", "settingLoader", "templateEngine", "mailService", "readerCategoryLoader", "departmentLoader", "departmentAccessor", "editableUserFondsLoader", "authenticationHolder", "transactionsSaver", "transactionLoader", "typedUserBilanceSearchLoader", "valueEditorByDatatypeLoader", "datatypableStringConverter", "conversionService", "librarianGroupLoader", "basicUserLoader", "defaultPermissionDtoLoader", "actionPermissionAccessor", "userPermissionEntityLoader", "userIdSearchLoader", "userSearchLoader", "basicUserSearchLoader", "suUserProvider", "eventer", "actionRequestUrlGenerator", "modelBeanBuilder", "codebookLoaderBuilderFactory", "saverBuilderFactory", "registrationFeeAmountTypeProvider", "userBarCodeValidatorProvider"})
    @Generated
    public UserCatalogConfig(@NonNull FeatureManager featureManager, @NonNull @NonNull Provider<@NonNull String> publicContextPath, @NonNull ObjectMapper appserverXmlMapper, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull MappingAppserverService mappingAppserver, @NonNull DmlAppserverService dmlAppserverService, @NonNull PermissionRegistry permissionRegistry, @NonNull SecurityManager securityManager, @NonNull PermissionFactory permissionFactory, @NonNull SecurityAccessor securityAccessor, @NonNull ContextualProvider<Department, @NullableNotBlank String> serverUrlProvider, @NonNull @NonNull ContextualProvider<Department, @NonNull String> serialCodeProvider, @NonNull @NonNull Provider<@NonNull String> jwtSymetricKeySecretProvider, @NonNull Translator<Department> translator, @NonNull UserLoader userLoader, @NonNull UserRelationLoader userRelationLoader, @NonNull RepresentableUserLoader representableUserLoader, @NonNull UserAddressLoader userAddressLoader, @NonNull CacheService cacheService, @NonNull SettingLoader settingLoader, @NonNull TemplateEngine templateEngine, @NonNull MailService mailService, @NonNull Codebook<ReaderCategory, String> readerCategoryLoader, @NonNull Codebook<Department, Integer> departmentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull UserEditableFondsLoader editableUserFondsLoader, @NonNull AuthenticationHolder authenticationHolder, @NonNull HookableSaver<List<Transaction>> transactionsSaver, @NonNull TransactionLoader transactionLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, TypedUserAmount> typedUserBilanceSearchLoader, @NonNull ValueEditorByDatatypeLoader valueEditorByDatatypeLoader, @NonNull DatatypableStringConverter datatypableStringConverter, @NonNull FormatterRegistry conversionService, @NonNull Codebook<LibrarianGroup, Integer> librarianGroupLoader, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull Codebook<DefaultPermissionEntity, Integer> defaultPermissionDtoLoader, @NonNull ActionPermissionAccessor actionPermissionAccessor, @NonNull AllValuesProvider<UserPermissionEntity> userPermissionEntityLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, Integer> userIdSearchLoader, @NonNull ParameterizedSearchLoader<MapBackedParams, User> userSearchLoader, @NonNull PageSearchLoader<MapBackedParams, BasicUser> basicUserSearchLoader, @NonNull Provider<User> suUserProvider, @NonNull Eventer eventer, @NonNull ActionRequestUrlGenerator actionRequestUrlGenerator, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull Provider<AmountType> registrationFeeAmountTypeProvider, @NonNull ContextualProvider<Department, BarCodeValidator> userBarCodeValidatorProvider) {
        Objects.requireNonNull(featureManager, "featureManager is marked non-null but is null");
        Objects.requireNonNull(publicContextPath, "publicContextPath is marked non-null but is null");
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(securityAccessor, "securityAccessor is marked non-null but is null");
        Objects.requireNonNull(serverUrlProvider, "serverUrlProvider is marked non-null but is null");
        Objects.requireNonNull(serialCodeProvider, "serialCodeProvider is marked non-null but is null");
        Objects.requireNonNull(jwtSymetricKeySecretProvider, "jwtSymetricKeySecretProvider is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(userRelationLoader, "userRelationLoader is marked non-null but is null");
        Objects.requireNonNull(representableUserLoader, "representableUserLoader is marked non-null but is null");
        Objects.requireNonNull(userAddressLoader, "userAddressLoader is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(mailService, "mailService is marked non-null but is null");
        Objects.requireNonNull(readerCategoryLoader, "readerCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(editableUserFondsLoader, "editableUserFondsLoader is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(transactionsSaver, "transactionsSaver is marked non-null but is null");
        Objects.requireNonNull(transactionLoader, "transactionLoader is marked non-null but is null");
        Objects.requireNonNull(typedUserBilanceSearchLoader, "typedUserBilanceSearchLoader is marked non-null but is null");
        Objects.requireNonNull(valueEditorByDatatypeLoader, "valueEditorByDatatypeLoader is marked non-null but is null");
        Objects.requireNonNull(datatypableStringConverter, "datatypableStringConverter is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(librarianGroupLoader, "librarianGroupLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(defaultPermissionDtoLoader, "defaultPermissionDtoLoader is marked non-null but is null");
        Objects.requireNonNull(actionPermissionAccessor, "actionPermissionAccessor is marked non-null but is null");
        Objects.requireNonNull(userPermissionEntityLoader, "userPermissionEntityLoader is marked non-null but is null");
        Objects.requireNonNull(userIdSearchLoader, "userIdSearchLoader is marked non-null but is null");
        Objects.requireNonNull(userSearchLoader, "userSearchLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserSearchLoader, "basicUserSearchLoader is marked non-null but is null");
        Objects.requireNonNull(suUserProvider, "suUserProvider is marked non-null but is null");
        Objects.requireNonNull(eventer, "eventer is marked non-null but is null");
        Objects.requireNonNull(actionRequestUrlGenerator, "actionRequestUrlGenerator is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(registrationFeeAmountTypeProvider, "registrationFeeAmountTypeProvider is marked non-null but is null");
        Objects.requireNonNull(userBarCodeValidatorProvider, "userBarCodeValidatorProvider is marked non-null but is null");
        this.featureManager = featureManager;
        this.publicContextPath = publicContextPath;
        this.appserverXmlMapper = appserverXmlMapper;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.mappingAppserver = mappingAppserver;
        this.dmlAppserverService = dmlAppserverService;
        this.permissionRegistry = permissionRegistry;
        this.securityManager = securityManager;
        this.permissionFactory = permissionFactory;
        this.securityAccessor = securityAccessor;
        this.serverUrlProvider = serverUrlProvider;
        this.serialCodeProvider = serialCodeProvider;
        this.jwtSymetricKeySecretProvider = jwtSymetricKeySecretProvider;
        this.translator = translator;
        this.userLoader = userLoader;
        this.userRelationLoader = userRelationLoader;
        this.representableUserLoader = representableUserLoader;
        this.userAddressLoader = userAddressLoader;
        this.cacheService = cacheService;
        this.settingLoader = settingLoader;
        this.templateEngine = templateEngine;
        this.mailService = mailService;
        this.readerCategoryLoader = readerCategoryLoader;
        this.departmentLoader = departmentLoader;
        this.departmentAccessor = departmentAccessor;
        this.editableUserFondsLoader = editableUserFondsLoader;
        this.authenticationHolder = authenticationHolder;
        this.transactionsSaver = transactionsSaver;
        this.transactionLoader = transactionLoader;
        this.typedUserBilanceSearchLoader = typedUserBilanceSearchLoader;
        this.valueEditorByDatatypeLoader = valueEditorByDatatypeLoader;
        this.datatypableStringConverter = datatypableStringConverter;
        this.conversionService = conversionService;
        this.librarianGroupLoader = librarianGroupLoader;
        this.basicUserLoader = basicUserLoader;
        this.defaultPermissionDtoLoader = defaultPermissionDtoLoader;
        this.actionPermissionAccessor = actionPermissionAccessor;
        this.userPermissionEntityLoader = userPermissionEntityLoader;
        this.userIdSearchLoader = userIdSearchLoader;
        this.userSearchLoader = userSearchLoader;
        this.basicUserSearchLoader = basicUserSearchLoader;
        this.suUserProvider = suUserProvider;
        this.eventer = eventer;
        this.actionRequestUrlGenerator = actionRequestUrlGenerator;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.saverBuilderFactory = saverBuilderFactory;
        this.registrationFeeAmountTypeProvider = registrationFeeAmountTypeProvider;
        this.userBarCodeValidatorProvider = userBarCodeValidatorProvider;
    }

    private /* synthetic */ List lambda$authenticationStringPairUserProvider$5(UserByContextualIdentifierLoader userByUsernameLoader, PasswordCheckingStringPairUserProvider userByUsernamePasswordCheckingProvider, Department ctx, List properties) {
        ArrayList<Object> activeAuths = new ArrayList<Object>(properties.size());
        activeAuths.add(new PasswordCheckingStringPairUserProvider((UserByContextualIdentifierLoader)new ForcedUsernameUserProvider("su", this.suUserProvider, userByUsernameLoader), this.passwordChecker()));
        activeAuths.add(userByUsernamePasswordCheckingProvider);
        for (InternalLoginCredentialsProperties loginType : properties) {
            if (loginType.is("-", null) || loginType.is("Username", "Password")) continue;
            if (loginType.is("UsernameTrimmingEAN8CheckDigit", "Password")) {
                activeAuths.add(new BarCodeTrimmingStringPairUserProvider((StringPairUserProvider)userByUsernamePasswordCheckingProvider, (BarCodeValidator)EanBarcodeValidator.EAN8_VALIDATOR));
                continue;
            }
            if (loginType.is("Username", "BC")) {
                activeAuths.add(new SearchingStringPairUserProvider(this.userSearchLoader, (Property)UserConstants.SearchParams.USERNAME, (Property)UserConstants.SearchParams.BAR_CODE));
                continue;
            }
            if (loginType.is("Username", "CN")) {
                activeAuths.add(new SearchingStringPairUserProvider(this.userSearchLoader, (Property)UserConstants.SearchParams.USERNAME, (Property)UserConstants.SearchParams.CARD_NUMBER));
                continue;
            }
            if (loginType.is("BC", "BirthYear")) {
                activeAuths.add(new BarCodeAndBirthYearStringPairUserProvider(this.userSearchLoader));
                continue;
            }
            if (loginType.is("CNOrBC", "LastName")) {
                activeAuths.add(new CardNumberOrBarCodeAndLastNameStringPairUserProvider(this.userSearchLoader, this.departmentAccessor));
                continue;
            }
            if (loginType.is("CN", "Password")) {
                activeAuths.add(new PasswordCheckingStringPairUserProvider((UserByContextualIdentifierLoader)new CardNumberSearchingUserByContextualIdentifierLoader(this.userSearchLoader, (HierarchyContextsByModeLoader)this.departmentAccessor), this.passwordChecker()));
                continue;
            }
            if (loginType.is("BC", "Password")) {
                activeAuths.add(new PasswordCheckingStringPairUserProvider((UserByContextualIdentifierLoader)new SearchingUserByContextualIdentifierLoader(this.userSearchLoader, (Property)UserConstants.SearchParams.BAR_CODE), this.passwordChecker()));
                continue;
            }
            if (loginType.is("Email", "Password")) {
                activeAuths.add(new PasswordCheckingStringPairUserProvider((department, email) -> this.userSearchLoader.getMaxOne((Consumer)StaticParamsModifier.of((Property)UserConstants.SearchParams.EMAIL, List.of(email))), this.passwordChecker()));
                continue;
            }
            if (loginType.is("LastName", "CN")) {
                activeAuths.add(new SearchingStringPairUserProvider(this.userSearchLoader, (Property)UserConstants.SearchParams.LAST_NAME, (Property)UserConstants.SearchParams.CARD_NUMBER));
                continue;
            }
            if (loginType.is("LastName", "BC")) {
                activeAuths.add(new SearchingStringPairUserProvider(this.userSearchLoader, (Property)UserConstants.SearchParams.LAST_NAME, (Property)UserConstants.SearchParams.BAR_CODE));
                continue;
            }
            if (loginType.is("Username", null)) {
                activeAuths.add(new FirstEntryOnlyDelegatingStringPairUserProvider(userByUsernameLoader));
                continue;
            }
            if (loginType.is("CN", null)) {
                activeAuths.add(new FirstEntryOnlyDelegatingStringPairUserProvider((UserByContextualIdentifierLoader)new CardNumberSearchingUserByContextualIdentifierLoader(this.userSearchLoader, (HierarchyContextsByModeLoader)this.departmentAccessor)));
                continue;
            }
            if (loginType.is("BC", null)) {
                activeAuths.add(new FirstEntryOnlyDelegatingStringPairUserProvider((UserByContextualIdentifierLoader)new SearchingUserByContextualIdentifierLoader(this.userSearchLoader, (Property)UserConstants.SearchParams.BAR_CODE)));
                continue;
            }
            log.warn("Chybne nastaveny zpusob prihlaseni \"{}\", hodnota bude vynechana.", (Object)loginType);
        }
        return activeAuths;
    }
}

