/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.commons.cache.CacheBackedRepository;
import cz.kpsys.portaro.commons.cache.CacheCleaner;
import cz.kpsys.portaro.commons.cache.CacheService;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.contextual.ContextualConsumer;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.contextual.SwitchContextualProvider;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.ConvertingAllValuesProvider;
import cz.kpsys.portaro.commons.object.IdentifiedValue;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.Deleter;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ItemNotFoundException;
import cz.kpsys.portaro.commons.object.repo.NotFoundExceptionTranslatingRepository;
import cz.kpsys.portaro.commons.object.repo.PreConvertingSaver;
import cz.kpsys.portaro.commons.object.repo.Repository;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.object.repo.SeveritedItemNotFoundException;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.core.editor.RecordValueEditorByDatatypeResolver;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.form.editor.ValueEditorByDatatypeLoader;
import cz.kpsys.portaro.form.editor.ValueEditorByDatatypeResolver;
import cz.kpsys.portaro.form.property.AcceptableValuesResolver;
import cz.kpsys.portaro.marcxml.convert.JacksonStringToRecordMarcDtoConverter;
import cz.kpsys.portaro.marcxml.model.RecordMarcDto;
import cz.kpsys.portaro.object.TypedDepartmentedObjectModifier;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordCatalogizationPhase;
import cz.kpsys.portaro.record.RecordImportApiController;
import cz.kpsys.portaro.record.RecordSaver;
import cz.kpsys.portaro.record.RichRecord;
import cz.kpsys.portaro.record.copy.RecordCopyRequest;
import cz.kpsys.portaro.record.deletion.RecordDeleter;
import cz.kpsys.portaro.record.deletion.RecordDeleterAppserver;
import cz.kpsys.portaro.record.deletion.RecordDeleterDelegatingRecordHoldingDeleter;
import cz.kpsys.portaro.record.deletion.RecordDeletionCommand;
import cz.kpsys.portaro.record.deletion.RecordHoldingDeletionCommand;
import cz.kpsys.portaro.record.deletion.SecuredRecordDeleter;
import cz.kpsys.portaro.record.deletion.SecuredRecordHoldingDeleter;
import cz.kpsys.portaro.record.detail.FieldType;
import cz.kpsys.portaro.record.detail.FieldTypeId;
import cz.kpsys.portaro.record.detail.IndicatorTypeLoader;
import cz.kpsys.portaro.record.detail.SubfieldTypeId;
import cz.kpsys.portaro.record.detail.dflt.CustomSettingDefaultFieldValueResolver;
import cz.kpsys.portaro.record.detail.dflt.CustomSettingLoadingAllDefaultFieldValuesLoader;
import cz.kpsys.portaro.record.detail.dflt.CustomSettingToDefaultFieldValueConverter;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueApiController;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueId;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueResolver;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueSaveCommand;
import cz.kpsys.portaro.record.detail.dflt.DefaultFieldValueSaveCommandToCustomSettingConverter;
import cz.kpsys.portaro.record.edit.ByFondLoaderDelegatingRecordFieldTypesLoader;
import cz.kpsys.portaro.record.edit.DatatypeResolvingValueEditorByFieldTypeLoader;
import cz.kpsys.portaro.record.edit.EditableFieldType;
import cz.kpsys.portaro.record.edit.FieldTypesByFondLoader;
import cz.kpsys.portaro.record.edit.MissingAddingRecordEditableFieldTypesLoader;
import cz.kpsys.portaro.record.edit.MissingFieldTypesAdder;
import cz.kpsys.portaro.record.edit.RecordAutoSavingPolicy;
import cz.kpsys.portaro.record.edit.RecordEditation;
import cz.kpsys.portaro.record.edit.RecordEditationFactory;
import cz.kpsys.portaro.record.edit.RecordEntryElementResolver;
import cz.kpsys.portaro.record.edit.RecordFieldTypesLoader;
import cz.kpsys.portaro.record.edit.SpringDbEditableFieldTypesByFondLoader;
import cz.kpsys.portaro.record.edit.SpringDbRichEditableFieldTypeDtoByFondLoader;
import cz.kpsys.portaro.record.edit.ValueEditorByFieldTypeLoader;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.importer.RecordImporter;
import cz.kpsys.portaro.record.importer.RecordMarcDtoImporter;
import cz.kpsys.portaro.record.merge.RecordMergeRequest;
import cz.kpsys.portaro.record.sec.CurrentAuthEditableFondsLoader;
import cz.kpsys.portaro.record.view.EditableFieldTypesToResponseConverter;
import cz.kpsys.portaro.record.view.ViewableRecordEditationFactory;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.HierarchyFinder;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.view.web.rest.record.EditableFieldTypeApiController;
import jakarta.validation.constraints.NotBlank;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
@Lazy
public class RecordEditConfig {
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final CacheService cacheService;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final RecordSaver recordSaver;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final ByIdLoadable<FieldType, FieldTypeId> topfieldTypeLoader;
    @NonNull
    private final ByIdLoadable<FieldType, SubfieldTypeId> subfieldTypeLoader;
    @NonNull
    private final Codebook<Fond, Integer> fondLoader;
    @NonNull
    private final AllValuesProvider<Fond> documentFondLoader;
    @NonNull
    private final AllValuesProvider<Fond> authorityFondLoader;
    @NonNull
    private final IdAndIdsLoadable<? extends Record, UUID> recordLoader;
    @NonNull
    private final DynamicCache<RichRecord> recordCache;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader;
    @NonNull
    private final ContextualConsumer<RecordDeletionCommand, Department> subtreeDepartmentedRecordExemplarsDeleter;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final ValueEditorByDatatypeLoader valueEditorByDatatypeLoader;
    @NonNull
    private final IndicatorTypeLoader defaultableDocumentIndicatorTypeLoader;
    @NonNull
    private final IndicatorTypeLoader defaultableAuthorityIndicatorTypeLoader;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    @NonNull
    private final Saver<CustomSetting<String>> customSettingSaver;

    @Bean
    public ViewableRecordEditationFactory viewableRecordEditationFactory() {
        return new ViewableRecordEditationFactory(this.documentFondLoader, this.authorityFondLoader, this.currentAuthEditableFondsLoader, this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_EDITED_INDICATORS_ENABLED), this.settingLoader.getDepartmentedProvider(SettingKeys.SHOW_EDITED_FIELD_IDENTIFIERS_ENABLED));
    }

    @Bean
    public TypedDepartmentedObjectModifier<RecordMergeRequest> recordMergeRequestDefaulter() {
        return (formObject, ctx) -> {
            if (formObject.mergeDetail() == null) {
                formObject = formObject.withMergeDetail(Boolean.valueOf(true));
            }
            return formObject;
        };
    }

    @Bean
    public AcceptableValuesResolver<RecordCopyRequest, Fond> recordCopyRequestAllowedFondsResolver() {
        return new RecordCopyRequest.RecordCopyRequestAllowedFondsResolver(this.authenticationHolder, this.currentAuthEditableFondsLoader);
    }

    @Bean
    public DefaultFieldValueApiController defaultFieldValueApiController() {
        return new DefaultFieldValueApiController(this.defaultFieldValueLoader(), this.defaultFieldValueSaver());
    }

    @Bean
    public RecordImportApiController recordImportApiController() {
        return new RecordImportApiController(this.stringToRecordMarcDtoConverter(), this.recordMarcDtoImporter());
    }

    @Bean
    public RecordImporter<RecordMarcDto> recordMarcDtoImporter() {
        return new RecordMarcDtoImporter(this.recordEditationFactory(), this.defaultableAuthorityIndicatorTypeLoader, this.defaultableDocumentIndicatorTypeLoader);
    }

    @Bean
    public Converter<String, RecordMarcDto> stringToRecordMarcDtoConverter() {
        return new JacksonStringToRecordMarcDtoConverter();
    }

    @Bean
    public EditableFieldTypeApiController editableFieldTypeApiController() {
        return new EditableFieldTypeApiController(this.recordEditableFieldTypesLoader(), (Converter)this.editableFieldTypesToResponseConverter());
    }

    @Bean
    public EditableFieldTypesToResponseConverter editableFieldTypesToResponseConverter() {
        return new EditableFieldTypesToResponseConverter();
    }

    @Bean
    public RecordEditationFactory recordEditationFactory() {
        return new RecordEditationFactory(this.recordEditableFieldTypesLoader(), this.recordEntryElementResolver(), this.recordSaver, this.missingFieldTypesAdder(), (ContextualProvider)new SwitchContextualProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.PUBLISHING_DOCUMENT_FINISHED_CATALOGIZATION), (Object)RecordCatalogizationPhase.CATALOGING, (Object)RecordCatalogizationPhase.CATALOGED));
    }

    @Bean
    public RecordFieldTypesLoader<EditableFieldType> recordEditableFieldTypesLoader() {
        return new MissingAddingRecordEditableFieldTypesLoader((RecordFieldTypesLoader)new ByFondLoaderDelegatingRecordFieldTypesLoader(this.editableFieldTypesByFondLoader()), this.missingFieldTypesAdder());
    }

    @Bean
    public MissingFieldTypesAdder missingFieldTypesAdder() {
        return new MissingFieldTypesAdder(this.topfieldTypeLoader, this.subfieldTypeLoader, (ValueEditorByFieldTypeLoader)this.valueEditorByFieldTypeLoader());
    }

    @Bean
    public RecordEntryElementResolver recordEntryElementResolver() {
        return new RecordEntryElementResolver(this.editableFieldTypesByFondLoader());
    }

    @Bean
    public FieldTypesByFondLoader<EditableFieldType> editableFieldTypesByFondLoader() {
        SpringDbEditableFieldTypesByFondLoader bean = new SpringDbEditableFieldTypesByFondLoader(new SpringDbRichEditableFieldTypeDtoByFondLoader(this.jdbcTemplate, this.queryFactory), this.topfieldTypeLoader, (ValueEditorByFieldTypeLoader)this.valueEditorByFieldTypeLoader(), this.defaultFieldValueResolver());
        this.cacheService.registerCleaner((CacheCleaner)bean);
        return bean;
    }

    @Bean
    public DatatypeResolvingValueEditorByFieldTypeLoader valueEditorByFieldTypeLoader() {
        return new DatatypeResolvingValueEditorByFieldTypeLoader(this.valueEditorByDatatypeLoader, (ValueEditorByDatatypeResolver)RecordValueEditorByDatatypeResolver.createWithSourceRecordSupportingBehaviour((Codebook)this.fondLoader));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Bean
    public Codebook<IdentifiedValue<DefaultFieldValueId, @NotBlank String>, DefaultFieldValueId> defaultFieldValueLoader() {
        @NotBlank ConvertingAllValuesProvider allValuesProvider = ConvertingAllValuesProvider.byItemConverter((AllValuesProvider)new CustomSettingLoadingAllDefaultFieldValuesLoader(this.customSettingLoader), (Converter)new CustomSettingToDefaultFieldValueConverter(this.departmentLoader, (ByIdLoadable)this.fondLoader));
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)allValuesProvider).springStaticCached(CustomSetting.class.getSimpleName(), "defaultFieldValues").build();
    }

    @Bean
    public Saver<DefaultFieldValueSaveCommand> defaultFieldValueSaver() {
        return new PreConvertingSaver((Converter)new DefaultFieldValueSaveCommandToCustomSettingConverter(this.customSettingLoader), this.customSettingSaver);
    }

    @Bean
    public DefaultFieldValueResolver defaultFieldValueResolver() {
        return new CustomSettingDefaultFieldValueResolver((AllValuesProvider)this.defaultFieldValueLoader(), HierarchyFinder.ofDepartment((ByIdLoadable)this.departmentLoader));
    }

    @Bean
    public Repository<RecordEditation, String> recordEditationRepository() {
        CacheBackedRepository delegate = CacheBackedRepository.ofIdentified((DynamicCache)GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofHours(2L), (boolean)false));
        return new NotFoundExceptionTranslatingRepository((Repository)delegate, source -> {
            Object desiredItemIdentifier = source instanceof ItemNotFoundException ? ((ItemNotFoundException)source).getDesiredItemIdentifier() : null;
            return new SeveritedItemNotFoundException(RecordEditation.class, desiredItemIdentifier, null, Texts.ofNative((String)"Editation is expired or not exists"), 2);
        });
    }

    @Bean
    public RecordDeleter recordDeleter() {
        RecordDeleterAppserver bean = new RecordDeleterAppserver(this.mappingAppserver, this.subtreeDepartmentedRecordExemplarsDeleter, this.appserverXmlMapper, List.of(this.recordCache));
        return new SecuredRecordDeleter((RecordDeleter)bean, this.securityManager);
    }

    @Bean
    public Deleter<RecordHoldingDeletionCommand> recordHoldingDeleter() {
        RecordDeleterDelegatingRecordHoldingDeleter bean = new RecordDeleterDelegatingRecordHoldingDeleter((ByIdLoadable)this.recordLoader, this.recordDeleter());
        return new SecuredRecordHoldingDeleter((Deleter)bean, this.securityManager);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForStringId(RecordAutoSavingPolicy.class, (ByIdLoadable)RecordAutoSavingPolicy.CODEBOOK).registerForStringId(RecordEditation.class, (ByIdLoadable)this.recordEditationRepository());
    }

    @ConstructorProperties(value={"queryFactory", "jdbcTemplate", "appserverXmlMapper", "mappingAppserver", "codebookLoaderBuilderFactory", "cacheService", "securityManager", "authenticationHolder", "recordSaver", "departmentLoader", "topfieldTypeLoader", "subfieldTypeLoader", "fondLoader", "documentFondLoader", "authorityFondLoader", "recordLoader", "recordCache", "settingLoader", "currentAuthEditableFondsLoader", "subtreeDepartmentedRecordExemplarsDeleter", "converterRegisterer", "valueEditorByDatatypeLoader", "defaultableDocumentIndicatorTypeLoader", "defaultableAuthorityIndicatorTypeLoader", "customSettingLoader", "customSettingSaver"})
    @Generated
    public RecordEditConfig(@NonNull QueryFactory queryFactory, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull ObjectMapper appserverXmlMapper, @NonNull MappingAppserverService mappingAppserver, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull CacheService cacheService, @NonNull SecurityManager securityManager, @NonNull AuthenticationHolder authenticationHolder, @NonNull RecordSaver recordSaver, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull ByIdLoadable<FieldType, FieldTypeId> topfieldTypeLoader, @NonNull ByIdLoadable<FieldType, SubfieldTypeId> subfieldTypeLoader, @NonNull Codebook<Fond, Integer> fondLoader, @NonNull AllValuesProvider<Fond> documentFondLoader, @NonNull AllValuesProvider<Fond> authorityFondLoader, @NonNull IdAndIdsLoadable<? extends Record, UUID> recordLoader, @NonNull DynamicCache<RichRecord> recordCache, @NonNull SettingLoader settingLoader, @NonNull CurrentAuthEditableFondsLoader currentAuthEditableFondsLoader, @NonNull ContextualConsumer<RecordDeletionCommand, Department> subtreeDepartmentedRecordExemplarsDeleter, @NonNull ConverterRegisterer converterRegisterer, @NonNull ValueEditorByDatatypeLoader valueEditorByDatatypeLoader, @NonNull IndicatorTypeLoader defaultableDocumentIndicatorTypeLoader, @NonNull IndicatorTypeLoader defaultableAuthorityIndicatorTypeLoader, @NonNull CustomSettingLoader customSettingLoader, @NonNull Saver<CustomSetting<String>> customSettingSaver) {
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(cacheService, "cacheService is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(recordSaver, "recordSaver is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(topfieldTypeLoader, "topfieldTypeLoader is marked non-null but is null");
        Objects.requireNonNull(subfieldTypeLoader, "subfieldTypeLoader is marked non-null but is null");
        Objects.requireNonNull(fondLoader, "fondLoader is marked non-null but is null");
        Objects.requireNonNull(documentFondLoader, "documentFondLoader is marked non-null but is null");
        Objects.requireNonNull(authorityFondLoader, "authorityFondLoader is marked non-null but is null");
        Objects.requireNonNull(recordLoader, "recordLoader is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableFondsLoader, "currentAuthEditableFondsLoader is marked non-null but is null");
        Objects.requireNonNull(subtreeDepartmentedRecordExemplarsDeleter, "subtreeDepartmentedRecordExemplarsDeleter is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(valueEditorByDatatypeLoader, "valueEditorByDatatypeLoader is marked non-null but is null");
        Objects.requireNonNull(defaultableDocumentIndicatorTypeLoader, "defaultableDocumentIndicatorTypeLoader is marked non-null but is null");
        Objects.requireNonNull(defaultableAuthorityIndicatorTypeLoader, "defaultableAuthorityIndicatorTypeLoader is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        this.queryFactory = queryFactory;
        this.jdbcTemplate = jdbcTemplate;
        this.appserverXmlMapper = appserverXmlMapper;
        this.mappingAppserver = mappingAppserver;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.cacheService = cacheService;
        this.securityManager = securityManager;
        this.authenticationHolder = authenticationHolder;
        this.recordSaver = recordSaver;
        this.departmentLoader = departmentLoader;
        this.topfieldTypeLoader = topfieldTypeLoader;
        this.subfieldTypeLoader = subfieldTypeLoader;
        this.fondLoader = fondLoader;
        this.documentFondLoader = documentFondLoader;
        this.authorityFondLoader = authorityFondLoader;
        this.recordLoader = recordLoader;
        this.recordCache = recordCache;
        this.settingLoader = settingLoader;
        this.currentAuthEditableFondsLoader = currentAuthEditableFondsLoader;
        this.subtreeDepartmentedRecordExemplarsDeleter = subtreeDepartmentedRecordExemplarsDeleter;
        this.converterRegisterer = converterRegisterer;
        this.valueEditorByDatatypeLoader = valueEditorByDatatypeLoader;
        this.defaultableDocumentIndicatorTypeLoader = defaultableDocumentIndicatorTypeLoader;
        this.defaultableAuthorityIndicatorTypeLoader = defaultableAuthorityIndicatorTypeLoader;
        this.customSettingLoader = customSettingLoader;
        this.customSettingSaver = customSettingSaver;
    }
}

