/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadableByAllValuesProviderAdapter;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadableByAllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadableConverting;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SaverBuilderFactory;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.event.Event;
import cz.kpsys.portaro.event.Eventer;
import cz.kpsys.portaro.file.IdentifiedFile;
import cz.kpsys.portaro.messages.MessageFromEntityConverter;
import cz.kpsys.portaro.messages.MessageMedium;
import cz.kpsys.portaro.messages.MessageSendingFromEntityConverter;
import cz.kpsys.portaro.messages.MessageSendingToEntityConverter;
import cz.kpsys.portaro.messages.MessageSendingsSendStatus;
import cz.kpsys.portaro.messages.MessageSeverity;
import cz.kpsys.portaro.messages.MessageToEntityConverter;
import cz.kpsys.portaro.messages.MessageTopic;
import cz.kpsys.portaro.messages.SpringDbMessageIdSearchLoader;
import cz.kpsys.portaro.messages.SpringDbMessageSendingIdSearchLoader;
import cz.kpsys.portaro.messages.SpringDbMessageSendingLoader;
import cz.kpsys.portaro.messages.dto.Message;
import cz.kpsys.portaro.messages.dto.MessageSending;
import cz.kpsys.portaro.messages.entity.MessageEntity;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.sms.SmsMessageSender;
import cz.kpsys.portaro.sms.SmsSender;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.contact.ContactManager;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.rest.message.MessageApiController;
import cz.kpsys.portaro.view.web.rest.sms.SmsApiController;
import cz.kpsys.portaro.view.web.stream.PdfByIdentifiedFilesMerger;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class MessageConfig {
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final SaverBuilderFactory saverBuilderFactory;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final AllByIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final AllByIdsLoadable<Event, UUID> eventLoader;
    @NonNull
    private final Eventer eventer;
    @NonNull
    private final ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader;
    @NonNull
    private final PdfByIdentifiedFilesMerger pdfByIdentifiedFilesMerger;
    @NonNull
    private final Codebook<Department, Integer> departmentLoader;
    @NonNull
    private final ContactManager contactManager;

    @Bean
    public IdAndIdsLoadable<Message, UUID> messageLoader() {
        MessageFromEntityConverter messageFromEntityConverter = new MessageFromEntityConverter(this.basicUserLoader, this.eventLoader, (AllByIdsLoadable)new AllByIdsLoadableByAllValuesProviderAdapter((AllValuesProvider)this.departmentLoader));
        ChunkingAllByIdsLoader allByIdsLoader = ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)this.modelBeanBuilder.allByIdsLoader(MessageEntity.class, (Converter)messageFromEntityConverter).build());
        return new ByIdLoadableByAllByIdsLoadable((AllByIdsLoadable)allByIdsLoader, Message.class);
    }

    @Bean
    public Saver<Message> messageSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new MessageToEntityConverter()).build();
    }

    @Bean
    public PageSearchLoader<MapBackedParams, UUID> messageIdSearchLoader() {
        return new SpringDbMessageIdSearchLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public PageSearchLoader<MapBackedParams, Message> messageSearchLoader() {
        return ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.messageIdSearchLoader(), (AllByIdsLoadable)this.messageLoader());
    }

    @Bean
    public PageSearchLoader<MapBackedParams, MessageSending> messageSendingSearchLoader() {
        return ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.messageSendingIdSearchLoader(), (AllByIdsLoadable)this.messageSendingLoader());
    }

    @Bean
    public PageSearchLoader<MapBackedParams, UUID> messageSendingIdSearchLoader() {
        return new SpringDbMessageSendingIdSearchLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public IdAndIdsLoadable<MessageSending, UUID> messageSendingLoader() {
        SpringDbMessageSendingLoader springDbMessageSendingLoader = new SpringDbMessageSendingLoader(this.jdbcTemplate, this.queryFactory);
        MessageSendingFromEntityConverter messageSendingFromEntityConverter = new MessageSendingFromEntityConverter(this.eventLoader, this.basicUserLoader, (AllByIdsLoadable)this.messageLoader());
        return new IdAndIdsLoadableConverting((AllByIdsLoadable)springDbMessageSendingLoader, id -> id, (Converter)messageSendingFromEntityConverter);
    }

    @Bean
    public Saver<MessageSending> messageSendingSaver() {
        return this.saverBuilderFactory.saver().intermediateConverting((Converter)new MessageSendingToEntityConverter()).build();
    }

    @Bean
    public SmsSender smsSender() {
        return new SmsMessageSender(this.messageSaver(), this.messageSendingSaver(), this.eventer, this.contactManager);
    }

    @Bean
    public MessageApiController messageApiController() {
        return new MessageApiController(this.messageSendingSaver(), this.messageSendingSearchLoader(), this.eventer, this.identifiedFileLoader, this.pdfByIdentifiedFilesMerger);
    }

    @Bean
    public SmsApiController smsApiController() {
        return new SmsApiController(this.smsSender(), this.contactManager);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        this.converterRegisterer.registerForIntegerId(MessageTopic.class, (ByIdLoadable)MessageTopic.CODEBOOK).registerForStringId(MessageSeverity.class, (ByIdLoadable)MessageSeverity.CODEBOOK).registerForStringId(MessageMedium.class, (ByIdLoadable)MessageMedium.CODEBOOK).registerForStringId(MessageSendingsSendStatus.class, (ByIdLoadable)MessageSendingsSendStatus.CODEBOOK).registerForUuidId(Message.class, (ByIdLoadable)this.messageLoader());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(SecurityActions.MESSAGE_SEARCH, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
    }

    @ConstructorProperties(value={"converterRegisterer", "jdbcTemplate", "queryFactory", "modelBeanBuilder", "saverBuilderFactory", "permissionRegistry", "permissionFactory", "basicUserLoader", "eventLoader", "eventer", "identifiedFileLoader", "pdfByIdentifiedFilesMerger", "departmentLoader", "contactManager"})
    @Generated
    public MessageConfig(@NonNull ConverterRegisterer converterRegisterer, @NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull SaverBuilderFactory saverBuilderFactory, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull AllByIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull AllByIdsLoadable<Event, UUID> eventLoader, @NonNull Eventer eventer, @NonNull ByIdLoadable<IdentifiedFile, Long> identifiedFileLoader, @NonNull PdfByIdentifiedFilesMerger pdfByIdentifiedFilesMerger, @NonNull Codebook<Department, Integer> departmentLoader, @NonNull ContactManager contactManager) {
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(saverBuilderFactory, "saverBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(eventLoader, "eventLoader is marked non-null but is null");
        Objects.requireNonNull(eventer, "eventer is marked non-null but is null");
        Objects.requireNonNull(identifiedFileLoader, "identifiedFileLoader is marked non-null but is null");
        Objects.requireNonNull(pdfByIdentifiedFilesMerger, "pdfByIdentifiedFilesMerger is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(contactManager, "contactManager is marked non-null but is null");
        this.converterRegisterer = converterRegisterer;
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.modelBeanBuilder = modelBeanBuilder;
        this.saverBuilderFactory = saverBuilderFactory;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.basicUserLoader = basicUserLoader;
        this.eventLoader = eventLoader;
        this.eventer = eventer;
        this.identifiedFileLoader = identifiedFileLoader;
        this.pdfByIdentifiedFilesMerger = pdfByIdentifiedFilesMerger;
        this.departmentLoader = departmentLoader;
        this.contactManager = contactManager;
    }
}

