/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import cz.kpsys.portaro.CoreConstants;
import cz.kpsys.portaro.app.PortaroUrls;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.mapping.MappingAppserverService;
import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.department.AuthContextualDepartmentsLoader;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.auth.password.PasswordChecker;
import cz.kpsys.portaro.commons.cache.CacheDeletableById;
import cz.kpsys.portaro.commons.cache.CacheDeleter;
import cz.kpsys.portaro.commons.cache.CompositeCacheDeleter;
import cz.kpsys.portaro.commons.cache.DynamicCache;
import cz.kpsys.portaro.commons.cache.GuavaTimedDynamicCache;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.ChainingConverter;
import cz.kpsys.portaro.commons.convert.IdToObjectConverter;
import cz.kpsys.portaro.commons.convert.ObjectToStringByToStringConverter;
import cz.kpsys.portaro.commons.convert.StringToAnyListConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerToAnyConverter;
import cz.kpsys.portaro.commons.date.DateRangeToBase64StringConverter;
import cz.kpsys.portaro.commons.json.ByStringConverterJsonDeserializer;
import cz.kpsys.portaro.commons.json.ConverterToStringJsonSerializer;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.localization.Translator;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.Range;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.commons.object.repo.AllByIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.ChunkingAllByIdsLoader;
import cz.kpsys.portaro.commons.object.repo.Codebook;
import cz.kpsys.portaro.commons.object.repo.IdAndIdsLoadable;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.config.CodebookLoaderBuilderFactory;
import cz.kpsys.portaro.config.ConverterRegisterer;
import cz.kpsys.portaro.config.LoanConfig;
import cz.kpsys.portaro.config.ModelBeanBuilder;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.department.HierarchyContextsByModeLoader;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.edit.AppserverExemplarSaver;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategory;
import cz.kpsys.portaro.export.AbstractToTextualFileExporter;
import cz.kpsys.portaro.export.CsvFileExporter;
import cz.kpsys.portaro.export.Exporter;
import cz.kpsys.portaro.export.ExporterResolver;
import cz.kpsys.portaro.export.ObjectToJsonFileExporter;
import cz.kpsys.portaro.export.SearchedItemsExporter;
import cz.kpsys.portaro.export.StaticExportDescriptorLoader;
import cz.kpsys.portaro.export.XlsFileExporterByCsvExporter;
import cz.kpsys.portaro.file.directory.DirectoryInsightLoader;
import cz.kpsys.portaro.finance.AmountTypeLoader;
import cz.kpsys.portaro.loan.ByExemplarQLoanPageSearchLoader;
import cz.kpsys.portaro.loan.DelegatingLoanLoader;
import cz.kpsys.portaro.loan.EnablableStaticLoanSetting;
import cz.kpsys.portaro.loan.IgnoresFiller;
import cz.kpsys.portaro.loan.Loan;
import cz.kpsys.portaro.loan.LoanAuthContextualDepartmentsLoader;
import cz.kpsys.portaro.loan.LoanConstants;
import cz.kpsys.portaro.loan.LoanId;
import cz.kpsys.portaro.loan.LoanLoader;
import cz.kpsys.portaro.loan.LoanQuantityLoader;
import cz.kpsys.portaro.loan.LoanSecurityActions;
import cz.kpsys.portaro.loan.LoanService;
import cz.kpsys.portaro.loan.LoanSetting;
import cz.kpsys.portaro.loan.LoanSettingKeys;
import cz.kpsys.portaro.loan.LoanState;
import cz.kpsys.portaro.loan.LoanType;
import cz.kpsys.portaro.loan.LoansProviderService;
import cz.kpsys.portaro.loan.LoansProviderServiceBySearch;
import cz.kpsys.portaro.loan.LoansProviderServiceSecurityProxy;
import cz.kpsys.portaro.loan.ReaderCatLoanCatSettingLoader;
import cz.kpsys.portaro.loan.ReaderCatLoanCatSettingLoaderAppserver;
import cz.kpsys.portaro.loan.SpringDbAllByIdsLoanLoader;
import cz.kpsys.portaro.loan.SpringDbLoanIdSearchLoader;
import cz.kpsys.portaro.loan.availability.AppserverDataBackedExemplarAvailability;
import cz.kpsys.portaro.loan.availability.AppserverExemplarAvailabilityService;
import cz.kpsys.portaro.loan.availability.DocumentAvailability;
import cz.kpsys.portaro.loan.availability.DocumentAvailabilityService;
import cz.kpsys.portaro.loan.availability.DocumentAvailabilityServiceAppserver;
import cz.kpsys.portaro.loan.availability.ExemplarAvailabilityService;
import cz.kpsys.portaro.loan.availability.LastReturnDateLoader;
import cz.kpsys.portaro.loan.availability.LastUserLoanDateLoader;
import cz.kpsys.portaro.loan.availability.ReservationsCountLoader;
import cz.kpsys.portaro.loan.availability.SpringDbLastReturnDateLoader;
import cz.kpsys.portaro.loan.availability.SpringDbLastUserLoanDateLoader;
import cz.kpsys.portaro.loan.availability.SpringDbReservationsCountLoader;
import cz.kpsys.portaro.loan.cancellation.AppserverCancellationService;
import cz.kpsys.portaro.loan.cancellation.CancelabilityService;
import cz.kpsys.portaro.loan.cancellation.CancelabilityServiceImpl;
import cz.kpsys.portaro.loan.cancellation.CancellationService;
import cz.kpsys.portaro.loan.export.UserActiveLoansExporterDelegatingToLoansExporter;
import cz.kpsys.portaro.loan.extern.AppserverExternalLendingService;
import cz.kpsys.portaro.loan.extern.ExternalLendingService;
import cz.kpsys.portaro.loan.extern.ExternalLoanRecordFondResolver;
import cz.kpsys.portaro.loan.extern.ExternalLoanService;
import cz.kpsys.portaro.loan.extern.MailSendingExternalLendingService;
import cz.kpsys.portaro.loan.extern.ProvidedFondIdComparingExternalLoanRecordFondResolver;
import cz.kpsys.portaro.loan.extern.SpringDbExternalLoanRecordLoader;
import cz.kpsys.portaro.loan.lending.AppserverLendingService;
import cz.kpsys.portaro.loan.lending.IgnoresFillingLendingService;
import cz.kpsys.portaro.loan.lending.LendingCommand;
import cz.kpsys.portaro.loan.lending.LendingService;
import cz.kpsys.portaro.loan.lending.LendingServiceVerifyingLenderProxy;
import cz.kpsys.portaro.loan.mail.MailLoanRequestCommand;
import cz.kpsys.portaro.loan.mail.MailLoanRequestRequest;
import cz.kpsys.portaro.loan.mail.MailLoanRequestService;
import cz.kpsys.portaro.loan.mvs.MvsLocalDocumentLoanRequestRequest;
import cz.kpsys.portaro.loan.mvs.MvsRequestDto;
import cz.kpsys.portaro.loan.mvs.MvsRequestLoader;
import cz.kpsys.portaro.loan.mvs.MvsRequestSaver;
import cz.kpsys.portaro.loan.mvs.MvsRequestSaverAppserver;
import cz.kpsys.portaro.loan.mvs.MvsState;
import cz.kpsys.portaro.loan.mvs.SpringDbMvsRequestLoader;
import cz.kpsys.portaro.loan.mvs.SpringDbMvsStateLoader;
import cz.kpsys.portaro.loan.notice.ExemplarAwareLoanStateChanger;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeFileGenerator;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeMailSender;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeMultipleSender;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeSendDebtCreator;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeSender;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeSenderByPrintTypeDispatcher;
import cz.kpsys.portaro.loan.notice.LoanReadyNoticeSmsSender;
import cz.kpsys.portaro.loan.notice.LoanReadyProcessor;
import cz.kpsys.portaro.loan.notice.NoticeSendingDebtCreatingStateChangingLoanProcessor;
import cz.kpsys.portaro.loan.penalty.AppserverDelayedReturnPenaltyService;
import cz.kpsys.portaro.loan.penalty.DelayedReturnPenaltyService;
import cz.kpsys.portaro.loan.quantum.QuantumLoanChangeLoader;
import cz.kpsys.portaro.loan.quantum.QuantumLoanChangeSummingLoanQuantityLoader;
import cz.kpsys.portaro.loan.quantum.SpringDbQuantumLoanChangeLoader;
import cz.kpsys.portaro.loan.reminder.LoanReminder;
import cz.kpsys.portaro.loan.reminder.LoanReminderEntity;
import cz.kpsys.portaro.loan.reminder.LoanReminderFromEntityConverter;
import cz.kpsys.portaro.loan.reminder.LoanReminderType;
import cz.kpsys.portaro.loan.reminder.SpringDbLoanReminderIdSearchLoader;
import cz.kpsys.portaro.loan.renewal.AppserverRenewabilityService;
import cz.kpsys.portaro.loan.renewal.AppserverRenewalService;
import cz.kpsys.portaro.loan.renewal.RenewabilityService;
import cz.kpsys.portaro.loan.renewal.RenewalAppserverRequestCreator;
import cz.kpsys.portaro.loan.renewal.RenewalService;
import cz.kpsys.portaro.loan.request.AppserverStandardLoanRequestService;
import cz.kpsys.portaro.loan.request.StandardLoanRequest;
import cz.kpsys.portaro.loan.request.StandardLoanRequestService;
import cz.kpsys.portaro.loan.request.TemplatedMailLoanRequestService;
import cz.kpsys.portaro.loan.request.form.BuildingPreferenceSavingStandardLoanRequestServiceProxy;
import cz.kpsys.portaro.loan.request.form.LoanRequestFormFactory;
import cz.kpsys.portaro.loan.returning.AppserverReturningService;
import cz.kpsys.portaro.loan.returning.IgnoresFillingReturningService;
import cz.kpsys.portaro.loan.returning.LoanReturnCommand;
import cz.kpsys.portaro.loan.returning.LoanReturnRequest;
import cz.kpsys.portaro.loan.returning.ReturningService;
import cz.kpsys.portaro.loan.timeslot.TimeslotOccupationLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.logging.ActionSaver;
import cz.kpsys.portaro.mail.MailService;
import cz.kpsys.portaro.object.TypedDepartmentedObjectModifier;
import cz.kpsys.portaro.payment.Transaction;
import cz.kpsys.portaro.record.ExportingRecord;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.RichRecord;
import cz.kpsys.portaro.record.document.CompositeDownloadLinkContextualResolver;
import cz.kpsys.portaro.record.document.ContextIgnoringDownloadLinkContextualResolver;
import cz.kpsys.portaro.record.document.DownloadLinkContextualResolver;
import cz.kpsys.portaro.record.document.DownloadLinkResolver;
import cz.kpsys.portaro.record.document.DownloadLinkResolverBy856Fields;
import cz.kpsys.portaro.record.document.DownloadLinkResolverByDirectoryInsight;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoader;
import cz.kpsys.portaro.search.ParameterizedSearchLoaderImpl;
import cz.kpsys.portaro.search.ResultConvertingPageSearchLoader;
import cz.kpsys.portaro.search.SearchParams;
import cz.kpsys.portaro.search.StaticParamsModifier;
import cz.kpsys.portaro.security.PermissionFactory;
import cz.kpsys.portaro.security.PermissionRegistry;
import cz.kpsys.portaro.security.PermissionResolver;
import cz.kpsys.portaro.security.PermissionResult;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.security.export.SecuredExporter;
import cz.kpsys.portaro.setting.CoreSettingKeys;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.sms.SmsSender;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.template.TemplateEngine;
import cz.kpsys.portaro.template.TemplateLoadingExportDescriptorLoader;
import cz.kpsys.portaro.template.Templates;
import cz.kpsys.portaro.user.BasicUser;
import cz.kpsys.portaro.user.Library;
import cz.kpsys.portaro.user.UserByBasicUserLoader;
import cz.kpsys.portaro.user.UserLoader;
import cz.kpsys.portaro.user.locale.UserLocaleResolver;
import cz.kpsys.portaro.user.prefs.UserPrefAccessor;
import cz.kpsys.portaro.user.role.reader.PrintType;
import cz.kpsys.portaro.user.sec.SecurityActions;
import cz.kpsys.portaro.view.web.rest.loan.AvailabilityApiController;
import cz.kpsys.portaro.view.web.rest.loan.CancellationApiController;
import cz.kpsys.portaro.view.web.rest.loan.LendingApiController;
import cz.kpsys.portaro.view.web.rest.loan.LoanApiController;
import cz.kpsys.portaro.view.web.rest.loan.LoanRequestApiController;
import cz.kpsys.portaro.view.web.rest.loan.MvsApiController;
import cz.kpsys.portaro.view.web.rest.loan.MvsLocalDocumentLoanRequestRequestDefaulter;
import cz.kpsys.portaro.view.web.rest.loan.MvsLocalDocumentLoanRequestRequestToActiveMvsRequestCommandConverter;
import cz.kpsys.portaro.view.web.rest.loan.PassiveMvsRequestRequest;
import cz.kpsys.portaro.view.web.rest.loan.PassiveMvsRequestRequestDefaulter;
import cz.kpsys.portaro.view.web.rest.loan.RenewalApiController;
import cz.kpsys.portaro.view.web.rest.loan.RequestToMailLoanRequestCommandConverter;
import cz.kpsys.portaro.view.web.rest.loan.RequestToPassiveMvsRequestCommandConverter;
import cz.kpsys.portaro.view.web.rest.loan.ReturningApiController;
import cz.kpsys.portaro.view.web.rest.user.DelayedReturnPenaltyApiController;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

@Configuration
public class LoanConfig {
    public static final int SEARCHED_LOANS_LIMIT_ITEMS = 400;
    @NonNull
    private final NamedParameterJdbcOperations jdbcTemplate;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final ModelBeanBuilder modelBeanBuilder;
    @NonNull
    private final CodebookLoaderBuilderFactory codebookLoaderBuilderFactory;
    @NonNull
    private final MappingAppserverService mappingAppserver;
    @NonNull
    private final DmlAppserverService dmlAppserverService;
    @NonNull
    private final ObjectMapper appserverXmlMapper;
    @NonNull
    private final IdAndIdsLoadable<RichDocument, Integer> documentByKindedIdLoader;
    @NonNull
    private final IdAndIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final AllByIdsLoadable<RichDocument, UUID> detailedDocumentLoader;
    @NonNull
    private final DynamicCache<RichRecord> recordCache;
    @NonNull
    private final UserLoader userLoader;
    @NonNull
    private final IdAndIdsLoadable<BasicUser, Integer> basicUserLoader;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Translator<Department> translator;
    @NonNull
    private final UserLocaleResolver userLocaleResolver;
    @NonNull
    private final UserPrefAccessor userPrefAccessor;
    @NonNull
    private final TemplateEngine templateEngine;
    @NonNull
    private final MailService mailService;
    @NonNull
    private final SmsSender smsSender;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final ObjectMapper objectMapper;
    @NonNull
    private final AllByIdsLoadable<Exemplar, Integer> exemplarLoader;
    @NonNull
    private final PageSearchLoader<MapBackedParams, Integer> exemplarIdSearchLoader;
    @NonNull
    private final ByIdLoadable<Location, Integer> locationLoader;
    @NonNull
    private final ByIdLoadable<Department, Integer> departmentLoader;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final ByIdLoadable<LoanCategory, String> loanCategoryLoader;
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final AmountTypeLoader amountTypeLoader;
    @NonNull
    private final Saver<List<Transaction>> transactionsSaver;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final DirectoryInsightLoader directoryInsightLoader;
    @NonNull
    private final SecurityAccessor securityAccessor;
    @NonNull
    private final PermissionRegistry permissionRegistry;
    @NonNull
    private final PermissionFactory permissionFactory;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final ExporterResolver exporterResolver;
    @NonNull
    private final TemplateLoadingExportDescriptorLoader templateLoadingExportDescriptorLoader;
    @NonNull
    private final StaticExportDescriptorLoader staticExportDescriptorLoader;
    @NonNull
    private final FormatterRegistry conversionService;
    @NonNull
    private final SimpleModule objectMapperModule;
    @NonNull
    private final ActionSaver actionSaver;
    @NonNull
    private final ConverterRegisterer converterRegisterer;
    @NonNull
    private final AppserverExemplarSaver pureExemplarSaver;
    @NonNull
    private final Converter<Record, ExportingRecord> recordToViewableRecordConverter;
    @NonNull
    private final TimeslotOccupationLoader timeslotOccupationLoader;
    @NonNull
    private final PasswordChecker passwordChecker;

    @Bean
    public LoanApiController loanApiController() {
        return new LoanApiController((PageSearchLoader)this.loanSearchLoader(), this.securedLoansProviderService(), (HierarchyContextsByModeLoader)this.departmentAccessor, this.loanService(), this.loanReadyProcessor(), this.loanReadyNoticeSender(), this.userLoader);
    }

    @Bean
    public AvailabilityApiController availabilityController() {
        return new AvailabilityApiController(this.documentAvailabilityService(), this.exemplarAvailabilityService());
    }

    @Bean
    public Converter<MailLoanRequestRequest, MailLoanRequestCommand> requestToMailLoanRequestCommandConverter() {
        return new RequestToMailLoanRequestCommandConverter();
    }

    @Bean
    public MvsLocalDocumentLoanRequestRequestToActiveMvsRequestCommandConverter mvsLocalDocumentLoanRequestRequestToActiveMvsRequestCommandConverter() {
        return new MvsLocalDocumentLoanRequestRequestToActiveMvsRequestCommandConverter();
    }

    @Bean
    public LoanRequestApiController loanRequestApiController() {
        return new LoanRequestApiController(this.loanService(), this.loanRequestFormFactory(), this.standardLoanRequestService(), this.documentAvailabilityService(), this.requestToMailLoanRequestCommandConverter(), this.mvsLocalDocumentLoanRequestRequestToActiveMvsRequestCommandConverter());
    }

    @Bean
    public CancellationApiController cancellationApiController() {
        return new CancellationApiController(this.loanService(), this.loanSearchLoader());
    }

    @Bean
    public LendingApiController lendingApiController() {
        return new LendingApiController(this.lendingService(), this.departmentAccessor, this.securityAccessor);
    }

    @Bean
    public DelayedReturnPenaltyApiController delayedReturnPenaltyApiController() {
        return new DelayedReturnPenaltyApiController(this.delayedReturnPenaltyService(), this.securityManager);
    }

    @Bean
    public RenewalApiController renewalApiController() {
        return new RenewalApiController(this.actionSaver, this.renewalService(), (PageSearchLoader)this.loanSearchLoader());
    }

    @Bean
    public ReturningApiController returningApiController() {
        return new ReturningApiController(this.returningService(), this.departmentAccessor, this.securityAccessor);
    }

    @Bean
    public TypedDepartmentedObjectModifier<LoanReturnRequest> loanReturnRequestPreValidationModifier() {
        return new LoanReturnRequest.LoanReturnRequestPreValidationModifier();
    }

    @Bean
    public TypedDepartmentedObjectModifier<LoanReturnRequest> loanReturnRequestDefaulter() {
        return new LoanReturnRequest.LoanReturnRequestDefaulter(this.loanQuantityLoader());
    }

    @Bean
    public MvsApiController mvsApiController() {
        return new MvsApiController(this.loanService(), this.requestToPassiveMvsRequestCommandConverter());
    }

    @Bean
    public RequestToPassiveMvsRequestCommandConverter requestToPassiveMvsRequestCommandConverter() {
        return new RequestToPassiveMvsRequestCommandConverter();
    }

    @Bean
    public TypedDepartmentedObjectModifier<PassiveMvsRequestRequest> passiveMvsRequestRequestDefaulter() {
        return new PassiveMvsRequestRequestDefaulter(this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_MVS_REQUEST_INTEREST_DAYS));
    }

    @Bean
    public TypedDepartmentedObjectModifier<MvsLocalDocumentLoanRequestRequest> mvsLocalDocumentLoanRequestRequestDefaulter() {
        return new MvsLocalDocumentLoanRequestRequestDefaulter(this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_MVS_REQUEST_INTEREST_DAYS));
    }

    @Bean
    public ContextualProvider<Department, @NonNull LoanSetting> loanSettingProvider() {
        return department -> new EnablableStaticLoanSetting((Boolean)this.settingLoader.getOn(SettingKeys.LOANS_ENABLED, department), (String)this.settingLoader.getOn(SettingKeys.ORDERING_TYPE, department), (String)this.settingLoader.getOn(SettingKeys.RESERVING_TYPE, department));
    }

    @Bean
    public ContextualProvider<Department, @NonNull Boolean> lendingToExpiredReaderAllowed() {
        return ContextIgnoringContextualProvider.of((Object)true);
    }

    @Bean
    public LoanService loanService() {
        return new LoanService(this.securityManager, this.mailLoanRequestService(), this.externalLendingService(), this.cancellationService(), this.mvsRequestSaver(), this.loanQuantityLoader(), this.renewabilityService(), this.cancelabilityService(), this.timeslotOccupationLoader);
    }

    @Bean
    public LoansProviderService loansProviderService() {
        return new LoansProviderServiceBySearch(this.loanSettingProvider(), (PageSearchLoader)this.loanSearchLoader(), this.mvsRequestLoader(), this.loanAuthContextualDepartmentsLoader(), this.settingLoader.getOnRootProvidedList(SettingKeys.FORBIDDEN_RECORDS));
    }

    @Bean
    public AuthContextualDepartmentsLoader loanAuthContextualDepartmentsLoader() {
        return new LoanAuthContextualDepartmentsLoader(this.currentAuthEditableDepartmentsLoader, this.departmentAccessor, this.settingLoader.getDepartmentedProvider(SettingKeys.EDITABLE_SUBDEPARTMENTS_ONLY_LOANS_SHOW_ENABLED), (ContextualProvider)ContextIgnoringContextualProvider.of((Provider)this.settingLoader.getOnRootProvider(SettingKeys.LOANS_PROVIDED_TO_DEPARTMENTS)));
    }

    @Bean
    public LoansProviderService securedLoansProviderService() {
        return new LoansProviderServiceSecurityProxy(this.loansProviderService(), this.securityManager);
    }

    @Bean
    public LoanRequestFormFactory loanRequestFormFactory() {
        return new LoanRequestFormFactory((ByIdLoadable)this.nonDetailedDocumentLoader, this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_LOAN_REQUEST_INTEREST_DAYS), this.translator, this.documentAvailabilityService(), this.exemplarAvailabilityService(), this.userLocaleResolver, this.userPrefAccessor, this.settingLoader.getDepartmentedProvider(SettingKeys.RESERVATION_DATE_TO_REQUIRED));
    }

    @Bean
    public LendingService lendingService() {
        AppserverLendingService pureService = new AppserverLendingService(this.mappingAppserver, (ByIdLoadable)this.basicUserLoader, this.circulatingAffectedExemplarCacheDeleter(), this.appserverXmlMapper);
        LendingServiceVerifyingLenderProxy lenderVerifying = new LendingServiceVerifyingLenderProxy((LendingService)pureService, this.settingLoader.getDepartmentedProvider(SettingKeys.LENDER_READER_VERIFYING_ENABLED), (UserByBasicUserLoader)this.userLoader, this.passwordChecker);
        return new IgnoresFillingLendingService((LendingService)lenderVerifying, this.lendingCommandIgnoresFiller());
    }

    @Bean
    public LendingService lendingServiceWithoutVerification() {
        AppserverLendingService pureService = new AppserverLendingService(this.mappingAppserver, (ByIdLoadable)this.basicUserLoader, this.circulatingAffectedExemplarCacheDeleter(), this.appserverXmlMapper);
        return new IgnoresFillingLendingService((LendingService)pureService, this.lendingCommandIgnoresFiller());
    }

    @Bean
    public IgnoresFiller<LendingCommand> lendingCommandIgnoresFiller() {
        return new IgnoresFiller().withNegated(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_CHECK_DIFFERENT_DEPARTMENT), LendingCommand::ignoreLendingOnDifferentDepartment, LendingCommand::withIgnoreLendingOnDifferentDepartment).withNegated(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.LENDING_CHECK_DIFFERENT_LOCATION), LendingCommand::ignoreLendingOnDifferentLocation, LendingCommand::withIgnoreLendingOnDifferentLocation);
    }

    @Bean
    public ReturningService returningService() {
        AppserverReturningService pureService = new AppserverReturningService(this.appserverXmlMapper, this.mappingAppserver, (ByIdLoadable)this.userLoader, this.circulatingAffectedExemplarCacheDeleter(), arg_0 -> ((LoanLoader)this.loanLoader()).getByLoanRealizationId(arg_0));
        return new IgnoresFillingReturningService((ReturningService)pureService, this.returningCommandIgnoresFiller());
    }

    @Bean
    public CacheDeleter<Exemplar> circulatingAffectedExemplarCacheDeleter() {
        return CompositeCacheDeleter.of((CacheDeleter[])new CacheDeleter[]{exemplar -> this.documentAvailabilityCache().deleteFromCacheById((Object)exemplar.getRecordId()), exemplar -> this.exemplarAvailabilityCache().deleteFromCacheById((Object)AppserverDataBackedExemplarAvailability.createId((Integer)((Integer)exemplar.getId())))});
    }

    @Bean
    public IgnoresFiller<LoanReturnCommand> returningCommandIgnoresFiller() {
        return new IgnoresFiller().withNegated(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.RETURNING_CHECK_DIFFERENT_DEPARTMENT), LoanReturnCommand::ignoreReturnOnDifferentDepartment, LoanReturnCommand::withIgnoreReturnOnDifferentDepartment).withNegated(this.settingLoader.getDepartmentedProvider(LoanSettingKeys.RETURNING_CHECK_DIFFERENT_LOCATION), LoanReturnCommand::ignoreDocumentIsFromDifferentLocation, LoanReturnCommand::withIgnoreDocumentIsFromDifferentLocation);
    }

    @Bean
    public ExemplarAwareLoanStateChanger stateChanger() {
        return new ExemplarAwareLoanStateChanger(this.dmlAppserverService);
    }

    @Bean
    public LoanReadyProcessor loanReadyProcessor() {
        LoanReadyNoticeSendDebtCreator debtCreator = new LoanReadyNoticeSendDebtCreator(this.readerCatLoanCatSettingLoader(), this.amountTypeLoader, this.transactionsSaver, this.departmentAccessor, this.securityAccessor);
        return new NoticeSendingDebtCreatingStateChangingLoanProcessor(this.loanReadyNoticeSender(), this.stateChanger(), debtCreator);
    }

    @Bean
    public LoanReadyNoticeSender loanReadyNoticeSender() {
        LoanReadyNoticeMailSender mail = new LoanReadyNoticeMailSender(this.templateEngine, this.mailService, this.recordToViewableRecordConverter);
        LoanReadyNoticeSmsSender sms = new LoanReadyNoticeSmsSender(this.templateEngine, this.smsSender, this.recordToViewableRecordConverter);
        LoanReadyNoticeFileGenerator post = new LoanReadyNoticeFileGenerator(this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL).throwingWhenNull());
        Map<PrintType, LoanReadyNoticeMultipleSender> map = Map.of(PrintType.EMAIL, mail, PrintType.SMS, sms, PrintType.POST, post, PrintType.EMAIL_AND_SMS, new LoanReadyNoticeMultipleSender(List.of(mail, sms)));
        return new LoanReadyNoticeSenderByPrintTypeDispatcher(map);
    }

    @Bean
    public StandardLoanRequestService standardLoanRequestService() {
        return new BuildingPreferenceSavingStandardLoanRequestServiceProxy((StandardLoanRequestService)new AppserverStandardLoanRequestService(this.mappingAppserver, (Converter)new DateRangeToBase64StringConverter(this.objectMapper), this.appserverXmlMapper), this.userPrefAccessor);
    }

    @Bean
    public MailLoanRequestService mailLoanRequestService() {
        return new TemplatedMailLoanRequestService(this.mailService, this.templateEngine, this.translator, this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL).throwingWhenNull(), this.settingLoader.getDepartmentedProvider(CoreSettingKeys.DEFAULT_LOCALE), this.recordToViewableRecordConverter);
    }

    @Bean
    public ExternalLendingService externalLendingService() {
        SpringDbExternalLoanRecordLoader externalLoanRecordLoader = new SpringDbExternalLoanRecordLoader(this.jdbcTemplate, this.queryFactory);
        AppserverExternalLendingService appserverExternalLendingService = new AppserverExternalLendingService(this.mappingAppserver, (ByIdLoadable)externalLoanRecordLoader);
        return new MailSendingExternalLendingService((ExternalLendingService)appserverExternalLendingService, this.mailService, this.templateEngine, this.userLocaleResolver, (ByIdLoadable)externalLoanRecordLoader);
    }

    @Bean
    public RenewalService renewalService() {
        AppserverRenewalService bean = new AppserverRenewalService(this.mappingAppserver, this.appserverXmlMapper, this.renewalAppserverRequestCreator());
        bean.setRenewalProvider(this.settingLoader.getOnRootProvider(SettingKeys.RENEWAL_ENABLED));
        return bean;
    }

    @Bean
    public DelayedReturnPenaltyService delayedReturnPenaltyService() {
        return new AppserverDelayedReturnPenaltyService(this.appserverXmlMapper, this.mappingAppserver);
    }

    @Bean
    public RenewabilityService renewabilityService() {
        AppserverRenewabilityService bean = new AppserverRenewabilityService(this.mappingAppserver, this.appserverXmlMapper, this.renewalAppserverRequestCreator());
        bean.setRenewalProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.RENEWAL_ENABLED));
        return bean;
    }

    @Bean
    public RenewalAppserverRequestCreator renewalAppserverRequestCreator() {
        RenewalAppserverRequestCreator creator = new RenewalAppserverRequestCreator();
        creator.setRenewalByReaderOfDelayedLoansAllowed(this.settingLoader.getDepartmentedProvider(SettingKeys.DELAYED_LOANS_RENEWAL_ENABLED));
        creator.setRenewalByReaderWithDebtsAllowed(this.settingLoader.getDepartmentedProvider(SettingKeys.DEBTOR_LOANS_RENEWAL_BY_READER_ENABLED));
        creator.setRenewalByExpiredReaderAllowed(this.settingLoader.getDepartmentedProvider(SettingKeys.EXPIRED_READER_LOANS_RENEWAL_BY_READER_ENABLED));
        return creator;
    }

    @Bean
    public MvsRequestLoader mvsRequestLoader() {
        return new SpringDbMvsRequestLoader(this.jdbcTemplate, this.queryFactory, (ByIdLoadable)this.mvsStateLoader(), this.documentByKindedIdLoader, this.departmentLoader, (ByIdLoadable)this.basicUserLoader);
    }

    @Bean
    public DynamicCache<AppserverDataBackedExemplarAvailability> exemplarAvailabilityCache() {
        return GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofSeconds(5L), (boolean)true);
    }

    @Bean
    public DynamicCache<DocumentAvailability> documentAvailabilityCache() {
        return GuavaTimedDynamicCache.ofIdentified((Duration)Duration.ofSeconds(5L), (boolean)true);
    }

    @Bean
    public CancelabilityService cancelabilityService() {
        ContextIgnoringContextualProvider unprocessedOrdersCancellingEnabled = ContextIgnoringContextualProvider.of((Object)true);
        ContextualProvider processedOrdersCancellingEnabled = this.settingLoader.getDepartmentedProvider(SettingKeys.PROCESSED_ORDERS_CANCELLING_ENABLED);
        ContextIgnoringContextualProvider unsentReservationsCancellingEnabled = ContextIgnoringContextualProvider.of((Object)true);
        ContextualProvider sentReservationsCancellingEnabled = this.settingLoader.getDepartmentedProvider(SettingKeys.SENT_RESERVATIONS_CANCELLING_ENABLED);
        return new CancelabilityServiceImpl((ContextualProvider)unprocessedOrdersCancellingEnabled, processedOrdersCancellingEnabled, (ContextualProvider)unsentReservationsCancellingEnabled, sentReservationsCancellingEnabled);
    }

    @Bean
    public AllByIdsLoadable<Loan, LoanId> allByIdsLoanLoader() {
        return ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)new SpringDbAllByIdsLoanLoader(this.jdbcTemplate, this.queryFactory, this.locationLoader, this.detailedDocumentLoader, this.exemplarLoader, (AllByIdsLoadable)this.basicUserLoader, this.departmentAccessor, this.loanCategoryLoader, (ByIdLoadable)LoanType.CODEBOOK));
    }

    @Bean
    public AllByIdsLoadable<LoanReminder, Integer> allByIdsLoanReminderLoader() {
        LoanReminderFromEntityConverter loanReminderFromEntityConverter = new LoanReminderFromEntityConverter((AllByIdsLoadable)this.loanLoader());
        return ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)this.modelBeanBuilder.allByIdsLoader(LoanReminderEntity.class, (Converter)loanReminderFromEntityConverter).build());
    }

    @Bean
    public SpringDbLoanReminderIdSearchLoader springDbLoanReminderIdSearchLoader() {
        return new SpringDbLoanReminderIdSearchLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public PageSearchLoader<MapBackedParams, LoanReminder> loanReminderSearchLoader() {
        return ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)this.springDbLoanReminderIdSearchLoader(), (AllByIdsLoadable)this.allByIdsLoanReminderLoader());
    }

    @Bean
    public AllByIdsLoadable<Loan, LoanId> nonDetailedAllByIdsLoanLoader() {
        return ChunkingAllByIdsLoader.ofIdentified((AllByIdsLoadable)new SpringDbAllByIdsLoanLoader(this.jdbcTemplate, this.queryFactory, this.locationLoader, (AllByIdsLoadable)this.nonDetailedDocumentLoader, this.exemplarLoader, (AllByIdsLoadable)this.basicUserLoader, this.departmentAccessor, this.loanCategoryLoader, (ByIdLoadable)LoanType.CODEBOOK));
    }

    @Bean
    public LoanLoader loanLoader() {
        return new DelegatingLoanLoader(this.allByIdsLoanLoader());
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Loan> loanSearchLoader() {
        ParameterizedSearchLoaderImpl springDbLoanIdSearchLoader = new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)new SpringDbLoanIdSearchLoader(this.jdbcTemplate, this.queryFactory, this.departmentAccessor), (AllByIdsLoadable)this.loanLoader()));
        1 pageSearchLoader = new /* Unavailable Anonymous Inner Class!! */;
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)pageSearchLoader);
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Loan> byExemplarQLoanSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)new ByExemplarQLoanPageSearchLoader(this.loanSearchLoader(), this.exemplarIdSearchLoader));
    }

    @Bean
    public LoanLoader nonDetailedLoanLoader() {
        return new DelegatingLoanLoader(this.nonDetailedAllByIdsLoanLoader());
    }

    @Bean
    public QuantumLoanChangeLoader quantumLoanChangeLoader() {
        return new SpringDbQuantumLoanChangeLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public LoanQuantityLoader loanQuantityLoader() {
        return new QuantumLoanChangeSummingLoanQuantityLoader(this.quantumLoanChangeLoader());
    }

    @Bean
    public ParameterizedSearchLoader<MapBackedParams, Loan> nonDetailedLoanSearchLoader() {
        return new ParameterizedSearchLoaderImpl(MapBackedParams::createEmpty, (PageSearchLoader)ResultConvertingPageSearchLoader.createConvertingFromIds((PageSearchLoader)new SpringDbLoanIdSearchLoader(this.jdbcTemplate, this.queryFactory, this.departmentAccessor), (AllByIdsLoadable)this.nonDetailedLoanLoader()));
    }

    @Bean
    public DocumentAvailabilityService documentAvailabilityService() {
        CompositeDownloadLinkContextualResolver downloadLinkResolver = new CompositeDownloadLinkContextualResolver(List.of(new DownloadLinkResolverByDirectoryInsight(this.directoryInsightLoader, this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL), PortaroUrls.getUuidToRecordDetailUrlConverter((ContextualProvider)this.settingLoader.getDepartmentedProvider(SettingKeys.SERVER_URL))), new ContextIgnoringDownloadLinkContextualResolver((DownloadLinkResolver)new DownloadLinkResolverBy856Fields())));
        DocumentAvailabilityServiceAppserver bean = new DocumentAvailabilityServiceAppserver(this.mappingAppserver, this.documentAvailabilityCache(), this.securityManager, (Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)new IdToObjectConverter(this.departmentLoader)), (Converter)StringToAnyListConverter.create((Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)new IdToObjectConverter(this.departmentLoader))), this.lastReturnDateLoader(), this.lastUserLoanDateLoader(), (ReservationsCountLoader)new SpringDbReservationsCountLoader(this.jdbcTemplate, this.queryFactory), this.ordersOrSentOrUnsentReservationsCountByRecord(), this.loanSettingProvider(), this.executorService, this.authenticationHolder, (DownloadLinkContextualResolver)downloadLinkResolver, (ExternalLoanRecordFondResolver)new ProvidedFondIdComparingExternalLoanRecordFondResolver(this.settingLoader.getOnRootProvider(SettingKeys.EXTERNAL_RESOURCES_FOND)), this.appserverXmlMapper, (Provider)StaticProvider.of((Object)CoreConstants.CZECH_TIME_ZONE_ID));
        return bean;
    }

    public Function<UUID, Integer> ordersOrSentOrUnsentReservationsCountByRecord() {
        return recordId -> {
            MapBackedParams params = MapBackedParams.build((Consumer)StaticParamsModifier.of((Property)RecordConstants.SearchParams.RECORD, List.of(recordId), (Property)LoanConstants.SearchParams.LOAN_STATE, List.of(LoanState.UNPROCESSED_ORDER, LoanState.PROCESSED_ORDER, LoanState.UNSENT_RESERVATION, LoanState.SENT_RESERVATION)));
            return this.loanSearchLoader().getTotalElements((SearchParams)params);
        };
    }

    @Bean
    public ExemplarAvailabilityService exemplarAvailabilityService() {
        return new AppserverExemplarAvailabilityService(this.mappingAppserver, this.exemplarAvailabilityCache(), this.securityManager, this.loanSettingProvider(), this.appserverXmlMapper, (Converter)StringToAnyListConverter.create((Converter)StringToIntegerToAnyConverter.nullConvertingToNull((Converter)new IdToObjectConverter(this.departmentLoader))));
    }

    @Bean
    public LastReturnDateLoader lastReturnDateLoader() {
        return new SpringDbLastReturnDateLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public LastUserLoanDateLoader lastUserLoanDateLoader() {
        return new SpringDbLastUserLoanDateLoader(this.jdbcTemplate, this.queryFactory);
    }

    @Bean
    public Codebook<MvsState, Integer> mvsStateLoader() {
        return this.codebookLoaderBuilderFactory.create().providedBy((AllValuesProvider)new SpringDbMvsStateLoader(this.jdbcTemplate, this.queryFactory)).staticCached(MvsState.class.getSimpleName()).build();
    }

    @Bean
    public CancellationService cancellationService() {
        return new AppserverCancellationService(this.appserverXmlMapper, (CacheDeletableById)this.recordCache, this.mappingAppserver, this.cancelabilityService());
    }

    @Bean
    public MvsRequestSaver mvsRequestSaver() {
        return new MvsRequestSaverAppserver(this.dmlAppserverService);
    }

    @Bean
    public ReaderCatLoanCatSettingLoader readerCatLoanCatSettingLoader() {
        return new ReaderCatLoanCatSettingLoaderAppserver(this.appserverXmlMapper, this.mappingAppserver);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerExports() {
        CsvFileExporter loansCsvExporter = new CsvFileExporter("loans.csv", Templates.TEMPLATE_LOANS_CSV, Loan.class, "loans", this.templateEngine);
        this.exporterResolver.addStatic("loans-csv:", (Exporter)loansCsvExporter);
        XlsFileExporterByCsvExporter loansXlsExporter = new XlsFileExporterByCsvExporter("loans.xls", (AbstractToTextualFileExporter)loansCsvExporter);
        this.exporterResolver.addStatic("loans-xls:", (Exporter)loansXlsExporter);
        SearchedItemsExporter searchedLoansCsvExporter = new SearchedItemsExporter((Exporter)loansCsvExporter, 400);
        this.exporterResolver.addStatic("searched-loans-csv:", (Exporter)searchedLoansCsvExporter);
        SearchedItemsExporter searchedLoansXlsExporter = new SearchedItemsExporter((Exporter)new XlsFileExporterByCsvExporter("loans.xls", (AbstractToTextualFileExporter)loansCsvExporter), 400);
        this.exporterResolver.addStatic("searched-loans-xls:", (Exporter)searchedLoansXlsExporter);
        UserActiveLoansExporterDelegatingToLoansExporter userActiveLoansCsvExporter = new UserActiveLoansExporterDelegatingToLoansExporter((Exporter)loansCsvExporter, this.loansProviderService(), this.authenticationHolder, (UserByBasicUserLoader)this.userLoader);
        this.exporterResolver.addStatic("user-active-loans-csv:", (Exporter)userActiveLoansCsvExporter);
        UserActiveLoansExporterDelegatingToLoansExporter userActiveLoansXlsExporter = new UserActiveLoansExporterDelegatingToLoansExporter((Exporter)loansXlsExporter, this.loansProviderService(), this.authenticationHolder, (UserByBasicUserLoader)this.userLoader);
        this.exporterResolver.addStatic("user-active-loans-xls:", (Exporter)userActiveLoansXlsExporter);
        ObjectToJsonFileExporter personalDataEvidenceExporter = new ObjectToJsonFileExporter("data.json", BasicUser.class, this.objectMapper).withData("userData", arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0)).withData("loanData", user -> this.nonDetailedLoanSearchLoader().getContent(Range.forAll(), p -> p.set((Property)LoanConstants.SearchParams.LENDER, List.of(user))));
        SecuredExporter securedPersonalDataEvidenceExporter = new SecuredExporter((Exporter)personalDataEvidenceExporter, SecurityActions.USER_PERSONAL_DATA_EVIDENCE_EXPORT, this.authenticationHolder, this.securityManager);
        this.exporterResolver.addStatic("personal-data-evidence-json:", (Exporter)securedPersonalDataEvidenceExporter);
        this.templateLoadingExportDescriptorLoader.registerTemplated(List.of("user", "csv", "download"), "user-active-loans-csv:", Templates.TEMPLATE_LOANS_CSV.getType(), (Text)MultiText.ofTexts((Text[])new Text[]{Texts.ofMessageCoded((String)"user.export.ActiveLoans"), Texts.ofMessageCoded((String)"export.CsvButton")}).withDelimiter(" - ")).registerTemplated(List.of("user", "xls", "download"), "user-active-loans-xls:", Templates.TEMPLATE_LOANS_CSV.getType(), (Text)MultiText.ofTexts((Text[])new Text[]{Texts.ofMessageCoded((String)"user.export.ActiveLoans"), Texts.ofMessageCoded((String)"export.XlsButton")}).withDelimiter(" - ")).registerTemplated(List.of("loans", "csv", "download"), "loans-csv:", Templates.TEMPLATE_LOANS_CSV.getType(), Texts.ofMessageCoded((String)"export.CsvButton")).registerTemplated(List.of("loans", "xls", "download"), "loans-xls:", Templates.TEMPLATE_LOANS_CSV.getType(), Texts.ofMessageCoded((String)"export.XlsButton")).registerTemplated(List.of("searched-loans", "csv", "download"), "searched-loans-csv:", Templates.TEMPLATE_LOANS_CSV.getType(), Texts.ofMessageCoded((String)"export.CsvButton"), Texts.ofArgumentedMessageCoded((String)"export.LimitXRecords", (Object[])new Object[]{400})).registerTemplated(List.of("searched-loans", "xls", "download"), "searched-loans-xls:", Templates.TEMPLATE_LOANS_CSV.getType(), Texts.ofMessageCoded((String)"export.XlsButton"), Texts.ofArgumentedMessageCoded((String)"export.LimitXRecords", (Object[])new Object[]{400}));
        this.staticExportDescriptorLoader.with(List.of("user", "json", "download"), "personal-data-evidence-json:", Texts.ofMessageCoded((String)"gdpr.ExportOsobnichDat"));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerCacheHooks() {
        this.pureExemplarSaver.withCacheDeletable(this.circulatingAffectedExemplarCacheDeleter());
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerConverters() {
        ChainingConverter stringToLoanConverter = new ChainingConverter(LoanId::fromString, (Converter)new IdToObjectConverter((ByIdLoadable)this.loanLoader()));
        this.conversionService.addConverter(String.class, Loan.class, (Converter)stringToLoanConverter);
        this.objectMapperModule.addDeserializer(Loan.class, (JsonDeserializer)new ByStringConverterJsonDeserializer(Loan.class, (Converter)stringToLoanConverter));
        this.objectMapperModule.addSerializer(LoanId.class, (JsonSerializer)new ConverterToStringJsonSerializer(LoanId.class, (Converter)new ObjectToStringByToStringConverter()));
        this.converterRegisterer.registerForStringId(ExternalLoanService.class, (ByIdLoadable)ExternalLoanService.CODEBOOK);
        this.converterRegisterer.registerForIntegerId(LoanReminderType.class, (ByIdLoadable)LoanReminderType.CODEBOOK);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerPermissions() {
        this.permissionRegistry.add(LoanSecurityActions.LOAN_SEARCH, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(LoanSecurityActions.LOANS_SHOW_USER_LOANS, PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}), this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser()}));
        this.permissionRegistry.add(LoanSecurityActions.LOANS_SHOW_OF_DOCUMENT, this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_LIBRARIAN", "ROLE_ADMIN"}));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_LEND, (PermissionResolver)PermissionResolver.adaptingSubject(arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0), (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowedAndActiveRegistration(this.lendingToExpiredReaderAllowed()), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6102))})));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_RETURN_ANY, this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6103)));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_RETURN, PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.get(LoanSecurityActions.LOAN_RETURN_ANY)), PermissionResolver.adaptingSubject(loan -> loan.getExemplar().getDepartment(), (PermissionResolver)this.permissionFactory.editSubjectWithDepartment())}));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_CANCEL, (auth, ctx, loan) -> {
            if (loan != null && !auth.getRole().contains("ROLE_LIBRARIAN") && !auth.getActiveUser().equals((Object)loan.getUser())) {
                return PermissionResult.forbidden();
            }
            return PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveWithAnyOfRoles(new String[]{"ROLE_READER"}), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence()}).can(auth, ctx, null);
        });
        this.permissionRegistry.add(LoanSecurityActions.LOAN_RENEW, (PermissionResolver)PermissionResolver.adaptingSubject(arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0), (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowed(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicencedAction(Integer.valueOf(6114))})})));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_REQUEST_STANDARD, (PermissionResolver)PermissionResolver.adaptingSubject(StandardLoanRequest::getRequester, (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, requester) -> !(requester instanceof Library) ? PermissionResult.allow() : PermissionResult.forbidden(), this.permissionFactory.currentEvidedAuthenticActive(), this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowed(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence()})})));
        this.permissionRegistry.add(LoanSecurityActions.ANY_LOAN_REQUEST_MAIL, (auth, ctx, subject) -> PermissionResult.allow());
        this.permissionRegistry.add(LoanSecurityActions.LOAN_REQUEST_MAIL, (PermissionResolver)PermissionResolver.withoutSubject((PermissionResolver)this.permissionRegistry.get(LoanSecurityActions.ANY_LOAN_REQUEST_MAIL)));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_REQUEST_MVS_LOCAL_BOOK, (PermissionResolver)PermissionResolver.adaptingSubject(MvsRequestDto::getRequester, (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, requester) -> requester instanceof Library ? PermissionResult.allow() : PermissionResult.forbidden((Text)Texts.ofNative((String)"User is not Library")), this.permissionFactory.currentEvidedAuthenticActive(), this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowed(), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence()})})));
        this.permissionRegistry.add(LoanSecurityActions.LOAN_REQUEST_MVS_REMOTE_BOOK, (PermissionResolver)PermissionResolver.adaptingSubject(arg_0 -> ((UserLoader)this.userLoader).getUser(arg_0), (PermissionResolver)PermissionResolver.and((PermissionResolver[])new PermissionResolver[]{(auth, ctx, requester) -> !(requester instanceof Library) ? PermissionResult.allow() : PermissionResult.forbidden(), this.permissionFactory.subjectUserIsEvidedActiveUnblockedReaderWithLendingAllowedAndActiveRegistration(this.lendingToExpiredReaderAllowed()), PermissionResolver.or((PermissionResolver[])new PermissionResolver[]{this.permissionFactory.currentEvidedAuthenticActiveIsSubjectUser(), this.permissionFactory.currentEvidedAuthenticEditWithLoanLicence()})})));
    }

    @ConstructorProperties(value={"jdbcTemplate", "queryFactory", "modelBeanBuilder", "codebookLoaderBuilderFactory", "mappingAppserver", "dmlAppserverService", "appserverXmlMapper", "documentByKindedIdLoader", "nonDetailedDocumentLoader", "detailedDocumentLoader", "recordCache", "userLoader", "basicUserLoader", "settingLoader", "translator", "userLocaleResolver", "userPrefAccessor", "templateEngine", "mailService", "smsSender", "securityManager", "objectMapper", "exemplarLoader", "exemplarIdSearchLoader", "locationLoader", "departmentLoader", "departmentAccessor", "loanCategoryLoader", "authenticationHolder", "amountTypeLoader", "transactionsSaver", "executorService", "directoryInsightLoader", "securityAccessor", "permissionRegistry", "permissionFactory", "currentAuthEditableDepartmentsLoader", "exporterResolver", "templateLoadingExportDescriptorLoader", "staticExportDescriptorLoader", "conversionService", "objectMapperModule", "actionSaver", "converterRegisterer", "pureExemplarSaver", "recordToViewableRecordConverter", "timeslotOccupationLoader", "passwordChecker"})
    @Generated
    public LoanConfig(@NonNull NamedParameterJdbcOperations jdbcTemplate, @NonNull QueryFactory queryFactory, @NonNull ModelBeanBuilder modelBeanBuilder, @NonNull CodebookLoaderBuilderFactory codebookLoaderBuilderFactory, @NonNull MappingAppserverService mappingAppserver, @NonNull DmlAppserverService dmlAppserverService, @NonNull ObjectMapper appserverXmlMapper, @NonNull IdAndIdsLoadable<RichDocument, Integer> documentByKindedIdLoader, @NonNull IdAndIdsLoadable<RichDocument, UUID> nonDetailedDocumentLoader, @NonNull AllByIdsLoadable<RichDocument, UUID> detailedDocumentLoader, @NonNull DynamicCache<RichRecord> recordCache, @NonNull UserLoader userLoader, @NonNull IdAndIdsLoadable<BasicUser, Integer> basicUserLoader, @NonNull SettingLoader settingLoader, @NonNull Translator<Department> translator, @NonNull UserLocaleResolver userLocaleResolver, @NonNull UserPrefAccessor userPrefAccessor, @NonNull TemplateEngine templateEngine, @NonNull MailService mailService, @NonNull SmsSender smsSender, @NonNull SecurityManager securityManager, @NonNull ObjectMapper objectMapper, @NonNull AllByIdsLoadable<Exemplar, Integer> exemplarLoader, @NonNull PageSearchLoader<MapBackedParams, Integer> exemplarIdSearchLoader, @NonNull ByIdLoadable<Location, Integer> locationLoader, @NonNull ByIdLoadable<Department, Integer> departmentLoader, @NonNull DepartmentAccessor departmentAccessor, @NonNull ByIdLoadable<LoanCategory, String> loanCategoryLoader, @NonNull AuthenticationHolder authenticationHolder, @NonNull AmountTypeLoader amountTypeLoader, @NonNull Saver<List<Transaction>> transactionsSaver, @NonNull ExecutorService executorService, @NonNull DirectoryInsightLoader directoryInsightLoader, @NonNull SecurityAccessor securityAccessor, @NonNull PermissionRegistry permissionRegistry, @NonNull PermissionFactory permissionFactory, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull ExporterResolver exporterResolver, @NonNull TemplateLoadingExportDescriptorLoader templateLoadingExportDescriptorLoader, @NonNull StaticExportDescriptorLoader staticExportDescriptorLoader, @NonNull FormatterRegistry conversionService, @NonNull SimpleModule objectMapperModule, @NonNull ActionSaver actionSaver, @NonNull ConverterRegisterer converterRegisterer, @NonNull AppserverExemplarSaver pureExemplarSaver, @NonNull Converter<Record, ExportingRecord> recordToViewableRecordConverter, @NonNull TimeslotOccupationLoader timeslotOccupationLoader, @NonNull PasswordChecker passwordChecker) {
        Objects.requireNonNull(jdbcTemplate, "jdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(modelBeanBuilder, "modelBeanBuilder is marked non-null but is null");
        Objects.requireNonNull(codebookLoaderBuilderFactory, "codebookLoaderBuilderFactory is marked non-null but is null");
        Objects.requireNonNull(mappingAppserver, "mappingAppserver is marked non-null but is null");
        Objects.requireNonNull(dmlAppserverService, "dmlAppserverService is marked non-null but is null");
        Objects.requireNonNull(appserverXmlMapper, "appserverXmlMapper is marked non-null but is null");
        Objects.requireNonNull(documentByKindedIdLoader, "documentByKindedIdLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(detailedDocumentLoader, "detailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(recordCache, "recordCache is marked non-null but is null");
        Objects.requireNonNull(userLoader, "userLoader is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(translator, "translator is marked non-null but is null");
        Objects.requireNonNull(userLocaleResolver, "userLocaleResolver is marked non-null but is null");
        Objects.requireNonNull(userPrefAccessor, "userPrefAccessor is marked non-null but is null");
        Objects.requireNonNull(templateEngine, "templateEngine is marked non-null but is null");
        Objects.requireNonNull(mailService, "mailService is marked non-null but is null");
        Objects.requireNonNull(smsSender, "smsSender is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(objectMapper, "objectMapper is marked non-null but is null");
        Objects.requireNonNull(exemplarLoader, "exemplarLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarIdSearchLoader, "exemplarIdSearchLoader is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLoader, "departmentLoader is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(loanCategoryLoader, "loanCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(amountTypeLoader, "amountTypeLoader is marked non-null but is null");
        Objects.requireNonNull(transactionsSaver, "transactionsSaver is marked non-null but is null");
        Objects.requireNonNull(executorService, "executorService is marked non-null but is null");
        Objects.requireNonNull(directoryInsightLoader, "directoryInsightLoader is marked non-null but is null");
        Objects.requireNonNull(securityAccessor, "securityAccessor is marked non-null but is null");
        Objects.requireNonNull(permissionRegistry, "permissionRegistry is marked non-null but is null");
        Objects.requireNonNull(permissionFactory, "permissionFactory is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(exporterResolver, "exporterResolver is marked non-null but is null");
        Objects.requireNonNull(templateLoadingExportDescriptorLoader, "templateLoadingExportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(staticExportDescriptorLoader, "staticExportDescriptorLoader is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        Objects.requireNonNull(objectMapperModule, "objectMapperModule is marked non-null but is null");
        Objects.requireNonNull(actionSaver, "actionSaver is marked non-null but is null");
        Objects.requireNonNull(converterRegisterer, "converterRegisterer is marked non-null but is null");
        Objects.requireNonNull(pureExemplarSaver, "pureExemplarSaver is marked non-null but is null");
        Objects.requireNonNull(recordToViewableRecordConverter, "recordToViewableRecordConverter is marked non-null but is null");
        Objects.requireNonNull(timeslotOccupationLoader, "timeslotOccupationLoader is marked non-null but is null");
        Objects.requireNonNull(passwordChecker, "passwordChecker is marked non-null but is null");
        this.jdbcTemplate = jdbcTemplate;
        this.queryFactory = queryFactory;
        this.modelBeanBuilder = modelBeanBuilder;
        this.codebookLoaderBuilderFactory = codebookLoaderBuilderFactory;
        this.mappingAppserver = mappingAppserver;
        this.dmlAppserverService = dmlAppserverService;
        this.appserverXmlMapper = appserverXmlMapper;
        this.documentByKindedIdLoader = documentByKindedIdLoader;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.detailedDocumentLoader = detailedDocumentLoader;
        this.recordCache = recordCache;
        this.userLoader = userLoader;
        this.basicUserLoader = basicUserLoader;
        this.settingLoader = settingLoader;
        this.translator = translator;
        this.userLocaleResolver = userLocaleResolver;
        this.userPrefAccessor = userPrefAccessor;
        this.templateEngine = templateEngine;
        this.mailService = mailService;
        this.smsSender = smsSender;
        this.securityManager = securityManager;
        this.objectMapper = objectMapper;
        this.exemplarLoader = exemplarLoader;
        this.exemplarIdSearchLoader = exemplarIdSearchLoader;
        this.locationLoader = locationLoader;
        this.departmentLoader = departmentLoader;
        this.departmentAccessor = departmentAccessor;
        this.loanCategoryLoader = loanCategoryLoader;
        this.authenticationHolder = authenticationHolder;
        this.amountTypeLoader = amountTypeLoader;
        this.transactionsSaver = transactionsSaver;
        this.executorService = executorService;
        this.directoryInsightLoader = directoryInsightLoader;
        this.securityAccessor = securityAccessor;
        this.permissionRegistry = permissionRegistry;
        this.permissionFactory = permissionFactory;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.exporterResolver = exporterResolver;
        this.templateLoadingExportDescriptorLoader = templateLoadingExportDescriptorLoader;
        this.staticExportDescriptorLoader = staticExportDescriptorLoader;
        this.conversionService = conversionService;
        this.objectMapperModule = objectMapperModule;
        this.actionSaver = actionSaver;
        this.converterRegisterer = converterRegisterer;
        this.pureExemplarSaver = pureExemplarSaver;
        this.recordToViewableRecordConverter = recordToViewableRecordConverter;
        this.timeslotOccupationLoader = timeslotOccupationLoader;
        this.passwordChecker = passwordChecker;
    }
}

