/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.app.CatalogConstants;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.MultiText;
import cz.kpsys.portaro.commons.localization.Text;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.LabeledId;
import cz.kpsys.portaro.commons.property.Property;
import cz.kpsys.portaro.datasource.Datasource;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.form.Form;
import cz.kpsys.portaro.form.editor2.FormField;
import cz.kpsys.portaro.form.editor2.ValueEditor;
import cz.kpsys.portaro.form.editor2.scannabletext.ScannableTextValueEditor;
import cz.kpsys.portaro.form.editor2.singleacceptable.SingleAcceptableValueEditor;
import cz.kpsys.portaro.form.editor2.text.TextValueEditor;
import cz.kpsys.portaro.form.editor2.year.YearValueEditor;
import cz.kpsys.portaro.form.property.EditedProperty;
import cz.kpsys.portaro.loan.LoanConstants;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.payment.PaymentProvider;
import cz.kpsys.portaro.record.RecordConstants;
import cz.kpsys.portaro.record.fond.Fond;
import cz.kpsys.portaro.record.operation.RecordOperationType;
import cz.kpsys.portaro.search.CoreSearchParams;
import cz.kpsys.portaro.search.MapBackedParams;
import cz.kpsys.portaro.search.view.SearchFormFactory;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.user.role.reader.ReaderCategory;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class FormConfig {
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedFondsDepartmentedProvider;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedAuthorityFondsDepartmentedProvider;
    @NonNull
    private final ContextualProvider<Department, List<Fond>> allowedDocumentFondsDepartmentedProvider;
    @NonNull
    private final @NonNull ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsDepartmentedProvider;
    @NonNull
    private final ContextualProvider<Department, List<Location>> allowedLocationsContextualProvider;
    @NonNull
    private final AllValuesProvider<ReaderCategory> readerCategoryLoader;
    @NonNull
    private final AllValuesProvider<RecordOperationType> recordOperationTypeLoader;
    @NonNull
    private final List<PaymentProvider> paymentProviders;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SecurityAccessor securityAccessor;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final ContextualProvider<Department, List<ReaderCategory>> readerCategoriesDepartmentedProvider;
    @NonNull
    private final ContextualProvider<Department, BarCodeValidator> userBarCodeValidatorProvider;

    @Bean
    public SearchFormFactory fieldsTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory searchSelectionTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private <PARAMS extends MapBackedParams> Form createDocumentSearchSelectionForm(List<String> kinds, PARAMS params, Department ctx) {
        Form form = new Form("document-selection-search", Texts.ofMessageCoded((String)"hledani.vybratZVyhledanych"));
        form.addField(FormField.createWithPropertyAndHint((Property)RecordConstants.SearchParams.ISBN_OR_ISSN, (Text)Texts.ofMessageCoded((String)"commons.IsbnOrIssn"), (Text)Texts.ofMessageCoded((String)"search.recordSearchSelectionForm.isbnOrIssn.hint"), (ValueEditor)ScannableTextValueEditor.getEmptyEditor().withMinLength(7).withMaxLength(20)));
        form.addField(FormField.createWithPropertyAndHint((Property)CoreSearchParams.NAME, (Text)Texts.ofMessageCoded((String)"commons.nazev"), (Text)Texts.ofMessageCoded((String)"search.recordSearchSelectionForm.nazev.hint"), (ValueEditor)TextValueEditor.getEmptyEditor().withMinLength(3).withMaxLength(100)));
        form.addField(FormField.createWithPropertyAndHint((Property)RecordConstants.SearchParams.AUTHOR, (Text)Texts.ofMessageCoded((String)"commons.autor"), (Text)Texts.ofMessageCoded((String)"search.recordSearchSelectionForm.autor.hint"), (ValueEditor)TextValueEditor.getEmptyEditor().withMinLength(3).withMaxLength(100)));
        form.addField(FormField.createWithPropertyAndHint((Property)RecordConstants.SearchParams.PUBLICATION_YEAR, (Text)Texts.ofMessageCoded((String)"commons.rokVydani"), (Text)Texts.ofMessageCoded((String)"search.recordSearchSelectionForm.rokVydani.hint"), (ValueEditor)YearValueEditor.getEmptyEditor()));
        List acceptableDatasources = this.getDatasourceEditorAcceptableValues(kinds, params, ctx);
        if (!acceptableDatasources.isEmpty()) {
            form.addField((FormField)EditedProperty.createWithProperty((Property)CoreSearchParams.DATASOURCE, (ValueEditor)SingleAcceptableValueEditor.getEmptyEditor((Collection)acceptableDatasources)));
        }
        return form;
    }

    private <PARAMS extends MapBackedParams> Form createGenericRecordSearchSelectionForm(List<String> kinds, PARAMS params, Department ctx) {
        Form form = new Form("record-selection-search", Texts.ofMessageCoded((String)"hledani.vybratZVyhledanych"));
        form.addField(FormField.createWithPropertyAndHint((Property)CoreSearchParams.Q, (Text)Texts.ofMessageCoded((String)"commons.nazev"), (Text)Texts.ofMessageCoded((String)"search.recordSearchSelectionForm.nazev.hint"), (ValueEditor)TextValueEditor.getEmptyEditor().withMinLength(3).withMaxLength(100).withPlaceholder(Texts.ofNative((String)"Zadejte po\u010d\u00e1te\u010dn\u00ed p\u00edsmena"))));
        List acceptableDatasources = this.getDatasourceEditorAcceptableValues(kinds, params, ctx);
        if (!acceptableDatasources.isEmpty()) {
            form.addField((FormField)EditedProperty.createWithProperty((Property)CoreSearchParams.DATASOURCE, (ValueEditor)SingleAcceptableValueEditor.getEmptyEditor((Collection)acceptableDatasources)));
        }
        return form;
    }

    private Form createGenericSearchSelectionForm(List<String> kinds, Department ctx) {
        Form form = new Form("generic-selection-search", Texts.ofMessageCoded((String)"hledani.vybratZVyhledanych"));
        form.addField(FormField.createWithPropertyAndHint((Property)CoreSearchParams.Q, (Text)Texts.ofMessageCoded((String)"commons.nazev"), (Text)Texts.ofMessageCoded((String)"search.recordSearchSelectionForm.nazev.hint"), (ValueEditor)TextValueEditor.getEmptyEditor().withMinLength(3).withMaxLength(100).withPlaceholder(Texts.ofNative((String)"Zadejte po\u010d\u00e1te\u010dn\u00ed p\u00edsmena"))));
        return form;
    }

    private <PARAMS extends MapBackedParams> List<LabeledId<String>> getDatasourceEditorAcceptableValues(List<String> kinds, PARAMS params, Department ctx) {
        return ((List)this.allowedDatasetsDepartmentedProvider.getOn((Object)ctx)).stream().filter(datasource -> datasource.supportsAnyOf((Collection)kinds)).filter(datasource -> !params.has((Property)CoreSearchParams.DATASOURCE_GROUP) || datasource.isOfGroup((String)params.get((Property)CoreSearchParams.DATASOURCE_GROUP))).filter(datasource -> !FormConfig.isSearchForSourceDocument((MapBackedParams)params) || !datasource.supportsOnly("authority")).map(datasource -> {
            Text text = datasource.getText();
            if (datasource.equals((Object)CatalogConstants.Search.DATASOURCE_LOCAL)) {
                text = MultiText.ofTexts((Text[])new Text[]{datasource.getText(), ctx.getText()}).withSpaceDelimiter();
            }
            return new LabeledId((Serializable)((Object)((String)datasource.getId())), text);
        }).toList();
    }

    private static <PARAMS extends MapBackedParams> boolean isSearchForSourceDocument(PARAMS params) {
        if (params.has((Property)RecordConstants.SearchParams.FOND)) {
            List fonds = (List)params.get((Property)RecordConstants.SearchParams.FOND);
            List authorityFonds = Fond.filterAuthorityFonds((List)fonds);
            return authorityFonds.size() == 1 && ((Fond)authorityFonds.get(0)).isForSourceDocument();
        }
        return false;
    }

    private Form createExemplarSearchSelectionForm() {
        Form form = new Form("exemplar-selection-search", Texts.ofMessageCoded((String)"hledani.vybratZVyhledanych"));
        form.addField((FormField)EditedProperty.createWithProperty((Property)CoreSearchParams.Q, (Text)Texts.ofMessageCoded((String)"commons.Identifikator"), (ValueEditor)ScannableTextValueEditor.getEmptyEditor().withMaxLength(20).withPlaceholder(Texts.ofMessageCoded((String)"exemplar.ExemplarIdentifier")).withAllowedAutomaticStart(Boolean.valueOf(true)).withRequired(true)));
        return form;
    }

    private Form createLoanSearchSelectionForm() {
        Form form = new Form("loan-selection-search", Texts.ofMessageCoded((String)"hledani.vybratZVyhledanych"));
        form.addField((FormField)EditedProperty.createWithProperty((Property)LoanConstants.SearchParams.EXEMPLAR_Q, (Text)Texts.ofMessageCoded((String)"commons.Identifikator"), (ValueEditor)ScannableTextValueEditor.getEmptyEditor().withMaxLength(20).withPlaceholder(Texts.ofMessageCoded((String)"exemplar.ExemplarIdentifier")).withAllowedAutomaticStart(Boolean.valueOf(true)).withRequired(true)));
        return form;
    }

    @Bean
    public SearchFormFactory newestTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private SearchFormFactory selectableFondSearchFormFactory(String formId) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory mostWatchedTypeSearchFormFactory() {
        return this.selectableFondSearchFormFactory("most-watched-search");
    }

    @Bean
    public SearchFormFactory topRatedTypeSearchFormFactory() {
        return this.selectableFondSearchFormFactory("top-rated-search");
    }

    @Bean
    public SearchFormFactory mostLentTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory documentIndexTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory authorityIndexTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory exemplarSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory userSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory recordOperationTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory fileSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory paymentSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory inventorySearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory matchSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory loanSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory loanReminderSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SearchFormFactory messageSearchTypeSearchFormFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @ConstructorProperties(value={"allowedFondsDepartmentedProvider", "allowedAuthorityFondsDepartmentedProvider", "allowedDocumentFondsDepartmentedProvider", "allowedDatasetsDepartmentedProvider", "allowedLocationsContextualProvider", "readerCategoryLoader", "recordOperationTypeLoader", "paymentProviders", "departmentAccessor", "securityAccessor", "currentAuthEditableDepartmentsLoader", "readerCategoriesDepartmentedProvider", "userBarCodeValidatorProvider"})
    @Generated
    public FormConfig(@NonNull ContextualProvider<Department, List<Fond>> allowedFondsDepartmentedProvider, @NonNull ContextualProvider<Department, List<Fond>> allowedAuthorityFondsDepartmentedProvider, @NonNull ContextualProvider<Department, List<Fond>> allowedDocumentFondsDepartmentedProvider, @NonNull @NonNull ContextualProvider<Department, @NonNull List<Datasource>> allowedDatasetsDepartmentedProvider, @NonNull ContextualProvider<Department, List<Location>> allowedLocationsContextualProvider, @NonNull AllValuesProvider<ReaderCategory> readerCategoryLoader, @NonNull AllValuesProvider<RecordOperationType> recordOperationTypeLoader, @NonNull List<PaymentProvider> paymentProviders, @NonNull DepartmentAccessor departmentAccessor, @NonNull SecurityAccessor securityAccessor, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull ContextualProvider<Department, List<ReaderCategory>> readerCategoriesDepartmentedProvider, @NonNull ContextualProvider<Department, BarCodeValidator> userBarCodeValidatorProvider) {
        Objects.requireNonNull(allowedFondsDepartmentedProvider, "allowedFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedAuthorityFondsDepartmentedProvider, "allowedAuthorityFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedDocumentFondsDepartmentedProvider, "allowedDocumentFondsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedDatasetsDepartmentedProvider, "allowedDatasetsDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(allowedLocationsContextualProvider, "allowedLocationsContextualProvider is marked non-null but is null");
        Objects.requireNonNull(readerCategoryLoader, "readerCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(recordOperationTypeLoader, "recordOperationTypeLoader is marked non-null but is null");
        Objects.requireNonNull(paymentProviders, "paymentProviders is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(securityAccessor, "securityAccessor is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(readerCategoriesDepartmentedProvider, "readerCategoriesDepartmentedProvider is marked non-null but is null");
        Objects.requireNonNull(userBarCodeValidatorProvider, "userBarCodeValidatorProvider is marked non-null but is null");
        this.allowedFondsDepartmentedProvider = allowedFondsDepartmentedProvider;
        this.allowedAuthorityFondsDepartmentedProvider = allowedAuthorityFondsDepartmentedProvider;
        this.allowedDocumentFondsDepartmentedProvider = allowedDocumentFondsDepartmentedProvider;
        this.allowedDatasetsDepartmentedProvider = allowedDatasetsDepartmentedProvider;
        this.allowedLocationsContextualProvider = allowedLocationsContextualProvider;
        this.readerCategoryLoader = readerCategoryLoader;
        this.recordOperationTypeLoader = recordOperationTypeLoader;
        this.paymentProviders = paymentProviders;
        this.departmentAccessor = departmentAccessor;
        this.securityAccessor = securityAccessor;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.readerCategoriesDepartmentedProvider = readerCategoriesDepartmentedProvider;
        this.userBarCodeValidatorProvider = userBarCodeValidatorProvider;
    }
}

