/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.portaro.config;

import cz.kpsys.portaro.auth.AuthenticationHolder;
import cz.kpsys.portaro.auth.BasicUserAuthentication;
import cz.kpsys.portaro.auth.department.CurrentAuthDepartmentsLoader;
import cz.kpsys.portaro.commons.barcode.BarCodeValidator;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.localization.Texts;
import cz.kpsys.portaro.commons.object.AllValuesProvider;
import cz.kpsys.portaro.commons.object.Identified;
import cz.kpsys.portaro.commons.object.LabeledId;
import cz.kpsys.portaro.commons.object.LabeledIdentified;
import cz.kpsys.portaro.commons.object.ProvidedProxiedList;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.TtlCachedProvider;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.commons.object.repo.DataUtils;
import cz.kpsys.portaro.commons.util.ListUtil;
import cz.kpsys.portaro.config.SettingKeys;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.department.DepartmentAccessor;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.exemplar.ExemplarSecurityActions;
import cz.kpsys.portaro.exemplar.ExemplarSequenceItemLoader;
import cz.kpsys.portaro.exemplar.ExemplarType;
import cz.kpsys.portaro.exemplar.accessnumber.AccessNumberSequenceItem;
import cz.kpsys.portaro.exemplar.accessnumber.AccessNumberSequenceLoader;
import cz.kpsys.portaro.exemplar.acquisitionway.AcquisitionWayLoader;
import cz.kpsys.portaro.exemplar.discard.DiscardNumberSequenceItemLoader;
import cz.kpsys.portaro.exemplar.discard.DiscardionRequestDefaulter;
import cz.kpsys.portaro.exemplar.exemplarstatus.ExemplarStatusLoader;
import cz.kpsys.portaro.exemplar.loancategory.LoanCategoryLoader;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceItem;
import cz.kpsys.portaro.exemplar.signature.SignatureSequenceLoader;
import cz.kpsys.portaro.exemplar.thematicgroup.ThematicGroupLoader;
import cz.kpsys.portaro.exemplar.volume.VolumeLoader;
import cz.kpsys.portaro.exemplar.volume.VolumePeriodicity;
import cz.kpsys.portaro.form.editor2.FieldsWhiteListResolverAllValuesProviderFactory;
import cz.kpsys.portaro.form.editor2.ValueEditor;
import cz.kpsys.portaro.form.editor2.list.ListValueEditorModifier;
import cz.kpsys.portaro.form.editor2.list.ListValueEditorOptions;
import cz.kpsys.portaro.form.editor2.object.ObjectValueEditor;
import cz.kpsys.portaro.form.editor2.scannabletext.ScannableTextValueEditorModifier;
import cz.kpsys.portaro.form.property.CanDoActionResolver;
import cz.kpsys.portaro.location.DepartmentLocationRelationLoader;
import cz.kpsys.portaro.location.Location;
import cz.kpsys.portaro.location.SmartDefaultLocationDepartmentedProvider;
import cz.kpsys.portaro.record.document.RichDocument;
import cz.kpsys.portaro.security.SecurityAccessor;
import cz.kpsys.portaro.security.SecurityManager;
import cz.kpsys.portaro.sequence.DefaultSequenceItem;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.user.sec.CurrentAuthLocationsLoader;
import cz.kpsys.portaro.user.sec.CurrentAuthLocationsLoaderByDepartments;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarIdentifierRequest;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequest;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestDefaulter;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestPreValidationDefaultModifier;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestToExemplarsConverter;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarRequestUtils;
import cz.kpsys.portaro.view.web.rest.exemplar.ExemplarToExemplarRequestConverter;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class ExemplarEditConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExemplarEditConfig.class);
    @NonNull
    private final AuthenticationHolder authenticationHolder;
    @NonNull
    private final DepartmentAccessor departmentAccessor;
    @NonNull
    private final SecurityAccessor securityAccessor;
    @NonNull
    private final CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader;
    @NonNull
    private final ByIdLoadable<Location, Integer> locationLoader;
    @NonNull
    private final DepartmentLocationRelationLoader departmentLocationRelationLoader;
    @NonNull
    private final SecurityManager securityManager;
    @NonNull
    private final Provider<Department> rootDepartmentProvider;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final DiscardNumberSequenceItemLoader discardNumberSequenceItemLoader;
    @NonNull
    private final ThematicGroupLoader thematicGroupLoader;
    @NonNull
    private final AcquisitionWayLoader acquisitionWayLoader;
    @NonNull
    private final LoanCategoryLoader loanCategoryLoader;
    @NonNull
    private final ExemplarStatusLoader exemplarStatusLoader;
    @NonNull
    private final VolumeLoader volumeLoader;
    @NonNull
    private final ByIdLoadable<RichDocument, UUID> nonDetailedDocumentLoader;
    @NonNull
    private final ExemplarSequenceItemLoader<AccessNumberSequenceItem> accessNumberSequenceItemLoader;
    @NonNull
    private final ExemplarSequenceItemLoader<SignatureSequenceItem> signatureSequenceItemLoader;
    @NonNull
    private final AccessNumberSequenceLoader accessNumberSequenceLoader;
    @NonNull
    private final SignatureSequenceLoader signatureSequenceLoader;
    @NonNull
    private final ContextualProvider<Department, BarCodeValidator> exemplarBarCodeValidatorProvider;

    @Bean
    public ContextualProvider<Department, Location> defaultLocationDepartmentedProvider() {
        return new SmartDefaultLocationDepartmentedProvider(this.settingLoader.getDepartmentedProvider(SettingKeys.DEFAULT_LOCATION), this.locationLoader, this.departmentLocationRelationLoader);
    }

    @Bean
    public AllValuesProvider<Department> exemplarEditDepartments() {
        return () -> this.departmentAccessor.getAllSubdepartmentsIncludingThese(this.currentAuthEditableDepartmentsLoader.getSubtreesByAuth((BasicUserAuthentication)this.authenticationHolder.getCurrentAuth())).stream().filter(Department::isExemplarable).distinct().toList();
    }

    @Bean
    public AllValuesProvider<Location> exemplarEditLocations() {
        CurrentAuthLocationsLoaderByDepartments currentAuthLocationsLoaderByDepartments = new CurrentAuthLocationsLoaderByDepartments(this.currentAuthEditableDepartmentsLoader, this.defaultLocationDepartmentedProvider(), this.departmentLocationRelationLoader);
        return () -> currentAuthLocationsLoaderByDepartments.getAllByAuth(this.authenticationHolder.getCurrentAuth());
    }

    @Bean
    public CanDoActionResolver<ExemplarIdentifierRequest> exemplarEditCanGenerateField() {
        return form -> this.securityManager.can(ExemplarSecurityActions.EXEMPLAR_FIELD_GENERATE, this.authenticationHolder.getCurrentAuth(), (Department)this.rootDepartmentProvider.get());
    }

    @Bean
    public AllValuesProvider<ExemplarType> exemplarTypes() {
        return ExemplarType.CODEBOOK;
    }

    @Bean
    public FieldsWhiteListResolverAllValuesProviderFactory<ExemplarRequest> editableExemplarRequestPropsProvider() {
        return exemplarRequest -> department -> {
            ContextualProvider propsProvider = exemplarRequest.volume() != null ? this.editableIssuePropsDepartmentedProvider() : this.editableExemplarPropsDepartmentedProvider();
            ArrayList<String> all = new ArrayList<String>((Collection)propsProvider.getOn(department));
            boolean addIdentifiers = all.stream().anyMatch(item -> "accessNumber".equals(item) || "signature".equals(item) || "barCode".equals(item));
            if (addIdentifiers) {
                all.add("identifiers");
            }
            return all;
        };
    }

    @Bean
    public FieldsWhiteListResolverAllValuesProviderFactory<ExemplarIdentifierRequest> editableExemplarRequestIdentifiersPropsProvider() {
        return exemplarIdentifierRequest -> {
            if (exemplarIdentifierRequest.getParentForm().volume() != null) {
                return this.settingLoader.getDepartmentedProvider(SettingKeys.EDITABLE_ISSUE_PROPS);
            }
            return this.settingLoader.getDepartmentedProvider(SettingKeys.EDITABLE_EXEMPLAR_PROPS);
        };
    }

    @Bean
    public ScannableTextValueEditorModifier<ExemplarIdentifierRequest> exemplarEditationMaxLengthScannableTextEditorAnnotationModifier() {
        return (editor, formObject, ctx) -> editor.withPatternValidation(((BarCodeValidator)this.exemplarBarCodeValidatorProvider.getOn((Object)ctx)).getEditorValidationPattern());
    }

    @Bean
    public ListValueEditorModifier<ObjectValueEditor, ExemplarIdentifierRequest, ExemplarRequest> exemplarRequestListEditorModifier() {
        return (editor, exemplarRequest, ctx) -> {
            if (DataUtils.isPersisted((Identified)exemplarRequest)) {
                ObjectValueEditor objectValueEditor = editor.getOptions().flatMap(ListValueEditorOptions::getSubEditor).map(ove -> ove.withDisabled(Boolean.valueOf(false))).orElseThrow(() -> new IllegalArgumentException("Object value editor is null, but it should not happen"));
                return editor.withDisabled(Boolean.valueOf(true)).withSubEditor((ValueEditor)objectValueEditor);
            }
            return editor;
        };
    }

    @Bean
    public ContextualProvider<Department, List<String>> editableIssuePropsDepartmentedProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.EDITABLE_ISSUE_PROPS);
    }

    @Bean
    public ContextualProvider<Department, List<String>> editableExemplarPropsDepartmentedProvider() {
        return this.settingLoader.getDepartmentedProvider(SettingKeys.EDITABLE_EXEMPLAR_PROPS);
    }

    @Bean
    public CurrentAuthLocationsLoaderByDepartments currentAuthLocationsLoader() {
        return new CurrentAuthLocationsLoaderByDepartments(this.currentAuthEditableDepartmentsLoader, this.defaultLocationDepartmentedProvider(), this.departmentLocationRelationLoader);
    }

    @Bean
    public ExemplarRequestDefaulter exemplarRequestDefaulter() {
        return new ExemplarRequestDefaulter(this.authenticationHolder, this.thematicGroupLoader, this.acquisitionWayLoader, this.loanCategoryLoader, this.exemplarStatusLoader, this.exemplarRequestPreValidationDefaultModifier(), this.securityAccessor, (CurrentAuthLocationsLoader)this.currentAuthLocationsLoader(), false);
    }

    @Bean
    public ExemplarRequestDefaulter importingExemplarRequestDefaulter() {
        return new ExemplarRequestDefaulter(this.authenticationHolder, this.thematicGroupLoader, this.acquisitionWayLoader, this.loanCategoryLoader, this.exemplarStatusLoader, this.exemplarRequestPreValidationDefaultModifier(), this.securityAccessor, (CurrentAuthLocationsLoader)this.currentAuthLocationsLoader(), true);
    }

    @Bean
    public ExemplarRequestUtils exemplarRequestUtils() {
        return new ExemplarRequestUtils(this.signatureSequenceItemLoader, this.signatureSequenceLoader, this.accessNumberSequenceItemLoader, this.accessNumberSequenceLoader);
    }

    @Bean
    public ExemplarRequestPreValidationDefaultModifier exemplarRequestPreValidationDefaultModifier() {
        return new ExemplarRequestPreValidationDefaultModifier(this.authenticationHolder, this.securityManager, this.securityAccessor, (CurrentAuthLocationsLoader)this.currentAuthLocationsLoader(), this.defaultLocationDepartmentedProvider(), this.editableIssuePropsDepartmentedProvider(), this.editableExemplarPropsDepartmentedProvider(), this.exemplarRequestUtils(), this.thematicGroupLoader, this.acquisitionWayLoader, this.exemplarStatusLoader, this.loanCategoryLoader);
    }

    @Bean
    public AllValuesProvider<LabeledIdentified<String>> discardNumberSequenceProvider() {
        return () -> new ProvidedProxiedList((Provider)TtlCachedProvider.ofSeconds((long)30L, () -> {
            List<DefaultSequenceItem> allReal = this.discardNumberSequenceItemLoader.getAllValid((Collection)this.currentAuthEditableDepartmentsLoader.getSubtreesByAuth((BasicUserAuthentication)this.authenticationHolder.getCurrentAuth()));
            if (allReal.isEmpty()) {
                allReal = List.of(new DefaultSequenceItem().next());
            }
            return ListUtil.convert((Iterable)allReal, source -> new LabeledId((Serializable)((Object)((String)source.getValue())), Texts.ofNative((String)((String)source.getValue() + " (vygenerov\u00e1no)"))));
        }));
    }

    @Bean
    public DiscardionRequestDefaulter discardionRequestDefaulter() {
        return new DiscardionRequestDefaulter(this.discardNumberSequenceProvider());
    }

    @Bean
    public AllValuesProvider<VolumePeriodicity> volumePeriodicity() {
        return VolumePeriodicity.CODEBOOK;
    }

    @Bean
    public ExemplarIdentifierRequest exemplarRequestIdentifiersPrototype() {
        return new ExemplarIdentifierRequest(null, null, null, null);
    }

    @Bean
    public Converter<ExemplarRequest, List<Exemplar>> exemplarRequestToExemplarsConverter() {
        return new ExemplarRequestToExemplarsConverter();
    }

    @Bean
    public Converter<Exemplar, ExemplarRequest> exemplarToExemplarRequestConverter() {
        return new ExemplarToExemplarRequestConverter(this.nonDetailedDocumentLoader, this.volumeLoader);
    }

    @ConstructorProperties(value={"authenticationHolder", "departmentAccessor", "securityAccessor", "currentAuthEditableDepartmentsLoader", "locationLoader", "departmentLocationRelationLoader", "securityManager", "rootDepartmentProvider", "settingLoader", "discardNumberSequenceItemLoader", "thematicGroupLoader", "acquisitionWayLoader", "loanCategoryLoader", "exemplarStatusLoader", "volumeLoader", "nonDetailedDocumentLoader", "accessNumberSequenceItemLoader", "signatureSequenceItemLoader", "accessNumberSequenceLoader", "signatureSequenceLoader", "exemplarBarCodeValidatorProvider"})
    @Generated
    public ExemplarEditConfig(@NonNull AuthenticationHolder authenticationHolder, @NonNull DepartmentAccessor departmentAccessor, @NonNull SecurityAccessor securityAccessor, @NonNull CurrentAuthDepartmentsLoader currentAuthEditableDepartmentsLoader, @NonNull ByIdLoadable<Location, Integer> locationLoader, @NonNull DepartmentLocationRelationLoader departmentLocationRelationLoader, @NonNull SecurityManager securityManager, @NonNull Provider<Department> rootDepartmentProvider, @NonNull SettingLoader settingLoader, @NonNull DiscardNumberSequenceItemLoader discardNumberSequenceItemLoader, @NonNull ThematicGroupLoader thematicGroupLoader, @NonNull AcquisitionWayLoader acquisitionWayLoader, @NonNull LoanCategoryLoader loanCategoryLoader, @NonNull ExemplarStatusLoader exemplarStatusLoader, @NonNull VolumeLoader volumeLoader, @NonNull ByIdLoadable<RichDocument, UUID> nonDetailedDocumentLoader, @NonNull ExemplarSequenceItemLoader<AccessNumberSequenceItem> accessNumberSequenceItemLoader, @NonNull ExemplarSequenceItemLoader<SignatureSequenceItem> signatureSequenceItemLoader, @NonNull AccessNumberSequenceLoader accessNumberSequenceLoader, @NonNull SignatureSequenceLoader signatureSequenceLoader, @NonNull ContextualProvider<Department, BarCodeValidator> exemplarBarCodeValidatorProvider) {
        Objects.requireNonNull(authenticationHolder, "authenticationHolder is marked non-null but is null");
        Objects.requireNonNull(departmentAccessor, "departmentAccessor is marked non-null but is null");
        Objects.requireNonNull(securityAccessor, "securityAccessor is marked non-null but is null");
        Objects.requireNonNull(currentAuthEditableDepartmentsLoader, "currentAuthEditableDepartmentsLoader is marked non-null but is null");
        Objects.requireNonNull(locationLoader, "locationLoader is marked non-null but is null");
        Objects.requireNonNull(departmentLocationRelationLoader, "departmentLocationRelationLoader is marked non-null but is null");
        Objects.requireNonNull(securityManager, "securityManager is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentProvider, "rootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(discardNumberSequenceItemLoader, "discardNumberSequenceItemLoader is marked non-null but is null");
        Objects.requireNonNull(thematicGroupLoader, "thematicGroupLoader is marked non-null but is null");
        Objects.requireNonNull(acquisitionWayLoader, "acquisitionWayLoader is marked non-null but is null");
        Objects.requireNonNull(loanCategoryLoader, "loanCategoryLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarStatusLoader, "exemplarStatusLoader is marked non-null but is null");
        Objects.requireNonNull(volumeLoader, "volumeLoader is marked non-null but is null");
        Objects.requireNonNull(nonDetailedDocumentLoader, "nonDetailedDocumentLoader is marked non-null but is null");
        Objects.requireNonNull(accessNumberSequenceItemLoader, "accessNumberSequenceItemLoader is marked non-null but is null");
        Objects.requireNonNull(signatureSequenceItemLoader, "signatureSequenceItemLoader is marked non-null but is null");
        Objects.requireNonNull(accessNumberSequenceLoader, "accessNumberSequenceLoader is marked non-null but is null");
        Objects.requireNonNull(signatureSequenceLoader, "signatureSequenceLoader is marked non-null but is null");
        Objects.requireNonNull(exemplarBarCodeValidatorProvider, "exemplarBarCodeValidatorProvider is marked non-null but is null");
        this.authenticationHolder = authenticationHolder;
        this.departmentAccessor = departmentAccessor;
        this.securityAccessor = securityAccessor;
        this.currentAuthEditableDepartmentsLoader = currentAuthEditableDepartmentsLoader;
        this.locationLoader = locationLoader;
        this.departmentLocationRelationLoader = departmentLocationRelationLoader;
        this.securityManager = securityManager;
        this.rootDepartmentProvider = rootDepartmentProvider;
        this.settingLoader = settingLoader;
        this.discardNumberSequenceItemLoader = discardNumberSequenceItemLoader;
        this.thematicGroupLoader = thematicGroupLoader;
        this.acquisitionWayLoader = acquisitionWayLoader;
        this.loanCategoryLoader = loanCategoryLoader;
        this.exemplarStatusLoader = exemplarStatusLoader;
        this.volumeLoader = volumeLoader;
        this.nonDetailedDocumentLoader = nonDetailedDocumentLoader;
        this.accessNumberSequenceItemLoader = accessNumberSequenceItemLoader;
        this.signatureSequenceItemLoader = signatureSequenceItemLoader;
        this.accessNumberSequenceLoader = accessNumberSequenceLoader;
        this.signatureSequenceLoader = signatureSequenceLoader;
        this.exemplarBarCodeValidatorProvider = exemplarBarCodeValidatorProvider;
    }
}

